/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Iterator;
import sandbox.java.util.Objects;
import sandbox.java.util.PrimitiveIterator;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.stream.AbstractSpinedBuffer;
import sandbox.java.util.stream.Tripwire;

class SpinedBuffer<E>
extends AbstractSpinedBuffer
implements Consumer<E>,
Iterable<E> {
    protected E[] curChunk;
    protected E[][] spine;
    private static final int SPLITERATOR_CHARACTERISTICS = 16464;

    SpinedBuffer(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractSpinedBuffer.<init>:(I)V");
        super(n);
        int n2 = 1 << this.initialChunkPower;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.curChunk = new Object[n2];
    }

    SpinedBuffer() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractSpinedBuffer.<init>:()V");
        int n = 1 << this.initialChunkPower;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        this.curChunk = new Object[n];
    }

    protected long capacity() {
        long l;
        RuntimeCostAccounter.recordJump();
        if (this.spineIndex == 0) {
            l = this.curChunk.length;
            RuntimeCostAccounter.recordJump();
        } else {
            l = this.priorElementCount[this.spineIndex] + (long)this.spine[this.spineIndex].length;
        }
        return l;
    }

    private void inflateSpine() {
        RuntimeCostAccounter.recordJump();
        if (this.spine == null) {
            RuntimeCostAccounter.recordArrayAllocation((int)8, (int)8);
            this.spine = new Object[8][];
            RuntimeCostAccounter.recordArrayAllocation((int)8, (int)8);
            this.priorElementCount = new long[8];
            this.spine[0] = this.curChunk;
        }
    }

    protected final void ensureCapacity(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.capacity:()J");
        long l2 = this.capacity();
        RuntimeCostAccounter.recordJump();
        if (l > l2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.inflateSpine:()V");
            this.inflateSpine();
            int n = this.spineIndex + 1;
            while (true) {
                int n2;
                RuntimeCostAccounter.recordJump();
                if (l <= l2) break;
                int n3 = this.spine.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n3) {
                    n2 = this.spine.length * 2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                    this.spine = (Object[][])Arrays.copyOf(this.spine, n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
                    this.priorElementCount = Arrays.copyOf(this.priorElementCount, n2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.chunkSize:(I)I");
                int n4 = n2 = this.chunkSize(n);
                RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
                this.spine[n] = new Object[n4];
                this.priorElementCount[n] = this.priorElementCount[n - 1] + (long)this.spine[n - 1].length;
                l2 += (long)n2;
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    protected void increaseCapacity() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.capacity:()J");
        long l = this.capacity() + 1L;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.ensureCapacity:(J)V");
        this.ensureCapacity(l);
    }

    public E get(long l) {
        RuntimeCostAccounter.recordJump();
        if (this.spineIndex == 0) {
            long l2 = l - (long)this.elementIndex;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 < 0) {
                return this.curChunk[(int)l];
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
            String string = Long.toString(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.count:()J");
        long l4 = l - this.count();
        long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l5 >= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
            String string = Long.toString(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > this.spineIndex) break;
            long l6 = l - (this.priorElementCount[n] + (long)this.spine[n].length);
            long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l7 < 0) {
                return this.spine[n][(int)(l - this.priorElementCount[n])];
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
        String string = Long.toString(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
        IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
        RuntimeCostAccounter.recordThrow();
        throw indexOutOfBoundsException;
    }

    public void copyInto(E[] EArray, int n) {
        block8: {
            block7: {
                long l = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.count:()J");
                long l2 = l + this.count();
                long l3 = l2 - (long)EArray.length;
                long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l4 > 0) break block7;
                long l5 = l2 - (long)n;
                long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l6 >= 0) break block8;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("does not fit");
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.spineIndex == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.curChunk, 0, EArray, n, this.elementIndex);
            RuntimeCostAccounter.recordJump();
        } else {
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= this.spineIndex) break;
                E[] EArray2 = this.spine[n2];
                int n3 = this.spine[n2].length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(EArray2, 0, EArray, n, n3);
                n += this.spine[n2].length;
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (this.elementIndex > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(this.curChunk, 0, EArray, n, this.elementIndex);
            }
        }
    }

    public E[] asArray(IntFunction<E[]> intFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.count:()J");
        long l = this.count();
        RuntimeCostAccounter.recordJump();
        if (l >= 0x7FFFFFF7L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n = (int)l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntFunction.apply:(I)Ljava/lang/Object;");
        E[] EArray = intFunction.apply(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.copyInto:([Ljava/lang/Object;I)V");
        this.copyInto(EArray, 0);
        return EArray;
    }

    @Override
    public void clear() {
        RuntimeCostAccounter.recordJump();
        if (this.spine != null) {
            this.curChunk = this.spine[0];
            int n = 0;
            while (true) {
                int n2 = this.curChunk.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                this.curChunk[n] = null;
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            this.spine = null;
            this.priorElementCount = null;
            RuntimeCostAccounter.recordJump();
        } else {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.elementIndex) break;
                this.curChunk[n] = null;
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        this.elementIndex = 0;
        this.spineIndex = 0;
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.spliterator:()Ljava/util/Spliterator;");
        Spliterator<E> spliterator = this.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.iterator:(Ljava/util/Spliterator;)Ljava/util/Iterator;");
        return Spliterators.iterator(spliterator);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.spineIndex) break;
            E[] EArray = this.spine[n];
            int n2 = EArray.length;
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                E e = EArray[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(e);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.elementIndex) break;
            E e = this.curChunk[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
            consumer.accept(e);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public void accept(E e) {
        block2: {
            block4: {
                block3: {
                    int n = this.curChunk.length;
                    RuntimeCostAccounter.recordJump();
                    if (this.elementIndex != n) break block2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.inflateSpine:()V");
                    this.inflateSpine();
                    int n2 = this.spine.length;
                    RuntimeCostAccounter.recordJump();
                    if (this.spineIndex + 1 >= n2) break block3;
                    E[] EArray = this.spine[this.spineIndex + 1];
                    RuntimeCostAccounter.recordJump();
                    if (EArray != null) break block4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.increaseCapacity:()V");
                this.increaseCapacity();
            }
            this.elementIndex = 0;
            ++this.spineIndex;
            this.curChunk = this.spine[this.spineIndex];
        }
        this.curChunk[this.elementIndex++] = e;
    }

    public String toString() {
        ArrayList arrayList;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList arrayList2 = arrayList = new ArrayList();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        arrayList2.getClass();
        Consumer<Object> consumer = arrayList2::add;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer.forEach:(Ljava/util/function/Consumer;)V");
        this.forEach(consumer);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("SpinedBuffer:");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string = ((Object)arrayList).toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder3.toString();
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$1Splitr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer;IIII)V");
        class Splitr
        implements Spliterator<E> {
            int splSpineIndex;
            final int lastSpineIndex;
            int splElementIndex;
            final int lastSpineElementFence;
            E[] splChunk;
            static final /* synthetic */ boolean $assertionsDisabled;

            Splitr(int n, int n2, int n3, int n4) {
                E[] EArray;
                block5: {
                    block6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                        this.splSpineIndex = n;
                        this.lastSpineIndex = n2;
                        this.splElementIndex = n3;
                        this.lastSpineElementFence = n4;
                        RuntimeCostAccounter.recordJump();
                        if ($assertionsDisabled) break block5;
                        E[][] EArray2 = SpinedBuffer.this.spine;
                        RuntimeCostAccounter.recordJump();
                        if (EArray2 != null) break block5;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) break block6;
                        RuntimeCostAccounter.recordJump();
                        if (n2 == 0) break block5;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
                E[][] EArray3 = SpinedBuffer.this.spine;
                RuntimeCostAccounter.recordJump();
                if (EArray3 == null) {
                    EArray = SpinedBuffer.this.curChunk;
                    RuntimeCostAccounter.recordJump();
                } else {
                    EArray = SpinedBuffer.this.spine[n];
                }
                this.splChunk = EArray;
            }

            @Override
            public long estimateSize() {
                long l;
                RuntimeCostAccounter.recordJump();
                if (this.splSpineIndex == this.lastSpineIndex) {
                    l = (long)this.lastSpineElementFence - (long)this.splElementIndex;
                    RuntimeCostAccounter.recordJump();
                } else {
                    l = SpinedBuffer.this.priorElementCount[this.lastSpineIndex] + (long)this.lastSpineElementFence - SpinedBuffer.this.priorElementCount[this.splSpineIndex] - (long)this.splElementIndex;
                }
                return l;
            }

            @Override
            public int characteristics() {
                return 16464;
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> consumer) {
                block7: {
                    block6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                        Objects.requireNonNull(consumer);
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex < this.lastSpineIndex) break block6;
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex != this.lastSpineIndex) break block7;
                        RuntimeCostAccounter.recordJump();
                        if (this.splElementIndex >= this.lastSpineElementFence) break block7;
                    }
                    Object e = this.splChunk[this.splElementIndex++];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(e);
                    int n = this.splChunk.length;
                    RuntimeCostAccounter.recordJump();
                    if (this.splElementIndex == n) {
                        this.splElementIndex = 0;
                        ++this.splSpineIndex;
                        E[][] EArray = SpinedBuffer.this.spine;
                        RuntimeCostAccounter.recordJump();
                        if (EArray != null) {
                            RuntimeCostAccounter.recordJump();
                            if (this.splSpineIndex <= this.lastSpineIndex) {
                                this.splChunk = SpinedBuffer.this.spine[this.splSpineIndex];
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super E> consumer) {
                block9: {
                    E[] EArray;
                    block8: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                        Objects.requireNonNull(consumer);
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex < this.lastSpineIndex) break block8;
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex != this.lastSpineIndex) break block9;
                        RuntimeCostAccounter.recordJump();
                        if (this.splElementIndex >= this.lastSpineElementFence) break block9;
                    }
                    int n = this.splElementIndex;
                    int n2 = this.splSpineIndex;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 >= this.lastSpineIndex) break;
                        E[] EArray2 = SpinedBuffer.this.spine[n2];
                        while (true) {
                            int n3 = EArray2.length;
                            RuntimeCostAccounter.recordJump();
                            if (n >= n3) break;
                            Object e = EArray2[n];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(e);
                            ++n;
                            RuntimeCostAccounter.recordJump();
                        }
                        n = 0;
                        ++n2;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.splSpineIndex == this.lastSpineIndex) {
                        EArray = this.splChunk;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        EArray = SpinedBuffer.this.spine[this.lastSpineIndex];
                    }
                    E[] EArray3 = EArray;
                    int n4 = this.lastSpineElementFence;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n >= n4) break;
                        Object e = EArray3[n];
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(e);
                        ++n;
                        RuntimeCostAccounter.recordJump();
                    }
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = this.lastSpineElementFence;
                }
            }

            @Override
            public Spliterator<E> trySplit() {
                RuntimeCostAccounter.recordJump();
                if (this.splSpineIndex < this.lastSpineIndex) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$1Splitr");
                    int n = SpinedBuffer.this.spine[this.lastSpineIndex - 1].length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer;IIII)V");
                    Splitr splitr = new Splitr(this.splSpineIndex, this.lastSpineIndex - 1, this.splElementIndex, n);
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = 0;
                    this.splChunk = SpinedBuffer.this.spine[this.splSpineIndex];
                    return splitr;
                }
                RuntimeCostAccounter.recordJump();
                if (this.splSpineIndex == this.lastSpineIndex) {
                    int n = (this.lastSpineElementFence - this.splElementIndex) / 2;
                    RuntimeCostAccounter.recordJump();
                    if (n == 0) {
                        return null;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([Ljava/lang/Object;II)Ljava/util/Spliterator;");
                    Spliterator spliterator = Arrays.spliterator(this.splChunk, this.splElementIndex, this.splElementIndex + n);
                    this.splElementIndex += n;
                    return spliterator;
                }
                return null;
            }

            static {
                boolean bl;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
                boolean bl2 = SpinedBuffer.class.desiredAssertionStatus();
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                $assertionsDisabled = bl;
            }
        }
        return new Splitr(0, this.spineIndex, 0, this.elementIndex);
    }

    static class OfDouble
    extends OfPrimitive<Double, double[], DoubleConsumer>
    implements DoubleConsumer {
        OfDouble() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.<init>:()V");
        }

        OfDouble(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.<init>:(I)V");
            super(n);
        }

        @Override
        public void forEach(Consumer<? super Double> consumer) {
            boolean bl = consumer instanceof DoubleConsumer;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                DoubleConsumer doubleConsumer = (DoubleConsumer)((Object)consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.forEach:(Ljava/lang/Object;)V");
                this.forEach(doubleConsumer);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (Tripwire.ENABLED) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = this.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                    Tripwire.trip(clazz, "{0} calling SpinedBuffer.OfDouble.forEach(Consumer)");
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.spliterator:()Ljava/util/Spliterator$OfDouble;");
                Spliterator.OfDouble ofDouble = this.spliterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfDouble.forEachRemaining:(Ljava/util/function/Consumer;)V");
                ofDouble.forEachRemaining(consumer);
            }
        }

        protected double[][] newArrayArray(int n) {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            return new double[n2][];
        }

        @Override
        public double[] newArray(int n) {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            return new double[n2];
        }

        @Override
        protected int arrayLength(double[] dArray) {
            return dArray.length;
        }

        @Override
        protected void arrayForEach(double[] dArray, int n, int n2, DoubleConsumer doubleConsumer) {
            int n3 = n;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                double d = dArray[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                doubleConsumer.accept(d);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public void accept(double d) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.preAccept:()V");
            this.preAccept();
            ((double[])this.curChunk)[this.elementIndex++] = d;
        }

        public double get(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.chunkFor:(J)I");
            int n = this.chunkFor(l);
            RuntimeCostAccounter.recordJump();
            if (this.spineIndex == 0) {
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    return ((double[])this.curChunk)[(int)l];
                }
            }
            return ((double[][])this.spine)[n][(int)(l - this.priorElementCount[n])];
        }

        public PrimitiveIterator.OfDouble iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.spliterator:()Ljava/util/Spliterator$OfDouble;");
            Spliterator.OfDouble ofDouble = this.spliterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.iterator:(Ljava/util/Spliterator$OfDouble;)Ljava/util/PrimitiveIterator$OfDouble;");
            return Spliterators.iterator(ofDouble);
        }

        public Spliterator.OfDouble spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfDouble$1Splitr");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer$OfDouble;IIII)V");
            class Splitr
            extends OfPrimitive.BaseSpliterator<Spliterator.OfDouble>
            implements Spliterator.OfDouble {
                Splitr(int n, int n2, int n3, int n4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive$BaseSpliterator.<init>:(Ljava/util/stream/SpinedBuffer$OfPrimitive;IIII)V");
                    super(n, n2, n3, n4);
                }

                @Override
                Splitr newSpliterator(int n, int n2, int n3, int n4) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfDouble$1Splitr");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer$OfDouble;IIII)V");
                    return new Splitr(n, n2, n3, n4);
                }

                @Override
                void arrayForOne(double[] dArray, int n, DoubleConsumer doubleConsumer) {
                    double d = dArray[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                    doubleConsumer.accept(d);
                }

                @Override
                Spliterator.OfDouble arraySpliterator(double[] dArray, int n, int n2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([DII)Ljava/util/Spliterator$OfDouble;");
                    return Arrays.spliterator(dArray, n, n + n2);
                }
            }
            return new Splitr(0, this.spineIndex, 0, this.elementIndex);
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.asPrimitiveArray:()Ljava/lang/Object;");
            double[] dArray = (double[])this.asPrimitiveArray();
            int n = dArray.length;
            RuntimeCostAccounter.recordJump();
            if (n < 200) {
                RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
                Object[] objectArray = new Object[4];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
                objectArray[0] = clazz.getSimpleName();
                int n2 = dArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[2] = this.spineIndex;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([D)Ljava/lang/String;");
                objectArray[3] = Arrays.toString(dArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                return String.format("%s[length=%d, chunks=%d]%s", objectArray);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([DI)[D");
            double[] dArray2 = Arrays.copyOf(dArray, 200);
            RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
            Object[] objectArray = new Object[4];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
            objectArray[0] = clazz.getSimpleName();
            int n3 = dArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[1] = n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[2] = this.spineIndex;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([D)Ljava/lang/String;");
            objectArray[3] = Arrays.toString(dArray2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("%s[length=%d, chunks=%d]%s...", objectArray);
        }
    }

    static class OfLong
    extends OfPrimitive<Long, long[], LongConsumer>
    implements LongConsumer {
        OfLong() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.<init>:()V");
        }

        OfLong(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.<init>:(I)V");
            super(n);
        }

        @Override
        public void forEach(Consumer<? super Long> consumer) {
            boolean bl = consumer instanceof LongConsumer;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                LongConsumer longConsumer = (LongConsumer)((Object)consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.forEach:(Ljava/lang/Object;)V");
                this.forEach(longConsumer);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (Tripwire.ENABLED) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = this.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                    Tripwire.trip(clazz, "{0} calling SpinedBuffer.OfLong.forEach(Consumer)");
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.spliterator:()Ljava/util/Spliterator$OfLong;");
                Spliterator.OfLong ofLong = this.spliterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfLong.forEachRemaining:(Ljava/util/function/Consumer;)V");
                ofLong.forEachRemaining(consumer);
            }
        }

        protected long[][] newArrayArray(int n) {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            return new long[n2][];
        }

        @Override
        public long[] newArray(int n) {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            return new long[n2];
        }

        @Override
        protected int arrayLength(long[] lArray) {
            return lArray.length;
        }

        @Override
        protected void arrayForEach(long[] lArray, int n, int n2, LongConsumer longConsumer) {
            int n3 = n;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                long l = lArray[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                longConsumer.accept(l);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public void accept(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.preAccept:()V");
            this.preAccept();
            ((long[])this.curChunk)[this.elementIndex++] = l;
        }

        public long get(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.chunkFor:(J)I");
            int n = this.chunkFor(l);
            RuntimeCostAccounter.recordJump();
            if (this.spineIndex == 0) {
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    return ((long[])this.curChunk)[(int)l];
                }
            }
            return ((long[][])this.spine)[n][(int)(l - this.priorElementCount[n])];
        }

        public PrimitiveIterator.OfLong iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.spliterator:()Ljava/util/Spliterator$OfLong;");
            Spliterator.OfLong ofLong = this.spliterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.iterator:(Ljava/util/Spliterator$OfLong;)Ljava/util/PrimitiveIterator$OfLong;");
            return Spliterators.iterator(ofLong);
        }

        public Spliterator.OfLong spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfLong$1Splitr");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer$OfLong;IIII)V");
            class Splitr
            extends OfPrimitive.BaseSpliterator<Spliterator.OfLong>
            implements Spliterator.OfLong {
                Splitr(int n, int n2, int n3, int n4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive$BaseSpliterator.<init>:(Ljava/util/stream/SpinedBuffer$OfPrimitive;IIII)V");
                    super(n, n2, n3, n4);
                }

                @Override
                Splitr newSpliterator(int n, int n2, int n3, int n4) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfLong$1Splitr");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer$OfLong;IIII)V");
                    return new Splitr(n, n2, n3, n4);
                }

                @Override
                void arrayForOne(long[] lArray, int n, LongConsumer longConsumer) {
                    long l = lArray[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                    longConsumer.accept(l);
                }

                @Override
                Spliterator.OfLong arraySpliterator(long[] lArray, int n, int n2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([JII)Ljava/util/Spliterator$OfLong;");
                    return Arrays.spliterator(lArray, n, n + n2);
                }
            }
            return new Splitr(0, this.spineIndex, 0, this.elementIndex);
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.asPrimitiveArray:()Ljava/lang/Object;");
            long[] lArray = (long[])this.asPrimitiveArray();
            int n = lArray.length;
            RuntimeCostAccounter.recordJump();
            if (n < 200) {
                RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
                Object[] objectArray = new Object[4];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
                objectArray[0] = clazz.getSimpleName();
                int n2 = lArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[2] = this.spineIndex;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([J)Ljava/lang/String;");
                objectArray[3] = Arrays.toString(lArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                return String.format("%s[length=%d, chunks=%d]%s", objectArray);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
            long[] lArray2 = Arrays.copyOf(lArray, 200);
            RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
            Object[] objectArray = new Object[4];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
            objectArray[0] = clazz.getSimpleName();
            int n3 = lArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[1] = n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[2] = this.spineIndex;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([J)Ljava/lang/String;");
            objectArray[3] = Arrays.toString(lArray2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("%s[length=%d, chunks=%d]%s...", objectArray);
        }
    }

    static class OfInt
    extends OfPrimitive<Integer, int[], IntConsumer>
    implements IntConsumer {
        OfInt() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.<init>:()V");
        }

        OfInt(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.<init>:(I)V");
            super(n);
        }

        @Override
        public void forEach(Consumer<? super Integer> consumer) {
            boolean bl = consumer instanceof IntConsumer;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                IntConsumer intConsumer = (IntConsumer)((Object)consumer);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.forEach:(Ljava/lang/Object;)V");
                this.forEach(intConsumer);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (Tripwire.ENABLED) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                    Class<?> clazz = this.getClass();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Tripwire.trip:(Ljava/lang/Class;Ljava/lang/String;)V");
                    Tripwire.trip(clazz, "{0} calling SpinedBuffer.OfInt.forEach(Consumer)");
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.spliterator:()Ljava/util/Spliterator$OfInt;");
                Spliterator.OfInt ofInt = this.spliterator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator$OfInt.forEachRemaining:(Ljava/util/function/Consumer;)V");
                ofInt.forEachRemaining(consumer);
            }
        }

        protected int[][] newArrayArray(int n) {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            return new int[n2][];
        }

        @Override
        public int[] newArray(int n) {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
            return new int[n2];
        }

        @Override
        protected int arrayLength(int[] nArray) {
            return nArray.length;
        }

        @Override
        protected void arrayForEach(int[] nArray, int n, int n2, IntConsumer intConsumer) {
            int n3 = n;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                int n4 = nArray[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                intConsumer.accept(n4);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public void accept(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.preAccept:()V");
            this.preAccept();
            ((int[])this.curChunk)[this.elementIndex++] = n;
        }

        public int get(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.chunkFor:(J)I");
            int n = this.chunkFor(l);
            RuntimeCostAccounter.recordJump();
            if (this.spineIndex == 0) {
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    return ((int[])this.curChunk)[(int)l];
                }
            }
            return ((int[][])this.spine)[n][(int)(l - this.priorElementCount[n])];
        }

        public PrimitiveIterator.OfInt iterator() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.spliterator:()Ljava/util/Spliterator$OfInt;");
            Spliterator.OfInt ofInt = this.spliterator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.iterator:(Ljava/util/Spliterator$OfInt;)Ljava/util/PrimitiveIterator$OfInt;");
            return Spliterators.iterator(ofInt);
        }

        public Spliterator.OfInt spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfInt$1Splitr");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer$OfInt;IIII)V");
            class Splitr
            extends OfPrimitive.BaseSpliterator<Spliterator.OfInt>
            implements Spliterator.OfInt {
                Splitr(int n, int n2, int n3, int n4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive$BaseSpliterator.<init>:(Ljava/util/stream/SpinedBuffer$OfPrimitive;IIII)V");
                    super(n, n2, n3, n4);
                }

                @Override
                Splitr newSpliterator(int n, int n2, int n3, int n4) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfInt$1Splitr");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt$1Splitr.<init>:(Ljava/util/stream/SpinedBuffer$OfInt;IIII)V");
                    return new Splitr(n, n2, n3, n4);
                }

                @Override
                void arrayForOne(int[] nArray, int n, IntConsumer intConsumer) {
                    int n2 = nArray[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                    intConsumer.accept(n2);
                }

                @Override
                Spliterator.OfInt arraySpliterator(int[] nArray, int n, int n2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.spliterator:([III)Ljava/util/Spliterator$OfInt;");
                    return Arrays.spliterator(nArray, n, n + n2);
                }
            }
            return new Splitr(0, this.spineIndex, 0, this.elementIndex);
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.asPrimitiveArray:()Ljava/lang/Object;");
            int[] nArray = (int[])this.asPrimitiveArray();
            int n = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n < 200) {
                RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
                Object[] objectArray = new Object[4];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = this.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
                objectArray[0] = clazz.getSimpleName();
                int n2 = nArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[1] = n2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                objectArray[2] = this.spineIndex;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([I)Ljava/lang/String;");
                objectArray[3] = Arrays.toString(nArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
                return String.format("%s[length=%d, chunks=%d]%s", objectArray);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([II)[I");
            int[] nArray2 = Arrays.copyOf(nArray, 200);
            RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
            Object[] objectArray = new Object[4];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
            objectArray[0] = clazz.getSimpleName();
            int n3 = nArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[1] = n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[2] = this.spineIndex;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([I)Ljava/lang/String;");
            objectArray[3] = Arrays.toString(nArray2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            return String.format("%s[length=%d, chunks=%d]%s...", objectArray);
        }
    }

    static abstract class OfPrimitive<E, T_ARR, T_CONS>
    extends AbstractSpinedBuffer
    implements Iterable<E> {
        T_ARR curChunk;
        T_ARR[] spine;

        OfPrimitive(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractSpinedBuffer.<init>:(I)V");
            super(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.newArray:(I)Ljava/lang/Object;");
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        OfPrimitive() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractSpinedBuffer.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.newArray:(I)Ljava/lang/Object;");
            this.curChunk = this.newArray(1 << this.initialChunkPower);
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract void forEach(Consumer<? super E> var1);

        protected abstract T_ARR[] newArrayArray(int var1);

        public abstract T_ARR newArray(int var1);

        protected abstract int arrayLength(T_ARR var1);

        protected abstract void arrayForEach(T_ARR var1, int var2, int var3, T_CONS var4);

        protected long capacity() {
            long l;
            RuntimeCostAccounter.recordJump();
            if (this.spineIndex == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                l = this.arrayLength(this.curChunk);
                RuntimeCostAccounter.recordJump();
            } else {
                long l2 = this.priorElementCount[this.spineIndex];
                T_ARR T_ARR = this.spine[this.spineIndex];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                l = l2 + (long)this.arrayLength(T_ARR);
            }
            return l;
        }

        private void inflateSpine() {
            RuntimeCostAccounter.recordJump();
            if (this.spine == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.newArrayArray:(I)[Ljava/lang/Object;");
                this.spine = this.newArrayArray(8);
                RuntimeCostAccounter.recordArrayAllocation((int)8, (int)8);
                this.priorElementCount = new long[8];
                this.spine[0] = this.curChunk;
            }
        }

        protected final void ensureCapacity(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.capacity:()J");
            long l2 = this.capacity();
            RuntimeCostAccounter.recordJump();
            if (l > l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.inflateSpine:()V");
                this.inflateSpine();
                int n = this.spineIndex + 1;
                while (true) {
                    int n2;
                    RuntimeCostAccounter.recordJump();
                    if (l <= l2) break;
                    int n3 = this.spine.length;
                    RuntimeCostAccounter.recordJump();
                    if (n >= n3) {
                        n2 = this.spine.length * 2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                        this.spine = Arrays.copyOf(this.spine, n2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([JI)[J");
                        this.priorElementCount = Arrays.copyOf(this.priorElementCount, n2);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.chunkSize:(I)I");
                    n2 = this.chunkSize(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.newArray:(I)Ljava/lang/Object;");
                    this.spine[n] = this.newArray(n2);
                    long l3 = this.priorElementCount[n - 1];
                    T_ARR T_ARR = this.spine[n - 1];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                    this.priorElementCount[n] = l3 + (long)this.arrayLength(T_ARR);
                    l2 += (long)n2;
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }

        protected void increaseCapacity() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.capacity:()J");
            long l = this.capacity() + 1L;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.ensureCapacity:(J)V");
            this.ensureCapacity(l);
        }

        protected int chunkFor(long l) {
            RuntimeCostAccounter.recordJump();
            if (this.spineIndex == 0) {
                long l2 = l - (long)this.elementIndex;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 < 0) {
                    return 0;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
                String string = Long.toString(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.count:()J");
            long l4 = l - this.count();
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 >= 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
                String string = Long.toString(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n > this.spineIndex) break;
                long l6 = this.priorElementCount[n];
                T_ARR T_ARR = this.spine[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                long l7 = l - (l6 + (long)this.arrayLength(T_ARR));
                long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l8 < 0) {
                    return n;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
            String string = Long.toString(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }

        public void copyInto(T_ARR T_ARR, int n) {
            block8: {
                block7: {
                    long l = n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.count:()J");
                    long l2 = l + this.count();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                    long l3 = l2 - (long)this.arrayLength(T_ARR);
                    long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l4 > 0) break block7;
                    long l5 = l2 - (long)n;
                    long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l6 >= 0) break block8;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("does not fit");
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.spineIndex == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(this.curChunk, 0, T_ARR, n, this.elementIndex);
                RuntimeCostAccounter.recordJump();
            } else {
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= this.spineIndex) break;
                    T_ARR T_ARR2 = this.spine[n2];
                    T_ARR T_ARR3 = this.spine[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                    int n3 = this.arrayLength(T_ARR3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(T_ARR2, 0, T_ARR, n, n3);
                    T_ARR T_ARR4 = this.spine[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                    n += this.arrayLength(T_ARR4);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (this.elementIndex > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(this.curChunk, 0, T_ARR, n, this.elementIndex);
                }
            }
        }

        public T_ARR asPrimitiveArray() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.count:()J");
            long l = this.count();
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.newArray:(I)Ljava/lang/Object;");
            T_ARR T_ARR = this.newArray(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.copyInto:(Ljava/lang/Object;I)V");
            this.copyInto(T_ARR, 0);
            return T_ARR;
        }

        protected void preAccept() {
            block2: {
                block4: {
                    block3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                        int n = this.arrayLength(this.curChunk);
                        RuntimeCostAccounter.recordJump();
                        if (this.elementIndex != n) break block2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.inflateSpine:()V");
                        this.inflateSpine();
                        int n2 = this.spine.length;
                        RuntimeCostAccounter.recordJump();
                        if (this.spineIndex + 1 >= n2) break block3;
                        T_ARR T_ARR = this.spine[this.spineIndex + 1];
                        RuntimeCostAccounter.recordJump();
                        if (T_ARR != null) break block4;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.increaseCapacity:()V");
                    this.increaseCapacity();
                }
                this.elementIndex = 0;
                ++this.spineIndex;
                this.curChunk = this.spine[this.spineIndex];
            }
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordJump();
            if (this.spine != null) {
                this.curChunk = this.spine[0];
                this.spine = null;
                this.priorElementCount = null;
            }
            this.elementIndex = 0;
            this.spineIndex = 0;
        }

        public void forEach(T_CONS T_CONS) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.spineIndex) break;
                T_ARR T_ARR = this.spine[n];
                T_ARR T_ARR2 = this.spine[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                int n2 = this.arrayLength(T_ARR2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayForEach:(Ljava/lang/Object;IILjava/lang/Object;)V");
                this.arrayForEach(T_ARR, 0, n2, T_CONS);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayForEach:(Ljava/lang/Object;IILjava/lang/Object;)V");
            this.arrayForEach(this.curChunk, 0, this.elementIndex, T_CONS);
        }

        abstract class BaseSpliterator<T_SPLITR extends Spliterator.OfPrimitive<E, T_CONS, T_SPLITR>>
        implements Spliterator.OfPrimitive<E, T_CONS, T_SPLITR> {
            int splSpineIndex;
            final int lastSpineIndex;
            int splElementIndex;
            final int lastSpineElementFence;
            T_ARR splChunk;
            static final /* synthetic */ boolean $assertionsDisabled;

            BaseSpliterator(int n, int n2, int n3, int n4) {
                Object T_ARR;
                block5: {
                    block6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                        this.splSpineIndex = n;
                        this.lastSpineIndex = n2;
                        this.splElementIndex = n3;
                        this.lastSpineElementFence = n4;
                        RuntimeCostAccounter.recordJump();
                        if ($assertionsDisabled) break block5;
                        T_ARR[] T_ARRArray = OfPrimitive.this.spine;
                        RuntimeCostAccounter.recordJump();
                        if (T_ARRArray != null) break block5;
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) break block6;
                        RuntimeCostAccounter.recordJump();
                        if (n2 == 0) break block5;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
                T_ARR[] T_ARRArray = OfPrimitive.this.spine;
                RuntimeCostAccounter.recordJump();
                if (T_ARRArray == null) {
                    T_ARR = OfPrimitive.this.curChunk;
                    RuntimeCostAccounter.recordJump();
                } else {
                    T_ARR = OfPrimitive.this.spine[n];
                }
                this.splChunk = T_ARR;
            }

            abstract T_SPLITR newSpliterator(int var1, int var2, int var3, int var4);

            abstract void arrayForOne(T_ARR var1, int var2, T_CONS var3);

            abstract T_SPLITR arraySpliterator(T_ARR var1, int var2, int var3);

            @Override
            public long estimateSize() {
                long l;
                RuntimeCostAccounter.recordJump();
                if (this.splSpineIndex == this.lastSpineIndex) {
                    l = (long)this.lastSpineElementFence - (long)this.splElementIndex;
                    RuntimeCostAccounter.recordJump();
                } else {
                    l = OfPrimitive.this.priorElementCount[this.lastSpineIndex] + (long)this.lastSpineElementFence - OfPrimitive.this.priorElementCount[this.splSpineIndex] - (long)this.splElementIndex;
                }
                return l;
            }

            @Override
            public int characteristics() {
                return 16464;
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                block7: {
                    block6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                        Objects.requireNonNull(T_CONS);
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex < this.lastSpineIndex) break block6;
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex != this.lastSpineIndex) break block7;
                        RuntimeCostAccounter.recordJump();
                        if (this.splElementIndex >= this.lastSpineElementFence) break block7;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive$BaseSpliterator.arrayForOne:(Ljava/lang/Object;ILjava/lang/Object;)V");
                    this.arrayForOne(this.splChunk, this.splElementIndex++, T_CONS);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                    int n = OfPrimitive.this.arrayLength(this.splChunk);
                    RuntimeCostAccounter.recordJump();
                    if (this.splElementIndex == n) {
                        this.splElementIndex = 0;
                        ++this.splSpineIndex;
                        T_ARR[] T_ARRArray = OfPrimitive.this.spine;
                        RuntimeCostAccounter.recordJump();
                        if (T_ARRArray != null) {
                            RuntimeCostAccounter.recordJump();
                            if (this.splSpineIndex <= this.lastSpineIndex) {
                                this.splChunk = OfPrimitive.this.spine[this.splSpineIndex];
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                block7: {
                    Object T_ARR;
                    block6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                        Objects.requireNonNull(T_CONS);
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex < this.lastSpineIndex) break block6;
                        RuntimeCostAccounter.recordJump();
                        if (this.splSpineIndex != this.lastSpineIndex) break block7;
                        RuntimeCostAccounter.recordJump();
                        if (this.splElementIndex >= this.lastSpineElementFence) break block7;
                    }
                    int n = this.splElementIndex;
                    int n2 = this.splSpineIndex;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 >= this.lastSpineIndex) break;
                        Object T_ARR2 = OfPrimitive.this.spine[n2];
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                        int n3 = OfPrimitive.this.arrayLength(T_ARR2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayForEach:(Ljava/lang/Object;IILjava/lang/Object;)V");
                        OfPrimitive.this.arrayForEach(T_ARR2, n, n3, T_CONS);
                        n = 0;
                        ++n2;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.splSpineIndex == this.lastSpineIndex) {
                        T_ARR = this.splChunk;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        T_ARR = OfPrimitive.this.spine[this.lastSpineIndex];
                    }
                    Object T_ARR3 = T_ARR;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayForEach:(Ljava/lang/Object;IILjava/lang/Object;)V");
                    OfPrimitive.this.arrayForEach(T_ARR3, n, this.lastSpineElementFence, T_CONS);
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = this.lastSpineElementFence;
                }
            }

            @Override
            public T_SPLITR trySplit() {
                RuntimeCostAccounter.recordJump();
                if (this.splSpineIndex < this.lastSpineIndex) {
                    Object T_ARR = OfPrimitive.this.spine[this.lastSpineIndex - 1];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive.arrayLength:(Ljava/lang/Object;)I");
                    int n = OfPrimitive.this.arrayLength(T_ARR);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive$BaseSpliterator.newSpliterator:(IIII)Ljava/util/Spliterator$OfPrimitive;");
                    T_SPLITR T_SPLITR = this.newSpliterator(this.splSpineIndex, this.lastSpineIndex - 1, this.splElementIndex, n);
                    this.splSpineIndex = this.lastSpineIndex;
                    this.splElementIndex = 0;
                    this.splChunk = OfPrimitive.this.spine[this.splSpineIndex];
                    return T_SPLITR;
                }
                RuntimeCostAccounter.recordJump();
                if (this.splSpineIndex == this.lastSpineIndex) {
                    int n = (this.lastSpineElementFence - this.splElementIndex) / 2;
                    RuntimeCostAccounter.recordJump();
                    if (n == 0) {
                        return null;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfPrimitive$BaseSpliterator.arraySpliterator:(Ljava/lang/Object;II)Ljava/util/Spliterator$OfPrimitive;");
                    T_SPLITR T_SPLITR = this.arraySpliterator(this.splChunk, this.splElementIndex, n);
                    this.splElementIndex += n;
                    return T_SPLITR;
                }
                return null;
            }

            static {
                boolean bl;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
                boolean bl2 = SpinedBuffer.class.desiredAssertionStatus();
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                $assertionsDisabled = bl;
            }
        }
    }
}

