/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Objects;
import sandbox.java.util.Optional;
import sandbox.java.util.OptionalDouble;
import sandbox.java.util.OptionalInt;
import sandbox.java.util.OptionalLong;
import sandbox.java.util.Set;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.CountedCompleter;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.BinaryOperator;
import sandbox.java.util.function.DoubleBinaryOperator;
import sandbox.java.util.function.IntBinaryOperator;
import sandbox.java.util.function.LongBinaryOperator;
import sandbox.java.util.function.ObjDoubleConsumer;
import sandbox.java.util.function.ObjIntConsumer;
import sandbox.java.util.function.ObjLongConsumer;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.stream.AbstractTask;
import sandbox.java.util.stream.Collector;
import sandbox.java.util.stream.PipelineHelper;
import sandbox.java.util.stream.Sink;
import sandbox.java.util.stream.StreamOpFlag;
import sandbox.java.util.stream.StreamShape;
import sandbox.java.util.stream.TerminalOp;
import sandbox.java.util.stream.TerminalSink;

final class ReduceOps {
    private ReduceOps() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static <T, U> TerminalOp<T, U> makeRef(final U u, final BiFunction<U, ? super T, U> biFunction, final BinaryOperator<U> binaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(binaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$1.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/BinaryOperator;Ljava/util/function/BiFunction;Ljava/lang/Object;)V");
        return new ReduceOp<T, U, 1ReducingSink>(StreamShape.REFERENCE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 1ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$1ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$1ReducingSink.<init>:(Ljava/lang/Object;Ljava/util/function/BiFunction;Ljava/util/function/BinaryOperator;)V");
                class ReducingSink
                extends Box<U>
                implements AccumulatingSink<T, U, ReducingSink> {
                    final /* synthetic */ Object val$seed;
                    final /* synthetic */ BiFunction val$reducer;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$seed = object;
                        this.val$reducer = biFunction;
                        this.val$combiner = binaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$Box.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$seed;
                    }

                    @Override
                    public void accept(T t) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.state = this.val$reducer.apply(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        Object object = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.state = this.val$combiner.apply(this.state, object);
                    }
                }
                return new ReducingSink(u, biFunction, binaryOperator);
            }
        };
    }

    public static <T> TerminalOp<T, Optional<T>> makeRef(final BinaryOperator<T> binaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(binaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$2.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/BinaryOperator;)V");
        return new ReduceOp<T, Optional<T>, 2ReducingSink>(StreamShape.REFERENCE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 2ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$2ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$2ReducingSink.<init>:(Ljava/util/function/BinaryOperator;)V");
                class ReducingSink
                implements AccumulatingSink<T, Optional<T>, ReducingSink> {
                    private boolean empty;
                    private T state;
                    final /* synthetic */ BinaryOperator val$operator;

                    ReducingSink(BinaryOperator binaryOperator) {
                        this.val$operator = binaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = null;
                    }

                    @Override
                    public void accept(T t) {
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            this.empty = false;
                            this.state = t;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            this.state = this.val$operator.apply(this.state, t);
                        }
                    }

                    @Override
                    public Optional<T> get() {
                        Optional optional;
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.empty:()Ljava/util/Optional;");
                            optional = Optional.empty();
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.of:(Ljava/lang/Object;)Ljava/util/Optional;");
                            optional = Optional.of(this.state);
                        }
                        return optional;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        boolean bl = reducingSink.empty;
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            Object t = reducingSink.state;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$2ReducingSink.accept:(Ljava/lang/Object;)V");
                            this.accept(t);
                        }
                    }
                }
                return new ReducingSink(binaryOperator);
            }
        };
    }

    public static <T, I> TerminalOp<T, I> makeRef(final Collector<? super T, I, ?> collector) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.supplier:()Ljava/util/function/Supplier;");
        final Supplier<I> supplier = Objects.requireNonNull(collector).supplier();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.accumulator:()Ljava/util/function/BiConsumer;");
        final BiConsumer<I, ? super T> biConsumer = collector.accumulator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.combiner:()Ljava/util/function/BinaryOperator;");
        final BinaryOperator<I> binaryOperator = collector.combiner();
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$3");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$3.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/BinaryOperator;Ljava/util/function/BiConsumer;Ljava/util/function/Supplier;Ljava/util/stream/Collector;)V");
        return new ReduceOp<T, I, 3ReducingSink>(StreamShape.REFERENCE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 3ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$3ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$3ReducingSink.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BinaryOperator;)V");
                class ReducingSink
                extends Box<I>
                implements AccumulatingSink<T, I, ReducingSink> {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ BiConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = biConsumer;
                        this.val$combiner = binaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$Box.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(T t) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        Object object = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.state = this.val$combiner.apply(this.state, object);
                    }
                }
                return new ReducingSink(supplier, biConsumer, binaryOperator);
            }

            @Override
            public int getOpFlags() {
                int n;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Collector.characteristics:()Ljava/util/Set;");
                Set<Collector.Characteristics> set = collector.characteristics();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
                boolean bl = set.contains((Object)Collector.Characteristics.UNORDERED);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    n = StreamOpFlag.NOT_ORDERED;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 0;
                }
                return n;
            }
        };
    }

    public static <T, R> TerminalOp<T, R> makeRef(final Supplier<R> supplier, final BiConsumer<R, ? super T> biConsumer, final BiConsumer<R, R> biConsumer2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(supplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biConsumer);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biConsumer2);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$4");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$4.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;Ljava/util/function/Supplier;)V");
        return new ReduceOp<T, R, 4ReducingSink>(StreamShape.REFERENCE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 4ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$4ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$4ReducingSink.<init>:(Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;)V");
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<T, R, ReducingSink> {
                    final /* synthetic */ Supplier val$seedFactory;
                    final /* synthetic */ BiConsumer val$accumulator;
                    final /* synthetic */ BiConsumer val$reducer;

                    ReducingSink() {
                        this.val$seedFactory = supplier;
                        this.val$accumulator = biConsumer;
                        this.val$reducer = biConsumer2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$Box.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                        this.state = this.val$seedFactory.get();
                    }

                    @Override
                    public void accept(T t) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        Object object = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                        this.val$reducer.accept(this.state, object);
                    }
                }
                return new ReducingSink(supplier, biConsumer, biConsumer2);
            }
        };
    }

    public static TerminalOp<Integer, Integer> makeInt(final int n, final IntBinaryOperator intBinaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(intBinaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$5");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$5.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/IntBinaryOperator;I)V");
        return new ReduceOp<Integer, Integer, 5ReducingSink>(StreamShape.INT_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 5ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$5ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$5ReducingSink.<init>:(ILjava/util/function/IntBinaryOperator;)V");
                class ReducingSink
                implements AccumulatingSink<Integer, Integer, ReducingSink>,
                Sink.OfInt {
                    private int state;
                    final /* synthetic */ int val$identity;
                    final /* synthetic */ IntBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = n;
                        this.val$operator = intBinaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(int n) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntBinaryOperator.applyAsInt:(II)I");
                        this.state = this.val$operator.applyAsInt(this.state, n);
                    }

                    @Override
                    public Integer get() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        int n = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$5ReducingSink.accept:(I)V");
                        this.accept(n);
                    }
                }
                return new ReducingSink(n, intBinaryOperator);
            }
        };
    }

    public static TerminalOp<Integer, OptionalInt> makeInt(final IntBinaryOperator intBinaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(intBinaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$6");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$6.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/IntBinaryOperator;)V");
        return new ReduceOp<Integer, OptionalInt, 6ReducingSink>(StreamShape.INT_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 6ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$6ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$6ReducingSink.<init>:(Ljava/util/function/IntBinaryOperator;)V");
                class ReducingSink
                implements AccumulatingSink<Integer, OptionalInt, ReducingSink>,
                Sink.OfInt {
                    private boolean empty;
                    private int state;
                    final /* synthetic */ IntBinaryOperator val$operator;

                    ReducingSink(IntBinaryOperator intBinaryOperator) {
                        this.val$operator = intBinaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = 0;
                    }

                    @Override
                    public void accept(int n) {
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            this.empty = false;
                            this.state = n;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntBinaryOperator.applyAsInt:(II)I");
                            this.state = this.val$operator.applyAsInt(this.state, n);
                        }
                    }

                    @Override
                    public OptionalInt get() {
                        OptionalInt optionalInt;
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalInt.empty:()Ljava/util/OptionalInt;");
                            optionalInt = OptionalInt.empty();
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalInt.of:(I)Ljava/util/OptionalInt;");
                            optionalInt = OptionalInt.of(this.state);
                        }
                        return optionalInt;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        boolean bl = reducingSink.empty;
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            int n = reducingSink.state;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$6ReducingSink.accept:(I)V");
                            this.accept(n);
                        }
                    }
                }
                return new ReducingSink(intBinaryOperator);
            }
        };
    }

    public static <R> TerminalOp<Integer, R> makeInt(final Supplier<R> supplier, final ObjIntConsumer<R> objIntConsumer, final BinaryOperator<R> binaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(supplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(objIntConsumer);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(binaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$7");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$7.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/BinaryOperator;Ljava/util/function/ObjIntConsumer;Ljava/util/function/Supplier;)V");
        return new ReduceOp<Integer, R, 7ReducingSink>(StreamShape.INT_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 7ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$7ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$7ReducingSink.<init>:(Ljava/util/function/Supplier;Ljava/util/function/ObjIntConsumer;Ljava/util/function/BinaryOperator;)V");
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Integer, R, ReducingSink>,
                Sink.OfInt {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjIntConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objIntConsumer;
                        this.val$combiner = binaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$Box.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(int n) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ObjIntConsumer.accept:(Ljava/lang/Object;I)V");
                        this.val$accumulator.accept(this.state, n);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        Object object = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.state = this.val$combiner.apply(this.state, object);
                    }
                }
                return new ReducingSink(supplier, objIntConsumer, binaryOperator);
            }
        };
    }

    public static TerminalOp<Long, Long> makeLong(final long l, final LongBinaryOperator longBinaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(longBinaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$8");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$8.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/LongBinaryOperator;J)V");
        return new ReduceOp<Long, Long, 8ReducingSink>(StreamShape.LONG_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 8ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$8ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$8ReducingSink.<init>:(JLjava/util/function/LongBinaryOperator;)V");
                class ReducingSink
                implements AccumulatingSink<Long, Long, ReducingSink>,
                Sink.OfLong {
                    private long state;
                    final /* synthetic */ long val$identity;
                    final /* synthetic */ LongBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = l;
                        this.val$operator = longBinaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(long l) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongBinaryOperator.applyAsLong:(JJ)J");
                        this.state = this.val$operator.applyAsLong(this.state, l);
                    }

                    @Override
                    public Long get() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        long l = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$8ReducingSink.accept:(J)V");
                        this.accept(l);
                    }
                }
                return new ReducingSink(l, longBinaryOperator);
            }
        };
    }

    public static TerminalOp<Long, OptionalLong> makeLong(final LongBinaryOperator longBinaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(longBinaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$9");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$9.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/LongBinaryOperator;)V");
        return new ReduceOp<Long, OptionalLong, 9ReducingSink>(StreamShape.LONG_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 9ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$9ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$9ReducingSink.<init>:(Ljava/util/function/LongBinaryOperator;)V");
                class ReducingSink
                implements AccumulatingSink<Long, OptionalLong, ReducingSink>,
                Sink.OfLong {
                    private boolean empty;
                    private long state;
                    final /* synthetic */ LongBinaryOperator val$operator;

                    ReducingSink(LongBinaryOperator longBinaryOperator) {
                        this.val$operator = longBinaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = 0L;
                    }

                    @Override
                    public void accept(long l) {
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            this.empty = false;
                            this.state = l;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongBinaryOperator.applyAsLong:(JJ)J");
                            this.state = this.val$operator.applyAsLong(this.state, l);
                        }
                    }

                    @Override
                    public OptionalLong get() {
                        OptionalLong optionalLong;
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalLong.empty:()Ljava/util/OptionalLong;");
                            optionalLong = OptionalLong.empty();
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalLong.of:(J)Ljava/util/OptionalLong;");
                            optionalLong = OptionalLong.of(this.state);
                        }
                        return optionalLong;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        boolean bl = reducingSink.empty;
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            long l = reducingSink.state;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$9ReducingSink.accept:(J)V");
                            this.accept(l);
                        }
                    }
                }
                return new ReducingSink(longBinaryOperator);
            }
        };
    }

    public static <R> TerminalOp<Long, R> makeLong(final Supplier<R> supplier, final ObjLongConsumer<R> objLongConsumer, final BinaryOperator<R> binaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(supplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(objLongConsumer);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(binaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$10");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$10.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/BinaryOperator;Ljava/util/function/ObjLongConsumer;Ljava/util/function/Supplier;)V");
        return new ReduceOp<Long, R, 10ReducingSink>(StreamShape.LONG_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 10ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$10ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$10ReducingSink.<init>:(Ljava/util/function/Supplier;Ljava/util/function/ObjLongConsumer;Ljava/util/function/BinaryOperator;)V");
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Long, R, ReducingSink>,
                Sink.OfLong {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjLongConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objLongConsumer;
                        this.val$combiner = binaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$Box.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(long l) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ObjLongConsumer.accept:(Ljava/lang/Object;J)V");
                        this.val$accumulator.accept(this.state, l);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        Object object = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.state = this.val$combiner.apply(this.state, object);
                    }
                }
                return new ReducingSink(supplier, objLongConsumer, binaryOperator);
            }
        };
    }

    public static TerminalOp<Double, Double> makeDouble(final double d, final DoubleBinaryOperator doubleBinaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(doubleBinaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$11");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$11.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/DoubleBinaryOperator;D)V");
        return new ReduceOp<Double, Double, 11ReducingSink>(StreamShape.DOUBLE_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 11ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$11ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$11ReducingSink.<init>:(DLjava/util/function/DoubleBinaryOperator;)V");
                class ReducingSink
                implements AccumulatingSink<Double, Double, ReducingSink>,
                Sink.OfDouble {
                    private double state;
                    final /* synthetic */ double val$identity;
                    final /* synthetic */ DoubleBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = d;
                        this.val$operator = doubleBinaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(double d) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleBinaryOperator.applyAsDouble:(DD)D");
                        this.state = this.val$operator.applyAsDouble(this.state, d);
                    }

                    @Override
                    public Double get() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        double d = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$11ReducingSink.accept:(D)V");
                        this.accept(d);
                    }
                }
                return new ReducingSink(d, doubleBinaryOperator);
            }
        };
    }

    public static TerminalOp<Double, OptionalDouble> makeDouble(final DoubleBinaryOperator doubleBinaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(doubleBinaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$12");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$12.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/DoubleBinaryOperator;)V");
        return new ReduceOp<Double, OptionalDouble, 12ReducingSink>(StreamShape.DOUBLE_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 12ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$12ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$12ReducingSink.<init>:(Ljava/util/function/DoubleBinaryOperator;)V");
                class ReducingSink
                implements AccumulatingSink<Double, OptionalDouble, ReducingSink>,
                Sink.OfDouble {
                    private boolean empty;
                    private double state;
                    final /* synthetic */ DoubleBinaryOperator val$operator;

                    ReducingSink(DoubleBinaryOperator doubleBinaryOperator) {
                        this.val$operator = doubleBinaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        this.empty = true;
                        this.state = 0.0;
                    }

                    @Override
                    public void accept(double d) {
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            this.empty = false;
                            this.state = d;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleBinaryOperator.applyAsDouble:(DD)D");
                            this.state = this.val$operator.applyAsDouble(this.state, d);
                        }
                    }

                    @Override
                    public OptionalDouble get() {
                        OptionalDouble optionalDouble;
                        RuntimeCostAccounter.recordJump();
                        if (this.empty) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalDouble.empty:()Ljava/util/OptionalDouble;");
                            optionalDouble = OptionalDouble.empty();
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalDouble.of:(D)Ljava/util/OptionalDouble;");
                            optionalDouble = OptionalDouble.of(this.state);
                        }
                        return optionalDouble;
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        boolean bl = reducingSink.empty;
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            double d = reducingSink.state;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$12ReducingSink.accept:(D)V");
                            this.accept(d);
                        }
                    }
                }
                return new ReducingSink(doubleBinaryOperator);
            }
        };
    }

    public static <R> TerminalOp<Double, R> makeDouble(final Supplier<R> supplier, final ObjDoubleConsumer<R> objDoubleConsumer, final BinaryOperator<R> binaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(supplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(objDoubleConsumer);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(binaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$13");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$13.<init>:(Ljava/util/stream/StreamShape;Ljava/util/function/BinaryOperator;Ljava/util/function/ObjDoubleConsumer;Ljava/util/function/Supplier;)V");
        return new ReduceOp<Double, R, 13ReducingSink>(StreamShape.DOUBLE_VALUE){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.<init>:(Ljava/util/stream/StreamShape;)V");
                super(streamShape);
            }

            @Override
            public 13ReducingSink makeSink() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$13ReducingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$13ReducingSink.<init>:(Ljava/util/function/Supplier;Ljava/util/function/ObjDoubleConsumer;Ljava/util/function/BinaryOperator;)V");
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Double, R, ReducingSink>,
                Sink.OfDouble {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjDoubleConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objDoubleConsumer;
                        this.val$combiner = binaryOperator;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$Box.<init>:()V");
                    }

                    @Override
                    public void begin(long l) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(double d) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ObjDoubleConsumer.accept:(Ljava/lang/Object;D)V");
                        this.val$accumulator.accept(this.state, d);
                    }

                    @Override
                    public void combine(ReducingSink reducingSink) {
                        Object object = reducingSink.state;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.state = this.val$combiner.apply(this.state, object);
                    }
                }
                return new ReducingSink(supplier, objDoubleConsumer, binaryOperator);
            }
        };
    }

    private static final class ReduceTask<P_IN, P_OUT, R, S extends AccumulatingSink<P_OUT, R, S>>
    extends AbstractTask<P_IN, P_OUT, S, ReduceTask<P_IN, P_OUT, R, S>> {
        private final ReduceOp<P_OUT, R, S> op;

        ReduceTask(ReduceOp<P_OUT, R, S> reduceOp, PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
            super(pipelineHelper, spliterator);
            this.op = reduceOp;
        }

        ReduceTask(ReduceTask<P_IN, P_OUT, R, S> reduceTask, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.<init>:(Ljava/util/stream/AbstractTask;Ljava/util/Spliterator;)V");
            super(reduceTask, spliterator);
            this.op = reduceTask.op;
        }

        @Override
        protected ReduceTask<P_IN, P_OUT, R, S> makeChild(Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$ReduceTask");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceTask.<init>:(Ljava/util/stream/ReduceOps$ReduceTask;Ljava/util/Spliterator;)V");
            return new ReduceTask<P_IN, P_OUT, R, S>(this, spliterator);
        }

        @Override
        protected S doLeaf() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.makeSink:()Ljava/util/stream/ReduceOps$AccumulatingSink;");
            S s = this.op.makeSink();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
            return (S)((AccumulatingSink)this.helper.wrapAndCopyInto(s, this.spliterator));
        }

        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceTask.isLeaf:()Z");
            boolean bl = this.isLeaf();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                ReduceTask reduceTask = (ReduceTask)this.leftChild;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceTask.getLocalResult:()Ljava/lang/Object;");
                AccumulatingSink accumulatingSink = (AccumulatingSink)reduceTask.getLocalResult();
                ReduceTask reduceTask2 = (ReduceTask)this.rightChild;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceTask.getLocalResult:()Ljava/lang/Object;");
                AccumulatingSink accumulatingSink2 = (AccumulatingSink)reduceTask2.getLocalResult();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$AccumulatingSink.combine:(Ljava/util/stream/ReduceOps$AccumulatingSink;)V");
                accumulatingSink.combine(accumulatingSink2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceTask.setLocalResult:(Ljava/lang/Object;)V");
                this.setLocalResult(accumulatingSink);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.onCompletion:(Ljava/util/concurrent/CountedCompleter;)V");
            super.onCompletion(countedCompleter);
        }
    }

    private static abstract class ReduceOp<T, R, S extends AccumulatingSink<T, R, S>>
    implements TerminalOp<T, R> {
        private final StreamShape inputShape;

        ReduceOp(StreamShape streamShape) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.inputShape = streamShape;
        }

        public abstract S makeSink();

        @Override
        public StreamShape inputShape() {
            return this.inputShape;
        }

        @Override
        public <P_IN> R evaluateSequential(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceOp.makeSink:()Ljava/util/stream/ReduceOps$AccumulatingSink;");
            S s = this.makeSink();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
            AccumulatingSink accumulatingSink = (AccumulatingSink)pipelineHelper.wrapAndCopyInto(s, spliterator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$AccumulatingSink.get:()Ljava/lang/Object;");
            return (R)accumulatingSink.get();
        }

        @Override
        public <P_IN> R evaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ReduceOps$ReduceTask");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceTask.<init>:(Ljava/util/stream/ReduceOps$ReduceOp;Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
            ReduceTask reduceTask = new ReduceTask(this, pipelineHelper, spliterator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$ReduceTask.invoke:()Ljava/lang/Object;");
            AccumulatingSink accumulatingSink = (AccumulatingSink)reduceTask.invoke();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReduceOps$AccumulatingSink.get:()Ljava/lang/Object;");
            return (R)accumulatingSink.get();
        }
    }

    private static abstract class Box<U> {
        U state;

        Box() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        public U get() {
            return this.state;
        }
    }

    private static interface AccumulatingSink<T, R, K extends AccumulatingSink<T, R, K>>
    extends TerminalSink<T, R> {
        public void combine(K var1);
    }
}

