/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Arrays;
import sandbox.java.util.IntSummaryStatistics;
import sandbox.java.util.Objects;
import sandbox.java.util.OptionalDouble;
import sandbox.java.util.OptionalInt;
import sandbox.java.util.PrimitiveIterator;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.IntBinaryOperator;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.function.IntPredicate;
import sandbox.java.util.function.IntSupplier;
import sandbox.java.util.function.IntToDoubleFunction;
import sandbox.java.util.function.IntToLongFunction;
import sandbox.java.util.function.IntUnaryOperator;
import sandbox.java.util.function.ObjIntConsumer;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.stream.BaseStream;
import sandbox.java.util.stream.DoubleStream;
import sandbox.java.util.stream.LongStream;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamSpliterators;
import sandbox.java.util.stream.StreamSupport;
import sandbox.java.util.stream.Streams;

public interface IntStream
extends BaseStream<Integer, IntStream> {
    public IntStream filter(IntPredicate var1);

    public IntStream map(IntUnaryOperator var1);

    public <U> Stream<U> mapToObj(IntFunction<? extends U> var1);

    public LongStream mapToLong(IntToLongFunction var1);

    public DoubleStream mapToDouble(IntToDoubleFunction var1);

    public IntStream flatMap(IntFunction<? extends IntStream> var1);

    public IntStream distinct();

    public IntStream sorted();

    public IntStream peek(IntConsumer var1);

    public IntStream limit(long var1);

    public IntStream skip(long var1);

    public void forEach(IntConsumer var1);

    public void forEachOrdered(IntConsumer var1);

    public int[] toArray();

    public int reduce(int var1, IntBinaryOperator var2);

    public OptionalInt reduce(IntBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjIntConsumer<R> var2, BiConsumer<R, R> var3);

    public int sum();

    public OptionalInt min();

    public OptionalInt max();

    public long count();

    public OptionalDouble average();

    public IntSummaryStatistics summaryStatistics();

    public boolean anyMatch(IntPredicate var1);

    public boolean allMatch(IntPredicate var1);

    public boolean noneMatch(IntPredicate var1);

    public OptionalInt findFirst();

    public OptionalInt findAny();

    public LongStream asLongStream();

    public DoubleStream asDoubleStream();

    public Stream<Integer> boxed();

    @Override
    public IntStream sequential();

    @Override
    public IntStream parallel();

    public PrimitiveIterator.OfInt iterator();

    public Spliterator.OfInt spliterator();

    public static Builder builder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$IntStreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$IntStreamBuilderImpl.<init>:()V");
        return new Streams.IntStreamBuilderImpl();
    }

    public static IntStream empty() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptyIntSpliterator:()Ljava/util/Spliterator$OfInt;");
        Spliterator.OfInt ofInt = Spliterators.emptyIntSpliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(ofInt, false);
    }

    public static IntStream of(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$IntStreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$IntStreamBuilderImpl.<init>:(I)V");
        Streams.IntStreamBuilderImpl intStreamBuilderImpl = new Streams.IntStreamBuilderImpl(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(intStreamBuilderImpl, false);
    }

    public static IntStream of(int ... nArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.stream:([I)Ljava/util/stream/IntStream;");
        return Arrays.stream(nArray);
    }

    public static IntStream iterate(final int n, final IntUnaryOperator intUnaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(intUnaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/IntStream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream$1.<init>:(ILjava/util/function/IntUnaryOperator;)V");
        PrimitiveIterator.OfInt ofInt = new PrimitiveIterator.OfInt(){
            int t;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.t = n;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public int nextInt() {
                int n2 = this.t;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntUnaryOperator.applyAsInt:(I)I");
                this.t = intUnaryOperator.applyAsInt(this.t);
                return n2;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliteratorUnknownSize:(Ljava/util/PrimitiveIterator$OfInt;I)Ljava/util/Spliterator$OfInt;");
        Spliterator.OfInt ofInt2 = Spliterators.spliteratorUnknownSize(ofInt, 1296);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(ofInt2, false);
    }

    public static IntStream generate(IntSupplier intSupplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(intSupplier);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfInt.<init>:(JLjava/util/function/IntSupplier;)V");
        StreamSpliterators.InfiniteSupplyingSpliterator.OfInt ofInt = new StreamSpliterators.InfiniteSupplyingSpliterator.OfInt(Long.MAX_VALUE, intSupplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(ofInt, false);
    }

    public static IntStream range(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.empty:()Ljava/util/stream/IntStream;");
            return IntStream.empty();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$RangeIntSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$RangeIntSpliterator.<init>:(IIZ)V");
        Streams.RangeIntSpliterator rangeIntSpliterator = new Streams.RangeIntSpliterator(n, n2, false);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(rangeIntSpliterator, false);
    }

    public static IntStream rangeClosed(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.empty:()Ljava/util/stream/IntStream;");
            return IntStream.empty();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$RangeIntSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$RangeIntSpliterator.<init>:(IIZ)V");
        Streams.RangeIntSpliterator rangeIntSpliterator = new Streams.RangeIntSpliterator(n, n2, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(rangeIntSpliterator, false);
    }

    /*
     * Unable to fully structure code
     */
    public static IntStream concat(IntStream var0, IntStream var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var1_1);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$ConcatSpliterator$OfInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.spliterator:()Ljava/util/Spliterator$OfInt;");
        v0 = var0.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.spliterator:()Ljava/util/Spliterator$OfInt;");
        v1 = var1_1.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$ConcatSpliterator$OfInt.<init>:(Ljava/util/Spliterator$OfInt;Ljava/util/Spliterator$OfInt;)V");
        var2_2 = new Streams.ConcatSpliterator.OfInt(v0, v1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.isParallel:()Z");
        v2 = var0.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v2) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.isParallel:()Z");
        v3 = var1_1.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v3) lbl-1000:
        // 2 sources

        {
            v4 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            v4 = false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        var3_3 = StreamSupport.intStream(var2_2, v4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams.composedClose:(Ljava/util/stream/BaseStream;Ljava/util/stream/BaseStream;)Ljava/lang/Runnable;");
        v5 = Streams.composedClose(var0, var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream.onClose:(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;");
        return (IntStream)var3_3.onClose(v5);
    }

    public static interface Builder
    extends IntConsumer {
        @Override
        public void accept(int var1);

        default public Builder add(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntStream$Builder.accept:(I)V");
            this.accept(n);
            return this;
        }

        public IntStream build();
    }
}

