/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Objects;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.CountedCompleter;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.stream.AbstractTask;
import sandbox.java.util.stream.Node;
import sandbox.java.util.stream.PipelineHelper;
import sandbox.java.util.stream.Sink;
import sandbox.java.util.stream.StreamOpFlag;
import sandbox.java.util.stream.StreamShape;
import sandbox.java.util.stream.TerminalOp;
import sandbox.java.util.stream.TerminalSink;

final class ForEachOps {
    private ForEachOps() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static <T> TerminalOp<T, Void> makeRef(Consumer<? super T> consumer, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(consumer);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachOp$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp$OfRef.<init>:(Ljava/util/function/Consumer;Z)V");
        return new ForEachOp.OfRef<T>(consumer, bl);
    }

    public static TerminalOp<Integer, Void> makeInt(IntConsumer intConsumer, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(intConsumer);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachOp$OfInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp$OfInt.<init>:(Ljava/util/function/IntConsumer;Z)V");
        return new ForEachOp.OfInt(intConsumer, bl);
    }

    public static TerminalOp<Long, Void> makeLong(LongConsumer longConsumer, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(longConsumer);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachOp$OfLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp$OfLong.<init>:(Ljava/util/function/LongConsumer;Z)V");
        return new ForEachOp.OfLong(longConsumer, bl);
    }

    public static TerminalOp<Double, Void> makeDouble(DoubleConsumer doubleConsumer, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(doubleConsumer);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachOp$OfDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp$OfDouble.<init>:(Ljava/util/function/DoubleConsumer;Z)V");
        return new ForEachOp.OfDouble(doubleConsumer, bl);
    }

    static final class ForEachOrderedTask<S, T>
    extends CountedCompleter<Void> {
        private final PipelineHelper<T> helper;
        private Spliterator<S> spliterator;
        private final long targetSize;
        private final ConcurrentHashMap<ForEachOrderedTask<S, T>, ForEachOrderedTask<S, T>> completionMap;
        private final Sink<T> action;
        private final Object lock;
        private final ForEachOrderedTask<S, T> leftPredecessor;
        private Node<T> node;

        protected ForEachOrderedTask(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator, Sink<T> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:(Ljava/util/concurrent/CountedCompleter;)V");
            super(null);
            this.helper = pipelineHelper;
            this.spliterator = spliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
            long l = spliterator.estimateSize();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.suggestTargetSize:(J)J");
            this.targetSize = AbstractTask.suggestTargetSize(l);
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
            this.completionMap = new ConcurrentHashMap();
            this.action = sink;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.lock = new Object();
            this.leftPredecessor = null;
        }

        ForEachOrderedTask(ForEachOrderedTask<S, T> forEachOrderedTask, Spliterator<S> spliterator, ForEachOrderedTask<S, T> forEachOrderedTask2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:(Ljava/util/concurrent/CountedCompleter;)V");
            super(forEachOrderedTask);
            this.helper = forEachOrderedTask.helper;
            this.spliterator = spliterator;
            this.targetSize = forEachOrderedTask.targetSize;
            this.completionMap = forEachOrderedTask.completionMap;
            this.action = forEachOrderedTask.action;
            this.lock = forEachOrderedTask.lock;
            this.leftPredecessor = forEachOrderedTask2;
        }

        @Override
        public final void compute() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.doCompute:(Ljava/util/stream/ForEachOps$ForEachOrderedTask;)V");
            ForEachOrderedTask.doCompute(this);
        }

        private static <S, T> void doCompute(ForEachOrderedTask<S, T> object) {
            ForEachOrderedTask<S, T> forEachOrderedTask;
            Spliterator<S> spliterator = ((ForEachOrderedTask)object).spliterator;
            long l = ((ForEachOrderedTask)object).targetSize;
            boolean bl = false;
            while (true) {
                ForEachOrderedTask<S, T> forEachOrderedTask2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
                long l2 = spliterator.estimateSize() - l;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 <= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.trySplit:()Ljava/util/Spliterator;");
                Spliterator<S> spliterator2 = spliterator.trySplit();
                RuntimeCostAccounter.recordJump();
                if (spliterator2 == null) break;
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachOrderedTask");
                ForEachOrderedTask<S, T> forEachOrderedTask3 = ((ForEachOrderedTask)object).leftPredecessor;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.<init>:(Ljava/util/stream/ForEachOps$ForEachOrderedTask;Ljava/util/Spliterator;Ljava/util/stream/ForEachOps$ForEachOrderedTask;)V");
                forEachOrderedTask = new ForEachOrderedTask<S, T>(object, spliterator2, forEachOrderedTask3);
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachOrderedTask");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.<init>:(Ljava/util/stream/ForEachOps$ForEachOrderedTask;Ljava/util/Spliterator;Ljava/util/stream/ForEachOps$ForEachOrderedTask;)V");
                ForEachOrderedTask<S, T> forEachOrderedTask4 = new ForEachOrderedTask<S, T>(object, spliterator, forEachOrderedTask);
                ConcurrentHashMap<ForEachOrderedTask<S, T>, ForEachOrderedTask<S, T>> concurrentHashMap = ((ForEachOrderedTask)object).completionMap;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                concurrentHashMap.put(forEachOrderedTask, forEachOrderedTask4);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.addToPendingCount:(I)V");
                ((CountedCompleter)object).addToPendingCount(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.addToPendingCount:(I)V");
                forEachOrderedTask4.addToPendingCount(1);
                ForEachOrderedTask<S, T> forEachOrderedTask5 = ((ForEachOrderedTask)object).leftPredecessor;
                RuntimeCostAccounter.recordJump();
                if (forEachOrderedTask5 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.addToPendingCount:(I)V");
                    forEachOrderedTask.addToPendingCount(1);
                    ConcurrentHashMap<ForEachOrderedTask<S, T>, ForEachOrderedTask<S, T>> concurrentHashMap2 = ((ForEachOrderedTask)object).completionMap;
                    ForEachOrderedTask<S, T> forEachOrderedTask6 = ((ForEachOrderedTask)object).leftPredecessor;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.replace:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl2 = concurrentHashMap2.replace(forEachOrderedTask6, (ForEachOrderedTask<S, T>)object, forEachOrderedTask);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.addToPendingCount:(I)V");
                        ((CountedCompleter)object).addToPendingCount(-1);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.addToPendingCount:(I)V");
                        forEachOrderedTask.addToPendingCount(-1);
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    bl = false;
                    spliterator = spliterator2;
                    object = forEachOrderedTask;
                    forEachOrderedTask2 = forEachOrderedTask4;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = true;
                    object = forEachOrderedTask4;
                    forEachOrderedTask2 = forEachOrderedTask;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.fork:()Ljava/util/concurrent/ForkJoinTask;");
                forEachOrderedTask2.fork();
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.getPendingCount:()I");
            int n2 = ((CountedCompleter)object).getPendingCount();
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                PipelineHelper<T> pipelineHelper = ((ForEachOrderedTask)object).helper;
                Sink<T> sink = ((ForEachOrderedTask)object).action;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
                pipelineHelper.wrapAndCopyInto(sink, spliterator);
                RuntimeCostAccounter.recordJump();
            } else {
                PipelineHelper<T> pipelineHelper = ((ForEachOrderedTask)object).helper;
                PipelineHelper<T> pipelineHelper2 = ((ForEachOrderedTask)object).helper;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.exactOutputSizeIfKnown:(Ljava/util/Spliterator;)J");
                long l4 = pipelineHelper2.exactOutputSizeIfKnown(spliterator);
                IntFunction<P_OUT[]> intFunction = n -> {
                    int n2 = n;
                    RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
                    return new Object[n2];
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.makeNodeBuilder:(JLjava/util/function/IntFunction;)Ljava/util/stream/Node$Builder;");
                forEachOrderedTask = pipelineHelper.makeNodeBuilder(l4, intFunction);
                PipelineHelper<T> pipelineHelper3 = ((ForEachOrderedTask)object).helper;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
                Node.Builder builder = (Node.Builder)pipelineHelper3.wrapAndCopyInto(forEachOrderedTask, spliterator);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$Builder.build:()Ljava/util/stream/Node;");
                ((ForEachOrderedTask)object).node = builder.build();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.tryComplete:()V");
            ((CountedCompleter)object).tryComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            ForEachOrderedTask<S, T> forEachOrderedTask;
            block3: {
                this.spliterator = null;
                RuntimeCostAccounter.recordJump();
                if (this.node == null) break block3;
                forEachOrderedTask = this.lock;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.forEach:(Ljava/util/function/Consumer;)V");
                    this.node.forEach(this.action);
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordJump();
                this.node = null;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            forEachOrderedTask = this.completionMap.remove(this);
            RuntimeCostAccounter.recordJump();
            if (forEachOrderedTask != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.tryComplete:()V");
                forEachOrderedTask.tryComplete();
            }
        }
    }

    static final class ForEachTask<S, T>
    extends CountedCompleter<Void> {
        private Spliterator<S> spliterator;
        private final Sink<S> sink;
        private final PipelineHelper<T> helper;
        private long targetSize;

        ForEachTask(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator, Sink<S> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:(Ljava/util/concurrent/CountedCompleter;)V");
            super(null);
            this.sink = sink;
            this.helper = pipelineHelper;
            this.spliterator = spliterator;
            this.targetSize = 0L;
        }

        ForEachTask(ForEachTask<S, T> forEachTask, Spliterator<S> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CountedCompleter.<init>:(Ljava/util/concurrent/CountedCompleter;)V");
            super(forEachTask);
            this.spliterator = spliterator;
            this.sink = forEachTask.sink;
            this.targetSize = forEachTask.targetSize;
            this.helper = forEachTask.helper;
        }

        @Override
        public void compute() {
            Spliterator<S> spliterator = this.spliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
            long l = spliterator.estimateSize();
            long l2 = this.targetSize;
            RuntimeCostAccounter.recordJump();
            if (l2 == 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractTask.suggestTargetSize:(J)J");
                this.targetSize = l2 = AbstractTask.suggestTargetSize(l);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.getStreamAndOpFlags:()I");
            int n = this.helper.getStreamAndOpFlags();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SHORT_CIRCUIT.isKnown(n);
            boolean bl2 = false;
            Sink<S> sink = this.sink;
            ForEachTask forEachTask = this;
            while (true) {
                ForEachTask forEachTask2;
                Spliterator<S> spliterator2;
                block9: {
                    block8: {
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                            boolean bl3 = sink.cancellationRequested();
                            RuntimeCostAccounter.recordJump();
                            if (bl3) break;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (l <= l2) break block8;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.trySplit:()Ljava/util/Spliterator;");
                        spliterator2 = spliterator.trySplit();
                        RuntimeCostAccounter.recordJump();
                        if (spliterator2 != null) break block9;
                    }
                    PipelineHelper<T> pipelineHelper = forEachTask.helper;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.copyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)V");
                    pipelineHelper.copyInto(sink, spliterator);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachTask");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachTask.<init>:(Ljava/util/stream/ForEachOps$ForEachTask;Ljava/util/Spliterator;)V");
                ForEachTask forEachTask3 = new ForEachTask(forEachTask, spliterator2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachTask.addToPendingCount:(I)V");
                forEachTask.addToPendingCount(1);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    bl2 = false;
                    spliterator = spliterator2;
                    forEachTask2 = forEachTask;
                    forEachTask = forEachTask3;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl2 = true;
                    forEachTask2 = forEachTask3;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachTask.fork:()Ljava/util/concurrent/ForkJoinTask;");
                forEachTask2.fork();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterator.estimateSize:()J");
                l = spliterator.estimateSize();
                RuntimeCostAccounter.recordJump();
            }
            forEachTask.spliterator = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachTask.propagateCompletion:()V");
            forEachTask.propagateCompletion();
        }
    }

    static abstract class ForEachOp<T>
    implements TerminalOp<T, Void>,
    TerminalSink<T, Void> {
        private final boolean ordered;

        protected ForEachOp(boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.ordered = bl;
        }

        @Override
        public int getOpFlags() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.ordered) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n = StreamOpFlag.NOT_ORDERED;
            }
            return n;
        }

        @Override
        public <S> Void evaluateSequential(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp.get:()Ljava/lang/Void;");
            return pipelineHelper.wrapAndCopyInto(this, spliterator).get();
        }

        @Override
        public <S> Void evaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator) {
            RuntimeCostAccounter.recordJump();
            if (this.ordered) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachOrderedTask");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/stream/Sink;)V");
                ForEachOrderedTask<S, T> forEachOrderedTask = new ForEachOrderedTask<S, T>(pipelineHelper, spliterator, this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOrderedTask.invoke:()Ljava/lang/Object;");
                forEachOrderedTask.invoke();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/ForEachOps$ForEachTask");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapSink:(Ljava/util/stream/Sink;)Ljava/util/stream/Sink;");
                Sink sink = pipelineHelper.wrapSink(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;Ljava/util/stream/Sink;)V");
                ForEachTask<S, T> forEachTask = new ForEachTask<S, T>(pipelineHelper, spliterator, sink);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachTask.invoke:()Ljava/lang/Object;");
                forEachTask.invoke();
            }
            return null;
        }

        @Override
        public Void get() {
            return null;
        }

        static final class OfDouble
        extends ForEachOp<Double>
        implements Sink.OfDouble {
            final DoubleConsumer consumer;

            OfDouble(DoubleConsumer doubleConsumer, boolean bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp.<init>:(Z)V");
                super(bl);
                this.consumer = doubleConsumer;
            }

            @Override
            public StreamShape inputShape() {
                return StreamShape.DOUBLE_VALUE;
            }

            @Override
            public void accept(double d) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                this.consumer.accept(d);
            }
        }

        static final class OfLong
        extends ForEachOp<Long>
        implements Sink.OfLong {
            final LongConsumer consumer;

            OfLong(LongConsumer longConsumer, boolean bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp.<init>:(Z)V");
                super(bl);
                this.consumer = longConsumer;
            }

            @Override
            public StreamShape inputShape() {
                return StreamShape.LONG_VALUE;
            }

            @Override
            public void accept(long l) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                this.consumer.accept(l);
            }
        }

        static final class OfInt
        extends ForEachOp<Integer>
        implements Sink.OfInt {
            final IntConsumer consumer;

            OfInt(IntConsumer intConsumer, boolean bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp.<init>:(Z)V");
                super(bl);
                this.consumer = intConsumer;
            }

            @Override
            public StreamShape inputShape() {
                return StreamShape.INT_VALUE;
            }

            @Override
            public void accept(int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                this.consumer.accept(n);
            }
        }

        static final class OfRef<T>
        extends ForEachOp<T> {
            final Consumer<? super T> consumer;

            OfRef(Consumer<? super T> consumer, boolean bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ForEachOps$ForEachOp.<init>:(Z)V");
                super(bl);
                this.consumer = consumer;
            }

            @Override
            public void accept(T t) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                this.consumer.accept(t);
            }
        }
    }
}

