/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Optional;
import sandbox.java.util.OptionalDouble;
import sandbox.java.util.OptionalInt;
import sandbox.java.util.OptionalLong;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.CountedCompleter;
import sandbox.java.util.function.Predicate;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.stream.AbstractShortCircuitTask;
import sandbox.java.util.stream.PipelineHelper;
import sandbox.java.util.stream.Sink;
import sandbox.java.util.stream.StreamOpFlag;
import sandbox.java.util.stream.StreamShape;
import sandbox.java.util.stream.TerminalOp;
import sandbox.java.util.stream.TerminalSink;

final class FindOps {
    private FindOps() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static <T> TerminalOp<T, Optional<T>> makeRef(boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/FindOps$FindOp");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.empty:()Ljava/util/Optional;");
        Optional optional = Optional.empty();
        Predicate<Optional> predicate = Optional::isPresent;
        Supplier supplier = FindSink.OfRef::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindOp.<init>:(ZLjava/util/stream/StreamShape;Ljava/lang/Object;Ljava/util/function/Predicate;Ljava/util/function/Supplier;)V");
        return new FindOp(bl, StreamShape.REFERENCE, optional, predicate, supplier);
    }

    public static TerminalOp<Integer, OptionalInt> makeInt(boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/FindOps$FindOp");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalInt.empty:()Ljava/util/OptionalInt;");
        OptionalInt optionalInt = OptionalInt.empty();
        Predicate<OptionalInt> predicate = OptionalInt::isPresent;
        Supplier supplier = FindSink.OfInt::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindOp.<init>:(ZLjava/util/stream/StreamShape;Ljava/lang/Object;Ljava/util/function/Predicate;Ljava/util/function/Supplier;)V");
        return new FindOp<Integer, OptionalInt>(bl, StreamShape.INT_VALUE, optionalInt, predicate, supplier);
    }

    public static TerminalOp<Long, OptionalLong> makeLong(boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/FindOps$FindOp");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalLong.empty:()Ljava/util/OptionalLong;");
        OptionalLong optionalLong = OptionalLong.empty();
        Predicate<OptionalLong> predicate = OptionalLong::isPresent;
        Supplier supplier = FindSink.OfLong::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindOp.<init>:(ZLjava/util/stream/StreamShape;Ljava/lang/Object;Ljava/util/function/Predicate;Ljava/util/function/Supplier;)V");
        return new FindOp<Long, OptionalLong>(bl, StreamShape.LONG_VALUE, optionalLong, predicate, supplier);
    }

    public static TerminalOp<Double, OptionalDouble> makeDouble(boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/FindOps$FindOp");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalDouble.empty:()Ljava/util/OptionalDouble;");
        OptionalDouble optionalDouble = OptionalDouble.empty();
        Predicate<OptionalDouble> predicate = OptionalDouble::isPresent;
        Supplier supplier = FindSink.OfDouble::new;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindOp.<init>:(ZLjava/util/stream/StreamShape;Ljava/lang/Object;Ljava/util/function/Predicate;Ljava/util/function/Supplier;)V");
        return new FindOp<Double, OptionalDouble>(bl, StreamShape.DOUBLE_VALUE, optionalDouble, predicate, supplier);
    }

    private static final class FindTask<P_IN, P_OUT, O>
    extends AbstractShortCircuitTask<P_IN, P_OUT, O, FindTask<P_IN, P_OUT, O>> {
        private final FindOp<P_OUT, O> op;

        FindTask(FindOp<P_OUT, O> findOp, PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractShortCircuitTask.<init>:(Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
            super(pipelineHelper, spliterator);
            this.op = findOp;
        }

        FindTask(FindTask<P_IN, P_OUT, O> findTask, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractShortCircuitTask.<init>:(Ljava/util/stream/AbstractShortCircuitTask;Ljava/util/Spliterator;)V");
            super(findTask, spliterator);
            this.op = findTask.op;
        }

        @Override
        protected FindTask<P_IN, P_OUT, O> makeChild(Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/FindOps$FindTask");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.<init>:(Ljava/util/stream/FindOps$FindTask;Ljava/util/Spliterator;)V");
            return new FindTask<P_IN, P_OUT, O>(this, spliterator);
        }

        @Override
        protected O getEmptyResult() {
            return this.op.emptyValue;
        }

        private void foundResult(O o) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.isLeftmostNode:()Z");
            boolean bl = this.isLeftmostNode();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.shortCircuit:(Ljava/lang/Object;)V");
                this.shortCircuit(o);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.cancelLaterNodes:()V");
                this.cancelLaterNodes();
            }
        }

        @Override
        protected O doLeaf() {
            Supplier supplier = this.op.sinkSupplier;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
            Sink sink = supplier.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
            TerminalSink terminalSink = (TerminalSink)this.helper.wrapAndCopyInto(sink, this.spliterator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/TerminalSink.get:()Ljava/lang/Object;");
            Object t = terminalSink.get();
            boolean bl = this.op.mustFindFirst;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (t != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.shortCircuit:(Ljava/lang/Object;)V");
                    this.shortCircuit(t);
                }
                return null;
            }
            RuntimeCostAccounter.recordJump();
            if (t != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.foundResult:(Ljava/lang/Object;)V");
                this.foundResult(t);
                return (O)t;
            }
            return null;
        }

        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            boolean bl = this.op.mustFindFirst;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                FindTask findTask = (FindTask)this.leftChild;
                FindTask findTask2 = null;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (findTask == findTask2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.getLocalResult:()Ljava/lang/Object;");
                    Object r = findTask.getLocalResult();
                    RuntimeCostAccounter.recordJump();
                    if (r != null) {
                        Predicate predicate = this.op.presentPredicate;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Predicate.test:(Ljava/lang/Object;)Z");
                        boolean bl2 = predicate.test(r);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.setLocalResult:(Ljava/lang/Object;)V");
                            this.setLocalResult(r);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.foundResult:(Ljava/lang/Object;)V");
                            this.foundResult(r);
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                    }
                    findTask2 = findTask;
                    findTask = (FindTask)this.rightChild;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/AbstractShortCircuitTask.onCompletion:(Ljava/util/concurrent/CountedCompleter;)V");
            super.onCompletion(countedCompleter);
        }
    }

    private static abstract class FindSink<T, O>
    implements TerminalSink<T, O> {
        boolean hasValue;
        T value;

        FindSink() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        @Override
        public void accept(T t) {
            RuntimeCostAccounter.recordJump();
            if (!this.hasValue) {
                this.hasValue = true;
                this.value = t;
            }
        }

        @Override
        public boolean cancellationRequested() {
            return this.hasValue;
        }

        static final class OfDouble
        extends FindSink<Double, OptionalDouble>
        implements Sink.OfDouble {
            OfDouble() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindSink.<init>:()V");
            }

            @Override
            public void accept(double d) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
                Double d2 = d;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindSink$OfDouble.accept:(Ljava/lang/Object;)V");
                this.accept(d2);
            }

            @Override
            public OptionalDouble get() {
                OptionalDouble optionalDouble;
                RuntimeCostAccounter.recordJump();
                if (this.hasValue) {
                    Double d = (Double)this.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleValue:()D");
                    double d2 = d;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalDouble.of:(D)Ljava/util/OptionalDouble;");
                    optionalDouble = OptionalDouble.of(d2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    optionalDouble = null;
                }
                return optionalDouble;
            }
        }

        static final class OfLong
        extends FindSink<Long, OptionalLong>
        implements Sink.OfLong {
            OfLong() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindSink.<init>:()V");
            }

            @Override
            public void accept(long l) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l2 = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindSink$OfLong.accept:(Ljava/lang/Object;)V");
                this.accept(l2);
            }

            @Override
            public OptionalLong get() {
                OptionalLong optionalLong;
                RuntimeCostAccounter.recordJump();
                if (this.hasValue) {
                    Long l = (Long)this.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                    long l2 = l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalLong.of:(J)Ljava/util/OptionalLong;");
                    optionalLong = OptionalLong.of(l2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    optionalLong = null;
                }
                return optionalLong;
            }
        }

        static final class OfInt
        extends FindSink<Integer, OptionalInt>
        implements Sink.OfInt {
            OfInt() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindSink.<init>:()V");
            }

            @Override
            public void accept(int n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                Integer n2 = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindSink$OfInt.accept:(Ljava/lang/Object;)V");
                this.accept(n2);
            }

            @Override
            public OptionalInt get() {
                OptionalInt optionalInt;
                RuntimeCostAccounter.recordJump();
                if (this.hasValue) {
                    Integer n = (Integer)this.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    int n2 = n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalInt.of:(I)Ljava/util/OptionalInt;");
                    optionalInt = OptionalInt.of(n2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    optionalInt = null;
                }
                return optionalInt;
            }
        }

        static final class OfRef<T>
        extends FindSink<T, Optional<T>> {
            OfRef() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindSink.<init>:()V");
            }

            @Override
            public Optional<T> get() {
                Optional<Object> optional;
                RuntimeCostAccounter.recordJump();
                if (this.hasValue) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Optional.of:(Ljava/lang/Object;)Ljava/util/Optional;");
                    optional = Optional.of(this.value);
                    RuntimeCostAccounter.recordJump();
                } else {
                    optional = null;
                }
                return optional;
            }
        }
    }

    private static final class FindOp<T, O>
    implements TerminalOp<T, O> {
        private final StreamShape shape;
        final boolean mustFindFirst;
        final O emptyValue;
        final Predicate<O> presentPredicate;
        final Supplier<TerminalSink<T, O>> sinkSupplier;

        FindOp(boolean bl, StreamShape streamShape, O o, Predicate<O> predicate, Supplier<TerminalSink<T, O>> supplier) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.mustFindFirst = bl;
            this.shape = streamShape;
            this.emptyValue = o;
            this.presentPredicate = predicate;
            this.sinkSupplier = supplier;
        }

        @Override
        public int getOpFlags() {
            int n;
            RuntimeCostAccounter.recordJump();
            if (this.mustFindFirst) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n = StreamOpFlag.NOT_ORDERED;
            }
            return StreamOpFlag.IS_SHORT_CIRCUIT | n;
        }

        @Override
        public StreamShape inputShape() {
            return this.shape;
        }

        @Override
        public <S> O evaluateSequential(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator) {
            Object object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
            Sink sink = this.sinkSupplier.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.wrapAndCopyInto:(Ljava/util/stream/Sink;Ljava/util/Spliterator;)Ljava/util/stream/Sink;");
            TerminalSink terminalSink = (TerminalSink)pipelineHelper.wrapAndCopyInto(sink, spliterator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/TerminalSink.get:()Ljava/lang/Object;");
            Object t = terminalSink.get();
            RuntimeCostAccounter.recordJump();
            if (t != null) {
                object = t;
                RuntimeCostAccounter.recordJump();
            } else {
                object = this.emptyValue;
            }
            return (O)object;
        }

        @Override
        public <P_IN> O evaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/FindOps$FindTask");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.<init>:(Ljava/util/stream/FindOps$FindOp;Ljava/util/stream/PipelineHelper;Ljava/util/Spliterator;)V");
            FindTask findTask = new FindTask(this, pipelineHelper, spliterator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/FindOps$FindTask.invoke:()Ljava/lang/Object;");
            return (O)findTask.invoke();
        }
    }
}

