/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Arrays;
import sandbox.java.util.DoubleSummaryStatistics;
import sandbox.java.util.Objects;
import sandbox.java.util.OptionalDouble;
import sandbox.java.util.PrimitiveIterator;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.DoubleBinaryOperator;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.DoubleFunction;
import sandbox.java.util.function.DoublePredicate;
import sandbox.java.util.function.DoubleSupplier;
import sandbox.java.util.function.DoubleToIntFunction;
import sandbox.java.util.function.DoubleToLongFunction;
import sandbox.java.util.function.DoubleUnaryOperator;
import sandbox.java.util.function.ObjDoubleConsumer;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.stream.BaseStream;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.LongStream;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamSpliterators;
import sandbox.java.util.stream.StreamSupport;
import sandbox.java.util.stream.Streams;

public interface DoubleStream
extends BaseStream<Double, DoubleStream> {
    public DoubleStream filter(DoublePredicate var1);

    public DoubleStream map(DoubleUnaryOperator var1);

    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> var1);

    public IntStream mapToInt(DoubleToIntFunction var1);

    public LongStream mapToLong(DoubleToLongFunction var1);

    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> var1);

    public DoubleStream distinct();

    public DoubleStream sorted();

    public DoubleStream peek(DoubleConsumer var1);

    public DoubleStream limit(long var1);

    public DoubleStream skip(long var1);

    public void forEach(DoubleConsumer var1);

    public void forEachOrdered(DoubleConsumer var1);

    public double[] toArray();

    public double reduce(double var1, DoubleBinaryOperator var3);

    public OptionalDouble reduce(DoubleBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjDoubleConsumer<R> var2, BiConsumer<R, R> var3);

    public double sum();

    public OptionalDouble min();

    public OptionalDouble max();

    public long count();

    public OptionalDouble average();

    public DoubleSummaryStatistics summaryStatistics();

    public boolean anyMatch(DoublePredicate var1);

    public boolean allMatch(DoublePredicate var1);

    public boolean noneMatch(DoublePredicate var1);

    public OptionalDouble findFirst();

    public OptionalDouble findAny();

    public Stream<Double> boxed();

    @Override
    public DoubleStream sequential();

    @Override
    public DoubleStream parallel();

    public PrimitiveIterator.OfDouble iterator();

    public Spliterator.OfDouble spliterator();

    public static Builder builder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$DoubleStreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$DoubleStreamBuilderImpl.<init>:()V");
        return new Streams.DoubleStreamBuilderImpl();
    }

    public static DoubleStream empty() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptyDoubleSpliterator:()Ljava/util/Spliterator$OfDouble;");
        Spliterator.OfDouble ofDouble = Spliterators.emptyDoubleSpliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(ofDouble, false);
    }

    public static DoubleStream of(double d) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$DoubleStreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$DoubleStreamBuilderImpl.<init>:(D)V");
        Streams.DoubleStreamBuilderImpl doubleStreamBuilderImpl = new Streams.DoubleStreamBuilderImpl(d);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(doubleStreamBuilderImpl, false);
    }

    public static DoubleStream of(double ... dArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.stream:([D)Ljava/util/stream/DoubleStream;");
        return Arrays.stream(dArray);
    }

    public static DoubleStream iterate(final double d, final DoubleUnaryOperator doubleUnaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(doubleUnaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/DoubleStream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoubleStream$1.<init>:(DLjava/util/function/DoubleUnaryOperator;)V");
        PrimitiveIterator.OfDouble ofDouble = new PrimitiveIterator.OfDouble(){
            double t;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.t = d;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public double nextDouble() {
                double d2 = this.t;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleUnaryOperator.applyAsDouble:(D)D");
                this.t = doubleUnaryOperator.applyAsDouble(this.t);
                return d2;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliteratorUnknownSize:(Ljava/util/PrimitiveIterator$OfDouble;I)Ljava/util/Spliterator$OfDouble;");
        Spliterator.OfDouble ofDouble2 = Spliterators.spliteratorUnknownSize(ofDouble, 1296);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(ofDouble2, false);
    }

    public static DoubleStream generate(DoubleSupplier doubleSupplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(doubleSupplier);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfDouble.<init>:(JLjava/util/function/DoubleSupplier;)V");
        StreamSpliterators.InfiniteSupplyingSpliterator.OfDouble ofDouble = new StreamSpliterators.InfiniteSupplyingSpliterator.OfDouble(Long.MAX_VALUE, doubleSupplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(ofDouble, false);
    }

    /*
     * Unable to fully structure code
     */
    public static DoubleStream concat(DoubleStream var0, DoubleStream var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var1_1);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$ConcatSpliterator$OfDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoubleStream.spliterator:()Ljava/util/Spliterator$OfDouble;");
        v0 = var0.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoubleStream.spliterator:()Ljava/util/Spliterator$OfDouble;");
        v1 = var1_1.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$ConcatSpliterator$OfDouble.<init>:(Ljava/util/Spliterator$OfDouble;Ljava/util/Spliterator$OfDouble;)V");
        var2_2 = new Streams.ConcatSpliterator.OfDouble(v0, v1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoubleStream.isParallel:()Z");
        v2 = var0.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v2) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoubleStream.isParallel:()Z");
        v3 = var1_1.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v3) lbl-1000:
        // 2 sources

        {
            v4 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            v4 = false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        var3_3 = StreamSupport.doubleStream(var2_2, v4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams.composedClose:(Ljava/util/stream/BaseStream;Ljava/util/stream/BaseStream;)Ljava/lang/Runnable;");
        v5 = Streams.composedClose(var0, var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoubleStream.onClose:(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;");
        return (DoubleStream)var3_3.onClose(v5);
    }

    public static interface Builder
    extends DoubleConsumer {
        @Override
        public void accept(double var1);

        default public Builder add(double d) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoubleStream$Builder.accept:(D)V");
            this.accept(d);
            return this;
        }

        public DoubleStream build();
    }
}

