/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.prefs;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.File;
import sandbox.java.io.FileInputStream;
import sandbox.java.io.FileNotFoundException;
import sandbox.java.io.FileOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.PrivilegedActionException;
import sandbox.java.security.PrivilegedExceptionAction;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.List;
import sandbox.java.util.Map;
import sandbox.java.util.Set;
import sandbox.java.util.Timer;
import sandbox.java.util.TimerTask;
import sandbox.java.util.TreeMap;
import sandbox.java.util.prefs.AbstractPreferences;
import sandbox.java.util.prefs.BackingStoreException;
import sandbox.java.util.prefs.Base64;
import sandbox.java.util.prefs.InvalidPreferencesFormatException;
import sandbox.java.util.prefs.Preferences;
import sandbox.java.util.prefs.XmlSupport;
import sandbox.sun.security.action.GetPropertyAction;
import sandbox.sun.util.logging.PlatformLogger;

class FileSystemPreferences
extends AbstractPreferences {
    private static final int SYNC_INTERVAL;
    private static File systemRootDir;
    private static boolean isSystemRootWritable;
    private static File userRootDir;
    private static boolean isUserRootWritable;
    static Preferences userRoot;
    static Preferences systemRoot;
    private static final int USER_READ_WRITE = 384;
    private static final int USER_RW_ALL_READ = 420;
    private static final int USER_RWX_ALL_RX = 493;
    private static final int USER_RWX = 448;
    static File userLockFile;
    static File systemLockFile;
    private static int userRootLockHandle;
    private static int systemRootLockHandle;
    private final File dir;
    private final File prefsFile;
    private final File tmpFile;
    private static File userRootModFile;
    private static boolean isUserRootModified;
    private static long userRootModTime;
    private static File systemRootModFile;
    private static boolean isSystemRootModified;
    private static long systemRootModTime;
    private Map<String, String> prefsCache;
    private long lastSyncTime;
    private static final int EAGAIN = 11;
    private static final int EACCES = 13;
    private static final int LOCK_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    final List<Change> changeLog;
    NodeCreate nodeCreate;
    private static Timer syncTimer;
    private final boolean isUserNode;
    private static final String[] EMPTY_STRING_ARRAY;
    private static int INIT_SLEEP_TIME;
    private static int MAX_ATTEMPTS;

    private static PlatformLogger getLogger() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.getLogger:(Ljava/lang/String;)Lsun/util/logging/PlatformLogger;");
        return PlatformLogger.getLogger((String)"java.util.prefs");
    }

    static synchronized Preferences getUserRoot() {
        RuntimeCostAccounter.recordJump();
        if (userRoot == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.setupUserRoot:()V");
            FileSystemPreferences.setupUserRoot();
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.<init>:(Z)V");
            userRoot = new FileSystemPreferences(true);
        }
        return userRoot;
    }

    private static void setupUserRoot() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$1.<init>:()V");
        PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Void run() {
                block6: {
                    block7: {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        String string = System.getProperty("user.home");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
                        String string2 = System.getProperty("java.util.prefs.userRoot", string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
                        File file = new File(string2, ".java/.userPrefs");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$002:(Ljava/io/File;)Ljava/io/File;");
                        userRootDir = file;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$000:()Ljava/io/File;");
                        File file2 = userRootDir;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                        boolean bl = file2.exists();
                        RuntimeCostAccounter.recordJump();
                        if (bl) break block6;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$000:()Ljava/io/File;");
                        File file3 = userRootDir;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.mkdirs:()Z");
                        boolean bl2 = file3.mkdirs();
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block7;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$000:()Ljava/io/File;");
                            File file4 = userRootDir;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                            String string3 = file4.getCanonicalPath();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$100:(Ljava/lang/String;I)I");
                            FileSystemPreferences.access$100(string3, 448);
                        }
                        catch (IOException iOException) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                            PlatformLogger platformLogger = FileSystemPreferences.access$200();
                            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                            platformLogger.warning("Could not change permissions on userRoot directory. ");
                        }
                        RuntimeCostAccounter.recordJump();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                        PlatformLogger platformLogger = FileSystemPreferences.access$200();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.info:(Ljava/lang/String;)V");
                        platformLogger.info("Created user preferences directory.");
                        RuntimeCostAccounter.recordJump();
                        break block6;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                    PlatformLogger platformLogger = FileSystemPreferences.access$200();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                    platformLogger.warning("Couldn't create user preferences directory. User preferences are unusable.");
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$000:()Ljava/io/File;");
                File file = userRootDir;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.canWrite:()Z");
                boolean bl = file.canWrite();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$302:(Z)Z");
                isUserRootWritable = bl;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                String string = System.getProperty("user.name");
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$000:()Ljava/io/File;");
                File file5 = userRootDir;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(".user.lock.");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string4 = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                userLockFile = new File(file5, string4);
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$000:()Ljava/io/File;");
                File file6 = userRootDir;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder4 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(".userRootModFile.");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string5 = stringBuilder6.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                File file7 = new File(file6, string5);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$402:(Ljava/io/File;)Ljava/io/File;");
                userRootModFile = file7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$400:()Ljava/io/File;");
                File file8 = userRootModFile;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                boolean bl3 = file8.exists();
                RuntimeCostAccounter.recordJump();
                if (!bl3) {
                    block5: {
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$400:()Ljava/io/File;");
                            File file9 = userRootModFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.createNewFile:()Z");
                            file9.createNewFile();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$400:()Ljava/io/File;");
                            File file10 = userRootModFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                            String string6 = file10.getCanonicalPath();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$100:(Ljava/lang/String;I)I");
                            int n = FileSystemPreferences.access$100(string6, 384);
                            RuntimeCostAccounter.recordJump();
                            if (n == 0) break block5;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                            PlatformLogger platformLogger = FileSystemPreferences.access$200();
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder7 = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder8 = stringBuilder7.append("Problem creating userRoot mod file. Chmod failed on ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$400:()Ljava/io/File;");
                            File file11 = userRootModFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                            String string7 = file11.getCanonicalPath();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder9 = stringBuilder8.append(string7);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder10 = stringBuilder9.append(" Unix error code ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder11 = stringBuilder10.append(n);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string8 = stringBuilder11.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                            platformLogger.warning(string8);
                        }
                        catch (IOException iOException) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                            PlatformLogger platformLogger = FileSystemPreferences.access$200();
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.toString:()Ljava/lang/String;");
                            String string9 = iOException.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                            platformLogger.warning(string9);
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$400:()Ljava/io/File;");
                File file12 = userRootModFile;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
                long l = file12.lastModified();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$502:(J)J");
                userRootModTime = l;
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
    }

    static synchronized Preferences getSystemRoot() {
        RuntimeCostAccounter.recordJump();
        if (systemRoot == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.setupSystemRoot:()V");
            FileSystemPreferences.setupSystemRoot();
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.<init>:(Z)V");
            systemRoot = new FileSystemPreferences(false);
        }
        return systemRoot;
    }

    private static void setupSystemRoot() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$2.<init>:()V");
        PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Void run() {
                block7: {
                    block8: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
                        String string = System.getProperty("java.util.prefs.systemRoot", "/etc/.java");
                        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
                        File file = new File(string, ".systemPrefs");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$602:(Ljava/io/File;)Ljava/io/File;");
                        systemRootDir = file;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$600:()Ljava/io/File;");
                        File file2 = systemRootDir;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                        boolean bl = file2.exists();
                        RuntimeCostAccounter.recordJump();
                        if (bl) break block7;
                        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                        String string2 = System.getProperty("java.home");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
                        File file3 = new File(string2, ".systemPrefs");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$602:(Ljava/io/File;)Ljava/io/File;");
                        systemRootDir = file3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$600:()Ljava/io/File;");
                        File file4 = systemRootDir;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                        boolean bl2 = file4.exists();
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break block7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$600:()Ljava/io/File;");
                        File file5 = systemRootDir;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.mkdirs:()Z");
                        boolean bl3 = file5.mkdirs();
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) break block8;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                        PlatformLogger platformLogger = FileSystemPreferences.access$200();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.info:(Ljava/lang/String;)V");
                        platformLogger.info("Created system preferences directory in java.home.");
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$600:()Ljava/io/File;");
                            File file6 = systemRootDir;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                            String string3 = file6.getCanonicalPath();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$100:(Ljava/lang/String;I)I");
                            FileSystemPreferences.access$100(string3, 493);
                        }
                        catch (IOException iOException) {
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        break block7;
                        break block7;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                    PlatformLogger platformLogger = FileSystemPreferences.access$200();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                    platformLogger.warning("Could not create system preferences directory. System preferences are unusable.");
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$600:()Ljava/io/File;");
                File file = systemRootDir;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.canWrite:()Z");
                boolean bl = file.canWrite();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$702:(Z)Z");
                isSystemRootWritable = bl;
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$600:()Ljava/io/File;");
                File file7 = systemRootDir;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                systemLockFile = new File(file7, ".system.lock");
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$600:()Ljava/io/File;");
                File file8 = systemRootDir;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                File file9 = new File(file8, ".systemRootModFile");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$802:(Ljava/io/File;)Ljava/io/File;");
                systemRootModFile = file9;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$800:()Ljava/io/File;");
                File file10 = systemRootModFile;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                boolean bl4 = file10.exists();
                RuntimeCostAccounter.recordJump();
                if (!bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$700:()Z");
                    boolean bl5 = isSystemRootWritable;
                    RuntimeCostAccounter.recordJump();
                    if (bl5) {
                        block6: {
                            try {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$800:()Ljava/io/File;");
                                File file11 = systemRootModFile;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.createNewFile:()Z");
                                file11.createNewFile();
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$800:()Ljava/io/File;");
                                File file12 = systemRootModFile;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                                String string = file12.getCanonicalPath();
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$100:(Ljava/lang/String;I)I");
                                int n = FileSystemPreferences.access$100(string, 420);
                                RuntimeCostAccounter.recordJump();
                                if (n == 0) break block6;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                                PlatformLogger platformLogger = FileSystemPreferences.access$200();
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                StringBuilder stringBuilder = new StringBuilder();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder2 = stringBuilder.append("Chmod failed on ");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$800:()Ljava/io/File;");
                                File file13 = systemRootModFile;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                                String string4 = file13.getCanonicalPath();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder3 = stringBuilder2.append(string4);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder4 = stringBuilder3.append(" Unix error code ");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder5 = stringBuilder4.append(n);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                String string5 = stringBuilder5.toString();
                                RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                                platformLogger.warning(string5);
                            }
                            catch (IOException iOException) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                                PlatformLogger platformLogger = FileSystemPreferences.access$200();
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.toString:()Ljava/lang/String;");
                                String string = iOException.toString();
                                RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                                platformLogger.warning(string);
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$800:()Ljava/io/File;");
                File file14 = systemRootModFile;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
                long l = file14.lastModified();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$902:(J)J");
                systemRootModTime = l;
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
    }

    private void replayChanges() {
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = this.changeLog.size();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$Change.replay:()V");
            this.changeLog.get(n).replay();
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncWorld() {
        block7: {
            Preferences preferences;
            block6: {
                Preferences preferences2;
                Class<FileSystemPreferences> clazz = FileSystemPreferences.class;
                try {
                    preferences2 = userRoot;
                    preferences = systemRoot;
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordJump();
                try {
                    RuntimeCostAccounter.recordJump();
                    if (preferences2 == null) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.flush:()V");
                    preferences2.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.getLogger:()Lsun/util/logging/PlatformLogger;");
                    PlatformLogger platformLogger = FileSystemPreferences.getLogger();
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Couldn't flush user prefs: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(backingStoreException);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                    platformLogger.warning(string);
                }
            }
            RuntimeCostAccounter.recordJump();
            try {
                RuntimeCostAccounter.recordJump();
                if (preferences == null) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Preferences.flush:()V");
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.getLogger:()Lsun/util/logging/PlatformLogger;");
                PlatformLogger platformLogger = FileSystemPreferences.getLogger();
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append("Couldn't flush system prefs: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(backingStoreException);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                platformLogger.warning(string);
            }
        }
        RuntimeCostAccounter.recordJump();
    }

    private FileSystemPreferences(boolean bl) {
        File file;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/AbstractPreferences.<init>:(Ljava/util/prefs/AbstractPreferences;Ljava/lang/String;)V");
        super(null, "");
        this.prefsCache = null;
        this.lastSyncTime = 0L;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.changeLog = new ArrayList<Change>();
        this.nodeCreate = null;
        this.isUserNode = bl;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            file = userRootDir;
            RuntimeCostAccounter.recordJump();
        } else {
            file = systemRootDir;
        }
        this.dir = file;
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
        this.prefsFile = new File(this.dir, "prefs.xml");
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
        this.tmpFile = new File(this.dir, "prefs.tmp");
    }

    private FileSystemPreferences(FileSystemPreferences fileSystemPreferences, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/AbstractPreferences.<init>:(Ljava/util/prefs/AbstractPreferences;Ljava/lang/String;)V");
        super(fileSystemPreferences, string);
        this.prefsCache = null;
        this.lastSyncTime = 0L;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.changeLog = new ArrayList<Change>();
        this.nodeCreate = null;
        this.isUserNode = fileSystemPreferences.isUserNode;
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        File file = fileSystemPreferences.dir;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.dirName:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = FileSystemPreferences.dirName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
        this.dir = new File(file, string2);
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
        this.prefsFile = new File(this.dir, "prefs.xml");
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
        this.tmpFile = new File(this.dir, "prefs.tmp");
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$5");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$5.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
        PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Void run() {
                boolean bl;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                File file = FileSystemPreferences.this.dir;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                boolean bl2 = file.exists();
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                FileSystemPreferences.this.newNode = bl;
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        RuntimeCostAccounter.recordJump();
        if (this.newNode) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.<init>:()V");
            this.prefsCache = new TreeMap<String, String>();
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$NodeCreate");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$NodeCreate.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/util/prefs/FileSystemPreferences$1;)V");
            this.nodeCreate = new NodeCreate(this, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            this.changeLog.add(this.nodeCreate);
        }
    }

    @Override
    public boolean isUserNode() {
        return this.isUserNode;
    }

    @Override
    protected void putSpi(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.initCacheIfNecessary:()V");
        this.initCacheIfNecessary();
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$Put");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$Put.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/lang/String;Ljava/lang/String;)V");
        Put put = new Put(string, string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
        this.changeLog.add(put);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        this.prefsCache.put(string, string2);
    }

    @Override
    protected String getSpi(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.initCacheIfNecessary:()V");
        this.initCacheIfNecessary();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.prefsCache.get(string);
    }

    @Override
    protected void removeSpi(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.initCacheIfNecessary:()V");
        this.initCacheIfNecessary();
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$Remove");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$Remove.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/lang/String;)V");
        Remove remove = new Remove(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
        this.changeLog.add(remove);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        this.prefsCache.remove(string);
    }

    private void initCacheIfNecessary() {
        RuntimeCostAccounter.recordJump();
        if (this.prefsCache != null) {
            return;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.loadCache:()V");
            this.loadCache();
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.<init>:()V");
            this.prefsCache = new TreeMap<String, String>();
        }
        RuntimeCostAccounter.recordJump();
    }

    private void loadCache() throws BackingStoreException {
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$6");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$6.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
            PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public Void run() throws BackingStoreException {
                    long l;
                    TreeMap<String, String> treeMap;
                    block13: {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.<init>:()V");
                        treeMap = new TreeMap<String, String>();
                        l = 0L;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                            File file = FileSystemPreferences.this.prefsFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
                            l = file.lastModified();
                            RuntimeCostAccounter.recordAllocation((String)"java/io/FileInputStream");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                            File file2 = FileSystemPreferences.this.prefsFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.<init>:(Ljava/io/File;)V");
                            FileInputStream fileInputStream = new FileInputStream(file2);
                            Throwable throwable = null;
                            try {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/XmlSupport.importMap:(Ljava/io/InputStream;Ljava/util/Map;)V");
                                XmlSupport.importMap(fileInputStream, treeMap);
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    RuntimeCostAccounter.recordThrow();
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    block14: {
                                        block15: {
                                            RuntimeCostAccounter.recordJump();
                                            if (fileInputStream == null) break block14;
                                            RuntimeCostAccounter.recordJump();
                                            if (throwable == null) break block15;
                                            try {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.close:()V");
                                                fileInputStream.close();
                                            }
                                            catch (Throwable throwable4) {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                                throwable.addSuppressed(throwable4);
                                                RuntimeCostAccounter.recordJump();
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            break block14;
                                            break block14;
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.close:()V");
                                        fileInputStream.close();
                                    }
                                    RuntimeCostAccounter.recordThrow();
                                    throw throwable3;
                                }
                            }
                            RuntimeCostAccounter.recordJump();
                            if (fileInputStream == null) break block13;
                            RuntimeCostAccounter.recordJump();
                            if (throwable != null) {
                                try {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.close:()V");
                                    fileInputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                    throwable.addSuppressed(throwable5);
                                    RuntimeCostAccounter.recordJump();
                                    break block13;
                                }
                                RuntimeCostAccounter.recordJump();
                                break block13;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.close:()V");
                            fileInputStream.close();
                            RuntimeCostAccounter.recordJump();
                        }
                        catch (Exception exception) {
                            boolean bl = exception instanceof InvalidPreferencesFormatException;
                            RuntimeCostAccounter.recordJump();
                            if (bl) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                                PlatformLogger platformLogger = FileSystemPreferences.access$200();
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                StringBuilder stringBuilder = new StringBuilder();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder2 = stringBuilder.append("Invalid preferences format in ");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                                File file = FileSystemPreferences.this.prefsFile;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
                                String string = file.getPath();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                String string2 = stringBuilder3.toString();
                                RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                                platformLogger.warning(string2);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                                File file3 = FileSystemPreferences.this.prefsFile;
                                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                                File file4 = FileSystemPreferences.this.prefsFile;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getParentFile:()Ljava/io/File;");
                                File file5 = file4.getParentFile();
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                                File file6 = new File(file5, "IncorrectFormatPrefs.xml");
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.renameTo:(Ljava/io/File;)Z");
                                file3.renameTo(file6);
                                RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.<init>:()V");
                                treeMap = new TreeMap();
                                RuntimeCostAccounter.recordJump();
                            }
                            boolean bl2 = exception instanceof FileNotFoundException;
                            RuntimeCostAccounter.recordJump();
                            if (bl2) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                                PlatformLogger platformLogger = FileSystemPreferences.access$200();
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                StringBuilder stringBuilder = new StringBuilder();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder4 = stringBuilder.append("Prefs file removed in background ");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                                File file = FileSystemPreferences.this.prefsFile;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
                                String string = file.getPath();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder5 = stringBuilder4.append(string);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                String string3 = stringBuilder5.toString();
                                RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                                platformLogger.warning(string3);
                                RuntimeCostAccounter.recordJump();
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/BackingStoreException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/BackingStoreException.<init>:(Ljava/lang/Throwable;)V");
                            BackingStoreException backingStoreException = new BackingStoreException(exception);
                            RuntimeCostAccounter.recordThrow();
                            throw backingStoreException;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1102:(Ljava/util/prefs/FileSystemPreferences;Ljava/util/Map;)Ljava/util/Map;");
                    FileSystemPreferences.this.prefsCache = treeMap;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1702:(Ljava/util/prefs/FileSystemPreferences;J)J");
                    FileSystemPreferences.this.lastSyncTime = l;
                    return null;
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;");
            AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
            BackingStoreException backingStoreException = (BackingStoreException)privilegedActionException.getException();
            RuntimeCostAccounter.recordThrow();
            throw backingStoreException;
        }
        RuntimeCostAccounter.recordJump();
    }

    private void writeBackCache() throws BackingStoreException {
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$7");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$7.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
            PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Void run() throws BackingStoreException {
                    try {
                        block21: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                            File file = FileSystemPreferences.this.dir;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                            boolean bl = file.exists();
                            RuntimeCostAccounter.recordJump();
                            if (!bl) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                                File file2 = FileSystemPreferences.this.dir;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.mkdirs:()Z");
                                boolean bl2 = file2.mkdirs();
                                RuntimeCostAccounter.recordJump();
                                if (!bl2) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/BackingStoreException");
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                    StringBuilder stringBuilder = new StringBuilder();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                                    File file3 = FileSystemPreferences.this.dir;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                                    StringBuilder stringBuilder2 = stringBuilder.append(file3);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                    StringBuilder stringBuilder3 = stringBuilder2.append(" create failed.");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                    String string = stringBuilder3.toString();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/BackingStoreException.<init>:(Ljava/lang/String;)V");
                                    BackingStoreException backingStoreException = new BackingStoreException(string);
                                    RuntimeCostAccounter.recordThrow();
                                    throw backingStoreException;
                                }
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1800:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                            File file4 = FileSystemPreferences.this.tmpFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;)V");
                            FileOutputStream fileOutputStream = new FileOutputStream(file4);
                            Throwable throwable = null;
                            try {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1100:(Ljava/util/prefs/FileSystemPreferences;)Ljava/util/Map;");
                                Map map = FileSystemPreferences.this.prefsCache;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/XmlSupport.exportMap:(Ljava/io/OutputStream;Ljava/util/Map;)V");
                                XmlSupport.exportMap(fileOutputStream, map);
                            }
                            catch (Throwable throwable3) {
                                try {
                                    throwable = throwable3;
                                    RuntimeCostAccounter.recordThrow();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    block20: {
                                        RuntimeCostAccounter.recordJump();
                                        if (fileOutputStream != null) {
                                            RuntimeCostAccounter.recordJump();
                                            if (throwable != null) {
                                                try {
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.close:()V");
                                                    fileOutputStream.close();
                                                }
                                                catch (Throwable throwable5) {
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                                    throwable.addSuppressed(throwable5);
                                                    RuntimeCostAccounter.recordJump();
                                                    break block20;
                                                }
                                                RuntimeCostAccounter.recordJump();
                                            } else {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.close:()V");
                                                fileOutputStream.close();
                                            }
                                        }
                                    }
                                    RuntimeCostAccounter.recordThrow();
                                    throw throwable4;
                                }
                            }
                            RuntimeCostAccounter.recordJump();
                            if (fileOutputStream != null) {
                                RuntimeCostAccounter.recordJump();
                                if (throwable != null) {
                                    try {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.close:()V");
                                        fileOutputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                        throwable.addSuppressed(throwable2);
                                        RuntimeCostAccounter.recordJump();
                                        break block21;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.close:()V");
                                    fileOutputStream.close();
                                    RuntimeCostAccounter.recordJump();
                                }
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1800:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                        File file = FileSystemPreferences.this.tmpFile;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                        File file5 = FileSystemPreferences.this.prefsFile;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.renameTo:(Ljava/io/File;)Z");
                        boolean bl = file.renameTo(file5);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/BackingStoreException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder4 = stringBuilder.append("Can't rename ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1800:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                            File file6 = FileSystemPreferences.this.tmpFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder5 = stringBuilder4.append(file6);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder6 = stringBuilder5.append(" to ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                            File file7 = FileSystemPreferences.this.prefsFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder7 = stringBuilder6.append(file7);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string = stringBuilder7.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/BackingStoreException.<init>:(Ljava/lang/String;)V");
                            BackingStoreException backingStoreException = new BackingStoreException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw backingStoreException;
                        }
                    }
                    catch (Exception exception) {
                        boolean bl = exception instanceof BackingStoreException;
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            BackingStoreException backingStoreException = (BackingStoreException)exception;
                            RuntimeCostAccounter.recordThrow();
                            throw backingStoreException;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/BackingStoreException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/BackingStoreException.<init>:(Ljava/lang/Throwable;)V");
                        BackingStoreException backingStoreException = new BackingStoreException(exception);
                        RuntimeCostAccounter.recordThrow();
                        throw backingStoreException;
                    }
                    RuntimeCostAccounter.recordJump();
                    return null;
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;");
            AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
            BackingStoreException backingStoreException = (BackingStoreException)privilegedActionException.getException();
            RuntimeCostAccounter.recordThrow();
            throw backingStoreException;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    protected String[] keysSpi() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.initCacheIfNecessary:()V");
        this.initCacheIfNecessary();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
        Set<String> set = this.prefsCache.keySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n = this.prefsCache.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        String[] stringArray = new String[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return set.toArray(stringArray);
    }

    @Override
    protected String[] childrenNamesSpi() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$8");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$8.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
        PrivilegedAction<String[]> privilegedAction = new PrivilegedAction<String[]>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public String[] run() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
                ArrayList<String> arrayList = new ArrayList<String>();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                File file = FileSystemPreferences.this.dir;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.listFiles:()[Ljava/io/File;");
                File[] fileArray = file.listFiles();
                RuntimeCostAccounter.recordJump();
                if (fileArray != null) {
                    int n = 0;
                    while (true) {
                        int n2 = fileArray.length;
                        RuntimeCostAccounter.recordJump();
                        if (n >= n2) break;
                        File file2 = fileArray[n];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isDirectory:()Z");
                        boolean bl = file2.isDirectory();
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            File file3 = fileArray[n];
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getName:()Ljava/lang/String;");
                            String string = file3.getName();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1900:(Ljava/lang/String;)Ljava/lang/String;");
                            String string2 = FileSystemPreferences.access$1900(string);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                            arrayList.add(string2);
                        }
                        ++n;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$2000:()[Ljava/lang/String;");
                String[] stringArray = EMPTY_STRING_ARRAY;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
                return arrayList.toArray(stringArray);
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        return (String[])AccessController.doPrivileged((PrivilegedAction)privilegedAction);
    }

    @Override
    protected AbstractPreferences childSpi(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/lang/String;)V");
        return new FileSystemPreferences(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        File file;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
        boolean bl = this.isUserNode();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            file = userLockFile;
            RuntimeCostAccounter.recordJump();
        } else {
            file = systemLockFile;
        }
        File file2 = file;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.lockFile:(Z)Z");
            boolean bl2 = this.lockFile(false);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/BackingStoreException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/BackingStoreException.<init>:(Ljava/lang/String;)V");
                BackingStoreException backingStoreException = new BackingStoreException("Couldn't get file lock.");
                RuntimeCostAccounter.recordThrow();
                throw backingStoreException;
            }
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/AbstractPreferences.removeNode:()V");
                super.removeNode();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.unlockFile:()V");
                this.unlockFile();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.unlockFile:()V");
            this.unlockFile();
            RuntimeCostAccounter.recordJump();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$9");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$9.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
            PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public Void run() throws BackingStoreException {
                    List<Change> list = FileSystemPreferences.this.changeLog;
                    NodeCreate nodeCreate = FileSystemPreferences.this.nodeCreate;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.contains:(Ljava/lang/Object;)Z");
                    boolean bl = list.contains(nodeCreate);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        List<Change> list2 = FileSystemPreferences.this.changeLog;
                        NodeCreate nodeCreate2 = FileSystemPreferences.this.nodeCreate;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.remove:(Ljava/lang/Object;)Z");
                        list2.remove(nodeCreate2);
                        FileSystemPreferences.this.nodeCreate = null;
                        return null;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                    File file = FileSystemPreferences.this.dir;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                    boolean bl2 = file.exists();
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) {
                        return null;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1600:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                    File file2 = FileSystemPreferences.this.prefsFile;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.delete:()Z");
                    file2.delete();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1800:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                    File file3 = FileSystemPreferences.this.tmpFile;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.delete:()Z");
                    file3.delete();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                    File file4 = FileSystemPreferences.this.dir;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.listFiles:()[Ljava/io/File;");
                    File[] fileArray = file4.listFiles();
                    int n = fileArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n != 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$200:()Lsun/util/logging/PlatformLogger;");
                        PlatformLogger platformLogger = FileSystemPreferences.access$200();
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("Found extraneous files when removing node: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
                        List<File> list3 = Arrays.asList(fileArray);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(list3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                        platformLogger.warning(string);
                        int n2 = 0;
                        while (true) {
                            int n3 = fileArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n2 >= n3) break;
                            File file5 = fileArray[n2];
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.delete:()Z");
                            file5.delete();
                            ++n2;
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                    File file6 = FileSystemPreferences.this.dir;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.delete:()Z");
                    boolean bl3 = file6.delete();
                    RuntimeCostAccounter.recordJump();
                    if (!bl3) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/BackingStoreException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder.append("Couldn't delete dir: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1400:(Ljava/util/prefs/FileSystemPreferences;)Ljava/io/File;");
                        File file7 = FileSystemPreferences.this.dir;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(file7);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder5.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/BackingStoreException.<init>:(Ljava/lang/String;)V");
                        BackingStoreException backingStoreException = new BackingStoreException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw backingStoreException;
                    }
                    return null;
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;");
            AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
            BackingStoreException backingStoreException = (BackingStoreException)privilegedActionException.getException();
            RuntimeCostAccounter.recordThrow();
            throw backingStoreException;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync() throws BackingStoreException {
        File file;
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
        boolean bl2 = this.isUserNode();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            bl = false;
            RuntimeCostAccounter.recordJump();
        } else {
            boolean bl3;
            RuntimeCostAccounter.recordJump();
            if (!isSystemRootWritable) {
                bl3 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl3 = false;
            }
            bl = bl3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
        boolean bl4 = this.isUserNode();
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            file = userLockFile;
            RuntimeCostAccounter.recordJump();
        } else {
            file = systemLockFile;
        }
        File file2 = file;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.lockFile:(Z)Z");
            boolean bl5 = this.lockFile(bl);
            RuntimeCostAccounter.recordJump();
            if (!bl5) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/BackingStoreException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/BackingStoreException.<init>:(Ljava/lang/String;)V");
                BackingStoreException backingStoreException = new BackingStoreException("Couldn't get file lock.");
                RuntimeCostAccounter.recordThrow();
                throw backingStoreException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$10");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$10.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
            PrivilegedAction<Long> privilegedAction = new PrivilegedAction<Long>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public Long run() {
                    long l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
                    boolean bl = FileSystemPreferences.this.isUserNode();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        boolean bl2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$400:()Ljava/io/File;");
                        File file = userRootModFile;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
                        l = file.lastModified();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$500:()J");
                        long l2 = userRootModTime - l;
                        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l3 == false) {
                            bl2 = true;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            bl2 = false;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$2102:(Z)Z");
                        isUserRootModified = bl2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        boolean bl3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$800:()Ljava/io/File;");
                        File file = systemRootModFile;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
                        l = file.lastModified();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$900:()J");
                        long l4 = systemRootModTime - l;
                        long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l5 == false) {
                            bl3 = true;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            bl3 = false;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$2202:(Z)Z");
                        isSystemRootModified = bl3;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Long");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.<init>:(J)V");
                    return new Long(l);
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
            final Long l = (Long)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/AbstractPreferences.sync:()V");
                super.sync();
                RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$11");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$11.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/lang/Long;)V");
                PrivilegedAction<Void> privilegedAction2 = new PrivilegedAction<Void>(){
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                    }

                    public Void run() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
                        boolean bl = FileSystemPreferences.this.isUserNode();
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                            long l4 = l + 1000L;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$502:(J)J");
                            userRootModTime = l4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$400:()Ljava/io/File;");
                            File file = userRootModFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$500:()J");
                            long l2 = userRootModTime;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.setLastModified:(J)Z");
                            file.setLastModified(l2);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                            long l5 = l + 1000L;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$902:(J)J");
                            systemRootModTime = l5;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$800:()Ljava/io/File;");
                            File file = systemRootModFile;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$900:()J");
                            long l3 = systemRootModTime;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.setLastModified:(J)Z");
                            file.setLastModified(l3);
                        }
                        return null;
                    }
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
                AccessController.doPrivileged((PrivilegedAction)privilegedAction2);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.unlockFile:()V");
                this.unlockFile();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.unlockFile:()V");
            this.unlockFile();
            RuntimeCostAccounter.recordJump();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$12");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$12.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
            PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){
                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                }

                public Void run() throws BackingStoreException {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$2300:(Ljava/util/prefs/FileSystemPreferences;)V");
                    FileSystemPreferences.access$2300(FileSystemPreferences.this);
                    return null;
                }
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;");
            AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
            BackingStoreException backingStoreException = (BackingStoreException)privilegedActionException.getException();
            RuntimeCostAccounter.recordThrow();
            throw backingStoreException;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * Unable to fully structure code
     */
    private void syncSpiPrivileged() throws BackingStoreException {
        block9: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isRemoved:()Z");
            v0 = this.isRemoved();
            RuntimeCostAccounter.recordJump();
            if (v0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                v1 = new IllegalStateException("Node has been removed");
                RuntimeCostAccounter.recordThrow();
                throw v1;
            }
            RuntimeCostAccounter.recordJump();
            if (this.prefsCache == null) {
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
            v2 = this.isUserNode();
            RuntimeCostAccounter.recordJump();
            if (!v2) break block9;
            RuntimeCostAccounter.recordJump();
            if (!FileSystemPreferences.isUserRootModified) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            ** GOTO lbl-1000
        }
        RuntimeCostAccounter.recordJump();
        if (FileSystemPreferences.isSystemRootModified) lbl-1000:
        // 2 sources

        {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
            var1_1 = this.prefsFile.lastModified();
            RuntimeCostAccounter.recordJump();
            if (var1_1 != this.lastSyncTime) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.loadCache:()V");
                this.loadCache();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.replayChanges:()V");
                this.replayChanges();
                this.lastSyncTime = var1_1;
                RuntimeCostAccounter.recordJump();
            }
        } else lbl-1000:
        // 2 sources

        {
            RuntimeCostAccounter.recordJump();
            if (this.lastSyncTime != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                v3 = this.dir.exists();
                RuntimeCostAccounter.recordJump();
                if (!v3) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.<init>:()V");
                    this.prefsCache = new TreeMap<String, String>();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.replayChanges:()V");
                    this.replayChanges();
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.isEmpty:()Z");
        v4 = this.changeLog.isEmpty();
        RuntimeCostAccounter.recordJump();
        if (!v4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.writeBackCache:()V");
            this.writeBackCache();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.lastModified:()J");
            var1_1 = this.prefsFile.lastModified();
            RuntimeCostAccounter.recordJump();
            if (this.lastSyncTime <= var1_1) {
                this.lastSyncTime = var1_1 + 1000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.setLastModified:(J)Z");
                this.prefsFile.setLastModified(this.lastSyncTime);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.clear:()V");
            this.changeLog.clear();
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isRemoved:()Z");
        boolean bl = this.isRemoved();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.sync:()V");
        this.sync();
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDirChar(char c) {
        RuntimeCostAccounter.recordJump();
        if (c <= '\u001f') return false;
        RuntimeCostAccounter.recordJump();
        if (c >= '\u007f') return false;
        RuntimeCostAccounter.recordJump();
        if (c == '/') return false;
        RuntimeCostAccounter.recordJump();
        if (c == '.') return false;
        RuntimeCostAccounter.recordJump();
        if (c == '_') return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    private static String dirName(String string) {
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = string.length();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            char c = string.charAt(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isDirChar:(C)Z");
            boolean bl = FileSystemPreferences.isDirChar(c);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("_");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.byteArray:(Ljava/lang/String;)[B");
                byte[] byArray = FileSystemPreferences.byteArray(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Base64.byteArrayToAltBase64:([B)Ljava/lang/String;");
                String string2 = Base64.byteArrayToAltBase64(byArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                return stringBuilder3.toString();
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        return string;
    }

    private static byte[] byteArray(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        int n2 = 2 * n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            char c = string.charAt(n3);
            byArray[n4++] = (byte)(c >> 8);
            byArray[n4++] = (byte)c;
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        return byArray;
    }

    private static String nodeName(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        char c = string.charAt(0);
        RuntimeCostAccounter.recordJump();
        if (c != '_') {
            return string;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
        String string2 = string.substring(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/Base64.altBase64ToByteArray:(Ljava/lang/String;)[B");
        byte[] byArray = Base64.altBase64ToByteArray(string2);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        int n = byArray.length / 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:(I)V");
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (true) {
            int n3 = byArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            int n4 = byArray[n2++] & 0xFF;
            int n5 = byArray[n2++] & 0xFF;
            char c2 = (char)(n4 << 8 | n5);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(C)Ljava/lang/StringBuffer;");
            stringBuffer.append(c2);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return stringBuffer.toString();
    }

    private boolean lockFile(boolean bl) throws SecurityException {
        File file;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
        boolean bl2 = this.isUserNode();
        int n = 0;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            file = userLockFile;
            RuntimeCostAccounter.recordJump();
        } else {
            file = systemLockFile;
        }
        File file2 = file;
        long l = INIT_SLEEP_TIME;
        int n2 = 0;
        while (true) {
            block11: {
                RuntimeCostAccounter.recordJump();
                if (n2 >= MAX_ATTEMPTS) break;
                try {
                    int n3;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        n3 = 384;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n3 = 420;
                    }
                    int n4 = n3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
                    String string = file2.getCanonicalPath();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.lockFile0:(Ljava/lang/String;IZ)[I");
                    int[] nArray = FileSystemPreferences.lockFile0(string, n4, bl);
                    n = nArray[1];
                    int n5 = nArray[0];
                    RuntimeCostAccounter.recordJump();
                    if (n5 == 0) break block11;
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        userRootLockHandle = nArray[0];
                        RuntimeCostAccounter.recordJump();
                    } else {
                        systemRootLockHandle = nArray[0];
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            RuntimeCostAccounter.recordJump();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.sleep:(J)V");
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.checkLockFile0ErrorCode:(I)V");
                this.checkLockFile0ErrorCode(n);
                return false;
            }
            RuntimeCostAccounter.recordJump();
            l *= 2L;
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.checkLockFile0ErrorCode:(I)V");
        this.checkLockFile0ErrorCode(n);
        return false;
    }

    private void checkLockFile0ErrorCode(int n) throws SecurityException {
        RuntimeCostAccounter.recordJump();
        if (n == 13) {
            String string;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/SecurityException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Could not lock ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
            boolean bl = this.isUserNode();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                string = "User prefs.";
                RuntimeCostAccounter.recordJump();
            } else {
                string = "System prefs.";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" Lock file access denied.");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityException.<init>:(Ljava/lang/String;)V");
            SecurityException securityException = new SecurityException(string2);
            RuntimeCostAccounter.recordThrow();
            throw securityException;
        }
        RuntimeCostAccounter.recordJump();
        if (n != 11) {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.getLogger:()Lsun/util/logging/PlatformLogger;");
            PlatformLogger platformLogger = FileSystemPreferences.getLogger();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder.append("Could not lock ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
            boolean bl = this.isUserNode();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                string = "User prefs. ";
                RuntimeCostAccounter.recordJump();
            } else {
                string = "System prefs.";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(" Unix error code ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(".");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder9.toString();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
            platformLogger.warning(string3);
        }
    }

    private static native int[] lockFile0(String var0, int var1, boolean var2);

    private static native int unlockFile0(int var0);

    private static native int chmod(String var0, int var1);

    private void unlockFile() {
        int n;
        File file;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
        boolean bl = this.isUserNode();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            file = userLockFile;
            RuntimeCostAccounter.recordJump();
        } else {
            file = systemLockFile;
        }
        File file2 = file;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = userRootLockHandle;
            RuntimeCostAccounter.recordJump();
        } else {
            n = systemRootLockHandle;
        }
        int n2 = n;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.getLogger:()Lsun/util/logging/PlatformLogger;");
            PlatformLogger platformLogger = FileSystemPreferences.getLogger();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unlock: zero lockHandle for ");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                string = "user";
                RuntimeCostAccounter.recordJump();
            } else {
                string = "system";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" preferences.)");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
            platformLogger.warning(string2);
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.unlockFile0:(I)I");
        int n3 = FileSystemPreferences.unlockFile0(n2);
        RuntimeCostAccounter.recordJump();
        if (n3 != 0) {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.getLogger:()Lsun/util/logging/PlatformLogger;");
            PlatformLogger platformLogger = FileSystemPreferences.getLogger();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder.append("Could not drop file-lock on ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
            boolean bl2 = this.isUserNode();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                string = "user";
                RuntimeCostAccounter.recordJump();
            } else {
                string = "system";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(" preferences.");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(" Unix error code ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder9.append(".");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder10.toString();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
            platformLogger.warning(string3);
            RuntimeCostAccounter.recordJump();
            if (n3 == 13) {
                String string4;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/SecurityException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder11 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder12 = stringBuilder11.append("Could not unlock");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
                boolean bl3 = this.isUserNode();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    string4 = "User prefs.";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string4 = "System prefs.";
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder13 = stringBuilder12.append(string4);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder14 = stringBuilder13.append(" Lock file access denied.");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string5 = stringBuilder14.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityException.<init>:(Ljava/lang/String;)V");
                SecurityException securityException = new SecurityException(string5);
                RuntimeCostAccounter.recordThrow();
                throw securityException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.isUserNode:()Z");
        boolean bl4 = this.isUserNode();
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            userRootLockHandle = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            systemRootLockHandle = 0;
        }
    }

    static /* synthetic */ int access$100(String string, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.chmod:(Ljava/lang/String;I)I");
        return FileSystemPreferences.chmod(string, n);
    }

    static /* synthetic */ PlatformLogger access$200() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.getLogger:()Lsun/util/logging/PlatformLogger;");
        return FileSystemPreferences.getLogger();
    }

    static /* synthetic */ void access$1200() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.syncWorld:()V");
        FileSystemPreferences.syncWorld();
    }

    static /* synthetic */ String access$1900(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.nodeName:(Ljava/lang/String;)Ljava/lang/String;");
        return FileSystemPreferences.nodeName(string);
    }

    static /* synthetic */ void access$2300(FileSystemPreferences fileSystemPreferences) throws BackingStoreException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.syncSpiPrivileged:()V");
        fileSystemPreferences.syncSpiPrivileged();
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction = new GetPropertyAction("java.util.prefs.syncInterval", "30");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        String string = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
        int n = Integer.parseInt(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        SYNC_INTERVAL = Math.max(1, n);
        userRoot = null;
        userRootLockHandle = 0;
        systemRootLockHandle = 0;
        isUserRootModified = false;
        isSystemRootModified = false;
        RuntimeCostAccounter.recordAllocation((String)"java/util/Timer");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.<init>:(Z)V");
        syncTimer = new Timer(true);
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$3");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$3.<init>:()V");
        TimerTask timerTask = new TimerTask(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerTask.<init>:()V");
            }

            @Override
            public void run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1200:()V");
                FileSystemPreferences.access$1200();
            }
        };
        long l = SYNC_INTERVAL * 1000;
        long l2 = SYNC_INTERVAL * 1000;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.schedule:(Ljava/util/TimerTask;JJ)V");
        syncTimer.schedule(timerTask, l, l2);
        RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$4");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$4.<init>:()V");
        PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Void run() {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
                Runtime runtime = Runtime.getRuntime();
                RuntimeCostAccounter.recordAllocation((String)"java/util/prefs/FileSystemPreferences$4$1");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$4$1.<init>:(Ljava/util/prefs/FileSystemPreferences$4;)V");
                Thread thread = new Thread(){
                    {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.<init>:()V");
                    }

                    @Override
                    public void run() {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1300:()Ljava/util/Timer;");
                        Timer timer = syncTimer;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.cancel:()V");
                        timer.cancel();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1200:()V");
                        FileSystemPreferences.access$1200();
                    }
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.addShutdownHook:(Ljava/lang/Thread;)V");
                runtime.addShutdownHook(thread);
                return null;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        EMPTY_STRING_ARRAY = new String[0];
        INIT_SLEEP_TIME = 50;
        MAX_ATTEMPTS = 5;
    }

    private class NodeCreate
    extends Change {
        final /* synthetic */ FileSystemPreferences this$0;

        private NodeCreate(FileSystemPreferences fileSystemPreferences) {
            this.this$0 = fileSystemPreferences;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$Change.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/util/prefs/FileSystemPreferences$1;)V");
            super(fileSystemPreferences, null);
        }

        @Override
        void replay() {
        }

        /* synthetic */ NodeCreate(FileSystemPreferences fileSystemPreferences, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$NodeCreate.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
            this(fileSystemPreferences);
        }
    }

    private class Remove
    extends Change {
        String key;

        Remove(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$Change.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/util/prefs/FileSystemPreferences$1;)V");
            super(FileSystemPreferences.this, null);
            this.key = string;
        }

        @Override
        void replay() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1100:(Ljava/util/prefs/FileSystemPreferences;)Ljava/util/Map;");
            Map map = FileSystemPreferences.this.prefsCache;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            map.remove(this.key);
        }
    }

    private class Put
    extends Change {
        String key;
        String value;

        Put(String string, String string2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$Change.<init>:(Ljava/util/prefs/FileSystemPreferences;Ljava/util/prefs/FileSystemPreferences$1;)V");
            super(FileSystemPreferences.this, null);
            this.key = string;
            this.value = string2;
        }

        @Override
        void replay() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences.access$1100:(Ljava/util/prefs/FileSystemPreferences;)Ljava/util/Map;");
            Map map = FileSystemPreferences.this.prefsCache;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            map.put(this.key, this.value);
        }
    }

    private abstract class Change {
        final /* synthetic */ FileSystemPreferences this$0;

        private Change(FileSystemPreferences fileSystemPreferences) {
            this.this$0 = fileSystemPreferences;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        abstract void replay();

        /* synthetic */ Change(FileSystemPreferences fileSystemPreferences, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/prefs/FileSystemPreferences$Change.<init>:(Ljava/util/prefs/FileSystemPreferences;)V");
            this(fileSystemPreferences);
        }
    }
}

