/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.PrintStream;
import sandbox.java.io.UnsupportedEncodingException;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.IllegalCharsetNameException;
import sandbox.java.util.logging.ErrorManager;
import sandbox.java.util.logging.Filter;
import sandbox.java.util.logging.Formatter;
import sandbox.java.util.logging.Level;
import sandbox.java.util.logging.LogManager;
import sandbox.java.util.logging.LogRecord;

public abstract class Handler {
    private static final int offValue;
    private final LogManager manager;
    private volatile Filter filter;
    private volatile Formatter formatter;
    private volatile Level logLevel;
    private volatile ErrorManager errorManager;
    private volatile String encoding;
    boolean sealed;

    protected Handler() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        this.manager = LogManager.getLogManager();
        this.logLevel = Level.ALL;
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/ErrorManager");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/ErrorManager.<init>:()V");
        this.errorManager = new ErrorManager();
        this.sealed = true;
    }

    public abstract void publish(LogRecord var1);

    public abstract void flush();

    public abstract void close() throws SecurityException;

    public synchronized void setFormatter(Formatter formatter) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        formatter.getClass();
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public synchronized void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            block3: {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.isSupported:(Ljava/lang/String;)Z");
                    boolean bl = Charset.isSupported((String)string);
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block3;
                    RuntimeCostAccounter.recordAllocation((String)"java/io/UnsupportedEncodingException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/UnsupportedEncodingException.<init>:(Ljava/lang/String;)V");
                    UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedEncodingException;
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/UnsupportedEncodingException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/UnsupportedEncodingException.<init>:(Ljava/lang/String;)V");
                    UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedEncodingException;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized void setFilter(Filter filter) throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.checkPermission:()V");
        this.checkPermission();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public synchronized void setErrorManager(ErrorManager errorManager) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.checkPermission:()V");
        this.checkPermission();
        RuntimeCostAccounter.recordJump();
        if (errorManager == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.errorManager = errorManager;
    }

    public ErrorManager getErrorManager() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.checkPermission:()V");
        this.checkPermission();
        return this.errorManager;
    }

    protected void reportError(String string, Exception exception, int n) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/ErrorManager.error:(Ljava/lang/String;Ljava/lang/Exception;I)V");
            this.errorManager.error(string, exception, n);
        }
        catch (Exception exception2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.println:(Ljava/lang/String;)V");
            ((PrintStream)((Object)System.err)).println("Handler.reportError caught:");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Exception.printStackTrace:()V");
            exception2.printStackTrace();
        }
        RuntimeCostAccounter.recordJump();
    }

    public synchronized void setLevel(Level level) throws SecurityException {
        RuntimeCostAccounter.recordJump();
        if (level == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.checkPermission:()V");
        this.checkPermission();
        this.logLevel = level;
    }

    public Level getLevel() {
        return this.logLevel;
    }

    public boolean isLoggable(LogRecord logRecord) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.getLevel:()Ljava/util/logging/Level;");
                Level level = this.getLevel();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
                int n = level.intValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.getLevel:()Ljava/util/logging/Level;");
                Level level2 = logRecord.getLevel();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
                int n2 = level2.intValue();
                RuntimeCostAccounter.recordJump();
                if (n2 < n) break block4;
                RuntimeCostAccounter.recordJump();
                if (n != offValue) break block5;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.getFilter:()Ljava/util/logging/Filter;");
        Filter filter = this.getFilter();
        RuntimeCostAccounter.recordJump();
        if (filter == null) {
            return true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Filter.isLoggable:(Ljava/util/logging/LogRecord;)Z");
        return filter.isLoggable(logRecord);
    }

    void checkPermission() throws SecurityException {
        RuntimeCostAccounter.recordJump();
        if (this.sealed) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.checkPermission:()V");
            this.manager.checkPermission();
        }
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
        offValue = Level.OFF.intValue();
    }
}

