/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.atomic;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.concurrent.atomic.Striped64;

public class DoubleAdder
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;

    public DoubleAdder() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/Striped64.<init>:()V");
    }

    public void add(double d) {
        block3: {
            boolean bl;
            block4: {
                Striped64.Cell[] cellArray;
                block2: {
                    cellArray = this.cells;
                    RuntimeCostAccounter.recordJump();
                    if (this.cells != null) break block2;
                    long l = this.base;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
                    double d2 = Double.longBitsToDouble(l) + d;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToRawLongBits:(D)J");
                    long l2 = Double.doubleToRawLongBits(d2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.casBase:(JJ)Z");
                    boolean bl2 = this.casBase(l, l2);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break block3;
                }
                bl = true;
                RuntimeCostAccounter.recordJump();
                if (cellArray == null) break block4;
                int n = cellArray.length - 1;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.getProbe:()I");
                Striped64.Cell cell = cellArray[DoubleAdder.getProbe() & n];
                RuntimeCostAccounter.recordJump();
                if (cell == null) break block4;
                long l = cell.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
                double d3 = Double.longBitsToDouble(l) + d;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToRawLongBits:(D)J");
                long l3 = Double.doubleToRawLongBits(d3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/Striped64$Cell.cas:(JJ)Z");
                bl = cell.cas(l, l3);
                RuntimeCostAccounter.recordJump();
                if (bl) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.doubleAccumulate:(DLjava/util/function/DoubleBinaryOperator;Z)V");
            this.doubleAccumulate(d, null, bl);
        }
    }

    public double sum() {
        Striped64.Cell[] cellArray = this.cells;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
        double d = Double.longBitsToDouble(this.base);
        RuntimeCostAccounter.recordJump();
        if (cellArray != null) {
            int n = 0;
            while (true) {
                int n2 = cellArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Striped64.Cell cell = cellArray[n];
                RuntimeCostAccounter.recordJump();
                if (cell != null) {
                    long l = cell.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
                    d += Double.longBitsToDouble(l);
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return d;
    }

    public void reset() {
        Striped64.Cell[] cellArray = this.cells;
        this.base = 0L;
        RuntimeCostAccounter.recordJump();
        if (cellArray != null) {
            int n = 0;
            while (true) {
                int n2 = cellArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Striped64.Cell cell = cellArray[n];
                RuntimeCostAccounter.recordJump();
                if (cell != null) {
                    cell.value = 0L;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    public double sumThenReset() {
        Striped64.Cell[] cellArray = this.cells;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
        double d = Double.longBitsToDouble(this.base);
        this.base = 0L;
        RuntimeCostAccounter.recordJump();
        if (cellArray != null) {
            int n = 0;
            while (true) {
                int n2 = cellArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                Striped64.Cell cell = cellArray[n];
                RuntimeCostAccounter.recordJump();
                if (cell != null) {
                    long l = cell.value;
                    cell.value = 0L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
                    d += Double.longBitsToDouble(l);
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return d;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.sum:()D");
        double d = this.sum();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.toString:(D)Ljava/lang/String;");
        return Double.toString(d);
    }

    @Override
    public double doubleValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.sum:()D");
        return this.sum();
    }

    @Override
    public long longValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.sum:()D");
        return (long)this.sum();
    }

    @Override
    public int intValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.sum:()D");
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.sum:()D");
        return (float)this.sum();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/DoubleAdder$SerializationProxy");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder$SerializationProxy.<init>:(Ljava/util/concurrent/atomic/DoubleAdder;)V");
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Proxy required");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final double value;

        SerializationProxy(DoubleAdder doubleAdder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.sum:()D");
            this.value = doubleAdder.sum();
        }

        private Object readResolve() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/DoubleAdder");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/DoubleAdder.<init>:()V");
            DoubleAdder doubleAdder = new DoubleAdder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToRawLongBits:(D)J");
            doubleAdder.base = Double.doubleToRawLongBits(this.value);
            return doubleAdder;
        }
    }
}

