/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.atomic;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.sun.misc.Unsafe;

public class AtomicMarkableReference<V> {
    private volatile Pair<V> pair;
    private static final Unsafe UNSAFE;
    private static final long pairOffset;

    public AtomicMarkableReference(V v, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference$Pair.of:(Ljava/lang/Object;Z)Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;");
        this.pair = Pair.of(v, bl);
    }

    public V getReference() {
        return (V)this.pair.reference;
    }

    public boolean isMarked() {
        return this.pair.mark;
    }

    public V get(boolean[] blArray) {
        Pair<V> pair = this.pair;
        blArray[0] = pair.mark;
        return (V)pair.reference;
    }

    public boolean weakCompareAndSet(V v, V v2, boolean bl, boolean bl2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference.compareAndSet:(Ljava/lang/Object;Ljava/lang/Object;ZZ)Z");
        return this.compareAndSet(v, v2, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean compareAndSet(V v, V v2, boolean bl, boolean bl2) {
        block3: {
            Pair<V> pair;
            block2: {
                pair = this.pair;
                Object t = pair.reference;
                RuntimeCostAccounter.recordJump();
                if (v != t) return false;
                boolean bl3 = pair.mark;
                RuntimeCostAccounter.recordJump();
                if (bl != bl3) return false;
                Object t2 = pair.reference;
                RuntimeCostAccounter.recordJump();
                if (v2 != t2) break block2;
                boolean bl4 = pair.mark;
                RuntimeCostAccounter.recordJump();
                if (bl2 == bl4) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference$Pair.of:(Ljava/lang/Object;Z)Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;");
            Pair<V> pair2 = Pair.of(v2, bl2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference.casPair:(Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;)Z");
            boolean bl5 = this.casPair(pair, pair2);
            RuntimeCostAccounter.recordJump();
            if (!bl5) return false;
        }
        boolean bl6 = true;
        RuntimeCostAccounter.recordJump();
        return bl6;
    }

    public void set(V v, boolean bl) {
        block3: {
            block2: {
                Pair<V> pair = this.pair;
                Object t = pair.reference;
                RuntimeCostAccounter.recordJump();
                if (v != t) break block2;
                boolean bl2 = pair.mark;
                RuntimeCostAccounter.recordJump();
                if (bl == bl2) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference$Pair.of:(Ljava/lang/Object;Z)Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;");
            this.pair = Pair.of(v, bl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean attemptMark(V v, boolean bl) {
        Pair<V> pair = this.pair;
        Object t = pair.reference;
        RuntimeCostAccounter.recordJump();
        if (v != t) return false;
        boolean bl2 = pair.mark;
        RuntimeCostAccounter.recordJump();
        if (bl != bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference$Pair.of:(Ljava/lang/Object;Z)Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;");
            Pair<V> pair2 = Pair.of(v, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference.casPair:(Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;Ljava/util/concurrent/atomic/AtomicMarkableReference$Pair;)Z");
            boolean bl3 = this.casPair(pair, pair2);
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
        }
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    private boolean casPair(Pair<V> pair, Pair<V> pair2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return UNSAFE.compareAndSwapObject((Object)this, pairOffset, pair, pair2);
    }

    static long objectFieldOffset(Unsafe unsafe, String string, Class<?> clazz) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField(string);
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            return unsafe.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NoSuchFieldError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NoSuchFieldError.<init>:(Ljava/lang/String;)V");
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NoSuchFieldError.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
            noSuchFieldError.initCause(noSuchFieldException);
            RuntimeCostAccounter.recordThrow();
            throw noSuchFieldError;
        }
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
        UNSAFE = Unsafe.getUnsafe();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference.objectFieldOffset:(Lsun/misc/Unsafe;Ljava/lang/String;Ljava/lang/Class;)J");
        pairOffset = AtomicMarkableReference.objectFieldOffset(UNSAFE, "pair", AtomicMarkableReference.class);
    }

    private static class Pair<T> {
        final T reference;
        final boolean mark;

        private Pair(T t, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.reference = t;
            this.mark = bl;
        }

        static <T> Pair<T> of(T t, boolean bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicMarkableReference$Pair");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicMarkableReference$Pair.<init>:(Ljava/lang/Object;Z)V");
            return new Pair<T>(t, bl);
        }
    }
}

