/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.Collection;
import sandbox.java.util.Collections;
import sandbox.java.util.Iterator;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.LockSupport;
import sandbox.java.util.concurrent.locks.ReentrantLock;
import sandbox.sun.misc.Unsafe;

public class SynchronousQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final int NCPUS;
    static final int maxTimedSpins;
    static final int maxUntimedSpins;
    static final long spinForTimeoutThreshold = 1000L;
    private volatile transient Transferer<E> transferer;
    private ReentrantLock qlock;
    private WaitQueue waitingProducers;
    private WaitQueue waitingConsumers;

    public SynchronousQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue.<init>:(Z)V");
        this(false);
    }

    public SynchronousQueue(boolean bl) {
        Transferer transferer;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$TransferQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.<init>:()V");
            transferer = new TransferQueue();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$TransferStack");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.<init>:()V");
            transferer = new TransferStack();
        }
        this.transferer = transferer;
    }

    @Override
    public void put(E e) throws InterruptedException {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.transfer:(Ljava/lang/Object;ZJ)Ljava/lang/Object;");
        E e2 = this.transferer.transfer(e, false, 0L);
        RuntimeCostAccounter.recordJump();
        if (e2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            Thread.interrupted();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
        long l2 = timeUnit.toNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.transfer:(Ljava/lang/Object;ZJ)Ljava/lang/Object;");
        E e2 = this.transferer.transfer(e, true, l2);
        RuntimeCostAccounter.recordJump();
        if (e2 != null) {
            return true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
        InterruptedException interruptedException = new InterruptedException();
        RuntimeCostAccounter.recordThrow();
        throw interruptedException;
    }

    @Override
    public boolean offer(E e) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.transfer:(Ljava/lang/Object;ZJ)Ljava/lang/Object;");
        E e2 = this.transferer.transfer(e, true, 0L);
        RuntimeCostAccounter.recordJump();
        if (e2 != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public E take() throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.transfer:(Ljava/lang/Object;ZJ)Ljava/lang/Object;");
        E e = this.transferer.transfer(null, false, 0L);
        RuntimeCostAccounter.recordJump();
        if (e != null) {
            return e;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        Thread.interrupted();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
        InterruptedException interruptedException = new InterruptedException();
        RuntimeCostAccounter.recordThrow();
        throw interruptedException;
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        block3: {
            E e;
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
                long l2 = timeUnit.toNanos(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.transfer:(Ljava/lang/Object;ZJ)Ljava/lang/Object;");
                e = this.transferer.transfer(null, true, l2);
                RuntimeCostAccounter.recordJump();
                if (e != null) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                boolean bl = Thread.interrupted();
                RuntimeCostAccounter.recordJump();
                if (bl) break block3;
            }
            return e;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
        InterruptedException interruptedException = new InterruptedException();
        RuntimeCostAccounter.recordThrow();
        throw interruptedException;
    }

    @Override
    public E poll() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.transfer:(Ljava/lang/Object;ZJ)Ljava/lang/Object;");
        return this.transferer.transfer(null, true, 0L);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.isEmpty:()Z");
        return collection.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.emptyIterator:()Ljava/util/Iterator;");
        return Collections.emptyIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptySpliterator:()Ljava/util/Spliterator;");
        return Spliterators.emptySpliterator();
    }

    @Override
    public Object[] toArray() {
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            TArray[0] = null;
        }
        return TArray;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        RuntimeCostAccounter.recordJump();
        if (collection == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (collection == this) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue.poll:()Ljava/lang/Object;");
            E e = this.poll();
            RuntimeCostAccounter.recordJump();
            if (e == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
            collection.add(e);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        RuntimeCostAccounter.recordJump();
        if (collection == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (collection == this) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue.poll:()Ljava/lang/Object;");
            E e = this.poll();
            RuntimeCostAccounter.recordJump();
            if (e == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
            collection.add(e);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.transferer instanceof TransferQueue;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:(Z)V");
            this.qlock = new ReentrantLock(true);
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$FifoWaitQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$FifoWaitQueue.<init>:()V");
            this.waitingProducers = new FifoWaitQueue();
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$FifoWaitQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$FifoWaitQueue.<init>:()V");
            this.waitingConsumers = new FifoWaitQueue();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
            this.qlock = new ReentrantLock();
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$LifoWaitQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$LifoWaitQueue.<init>:()V");
            this.waitingProducers = new LifoWaitQueue();
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$LifoWaitQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$LifoWaitQueue.<init>:()V");
            this.waitingConsumers = new LifoWaitQueue();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        boolean bl = this.waitingProducers instanceof FifoWaitQueue;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$TransferQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.<init>:()V");
            this.transferer = new TransferQueue();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$TransferStack");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.<init>:()V");
            this.transferer = new TransferStack();
        }
    }

    static long objectFieldOffset(Unsafe unsafe, String string, Class<?> clazz) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField(string);
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            return unsafe.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NoSuchFieldError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NoSuchFieldError.<init>:(Ljava/lang/String;)V");
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NoSuchFieldError.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
            noSuchFieldError.initCause(noSuchFieldException);
            RuntimeCostAccounter.recordThrow();
            throw noSuchFieldError;
        }
    }

    static {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.getRuntime:()Ljava/lang/Runtime;");
        Runtime runtime = Runtime.getRuntime();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runtime.availableProcessors:()I");
        NCPUS = runtime.availableProcessors();
        RuntimeCostAccounter.recordJump();
        if (NCPUS < 2) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 32;
        }
        maxTimedSpins = n;
        maxUntimedSpins = maxTimedSpins * 16;
    }

    static class FifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3623113410248163686L;

        FifoWaitQueue() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$WaitQueue.<init>:()V");
        }
    }

    static class LifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3633113410248163686L;

        LifoWaitQueue() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$WaitQueue.<init>:()V");
        }
    }

    static class WaitQueue
    implements Serializable {
        WaitQueue() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }
    }

    static final class TransferQueue<E>
    extends Transferer<E> {
        volatile transient QNode head;
        volatile transient QNode tail;
        volatile transient QNode cleanMe;
        private static final Unsafe UNSAFE;
        private static final long headOffset;
        private static final long tailOffset;
        private static final long cleanMeOffset;

        TransferQueue() {
            QNode qNode;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.<init>:()V");
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.<init>:(Ljava/lang/Object;Z)V");
            this.head = qNode = new QNode(null, false);
            this.tail = qNode;
        }

        void advanceHead(QNode qNode, QNode qNode2) {
            RuntimeCostAccounter.recordJump();
            if (qNode == this.head) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = UNSAFE.compareAndSwapObject((Object)this, headOffset, (Object)qNode, (Object)qNode2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    qNode.next = qNode;
                }
            }
        }

        void advanceTail(QNode qNode, QNode qNode2) {
            RuntimeCostAccounter.recordJump();
            if (this.tail == qNode) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                UNSAFE.compareAndSwapObject((Object)this, tailOffset, (Object)qNode, (Object)qNode2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean casCleanMe(QNode qNode, QNode qNode2) {
            RuntimeCostAccounter.recordJump();
            if (this.cleanMe != qNode) return false;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = UNSAFE.compareAndSwapObject((Object)this, cleanMeOffset, (Object)qNode, (Object)qNode2);
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }

        @Override
        E transfer(E e, boolean bl, long l) {
            Object object;
            Object object2;
            QNode qNode;
            QNode qNode2;
            boolean bl2;
            QNode qNode3 = null;
            RuntimeCostAccounter.recordJump();
            if (e != null) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            boolean bl3 = bl2;
            while (true) {
                boolean bl4;
                QNode qNode4;
                block26: {
                    Object object3;
                    block25: {
                        qNode4 = this.tail;
                        qNode2 = this.head;
                        RuntimeCostAccounter.recordJump();
                        if (qNode4 == null) continue;
                        RuntimeCostAccounter.recordJump();
                        if (qNode2 == null) {
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (qNode2 == qNode4) break block25;
                        boolean bl5 = qNode4.isData;
                        RuntimeCostAccounter.recordJump();
                        if (bl5 != bl3) break block26;
                    }
                    qNode = qNode4.next;
                    RuntimeCostAccounter.recordJump();
                    if (qNode4 != this.tail) {
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (qNode != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.advanceTail:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
                        this.advanceTail(qNode4, qNode);
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordJump();
                        if (l <= 0L) {
                            return null;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (qNode3 == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.<init>:(Ljava/lang/Object;Z)V");
                        qNode3 = new QNode(e, bl3);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.casNext:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)Z");
                    boolean bl6 = qNode4.casNext(null, qNode3);
                    RuntimeCostAccounter.recordJump();
                    if (!bl6) {
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.advanceTail:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
                    this.advanceTail(qNode4, qNode3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.awaitFulfill:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/lang/Object;ZJ)Ljava/lang/Object;");
                    object2 = this.awaitFulfill(qNode3, e, bl, l);
                    RuntimeCostAccounter.recordJump();
                    if (object2 == qNode3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.clean:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
                        this.clean(qNode4, qNode3);
                        return null;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.isOffList:()Z");
                    boolean bl7 = qNode3.isOffList();
                    RuntimeCostAccounter.recordJump();
                    if (!bl7) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.advanceHead:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
                        this.advanceHead(qNode4, qNode3);
                        RuntimeCostAccounter.recordJump();
                        if (object2 != null) {
                            qNode3.item = qNode3;
                        }
                        qNode3.waiter = null;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 != null) {
                        object3 = object2;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        object3 = e;
                    }
                    return (E)object3;
                }
                qNode = qNode2.next;
                RuntimeCostAccounter.recordJump();
                if (qNode4 != this.tail) continue;
                RuntimeCostAccounter.recordJump();
                if (qNode == null) continue;
                RuntimeCostAccounter.recordJump();
                if (qNode2 != this.head) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                object2 = qNode.item;
                RuntimeCostAccounter.recordJump();
                if (object2 != null) {
                    bl4 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl4 = false;
                }
                RuntimeCostAccounter.recordJump();
                if (bl3 != bl4) {
                    RuntimeCostAccounter.recordJump();
                    if (object2 != qNode) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.casItem:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                        boolean bl8 = qNode.casItem(object2, e);
                        RuntimeCostAccounter.recordJump();
                        if (bl8) break;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.advanceHead:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
                this.advanceHead(qNode2, qNode);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.advanceHead:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
            this.advanceHead(qNode2, qNode);
            Thread thread = qNode.waiter;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
            LockSupport.unpark(thread);
            RuntimeCostAccounter.recordJump();
            if (object2 != null) {
                object = object2;
                RuntimeCostAccounter.recordJump();
            } else {
                object = e;
            }
            return (E)object;
        }

        Object awaitFulfill(QNode qNode, E e, boolean bl, long l) {
            int n;
            long l2;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l2 = System.nanoTime() + l;
                RuntimeCostAccounter.recordJump();
            } else {
                l2 = 0L;
            }
            long l3 = l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            QNode qNode2 = this.head.next;
            RuntimeCostAccounter.recordJump();
            if (qNode2 == qNode) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    n = maxTimedSpins;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = maxUntimedSpins;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                n = 0;
            }
            int n2 = n;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isInterrupted:()Z");
                boolean bl2 = thread.isInterrupted();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.tryCancel:(Ljava/lang/Object;)V");
                    qNode.tryCancel(e);
                }
                Object object = qNode.item;
                RuntimeCostAccounter.recordJump();
                if (object != e) {
                    return object;
                }
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                    l = l3 - System.nanoTime();
                    RuntimeCostAccounter.recordJump();
                    if (l <= 0L) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.tryCancel:(Ljava/lang/Object;)V");
                        qNode.tryCancel(e);
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (n2 > 0) {
                    --n2;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Thread thread2 = qNode.waiter;
                    RuntimeCostAccounter.recordJump();
                    if (thread2 == null) {
                        qNode.waiter = thread;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
                            LockSupport.park(this);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordJump();
                            if (l > 1000L) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                                LockSupport.parkNanos(this, l);
                            }
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        void clean(QNode qNode, QNode qNode2) {
            qNode2.waiter = null;
            while (true) {
                block19: {
                    block16: {
                        QNode qNode3;
                        block18: {
                            block17: {
                                QNode qNode4;
                                block14: {
                                    block15: {
                                        QNode qNode5 = qNode.next;
                                        RuntimeCostAccounter.recordJump();
                                        if (qNode5 != qNode2) break;
                                        QNode qNode6 = this.head;
                                        QNode qNode7 = qNode6.next;
                                        RuntimeCostAccounter.recordJump();
                                        if (qNode7 != null) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.isCancelled:()Z");
                                            boolean bl = qNode7.isCancelled();
                                            RuntimeCostAccounter.recordJump();
                                            if (bl) {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.advanceHead:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
                                                this.advanceHead(qNode6, qNode7);
                                                RuntimeCostAccounter.recordJump();
                                                continue;
                                            }
                                        }
                                        qNode4 = this.tail;
                                        RuntimeCostAccounter.recordJump();
                                        if (qNode4 == qNode6) {
                                            return;
                                        }
                                        QNode qNode8 = qNode4.next;
                                        RuntimeCostAccounter.recordJump();
                                        if (qNode4 != this.tail) {
                                            RuntimeCostAccounter.recordJump();
                                            continue;
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        if (qNode8 != null) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.advanceTail:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)V");
                                            this.advanceTail(qNode4, qNode8);
                                            RuntimeCostAccounter.recordJump();
                                            continue;
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        if (qNode2 == qNode4) break block14;
                                        qNode3 = qNode2.next;
                                        RuntimeCostAccounter.recordJump();
                                        if (qNode3 == qNode2) break block15;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.casNext:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)Z");
                                        boolean bl = qNode.casNext(qNode2, qNode3);
                                        RuntimeCostAccounter.recordJump();
                                        if (!bl) break block14;
                                    }
                                    return;
                                }
                                qNode3 = this.cleanMe;
                                RuntimeCostAccounter.recordJump();
                                if (qNode3 == null) break block16;
                                QNode qNode9 = qNode3.next;
                                RuntimeCostAccounter.recordJump();
                                if (qNode9 == null) break block17;
                                RuntimeCostAccounter.recordJump();
                                if (qNode9 == qNode3) break block17;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.isCancelled:()Z");
                                boolean bl = qNode9.isCancelled();
                                RuntimeCostAccounter.recordJump();
                                if (!bl) break block17;
                                RuntimeCostAccounter.recordJump();
                                if (qNode9 == qNode4) break block18;
                                QNode qNode10 = qNode9.next;
                                RuntimeCostAccounter.recordJump();
                                if (qNode10 == null) break block18;
                                RuntimeCostAccounter.recordJump();
                                if (qNode10 == qNode9) break block18;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue$QNode.casNext:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)Z");
                                boolean bl2 = qNode3.casNext(qNode9, qNode10);
                                RuntimeCostAccounter.recordJump();
                                if (!bl2) break block18;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.casCleanMe:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)Z");
                            this.casCleanMe(qNode3, null);
                        }
                        RuntimeCostAccounter.recordJump();
                        if (qNode3 == qNode) {
                            return;
                        }
                        RuntimeCostAccounter.recordJump();
                        break block19;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferQueue.casCleanMe:(Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;Ljava/util/concurrent/SynchronousQueue$TransferQueue$QNode;)Z");
                    boolean bl = this.casCleanMe(null, qNode);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return;
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        static {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
                UNSAFE = Unsafe.getUnsafe();
                Class<TransferQueue> clazz = TransferQueue.class;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field = clazz.getDeclaredField("head");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                headOffset = UNSAFE.objectFieldOffset(field);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field2 = clazz.getDeclaredField("tail");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                tailOffset = UNSAFE.objectFieldOffset(field2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field3 = clazz.getDeclaredField("cleanMe");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                cleanMeOffset = UNSAFE.objectFieldOffset(field3);
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
                Error error = new Error(exception);
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
            RuntimeCostAccounter.recordJump();
        }

        static final class QNode {
            volatile QNode next;
            volatile Object item;
            volatile Thread waiter;
            final boolean isData;
            private static final Unsafe UNSAFE;
            private static final long itemOffset;
            private static final long nextOffset;

            QNode(Object object, boolean bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.item = object;
                this.isData = bl;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            boolean casNext(QNode qNode, QNode qNode2) {
                RuntimeCostAccounter.recordJump();
                if (this.next != qNode) return false;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = UNSAFE.compareAndSwapObject((Object)this, nextOffset, (Object)qNode, (Object)qNode2);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
                boolean bl2 = true;
                RuntimeCostAccounter.recordJump();
                return bl2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            boolean casItem(Object object, Object object2) {
                RuntimeCostAccounter.recordJump();
                if (this.item != object) return false;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = UNSAFE.compareAndSwapObject((Object)this, itemOffset, object, object2);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
                boolean bl2 = true;
                RuntimeCostAccounter.recordJump();
                return bl2;
            }

            void tryCancel(Object object) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                UNSAFE.compareAndSwapObject((Object)this, itemOffset, object, (Object)this);
            }

            boolean isCancelled() {
                boolean bl;
                RuntimeCostAccounter.recordJump();
                if (this.item == this) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                return bl;
            }

            boolean isOffList() {
                boolean bl;
                RuntimeCostAccounter.recordJump();
                if (this.next == this) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                return bl;
            }

            static {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
                    UNSAFE = Unsafe.getUnsafe();
                    Class<QNode> clazz = QNode.class;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                    Field field = clazz.getDeclaredField("item");
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                    itemOffset = UNSAFE.objectFieldOffset(field);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                    Field field2 = clazz.getDeclaredField("next");
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                    nextOffset = UNSAFE.objectFieldOffset(field2);
                }
                catch (Exception exception) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
                    Error error = new Error(exception);
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    static final class TransferStack<E>
    extends Transferer<E> {
        static final int REQUEST = 0;
        static final int DATA = 1;
        static final int FULFILLING = 2;
        volatile SNode head;
        private static final Unsafe UNSAFE;
        private static final long headOffset;

        TransferStack() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$Transferer.<init>:()V");
        }

        static boolean isFulfilling(int n) {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if ((n & 2) != 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean casHead(SNode sNode, SNode sNode2) {
            RuntimeCostAccounter.recordJump();
            if (sNode != this.head) return false;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
            boolean bl = UNSAFE.compareAndSwapObject((Object)this, headOffset, (Object)sNode, (Object)sNode2);
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }

        static SNode snode(SNode sNode, Object object, SNode sNode2, int n) {
            RuntimeCostAccounter.recordJump();
            if (sNode == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.<init>:(Ljava/lang/Object;)V");
                sNode = new SNode(object);
            }
            sNode.mode = n;
            sNode.next = sNode2;
            return sNode;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        E transfer(E var1_1, boolean var2_2, long var3_3) {
            var5_4 = null;
            RuntimeCostAccounter.recordJump();
            if (var1_1 == null) {
                v0 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                v0 = 1;
            }
            var6_5 = v0;
            while (true) {
                block25: {
                    block27: {
                        block26: {
                            var7_6 = this.head;
                            RuntimeCostAccounter.recordJump();
                            if (var7_6 == null) break block26;
                            v1 = var7_6.mode;
                            RuntimeCostAccounter.recordJump();
                            if (v1 != var6_5) break block27;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (!var2_2) ** GOTO lbl34
                        RuntimeCostAccounter.recordJump();
                        if (var3_3 > 0L) ** GOTO lbl34
                        RuntimeCostAccounter.recordJump();
                        if (var7_6 == null) ** GOTO lbl-1000
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.isCancelled:()Z");
                        v2 = var7_6.isCancelled();
                        RuntimeCostAccounter.recordJump();
                        if (v2) {
                            v3 = var7_6.next;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                            this.casHead(var7_6, v3);
                            RuntimeCostAccounter.recordJump();
                        } else lbl-1000:
                        // 2 sources

                        {
                            return null;
lbl34:
                            // 2 sources

                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.snode:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/lang/Object;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;I)Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;");
                            var5_4 = TransferStack.snode(var5_4, var1_1, var7_6, var6_5);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                            v4 = this.casHead(var7_6, var5_4);
                            RuntimeCostAccounter.recordJump();
                            if (v4) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.awaitFulfill:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;ZJ)Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;");
                                var8_7 = this.awaitFulfill(var5_4, var2_2, var3_3);
                                RuntimeCostAccounter.recordJump();
                                if (var8_7 == var5_4) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.clean:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)V");
                                    this.clean(var5_4);
                                    return null;
                                }
                                var7_6 = this.head;
                                RuntimeCostAccounter.recordJump();
                                if (var7_6 != null) {
                                    v5 = var7_6.next;
                                    RuntimeCostAccounter.recordJump();
                                    if (v5 == var5_4) {
                                        v6 = var5_4.next;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                                        this.casHead(var7_6, v6);
                                    }
                                }
                                RuntimeCostAccounter.recordJump();
                                if (var6_5 == 0) {
                                    v7 = var8_7.item;
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    v7 = var5_4.item;
                                }
                                return (E)v7;
                            }
                        }
                        break block25;
                    }
                    v8 = var7_6.mode;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.isFulfilling:(I)Z");
                    v9 = TransferStack.isFulfilling(v8);
                    RuntimeCostAccounter.recordJump();
                    if (!v9) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.isCancelled:()Z");
                        v10 = var7_6.isCancelled();
                        RuntimeCostAccounter.recordJump();
                        if (v10) {
                            v11 = var7_6.next;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                            this.casHead(var7_6, v11);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.snode:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/lang/Object;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;I)Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;");
                            var5_4 = TransferStack.snode(var5_4, var1_1, var7_6, 2 | var6_5);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                            v12 = this.casHead(var7_6, var5_4);
                            RuntimeCostAccounter.recordJump();
                            if (v12) {
                                while (true) {
                                    var8_7 = var5_4.next;
                                    RuntimeCostAccounter.recordJump();
                                    if (var8_7 == null) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                                        this.casHead(var5_4, null);
                                        var5_4 = null;
                                        RuntimeCostAccounter.recordJump();
                                        break;
                                    }
                                    var9_8 = var8_7.next;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.tryMatch:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                                    v13 = var8_7.tryMatch(var5_4);
                                    RuntimeCostAccounter.recordJump();
                                    if (v13) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                                        this.casHead(var5_4, var9_8);
                                        RuntimeCostAccounter.recordJump();
                                        if (var6_5 == 0) {
                                            v14 = var8_7.item;
                                            RuntimeCostAccounter.recordJump();
                                        } else {
                                            v14 = var5_4.item;
                                        }
                                        return (E)v14;
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.casNext:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                                    var5_4.casNext(var8_7, var9_8);
                                    RuntimeCostAccounter.recordJump();
                                }
                            }
                        }
                    } else {
                        var8_7 = var7_6.next;
                        RuntimeCostAccounter.recordJump();
                        if (var8_7 == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                            this.casHead(var7_6, null);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            var9_8 = var8_7.next;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.tryMatch:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                            v15 = var8_7.tryMatch(var7_6);
                            RuntimeCostAccounter.recordJump();
                            if (v15) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                                this.casHead(var7_6, var9_8);
                                RuntimeCostAccounter.recordJump();
                            } else {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.casNext:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                                var7_6.casNext(var8_7, var9_8);
                            }
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        SNode awaitFulfill(SNode sNode, boolean bl, long l) {
            int n;
            long l2;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l2 = System.nanoTime() + l;
                RuntimeCostAccounter.recordJump();
            } else {
                l2 = 0L;
            }
            long l3 = l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.shouldSpin:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
            boolean bl2 = this.shouldSpin(sNode);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    n = maxTimedSpins;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = maxUntimedSpins;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                n = 0;
            }
            int n2 = n;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isInterrupted:()Z");
                boolean bl3 = thread.isInterrupted();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.tryCancel:()V");
                    sNode.tryCancel();
                }
                SNode sNode2 = sNode.match;
                RuntimeCostAccounter.recordJump();
                if (sNode2 != null) {
                    return sNode2;
                }
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                    l = l3 - System.nanoTime();
                    RuntimeCostAccounter.recordJump();
                    if (l <= 0L) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.tryCancel:()V");
                        sNode.tryCancel();
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (n2 > 0) {
                    int n3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.shouldSpin:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                    boolean bl4 = this.shouldSpin(sNode);
                    RuntimeCostAccounter.recordJump();
                    if (bl4) {
                        n3 = n2 - 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n3 = 0;
                    }
                    n2 = n3;
                    RuntimeCostAccounter.recordJump();
                } else {
                    Thread thread2 = sNode.waiter;
                    RuntimeCostAccounter.recordJump();
                    if (thread2 == null) {
                        sNode.waiter = thread;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
                            LockSupport.park(this);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordJump();
                            if (l > 1000L) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                                LockSupport.parkNanos(this, l);
                            }
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean shouldSpin(SNode sNode) {
            SNode sNode2 = this.head;
            RuntimeCostAccounter.recordJump();
            if (sNode2 != sNode) {
                RuntimeCostAccounter.recordJump();
                if (sNode2 != null) {
                    int n = sNode2.mode;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.isFulfilling:(I)Z");
                    boolean bl = TransferStack.isFulfilling(n);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) return false;
                }
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        void clean(SNode var1_1) {
            var1_1.item = null;
            var1_1.waiter = null;
            var2_2 = var1_1.next;
            RuntimeCostAccounter.recordJump();
            if (var2_2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.isCancelled:()Z");
                v0 = var2_2.isCancelled();
                RuntimeCostAccounter.recordJump();
                if (v0) {
                    var2_2 = var2_2.next;
                }
            }
            while (true) {
                var3_3 = this.head;
                RuntimeCostAccounter.recordJump();
                if (var3_3 == null) break;
                RuntimeCostAccounter.recordJump();
                if (var3_3 == var2_2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.isCancelled:()Z");
                v1 = var3_3.isCancelled();
                RuntimeCostAccounter.recordJump();
                if (!v1) break;
                v2 = var3_3.next;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack.casHead:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                this.casHead(var3_3, v2);
                RuntimeCostAccounter.recordJump();
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var3_3 == null) break;
                RuntimeCostAccounter.recordJump();
                if (var3_3 == var2_2) break;
                var4_4 = var3_3.next;
                RuntimeCostAccounter.recordJump();
                if (var4_4 == null) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.isCancelled:()Z");
                v3 = var4_4.isCancelled();
                RuntimeCostAccounter.recordJump();
                if (v3) {
                    v4 = var4_4.next;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/SynchronousQueue$TransferStack$SNode.casNext:(Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;Ljava/util/concurrent/SynchronousQueue$TransferStack$SNode;)Z");
                    var3_3.casNext(var4_4, v4);
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    var3_3 = var4_4;
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        static {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
                UNSAFE = Unsafe.getUnsafe();
                Class<TransferStack> clazz = TransferStack.class;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field = clazz.getDeclaredField("head");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                headOffset = UNSAFE.objectFieldOffset(field);
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
                Error error = new Error(exception);
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
            RuntimeCostAccounter.recordJump();
        }

        static final class SNode {
            volatile SNode next;
            volatile SNode match;
            volatile Thread waiter;
            Object item;
            int mode;
            private static final Unsafe UNSAFE;
            private static final long matchOffset;
            private static final long nextOffset;

            SNode(Object object) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.item = object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            boolean casNext(SNode sNode, SNode sNode2) {
                RuntimeCostAccounter.recordJump();
                if (sNode != this.next) return false;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = UNSAFE.compareAndSwapObject((Object)this, nextOffset, (Object)sNode, (Object)sNode2);
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
                boolean bl2 = true;
                RuntimeCostAccounter.recordJump();
                return bl2;
            }

            boolean tryMatch(SNode sNode) {
                boolean bl;
                RuntimeCostAccounter.recordJump();
                if (this.match == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                    boolean bl2 = UNSAFE.compareAndSwapObject((Object)this, matchOffset, null, (Object)sNode);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        Thread thread = this.waiter;
                        RuntimeCostAccounter.recordJump();
                        if (thread != null) {
                            this.waiter = null;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
                            LockSupport.unpark(thread);
                        }
                        return true;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (this.match == sNode) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                return bl;
            }

            void tryCancel() {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
                UNSAFE.compareAndSwapObject((Object)this, matchOffset, null, (Object)this);
            }

            boolean isCancelled() {
                boolean bl;
                RuntimeCostAccounter.recordJump();
                if (this.match == this) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                return bl;
            }

            static {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
                    UNSAFE = Unsafe.getUnsafe();
                    Class<SNode> clazz = SNode.class;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                    Field field = clazz.getDeclaredField("match");
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                    matchOffset = UNSAFE.objectFieldOffset(field);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                    Field field2 = clazz.getDeclaredField("next");
                    RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                    nextOffset = UNSAFE.objectFieldOffset(field2);
                }
                catch (Exception exception) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
                    Error error = new Error(exception);
                    RuntimeCostAccounter.recordThrow();
                    throw error;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    static abstract class Transferer<E> {
        Transferer() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        abstract E transfer(E var1, boolean var2, long var3);
    }
}

