/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.Collection;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.concurrent.BlockingQueue;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.atomic.AtomicInteger;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.ReentrantLock;
import sandbox.java.util.function.Consumer;

public class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count;
    transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock;
    private final Condition notEmpty;
    private final ReentrantLock putLock;
    private final Condition notFull;

    private void signalNotEmpty() {
        ReentrantLock reentrantLock = this.takeLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
            this.notEmpty.signal();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    private void signalNotFull() {
        ReentrantLock reentrantLock = this.putLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
            this.notFull.signal();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    private void enqueue(Node<E> node) {
        this.last.next = node;
        this.last = this.last.next;
    }

    private E dequeue() {
        Node<E> node = this.head;
        Node node2 = node.next;
        node.next = node;
        this.head = node2;
        Object e = node2.item;
        node2.item = null;
        return e;
    }

    void fullyLock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        this.putLock.lock();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        this.takeLock.lock();
    }

    void fullyUnlock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        this.takeLock.unlock();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        this.putLock.unlock();
    }

    public LinkedBlockingQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.<init>:(I)V");
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:()V");
        this.count = new AtomicInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        this.takeLock = new ReentrantLock();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.notEmpty = this.takeLock.newCondition();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        this.putLock = new ReentrantLock();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.newCondition:()Ljava/util/concurrent/locks/Condition;");
        this.notFull = this.putLock.newCondition();
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.capacity = n;
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$Node.<init>:(Ljava/lang/Object;)V");
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingQueue(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.<init>:(I)V");
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.putLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            int n = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<E> iterator = collection.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                E e = iterator.next();
                RuntimeCostAccounter.recordJump();
                if (e == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n == this.capacity) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                    IllegalStateException illegalStateException = new IllegalStateException("Queue full");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue$Node");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$Node.<init>:(Ljava/lang/Object;)V");
                Node<E> node = new Node<E>(e);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.enqueue:(Ljava/util/concurrent/LinkedBlockingQueue$Node;)V");
                super.enqueue(node);
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.set:(I)V");
            this.count.set(n);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public int size() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        int n = -1;
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$Node.<init>:(Ljava/lang/Object;)V");
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                int n2 = atomicInteger.get();
                RuntimeCostAccounter.recordJump();
                if (n2 != this.capacity) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                this.notFull.await();
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.enqueue:(Ljava/util/concurrent/LinkedBlockingQueue$Node;)V");
            this.enqueue(node);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndIncrement:()I");
            n = atomicInteger.getAndIncrement();
            RuntimeCostAccounter.recordJump();
            if (n + 1 < this.capacity) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                this.notFull.signal();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.signalNotEmpty:()V");
            this.signalNotEmpty();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        boolean bl;
        ReentrantLock reentrantLock;
        int n;
        block8: {
            RuntimeCostAccounter.recordJump();
            if (e == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            AtomicInteger atomicInteger = this.count;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n2 = atomicInteger.get();
            RuntimeCostAccounter.recordJump();
            if (n2 == this.capacity) {
                return false;
            }
            n = -1;
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue$Node");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$Node.<init>:(Ljava/lang/Object;)V");
            Node<E> node = new Node<E>(e);
            reentrantLock = this.putLock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                int n3 = atomicInteger.get();
                RuntimeCostAccounter.recordJump();
                if (n3 >= this.capacity) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.enqueue:(Ljava/util/concurrent/LinkedBlockingQueue$Node;)V");
                this.enqueue(node);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndIncrement:()I");
                n = atomicInteger.getAndIncrement();
                RuntimeCostAccounter.recordJump();
                if (n + 1 < this.capacity) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                    this.notFull.signal();
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.signalNotEmpty:()V");
            this.signalNotEmpty();
        }
        RuntimeCostAccounter.recordJump();
        if (n >= 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E e;
        int n = -1;
        AtomicInteger atomicInteger = this.count;
        ReentrantLock reentrantLock = this.takeLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lockInterruptibly:()V");
        reentrantLock.lockInterruptibly();
        try {
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                int n2 = atomicInteger.get();
                RuntimeCostAccounter.recordJump();
                if (n2 != 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.await:()V");
                this.notEmpty.await();
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.dequeue:()Ljava/lang/Object;");
            e = this.dequeue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndDecrement:()I");
            n = atomicInteger.getAndDecrement();
            RuntimeCostAccounter.recordJump();
            if (n > 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                this.notEmpty.signal();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (n == this.capacity) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.signalNotFull:()V");
            this.signalNotFull();
        }
        return e;
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock reentrantLock;
        int n;
        E e;
        block5: {
            AtomicInteger atomicInteger = this.count;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n2 = atomicInteger.get();
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return null;
            }
            e = null;
            n = -1;
            reentrantLock = this.takeLock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
                int n3 = atomicInteger.get();
                RuntimeCostAccounter.recordJump();
                if (n3 <= 0) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.dequeue:()Ljava/lang/Object;");
                e = this.dequeue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndDecrement:()I");
                n = atomicInteger.getAndDecrement();
                RuntimeCostAccounter.recordJump();
                if (n > 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                    this.notEmpty.signal();
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (n == this.capacity) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.signalNotFull:()V");
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Node node;
        ReentrantLock reentrantLock;
        block4: {
            E e;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n = this.count.get();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                return null;
            }
            reentrantLock = this.takeLock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            try {
                node = this.head.next;
                RuntimeCostAccounter.recordJump();
                if (node != null) break block4;
                e = null;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            return e;
        }
        Object e = node.item;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        return e;
    }

    void unlink(Node<E> node, Node<E> node2) {
        node.item = null;
        node2.next = node.next;
        RuntimeCostAccounter.recordJump();
        if (this.last == node) {
            this.last = node2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndDecrement:()I");
        int n = this.count.getAndDecrement();
        RuntimeCostAccounter.recordJump();
        if (n == this.capacity) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
            this.notFull.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object object) {
        boolean bl;
        block6: {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (object == null) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
            this.fullyLock();
            try {
                Node<E> node = this.head;
                Node node2 = node.next;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (node2 == null) break;
                    Object e = node2.item;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = object.equals(e);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.unlink:(Ljava/util/concurrent/LinkedBlockingQueue$Node;Ljava/util/concurrent/LinkedBlockingQueue$Node;)V");
                        this.unlink(node2, node);
                        bl = true;
                        break block6;
                    }
                    node = node2;
                    node2 = node2.next;
                    RuntimeCostAccounter.recordJump();
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                this.fullyUnlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
        this.fullyUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object object) {
        boolean bl;
        block6: {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (object == null) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
            this.fullyLock();
            try {
                Node node = this.head.next;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (node == null) break;
                    Object e = node.item;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = object.equals(e);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        bl = true;
                        break block6;
                    }
                    node = node.next;
                    RuntimeCostAccounter.recordJump();
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                this.fullyUnlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
        this.fullyUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
        this.fullyLock();
        try {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n2 = n = this.count.get();
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            object = this.head.next;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (object == null) break;
                objectArray[n3++] = object.item;
                object = object.next;
                RuntimeCostAccounter.recordJump();
            }
            object = objectArray;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
        this.fullyUnlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        Object object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
        this.fullyLock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n = this.count.get();
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
                Class<?> clazz2 = clazz.getComponentType();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
                objectArray = (Object[])Array.newInstance(clazz2, n);
            }
            int n3 = 0;
            object = this.head.next;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (object == null) break;
                objectArray[n3++] = object.item;
                object = object.next;
                RuntimeCostAccounter.recordJump();
            }
            int n4 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n4 > n3) {
                objectArray[n3] = null;
            }
            object = objectArray;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
        this.fullyUnlock();
        return object;
    }

    @Override
    public String toString() {
        String string;
        StringBuilder stringBuilder;
        Node node;
        block7: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
            this.fullyLock();
            node = this.head.next;
            RuntimeCostAccounter.recordJump();
            if (node != null) break block7;
            String string2 = "[]";
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            return string2;
        }
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append('[');
            while (true) {
                String string3;
                Object e = node.item;
                RuntimeCostAccounter.recordJump();
                if (e == this) {
                    string3 = "(this Collection)";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string3 = e;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                stringBuilder.append((Object)string3);
                node = node.next;
                RuntimeCostAccounter.recordJump();
                if (node != null) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(']');
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder2.toString();
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                this.fullyUnlock();
                return string;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder.append(',');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder3.append(' ');
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    @Override
    public void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
        this.fullyLock();
        try {
            Node<E> node = this.head;
            while (true) {
                Node node2 = node.next;
                RuntimeCostAccounter.recordJump();
                if (node2 == null) break;
                node.next = node;
                node2.item = null;
                node = node2;
                RuntimeCostAccounter.recordJump();
            }
            this.head = this.last;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndSet:(I)I");
            int n = this.count.getAndSet(0);
            RuntimeCostAccounter.recordJump();
            if (n == this.capacity) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/Condition.signal:()V");
                this.notFull.signal();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
        this.fullyUnlock();
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.drainTo:(Ljava/util/Collection;I)I");
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        int n2;
        int n3;
        Node<E> node;
        ReentrantLock reentrantLock;
        boolean bl;
        block16: {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (collection == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordJump();
            if (collection == this) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (n <= 0) {
                return 0;
            }
            bl = false;
            reentrantLock = this.takeLock;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
            reentrantLock.lock();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.get:()I");
            int n4 = this.count.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n5 = Math.min(n, n4);
            node = this.head;
            n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n5) break;
                Node node2 = node.next;
                Object e = node2.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.add:(Ljava/lang/Object;)Z");
                collection.add(e);
                node2.item = null;
                node.next = node;
                node = node2;
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            n2 = n5;
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break block16;
            this.head = node;
            int n6 = -n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndAdd:(I)I");
            int n7 = this.count.getAndAdd(n6);
            RuntimeCostAccounter.recordJump();
            if (n7 == this.capacity) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.signalNotFull:()V");
            this.signalNotFull();
        }
        return n2;
        {
            catch (Throwable throwable) {
                try {
                    RuntimeCostAccounter.recordJump();
                    if (n3 > 0) {
                        boolean bl3;
                        this.head = node;
                        int n8 = -n3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndAdd:(I)I");
                        int n9 = this.count.getAndAdd(n8);
                        RuntimeCostAccounter.recordJump();
                        if (n9 == this.capacity) {
                            bl3 = true;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            bl3 = false;
                        }
                        bl = bl3;
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                    reentrantLock.unlock();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.signalNotFull:()V");
                        this.signalNotFull();
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$Itr.<init>:(Ljava/util/concurrent/LinkedBlockingQueue;)V");
        return new Itr();
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue$LBQSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$LBQSpliterator.<init>:(Ljava/util/concurrent/LinkedBlockingQueue;)V");
        return new LBQSpliterator(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
        this.fullyLock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
            objectOutputStream.defaultWriteObject();
            Node node = this.head.next;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Object e = node.item;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
                objectOutputStream.writeObject(e);
                node = node.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(null);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            this.fullyUnlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
        this.fullyUnlock();
        RuntimeCostAccounter.recordJump();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.set:(I)V");
        this.count.set(0);
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/LinkedBlockingQueue$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$Node.<init>:(Ljava/lang/Object;)V");
        this.head = new Node<Object>(null);
        this.last = this.head;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            Object object = objectInputStream.readObject();
            RuntimeCostAccounter.recordJump();
            if (object == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.add:(Ljava/lang/Object;)Z");
            this.add(object);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class LBQSpliterator<E>
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        final LinkedBlockingQueue<E> queue;
        Node<E> current;
        int batch;
        boolean exhausted;
        long est;

        LBQSpliterator(LinkedBlockingQueue<E> linkedBlockingQueue) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.queue = linkedBlockingQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.size:()I");
            this.est = linkedBlockingQueue.size();
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<E> trySplit() {
            block18: {
                Node<E> node;
                int n;
                LinkedBlockingQueue<E> linkedBlockingQueue;
                block19: {
                    int n2;
                    linkedBlockingQueue = this.queue;
                    int n3 = this.batch;
                    RuntimeCostAccounter.recordJump();
                    if (n3 <= 0) {
                        n2 = 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (n3 >= 0x2000000) {
                            n2 = 0x2000000;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            n2 = n3 + 1;
                        }
                    }
                    n = n2;
                    RuntimeCostAccounter.recordJump();
                    if (this.exhausted) break block18;
                    node = this.current;
                    RuntimeCostAccounter.recordJump();
                    if (node != null) break block19;
                    node = linkedBlockingQueue.head.next;
                    RuntimeCostAccounter.recordJump();
                    if (node == null) break block18;
                }
                Node node2 = node.next;
                RuntimeCostAccounter.recordJump();
                if (node2 != null) {
                    Node<E> node3;
                    int n4;
                    Object[] objectArray;
                    block17: {
                        int n5 = n;
                        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)8);
                        objectArray = new Object[n5];
                        n4 = 0;
                        node3 = this.current;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
                        linkedBlockingQueue.fullyLock();
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (node3 == null) {
                                node3 = linkedBlockingQueue.head.next;
                                RuntimeCostAccounter.recordJump();
                                if (node3 == null) break block17;
                            }
                            do {
                                objectArray[n4] = node3.item;
                                RuntimeCostAccounter.recordJump();
                                if (objectArray[n4] != null) {
                                    ++n4;
                                }
                                node3 = node3.next;
                                RuntimeCostAccounter.recordJump();
                                if (node3 == null) break;
                                RuntimeCostAccounter.recordJump();
                            } while (n4 < n);
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                            linkedBlockingQueue.fullyUnlock();
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                    linkedBlockingQueue.fullyUnlock();
                    RuntimeCostAccounter.recordJump();
                    this.current = node3;
                    RuntimeCostAccounter.recordJump();
                    if (this.current == null) {
                        this.est = 0L;
                        this.exhausted = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if ((this.est -= (long)n4) < 0L) {
                            this.est = 0L;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n4 > 0) {
                        this.batch = n4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliterator:([Ljava/lang/Object;III)Ljava/util/Spliterator;");
                        return Spliterators.spliterator(objectArray, 0, n4, 4368);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            block7: {
                RuntimeCostAccounter.recordJump();
                if (consumer == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                LinkedBlockingQueue<E> linkedBlockingQueue = this.queue;
                RuntimeCostAccounter.recordJump();
                if (this.exhausted) break block7;
                this.exhausted = true;
                Node<E> node = this.current;
                do {
                    block8: {
                        Object t;
                        block6: {
                            t = null;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
                            linkedBlockingQueue.fullyLock();
                            try {
                                RuntimeCostAccounter.recordJump();
                                if (node == null) {
                                    node = linkedBlockingQueue.head.next;
                                }
                                do {
                                    RuntimeCostAccounter.recordJump();
                                    if (node == null) break block6;
                                    t = node.item;
                                    node = node.next;
                                    RuntimeCostAccounter.recordJump();
                                } while (t == null);
                                RuntimeCostAccounter.recordJump();
                            }
                            catch (Throwable throwable) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                                linkedBlockingQueue.fullyUnlock();
                                RuntimeCostAccounter.recordThrow();
                                throw throwable;
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                        linkedBlockingQueue.fullyUnlock();
                        RuntimeCostAccounter.recordJump();
                        RuntimeCostAccounter.recordJump();
                        if (t == null) break block8;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                        consumer.accept(t);
                    }
                    RuntimeCostAccounter.recordJump();
                } while (node != null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            block7: {
                Object t;
                block8: {
                    LinkedBlockingQueue<E> linkedBlockingQueue;
                    block6: {
                        RuntimeCostAccounter.recordJump();
                        if (consumer == null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                            NullPointerException nullPointerException = new NullPointerException();
                            RuntimeCostAccounter.recordThrow();
                            throw nullPointerException;
                        }
                        linkedBlockingQueue = this.queue;
                        RuntimeCostAccounter.recordJump();
                        if (this.exhausted) break block7;
                        t = null;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
                        linkedBlockingQueue.fullyLock();
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (this.current == null) {
                                this.current = linkedBlockingQueue.head.next;
                            }
                            do {
                                RuntimeCostAccounter.recordJump();
                                if (this.current == null) break block6;
                                t = this.current.item;
                                this.current = this.current.next;
                                RuntimeCostAccounter.recordJump();
                            } while (t == null);
                            RuntimeCostAccounter.recordJump();
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                            linkedBlockingQueue.fullyUnlock();
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                    linkedBlockingQueue.fullyUnlock();
                    RuntimeCostAccounter.recordJump();
                    RuntimeCostAccounter.recordJump();
                    if (this.current != null) break block8;
                    this.exhausted = true;
                }
                RuntimeCostAccounter.recordJump();
                if (t != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(t);
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;

        Itr() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
            LinkedBlockingQueue.this.fullyLock();
            try {
                this.current = LinkedBlockingQueue.this.head.next;
                RuntimeCostAccounter.recordJump();
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                LinkedBlockingQueue.this.fullyUnlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            LinkedBlockingQueue.this.fullyUnlock();
            RuntimeCostAccounter.recordJump();
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.current != null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        private Node<E> nextNode(Node<E> node) {
            while (true) {
                Node node2;
                block6: {
                    block5: {
                        node2 = node.next;
                        RuntimeCostAccounter.recordJump();
                        if (node2 == node) {
                            return LinkedBlockingQueue.this.head.next;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (node2 == null) break block5;
                        Object e = node2.item;
                        RuntimeCostAccounter.recordJump();
                        if (e == null) break block6;
                    }
                    return node2;
                }
                node = node2;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public E next() {
            Object e;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
            LinkedBlockingQueue.this.fullyLock();
            try {
                Object v1;
                RuntimeCostAccounter.recordJump();
                if (this.current == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
                Object e2 = this.currentElement;
                this.lastRet = this.current;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue$Itr.nextNode:(Ljava/util/concurrent/LinkedBlockingQueue$Node;)Ljava/util/concurrent/LinkedBlockingQueue$Node;");
                this.current = this.nextNode(this.current);
                RuntimeCostAccounter.recordJump();
                if (this.current == null) {
                    v1 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v1 = this.current.item;
                }
                this.currentElement = v1;
                e = e2;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                LinkedBlockingQueue.this.fullyUnlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            LinkedBlockingQueue.this.fullyUnlock();
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyLock:()V");
            LinkedBlockingQueue.this.fullyLock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node node2 = LinkedBlockingQueue.this.head;
                Node node3 = node2.next;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (node3 == null) break;
                    RuntimeCostAccounter.recordJump();
                    if (node3 == node) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.unlink:(Ljava/util/concurrent/LinkedBlockingQueue$Node;Ljava/util/concurrent/LinkedBlockingQueue$Node;)V");
                        LinkedBlockingQueue.this.unlink(node3, node2);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    node2 = node3;
                    node3 = node3.next;
                    RuntimeCostAccounter.recordJump();
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
                LinkedBlockingQueue.this.fullyUnlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/LinkedBlockingQueue.fullyUnlock:()V");
            LinkedBlockingQueue.this.fullyUnlock();
            RuntimeCostAccounter.recordJump();
        }
    }

    static class Node<E> {
        E item;
        Node<E> next;

        Node(E e) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.item = e;
        }
    }
}

