/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.Collection;
import sandbox.java.util.List;
import sandbox.java.util.RandomAccess;
import sandbox.java.util.concurrent.Callable;
import sandbox.java.util.concurrent.CancellationException;
import sandbox.java.util.concurrent.CountedCompleter;
import sandbox.java.util.concurrent.ExecutionException;
import sandbox.java.util.concurrent.ForkJoinPool;
import sandbox.java.util.concurrent.ForkJoinWorkerThread;
import sandbox.java.util.concurrent.Future;
import sandbox.java.util.concurrent.RunnableFuture;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.TimeoutException;
import sandbox.java.util.concurrent.locks.ReentrantLock;
import sandbox.sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    static final int DONE_MASK = -268435456;
    static final int NORMAL = -268435456;
    static final int CANCELLED = -1073741824;
    static final int EXCEPTIONAL = Integer.MIN_VALUE;
    static final int SIGNAL = 65536;
    static final int SMASK = 65535;
    private static final ExceptionNode[] exceptionTable;
    private static final ReentrantLock exceptionTableLock;
    private static final ReferenceQueue<Object> exceptionTableRefQueue;
    private static final int EXCEPTION_MAP_CAPACITY = 32;
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe U;
    private static final long STATUS;

    public ForkJoinTask() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setCompletion(int n) {
        int n2;
        boolean bl;
        do {
            n2 = this.status;
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                return n2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            bl = U.compareAndSwapInt((Object)this, STATUS, n2, n2 | n);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        RuntimeCostAccounter.recordJump();
        if (n2 >>> 16 != 0) {
            ForkJoinTask forkJoinTask = this;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
                this.notifyAll();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    final int doExec() {
        int n;
        block3: {
            boolean bl;
            n = this.status;
            RuntimeCostAccounter.recordJump();
            if (n < 0) break block3;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.exec:()Z");
                bl = this.exec();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setExceptionalCompletion:(Ljava/lang/Throwable;)I");
                return this.setExceptionalCompletion(throwable);
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setCompletion:(I)I");
                n = this.setCompletion(-268435456);
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean trySetSignal() {
        int n = this.status;
        RuntimeCostAccounter.recordJump();
        if (n < 0) return false;
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        boolean bl = U.compareAndSwapInt((Object)this, STATUS, n, n | 0x10000);
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalAwaitDone() {
        int n;
        block13: {
            ForkJoinPool forkJoinPool = ForkJoinPool.common;
            n = this.status;
            RuntimeCostAccounter.recordJump();
            if (n < 0) break block13;
            RuntimeCostAccounter.recordJump();
            if (forkJoinPool != null) {
                boolean bl = this instanceof CountedCompleter;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    CountedCompleter countedCompleter = (CountedCompleter)this;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalHelpComplete:(Ljava/util/concurrent/CountedCompleter;I)I");
                    n = forkJoinPool.externalHelpComplete(countedCompleter, Integer.MAX_VALUE);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryExternalUnpush:(Ljava/util/concurrent/ForkJoinTask;)Z");
                    boolean bl2 = forkJoinPool.tryExternalUnpush(this);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                        n = this.doExec();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n < 0) break block13;
            n = this.status;
            RuntimeCostAccounter.recordJump();
            if (n < 0) break block13;
            boolean bl = false;
            do {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                boolean bl3 = U.compareAndSwapInt((Object)this, STATUS, n, n | 0x10000);
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    block12: {
                        try {
                            RuntimeCostAccounter.recordJump();
                            if (this.status >= 0) {
                                try {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:()V");
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    bl = true;
                                    RuntimeCostAccounter.recordJump();
                                    break block12;
                                }
                                RuntimeCostAccounter.recordJump();
                                break block12;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
                            this.notifyAll();
                        }
                        catch (Throwable throwable) {
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
                n = this.status;
                RuntimeCostAccounter.recordJump();
            } while (n >= 0);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
                thread.interrupt();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalInterruptibleAwaitDone() throws InterruptedException {
        ForkJoinPool forkJoinPool = ForkJoinPool.common;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
        int n = this.status;
        RuntimeCostAccounter.recordJump();
        if (n >= 0) {
            RuntimeCostAccounter.recordJump();
            if (forkJoinPool != null) {
                boolean bl2 = this instanceof CountedCompleter;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    CountedCompleter countedCompleter = (CountedCompleter)this;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalHelpComplete:(Ljava/util/concurrent/CountedCompleter;I)I");
                    forkJoinPool.externalHelpComplete(countedCompleter, Integer.MAX_VALUE);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryExternalUnpush:(Ljava/util/concurrent/ForkJoinTask;)Z");
                    boolean bl3 = forkJoinPool.tryExternalUnpush(this);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                        this.doExec();
                    }
                }
            }
        }
        while (true) {
            block10: {
                n = this.status;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                boolean bl4 = U.compareAndSwapInt((Object)this, STATUS, n, n | 0x10000);
                RuntimeCostAccounter.recordJump();
                if (!bl4) continue;
                try {
                    RuntimeCostAccounter.recordJump();
                    if (this.status >= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:()V");
                        this.wait();
                        RuntimeCostAccounter.recordJump();
                        break block10;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
                    this.notifyAll();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int doJoin() {
        int n;
        int n2 = this.status;
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            n = n2;
            RuntimeCostAccounter.recordJump();
            return n;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.externalAwaitDone:()I");
            n = this.externalAwaitDone();
            return n;
        }
        ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
        ForkJoinPool.WorkQueue workQueue = forkJoinWorkerThread.workQueue;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.tryUnpush:(Ljava/util/concurrent/ForkJoinTask;)Z");
        boolean bl2 = workQueue.tryUnpush(this);
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
            n2 = this.doExec();
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) {
                n = n2;
                RuntimeCostAccounter.recordJump();
                return n;
            }
        }
        ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.awaitJoin:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinTask;)I");
        n = forkJoinPool.awaitJoin(workQueue, this);
        RuntimeCostAccounter.recordJump();
        return n;
    }

    private int doInvoke() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
        int n2 = this.doExec();
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            n = n2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            boolean bl = thread instanceof ForkJoinWorkerThread;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
                ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
                ForkJoinPool.WorkQueue workQueue = forkJoinWorkerThread.workQueue;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.awaitJoin:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinTask;)I");
                n = forkJoinPool.awaitJoin(workQueue, this);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.externalAwaitDone:()I");
                n = this.externalAwaitDone();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int recordExceptionalCompletion(Throwable throwable) {
        int n = this.status;
        RuntimeCostAccounter.recordJump();
        if (n < 0) return n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.identityHashCode:(Ljava/lang/Object;)I");
        int n2 = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.expungeStaleExceptions:()V");
            ForkJoinTask.expungeStaleExceptions();
            ExceptionNode[] exceptionNodeArray = exceptionTable;
            int n3 = n2 & exceptionNodeArray.length - 1;
            ExceptionNode exceptionNode = exceptionNodeArray[n3];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (exceptionNode == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$ExceptionNode");
                    ExceptionNode exceptionNode2 = exceptionNodeArray[n3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$ExceptionNode.<init>:(Ljava/util/concurrent/ForkJoinTask;Ljava/lang/Throwable;Ljava/util/concurrent/ForkJoinTask$ExceptionNode;)V");
                    exceptionNodeArray[n3] = new ExceptionNode(this, throwable, exceptionNode2);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$ExceptionNode.get:()Ljava/lang/Object;");
                Object t = exceptionNode.get();
                RuntimeCostAccounter.recordJump();
                if (t == this) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                exceptionNode = exceptionNode.next;
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setCompletion:(I)I");
        return this.setCompletion(Integer.MIN_VALUE);
    }

    private int setExceptionalCompletion(Throwable throwable) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.recordExceptionalCompletion:(Ljava/lang/Throwable;)I");
        int n = this.recordExceptionalCompletion(throwable);
        RuntimeCostAccounter.recordJump();
        if ((n & 0xF0000000) == Integer.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.internalPropagateException:(Ljava/lang/Throwable;)V");
            this.internalPropagateException(throwable);
        }
        return n;
    }

    void internalPropagateException(Throwable throwable) {
    }

    static final void cancelIgnoringExceptions(ForkJoinTask<?> forkJoinTask) {
        RuntimeCostAccounter.recordJump();
        if (forkJoinTask != null) {
            int n = forkJoinTask.status;
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.cancel:(Z)Z");
                    forkJoinTask.cancel(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExceptionalCompletion() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.identityHashCode:(Ljava/lang/Object;)I");
        int n = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            ExceptionNode[] exceptionNodeArray = exceptionTable;
            int n2 = n & exceptionNodeArray.length - 1;
            ExceptionNode exceptionNode = exceptionNodeArray[n2];
            ExceptionNode exceptionNode2 = null;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (exceptionNode == null) break;
                ExceptionNode exceptionNode3 = exceptionNode.next;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$ExceptionNode.get:()Ljava/lang/Object;");
                Object t = exceptionNode.get();
                RuntimeCostAccounter.recordJump();
                if (t == this) {
                    RuntimeCostAccounter.recordJump();
                    if (exceptionNode2 == null) {
                        exceptionNodeArray[n2] = exceptionNode3;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    exceptionNode2.next = exceptionNode3;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                exceptionNode2 = exceptionNode;
                exceptionNode = exceptionNode3;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.expungeStaleExceptions:()V");
            ForkJoinTask.expungeStaleExceptions();
            this.status = 0;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Throwable getThrowableException() {
        ExceptionNode exceptionNode;
        RuntimeCostAccounter.recordJump();
        if ((this.status & 0xF0000000) != Integer.MIN_VALUE) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.identityHashCode:(Ljava/lang/Object;)I");
        int n = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.lock:()V");
        reentrantLock.lock();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.expungeStaleExceptions:()V");
            ForkJoinTask.expungeStaleExceptions();
            ExceptionNode[] exceptionNodeArray = exceptionTable;
            exceptionNode = exceptionNodeArray[n & exceptionNodeArray.length - 1];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (exceptionNode != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$ExceptionNode.get:()Ljava/lang/Object;");
                    Object t = exceptionNode.get();
                    RuntimeCostAccounter.recordJump();
                    if (t != this) {
                        exceptionNode = exceptionNode.next;
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
        reentrantLock.unlock();
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (exceptionNode != null) {
            Throwable throwable = exceptionNode.ex;
            RuntimeCostAccounter.recordJump();
            if (throwable != null) {
                return throwable;
            }
        }
        return null;
    }

    private static void expungeStaleExceptions() {
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.poll:()Ljava/lang/ref/Reference;");
            Reference<Object> reference = exceptionTableRefQueue.poll();
            RuntimeCostAccounter.recordJump();
            if (reference == null) break;
            boolean bl = reference instanceof ExceptionNode;
            RuntimeCostAccounter.recordJump();
            if (!bl) continue;
            int n = ((ExceptionNode)reference).hashCode;
            ExceptionNode[] exceptionNodeArray = exceptionTable;
            int n2 = n & exceptionNodeArray.length - 1;
            ExceptionNode exceptionNode = exceptionNodeArray[n2];
            ExceptionNode exceptionNode2 = null;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (exceptionNode == null) break;
                ExceptionNode exceptionNode3 = exceptionNode.next;
                RuntimeCostAccounter.recordJump();
                if (exceptionNode == reference) {
                    RuntimeCostAccounter.recordJump();
                    if (exceptionNode2 == null) {
                        exceptionNodeArray[n2] = exceptionNode3;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    exceptionNode2.next = exceptionNode3;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                exceptionNode2 = exceptionNode;
                exceptionNode = exceptionNode3;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    static final void helpExpungeStaleExceptions() {
        ReentrantLock reentrantLock = exceptionTableLock;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.tryLock:()Z");
        boolean bl = reentrantLock.tryLock();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.expungeStaleExceptions:()V");
                ForkJoinTask.expungeStaleExceptions();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
                reentrantLock.unlock();
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.unlock:()V");
            reentrantLock.unlock();
            RuntimeCostAccounter.recordJump();
        }
    }

    static void rethrow(Throwable throwable) {
        RuntimeCostAccounter.recordJump();
        if (throwable != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.uncheckedThrow:(Ljava/lang/Throwable;)V");
            ForkJoinTask.uncheckedThrow(throwable);
        }
    }

    static <T extends Throwable> void uncheckedThrow(Throwable throwable) throws T {
        RuntimeCostAccounter.recordThrow();
        throw throwable;
    }

    private void reportException(int n) {
        RuntimeCostAccounter.recordJump();
        if (n == -1073741824) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CancellationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CancellationException.<init>:()V");
            CancellationException cancellationException = new CancellationException();
            RuntimeCostAccounter.recordThrow();
            throw cancellationException;
        }
        RuntimeCostAccounter.recordJump();
        if (n == Integer.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getThrowableException:()Ljava/lang/Throwable;");
            Throwable throwable = this.getThrowableException();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.rethrow:(Ljava/lang/Throwable;)V");
            ForkJoinTask.rethrow(throwable);
        }
    }

    public final ForkJoinTask<V> fork() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ForkJoinPool.WorkQueue workQueue = ((ForkJoinWorkerThread)thread).workQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.push:(Ljava/util/concurrent/ForkJoinTask;)V");
            workQueue.push(this);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalPush:(Ljava/util/concurrent/ForkJoinTask;)V");
            ForkJoinPool.common.externalPush(this);
        }
        return this;
    }

    public final V join() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doJoin:()I");
        int n = this.doJoin() & 0xF0000000;
        RuntimeCostAccounter.recordJump();
        if (n != -268435456) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.reportException:(I)V");
            this.reportException(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getRawResult:()Ljava/lang/Object;");
        return this.getRawResult();
    }

    public final V invoke() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doInvoke:()I");
        int n = this.doInvoke() & 0xF0000000;
        RuntimeCostAccounter.recordJump();
        if (n != -268435456) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.reportException:(I)V");
            this.reportException(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getRawResult:()Ljava/lang/Object;");
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> forkJoinTask, ForkJoinTask<?> forkJoinTask2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.fork:()Ljava/util/concurrent/ForkJoinTask;");
        forkJoinTask2.fork();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doInvoke:()I");
        int n = super.doInvoke() & 0xF0000000;
        RuntimeCostAccounter.recordJump();
        if (n != -268435456) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.reportException:(I)V");
            super.reportException(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doJoin:()I");
        int n2 = super.doJoin() & 0xF0000000;
        RuntimeCostAccounter.recordJump();
        if (n2 != -268435456) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.reportException:(I)V");
            super.reportException(n2);
        }
    }

    public static void invokeAll(ForkJoinTask<?> ... forkJoinTaskArray) {
        ForkJoinTask<?> forkJoinTask;
        int n;
        Throwable throwable = null;
        int n2 = n = forkJoinTaskArray.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) break;
            forkJoinTask = forkJoinTaskArray[n2];
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask == null) {
                RuntimeCostAccounter.recordJump();
                if (throwable == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    throwable = new NullPointerException();
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordJump();
                if (n2 != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.fork:()Ljava/util/concurrent/ForkJoinTask;");
                    forkJoinTask.fork();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doInvoke:()I");
                    int n3 = super.doInvoke();
                    RuntimeCostAccounter.recordJump();
                    if (n3 < -268435456) {
                        RuntimeCostAccounter.recordJump();
                        if (throwable == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getException:()Ljava/lang/Throwable;");
                            throwable = forkJoinTask.getException();
                        }
                    }
                }
            }
            --n2;
            RuntimeCostAccounter.recordJump();
        }
        n2 = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 > n) break;
            forkJoinTask = forkJoinTaskArray[n2];
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask != null) {
                RuntimeCostAccounter.recordJump();
                if (throwable != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.cancel:(Z)Z");
                    forkJoinTask.cancel(false);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doJoin:()I");
                    int n4 = super.doJoin();
                    RuntimeCostAccounter.recordJump();
                    if (n4 < -268435456) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getException:()Ljava/lang/Throwable;");
                        throwable = forkJoinTask.getException();
                    }
                }
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (throwable != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.rethrow:(Ljava/lang/Throwable;)V");
            ForkJoinTask.rethrow(throwable);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> collection) {
        ForkJoinTask forkJoinTask;
        int n;
        block19: {
            block18: {
                boolean bl = collection instanceof RandomAccess;
                RuntimeCostAccounter.recordJump();
                if (!bl) break block18;
                boolean bl2 = collection instanceof List;
                RuntimeCostAccounter.recordJump();
                if (bl2) break block19;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
            int n2 = collection.size();
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            ForkJoinTask[] forkJoinTaskArray = new ForkJoinTask[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.invokeAll:([Ljava/util/concurrent/ForkJoinTask;)V");
            ForkJoinTask.invokeAll(collection.toArray(forkJoinTaskArray));
            return collection;
        }
        List list = (List)collection;
        Throwable throwable = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n3 = n = list.size() - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            forkJoinTask = (ForkJoinTask)list.get(n3);
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask == null) {
                RuntimeCostAccounter.recordJump();
                if (throwable == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    throwable = new NullPointerException();
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordJump();
                if (n3 != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.fork:()Ljava/util/concurrent/ForkJoinTask;");
                    forkJoinTask.fork();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doInvoke:()I");
                    int n4 = forkJoinTask.doInvoke();
                    RuntimeCostAccounter.recordJump();
                    if (n4 < -268435456) {
                        RuntimeCostAccounter.recordJump();
                        if (throwable == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getException:()Ljava/lang/Throwable;");
                            throwable = forkJoinTask.getException();
                        }
                    }
                }
            }
            --n3;
            RuntimeCostAccounter.recordJump();
        }
        n3 = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 > n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            forkJoinTask = (ForkJoinTask)list.get(n3);
            RuntimeCostAccounter.recordJump();
            if (forkJoinTask != null) {
                RuntimeCostAccounter.recordJump();
                if (throwable != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.cancel:(Z)Z");
                    forkJoinTask.cancel(false);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doJoin:()I");
                    int n5 = forkJoinTask.doJoin();
                    RuntimeCostAccounter.recordJump();
                    if (n5 < -268435456) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getException:()Ljava/lang/Throwable;");
                        throwable = forkJoinTask.getException();
                    }
                }
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (throwable != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.rethrow:(Ljava/lang/Throwable;)V");
            ForkJoinTask.rethrow(throwable);
        }
        return collection;
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setCompletion:(I)I");
        int n = this.setCompletion(-1073741824) & 0xF0000000;
        RuntimeCostAccounter.recordJump();
        if (n == -1073741824) {
            bl2 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public final boolean isDone() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.status < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final boolean isCancelled() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if ((this.status & 0xF0000000) == -1073741824) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isCompletedAbnormally() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.status < -268435456) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isCompletedNormally() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if ((this.status & 0xF0000000) == -268435456) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public final Throwable getException() {
        Throwable throwable;
        int n = this.status & 0xF0000000;
        RuntimeCostAccounter.recordJump();
        if (n >= -268435456) {
            throwable = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n == -1073741824) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CancellationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CancellationException.<init>:()V");
                throwable = new CancellationException();
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getThrowableException:()Ljava/lang/Throwable;");
                throwable = this.getThrowableException();
            }
        }
        return throwable;
    }

    /*
     * Unable to fully structure code
     */
    public void completeExceptionally(Throwable var1_1) {
        v0 = var1_1 instanceof RuntimeException;
        RuntimeCostAccounter.recordJump();
        if (v0) ** GOTO lbl-1000
        v1 = var1_1 instanceof Error;
        RuntimeCostAccounter.recordJump();
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = var1_1;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:(Ljava/lang/Throwable;)V");
            v2 = new RuntimeException(var1_1);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setExceptionalCompletion:(Ljava/lang/Throwable;)I");
        this.setExceptionalCompletion(v2);
    }

    public void complete(V v) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setRawResult:(Ljava/lang/Object;)V");
            this.setRawResult(v);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setExceptionalCompletion:(Ljava/lang/Throwable;)I");
            this.setExceptionalCompletion(throwable);
            return;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setCompletion:(I)I");
        this.setCompletion(-268435456);
    }

    public final void quietlyComplete() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setCompletion:(I)I");
        this.setCompletion(-268435456);
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        boolean bl = Thread.currentThread() instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doJoin:()I");
            n = this.doJoin();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.externalInterruptibleAwaitDone:()I");
            n = this.externalInterruptibleAwaitDone();
        }
        int n2 = n;
        RuntimeCostAccounter.recordJump();
        if ((n2 &= 0xF0000000) == -1073741824) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CancellationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CancellationException.<init>:()V");
            CancellationException cancellationException = new CancellationException();
            RuntimeCostAccounter.recordThrow();
            throw cancellationException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == Integer.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getThrowableException:()Ljava/lang/Throwable;");
            Throwable throwable = this.getThrowableException();
            RuntimeCostAccounter.recordJump();
            if (throwable != null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ExecutionException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutionException.<init>:(Ljava/lang/Throwable;)V");
                ExecutionException executionException = new ExecutionException(throwable);
                RuntimeCostAccounter.recordThrow();
                throw executionException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getRawResult:()Ljava/lang/Object;");
        return this.getRawResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        int n;
        block33: {
            boolean bl;
            boolean bl2;
            ForkJoinPool forkJoinPool;
            block31: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                boolean bl3 = Thread.interrupted();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                    InterruptedException interruptedException = new InterruptedException();
                    RuntimeCostAccounter.recordThrow();
                    throw interruptedException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
                long l2 = timeUnit.toNanos(l);
                n = this.status;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block33;
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0L) break block33;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                long l3 = System.nanoTime() + l2;
                forkJoinPool = null;
                ForkJoinPool.WorkQueue workQueue = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
                Thread thread = Thread.currentThread();
                boolean bl4 = thread instanceof ForkJoinWorkerThread;
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
                    forkJoinPool = forkJoinWorkerThread.pool;
                    workQueue = forkJoinWorkerThread.workQueue;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.helpJoinOnce:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;Ljava/util/concurrent/ForkJoinTask;)V");
                    forkJoinPool.helpJoinOnce(workQueue, this);
                    RuntimeCostAccounter.recordJump();
                } else {
                    ForkJoinPool forkJoinPool2 = ForkJoinPool.common;
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinPool2 != null) {
                        boolean bl5 = this instanceof CountedCompleter;
                        RuntimeCostAccounter.recordJump();
                        if (bl5) {
                            CountedCompleter countedCompleter = (CountedCompleter)this;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.externalHelpComplete:(Ljava/util/concurrent/CountedCompleter;I)I");
                            forkJoinPool2.externalHelpComplete(countedCompleter, Integer.MAX_VALUE);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryExternalUnpush:(Ljava/util/concurrent/ForkJoinTask;)Z");
                            boolean bl6 = forkJoinPool2.tryExternalUnpush(this);
                            RuntimeCostAccounter.recordJump();
                            if (bl6) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doExec:()I");
                                this.doExec();
                            }
                        }
                    }
                }
                bl2 = false;
                bl = false;
                try {
                    while (true) {
                        n = this.status;
                        RuntimeCostAccounter.recordJump();
                        if (n < 0) break block31;
                        RuntimeCostAccounter.recordJump();
                        if (workQueue != null) {
                            int n2 = workQueue.qlock;
                            RuntimeCostAccounter.recordJump();
                            if (n2 < 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.cancelIgnoringExceptions:(Ljava/util/concurrent/ForkJoinTask;)V");
                                ForkJoinTask.cancelIgnoringExceptions(this);
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) {
                            RuntimeCostAccounter.recordJump();
                            if (forkJoinPool != null) {
                                long l4 = forkJoinPool.ctl;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryCompensate:(J)Z");
                                boolean bl7 = forkJoinPool.tryCompensate(l4);
                                RuntimeCostAccounter.recordJump();
                                if (!bl7) continue;
                            }
                            bl2 = true;
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toMillis:(J)J");
                        long l5 = TimeUnit.NANOSECONDS.toMillis(l2);
                        RuntimeCostAccounter.recordJump();
                        if (l5 > 0L) {
                            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
                            boolean bl8 = U.compareAndSwapInt((Object)this, STATUS, n, n | 0x10000);
                            RuntimeCostAccounter.recordJump();
                            if (bl8) {
                                block32: {
                                    try {
                                        RuntimeCostAccounter.recordJump();
                                        if (this.status >= 0) {
                                            try {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:(J)V");
                                                this.wait(l5);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                RuntimeCostAccounter.recordJump();
                                                if (forkJoinPool == null) {
                                                    bl = true;
                                                }
                                                RuntimeCostAccounter.recordJump();
                                                break block32;
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            break block32;
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
                                        this.notifyAll();
                                    }
                                    catch (Throwable throwable) {
                                        RuntimeCostAccounter.recordThrow();
                                        throw throwable;
                                    }
                                }
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                        n = this.status;
                        RuntimeCostAccounter.recordJump();
                        if (n < 0) break block31;
                        RuntimeCostAccounter.recordJump();
                        if (bl) break block31;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                        l2 = l3 - System.nanoTime();
                        RuntimeCostAccounter.recordJump();
                        if (l2 <= 0L) break;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordJump();
                    if (forkJoinPool != null) {
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.incrementActiveCount:()V");
                            forkJoinPool.incrementActiveCount();
                        }
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (forkJoinPool != null) {
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.incrementActiveCount:()V");
                    forkJoinPool.incrementActiveCount();
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
        }
        RuntimeCostAccounter.recordJump();
        if ((n &= 0xF0000000) != -268435456) {
            RuntimeCostAccounter.recordJump();
            if (n == -1073741824) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/CancellationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/CancellationException.<init>:()V");
                CancellationException cancellationException = new CancellationException();
                RuntimeCostAccounter.recordThrow();
                throw cancellationException;
            }
            RuntimeCostAccounter.recordJump();
            if (n != Integer.MIN_VALUE) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/TimeoutException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeoutException.<init>:()V");
                TimeoutException timeoutException = new TimeoutException();
                RuntimeCostAccounter.recordThrow();
                throw timeoutException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getThrowableException:()Ljava/lang/Throwable;");
            Throwable throwable = this.getThrowableException();
            RuntimeCostAccounter.recordJump();
            if (throwable != null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ExecutionException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ExecutionException.<init>:(Ljava/lang/Throwable;)V");
                ExecutionException executionException = new ExecutionException(throwable);
                RuntimeCostAccounter.recordThrow();
                throw executionException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getRawResult:()Ljava/lang/Object;");
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doJoin:()I");
        this.doJoin();
    }

    public final void quietlyInvoke() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.doInvoke:()I");
        this.doInvoke();
    }

    public static void helpQuiesce() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
            ForkJoinPool.WorkQueue workQueue = forkJoinWorkerThread.workQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.helpQuiescePool:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;)V");
            forkJoinPool.helpQuiescePool(workQueue);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.quiesceCommonPool:()V");
            ForkJoinPool.quiesceCommonPool();
        }
    }

    public void reinitialize() {
        RuntimeCostAccounter.recordJump();
        if ((this.status & 0xF0000000) == Integer.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.clearExceptionalCompletion:()V");
            this.clearExceptionalCompletion();
            RuntimeCostAccounter.recordJump();
        } else {
            this.status = 0;
        }
    }

    public static ForkJoinPool getPool() {
        ForkJoinPool forkJoinPool;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            forkJoinPool = ((ForkJoinWorkerThread)thread).pool;
            RuntimeCostAccounter.recordJump();
        } else {
            forkJoinPool = null;
        }
        return forkJoinPool;
    }

    public static boolean inForkJoinPool() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl2 = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            ForkJoinPool.WorkQueue workQueue = ((ForkJoinWorkerThread)thread).workQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.tryUnpush:(Ljava/util/concurrent/ForkJoinTask;)Z");
            bl = workQueue.tryUnpush(this);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.tryExternalUnpush:(Ljava/util/concurrent/ForkJoinTask;)Z");
            bl = ForkJoinPool.common.tryExternalUnpush(this);
        }
        return bl;
    }

    public static int getQueuedTaskCount() {
        int n;
        ForkJoinPool.WorkQueue workQueue;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            workQueue = ((ForkJoinWorkerThread)thread).workQueue;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonSubmitterQueue:()Ljava/util/concurrent/ForkJoinPool$WorkQueue;");
            workQueue = ForkJoinPool.commonSubmitterQueue();
        }
        RuntimeCostAccounter.recordJump();
        if (workQueue == null) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.queueSize:()I");
            n = workQueue.queueSize();
        }
        return n;
    }

    public static int getSurplusQueuedTaskCount() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.getSurplusQueuedTaskCount:()I");
        return ForkJoinPool.getSurplusQueuedTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        ForkJoinTask<?> forkJoinTask;
        ForkJoinPool.WorkQueue workQueue;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            workQueue = ((ForkJoinWorkerThread)thread).workQueue;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.commonSubmitterQueue:()Ljava/util/concurrent/ForkJoinPool$WorkQueue;");
            workQueue = ForkJoinPool.commonSubmitterQueue();
        }
        RuntimeCostAccounter.recordJump();
        if (workQueue == null) {
            forkJoinTask = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.peek:()Ljava/util/concurrent/ForkJoinTask;");
            forkJoinTask = workQueue.peek();
        }
        return forkJoinTask;
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        ForkJoinTask<?> forkJoinTask;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ForkJoinPool.WorkQueue workQueue = ((ForkJoinWorkerThread)thread).workQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool$WorkQueue.nextLocalTask:()Ljava/util/concurrent/ForkJoinTask;");
            forkJoinTask = workQueue.nextLocalTask();
            RuntimeCostAccounter.recordJump();
        } else {
            forkJoinTask = null;
        }
        return forkJoinTask;
    }

    protected static ForkJoinTask<?> pollTask() {
        ForkJoinTask<?> forkJoinTask;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof ForkJoinWorkerThread;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
            ForkJoinPool.WorkQueue workQueue = forkJoinWorkerThread.workQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinPool.nextTaskFor:(Ljava/util/concurrent/ForkJoinPool$WorkQueue;)Ljava/util/concurrent/ForkJoinTask;");
            forkJoinTask = forkJoinPool.nextTaskFor(workQueue);
            RuntimeCostAccounter.recordJump();
        } else {
            forkJoinTask = null;
        }
        return forkJoinTask;
    }

    public final short getForkJoinTaskTag() {
        return (short)this.status;
    }

    public final short setForkJoinTaskTag(short s) {
        int n;
        boolean bl;
        do {
            n = this.status;
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            bl = U.compareAndSwapInt((Object)this, STATUS, n, n & 0xFFFF0000 | s & 0xFFFF);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return (short)n;
    }

    public final boolean compareAndSetForkJoinTaskTag(short s, short s2) {
        boolean bl;
        do {
            int n = this.status;
            short s3 = (short)n;
            RuntimeCostAccounter.recordJump();
            if (s3 != s) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
            bl = U.compareAndSwapInt((Object)this, STATUS, n, n & 0xFFFF0000 | s2 & 0xFFFF);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return true;
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnableAction");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnableAction.<init>:(Ljava/lang/Runnable;)V");
        return new AdaptedRunnableAction(runnable);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T t) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnable.<init>:(Ljava/lang/Runnable;Ljava/lang/Object;)V");
        return new AdaptedRunnable<T>(runnable, t);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable.<init>:(Ljava/util/concurrent/Callable;)V");
        return new AdaptedCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.getException:()Ljava/lang/Throwable;");
        Throwable throwable = this.getException();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
        objectOutputStream.writeObject(throwable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
        Object object = objectInputStream.readObject();
        RuntimeCostAccounter.recordJump();
        if (object != null) {
            Throwable throwable = (Throwable)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.setExceptionalCompletion:(Ljava/lang/Throwable;)I");
            this.setExceptionalCompletion(throwable);
        }
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/ReentrantLock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/ReentrantLock.<init>:()V");
        exceptionTableLock = new ReentrantLock();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/ReferenceQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.<init>:()V");
        exceptionTableRefQueue = new ReferenceQueue();
        RuntimeCostAccounter.recordArrayAllocation((int)32, (int)8);
        exceptionTable = new ExceptionNode[32];
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            U = Unsafe.getUnsafe();
            Class<ForkJoinTask> clazz = ForkJoinTask.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("status");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            STATUS = U.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (callable == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            this.callable = callable;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public final boolean exec() {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/Callable.call:()Ljava/lang/Object;");
                this.result = this.callable.call();
                return true;
            }
            catch (Error error) {
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
            catch (RuntimeException runtimeException) {
                RuntimeCostAccounter.recordThrow();
                throw runtimeException;
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:(Ljava/lang/Throwable;)V");
                RuntimeException runtimeException = new RuntimeException(exception);
                RuntimeCostAccounter.recordThrow();
                throw runtimeException;
            }
        }

        @Override
        public final void run() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedCallable.invoke:()Ljava/lang/Object;");
            this.invoke();
        }
    }

    static final class RunnableExecuteAction
    extends ForkJoinTask<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        RunnableExecuteAction(Runnable runnable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (runnable == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            this.runnable = runnable;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
            this.runnable.run();
            return true;
        }

        @Override
        void internalPropagateException(Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$RunnableExecuteAction.rethrow:(Ljava/lang/Throwable;)V");
            RunnableExecuteAction.rethrow(throwable);
        }
    }

    static final class AdaptedRunnableAction
    extends ForkJoinTask<Void>
    implements RunnableFuture<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnableAction(Runnable runnable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (runnable == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            this.runnable = runnable;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnableAction.invoke:()Ljava/lang/Object;");
            this.invoke();
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T t) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.<init>:()V");
            RuntimeCostAccounter.recordJump();
            if (runnable == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            this.runnable = runnable;
            this.result = t;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T t) {
            this.result = t;
        }

        @Override
        public final boolean exec() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Runnable.run:()V");
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask$AdaptedRunnable.invoke:()Ljava/lang/Object;");
            this.invoke();
        }
    }

    static final class ExceptionNode
    extends WeakReference<ForkJoinTask<?>> {
        final Throwable ex;
        ExceptionNode next;
        final long thrower;
        final int hashCode;

        ExceptionNode(ForkJoinTask<?> forkJoinTask, Throwable throwable, ExceptionNode exceptionNode) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ForkJoinTask.access$000:()Ljava/lang/ref/ReferenceQueue;");
            ReferenceQueue referenceQueue = exceptionTableRefQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.<init>:(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;)V");
            super(forkJoinTask, referenceQueue);
            this.ex = throwable;
            this.next = exceptionNode;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.getId:()J");
            this.thrower = thread.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.identityHashCode:(Ljava/lang/Object;)I");
            this.hashCode = System.identityHashCode(forkJoinTask);
        }
    }
}

