/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Date;
import sandbox.java.util.TaskQueue;
import sandbox.java.util.TimerTask;
import sandbox.java.util.TimerThread;
import sandbox.java.util.concurrent.atomic.AtomicInteger;

public class Timer {
    private final TaskQueue queue;
    private final TimerThread thread;
    private final Object threadReaper;
    private static final AtomicInteger nextSerialNumber;

    private static int serialNumber() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.getAndIncrement:()I");
        return nextSerialNumber.getAndIncrement();
    }

    public Timer() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Timer-");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.serialNumber:()I");
        int n = Timer.serialNumber();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.<init>:(Ljava/lang/String;)V");
        this(string);
    }

    public Timer(boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Timer-");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.serialNumber:()I");
        int n = Timer.serialNumber();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.<init>:(Ljava/lang/String;Z)V");
        this(string, bl);
    }

    public Timer(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/TaskQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.<init>:()V");
        this.queue = new TaskQueue();
        RuntimeCostAccounter.recordAllocation((String)"java/util/TimerThread");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerThread.<init>:(Ljava/util/TaskQueue;)V");
        this.thread = new TimerThread(this.queue);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Timer$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer$1.<init>:(Ljava/util/Timer;)V");
        this.threadReaper = new Object(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.access$000:(Ljava/util/Timer;)Ljava/util/TaskQueue;");
                TaskQueue taskQueue = Timer.this.queue;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.access$100:(Ljava/util/Timer;)Ljava/util/TimerThread;");
                    ((Timer)Timer.this).thread.newTasksMayBeScheduled = false;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.access$000:(Ljava/util/Timer;)Ljava/util/TaskQueue;");
                    TaskQueue taskQueue2 = Timer.this.queue;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notify:()V");
                    taskQueue2.notify();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordJump();
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerThread.setName:(Ljava/lang/String;)V");
        this.thread.setName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerThread.start:()V");
        this.thread.start();
    }

    public Timer(String string, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/TaskQueue");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.<init>:()V");
        this.queue = new TaskQueue();
        RuntimeCostAccounter.recordAllocation((String)"java/util/TimerThread");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerThread.<init>:(Ljava/util/TaskQueue;)V");
        this.thread = new TimerThread(this.queue);
        RuntimeCostAccounter.recordAllocation((String)"java/util/Timer$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer$1.<init>:(Ljava/util/Timer;)V");
        this.threadReaper = new /* invalid duplicate definition of identical inner class */;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerThread.setName:(Ljava/lang/String;)V");
        this.thread.setName(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerThread.setDaemon:(Z)V");
        this.thread.setDaemon(bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TimerThread.start:()V");
        this.thread.start();
    }

    public void schedule(TimerTask timerTask, long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative delay.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
        long l2 = System.currentTimeMillis() + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.sched:(Ljava/util/TimerTask;JJ)V");
        this.sched(timerTask, l2, 0L);
    }

    public void schedule(TimerTask timerTask, Date date) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getTime:()J");
        long l = date.getTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.sched:(Ljava/util/TimerTask;JJ)V");
        this.sched(timerTask, l, 0L);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative delay.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Non-positive period.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
        long l3 = System.currentTimeMillis() + l;
        long l4 = -l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.sched:(Ljava/util/TimerTask;JJ)V");
        this.sched(timerTask, l3, l4);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        RuntimeCostAccounter.recordJump();
        if (l <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Non-positive period.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getTime:()J");
        long l2 = date.getTime();
        long l3 = -l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.sched:(Ljava/util/TimerTask;JJ)V");
        this.sched(timerTask, l2, l3);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative delay.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Non-positive period.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
        long l3 = System.currentTimeMillis() + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.sched:(Ljava/util/TimerTask;JJ)V");
        this.sched(timerTask, l3, l2);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        RuntimeCostAccounter.recordJump();
        if (l <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Non-positive period.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getTime:()J");
        long l2 = date.getTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Timer.sched:(Ljava/util/TimerTask;JJ)V");
        this.sched(timerTask, l2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(TimerTask timerTask, long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal execution time.");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
        long l3 = Math.abs(l2) - 0x3FFFFFFFFFFFFFFFL;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l4 > 0) {
            l2 >>= 1;
        }
        TaskQueue taskQueue = this.queue;
        try {
            boolean bl = this.thread.newTasksMayBeScheduled;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                IllegalStateException illegalStateException = new IllegalStateException("Timer already cancelled.");
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            Object object = timerTask.lock;
            try {
                int n = timerTask.state;
                RuntimeCostAccounter.recordJump();
                if (n != 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                    IllegalStateException illegalStateException = new IllegalStateException("Task already scheduled or cancelled");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
                timerTask.nextExecutionTime = l;
                timerTask.period = l2;
                timerTask.state = 1;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.add:(Ljava/util/TimerTask;)V");
            this.queue.add(timerTask);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.getMin:()Ljava/util/TimerTask;");
            TimerTask timerTask2 = this.queue.getMin();
            RuntimeCostAccounter.recordJump();
            if (timerTask2 == timerTask) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notify:()V");
                this.queue.notify();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        try {
            this.thread.newTasksMayBeScheduled = false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.clear:()V");
            this.queue.clear();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notify:()V");
            this.queue.notify();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int n = 0;
        TaskQueue taskQueue = this.queue;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.size:()I");
            int n2 = this.queue.size();
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 <= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.get:(I)Ljava/util/TimerTask;");
                int n3 = this.queue.get((int)n2).state;
                RuntimeCostAccounter.recordJump();
                if (n3 == 3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.quickRemove:(I)V");
                    this.queue.quickRemove(n2);
                    ++n;
                }
                --n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/TaskQueue.heapify:()V");
                this.queue.heapify();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        return n;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:(I)V");
        nextSerialNumber = new AtomicInteger(0);
    }
}

