/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.Collection;
import sandbox.java.util.Iterator;
import sandbox.java.util.JumboEnumSet;
import sandbox.java.util.RegularEnumSet;
import sandbox.sun.misc.JavaLangAccess;
import sandbox.sun.misc.SharedSecrets;

public abstract class EnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    final Class<E> elementType;
    final Enum<?>[] universe;
    private static Enum<?>[] ZERO_LENGTH_ENUM_ARRAY;

    EnumSet(Class<E> clazz, Enum<?>[] enumArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        this.elementType = clazz;
        this.universe = enumArray;
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.getUniverse:(Ljava/lang/Class;)[Ljava/lang/Enum;");
        Enum[] enumArray = EnumSet.getUniverse(clazz);
        RuntimeCostAccounter.recordJump();
        if (enumArray == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(" not an enum");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException(string);
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        int n = enumArray.length;
        RuntimeCostAccounter.recordJump();
        if (n <= 64) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/RegularEnumSet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/RegularEnumSet.<init>:(Ljava/lang/Class;[Ljava/lang/Enum;)V");
            return new RegularEnumSet<E>(clazz, enumArray);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/JumboEnumSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/JumboEnumSet.<init>:(Ljava/lang/Class;[Ljava/lang/Enum;)V");
        return new JumboEnumSet<E>(clazz, enumArray);
    }

    public static <E extends Enum<E>> EnumSet<E> allOf(Class<E> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.addAll:()V");
        enumSet.addAll();
        return enumSet;
    }

    abstract void addAll();

    public static <E extends Enum<E>> EnumSet<E> copyOf(EnumSet<E> enumSet) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.clone:()Ljava/util/EnumSet;");
        return enumSet.clone();
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> collection) {
        boolean bl = collection instanceof EnumSet;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            EnumSet enumSet = (EnumSet)collection;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.clone:()Ljava/util/EnumSet;");
            return enumSet.clone();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.isEmpty:()Z");
        boolean bl2 = collection.isEmpty();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Collection is empty");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = collection.iterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
        Enum enum_ = (Enum)iterator.next();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.of:(Ljava/lang/Enum;)Ljava/util/EnumSet;");
        EnumSet<Enum> enumSet = EnumSet.of(enum_);
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl3 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl3) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
            enumSet.add((Enum)e);
            RuntimeCostAccounter.recordJump();
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(EnumSet<E> enumSet) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.copyOf:(Ljava/util/EnumSet;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet2 = EnumSet.copyOf(enumSet);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.complement:()V");
        enumSet2.complement();
        return enumSet2;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
        Class<E> clazz = e.getDeclaringClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
        Class<E> clazz = e.getDeclaringClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e2);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2, E e3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
        Class<E> clazz = e.getDeclaringClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e3);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2, E e3, E e4) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
        Class<E> clazz = e.getDeclaringClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e4);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e, E e2, E e3, E e4, E e5) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
        Class<E> clazz = e.getDeclaringClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e5);
        return enumSet;
    }

    @SafeVarargs
    public static <E extends Enum<E>> EnumSet<E> of(E e, E ... EArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
        Class<E> clazz = e.getDeclaringClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
        enumSet.add(e);
        E[] EArray2 = EArray;
        int n = EArray2.length;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            E e2 = EArray2[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
            enumSet.add(e2);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> range(E e, E e2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.compareTo:(Ljava/lang/Enum;)I");
        int n = e.compareTo(e2);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(" > ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(e2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.getDeclaringClass:()Ljava/lang/Class;");
        Class<E> clazz = e.getDeclaringClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.addRange:(Ljava/lang/Enum;Ljava/lang/Enum;)V");
        enumSet.addRange(e, e2);
        return enumSet;
    }

    abstract void addRange(E var1, E var2);

    public EnumSet<E> clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            return (EnumSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:(Ljava/lang/Object;)V");
            AssertionError assertionError = new AssertionError((Object)cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw assertionError;
        }
    }

    abstract void complement();

    final void typeCheck(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = e.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != this.elementType) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSuperclass:()Ljava/lang/Class;");
            Class<?> clazz2 = clazz.getSuperclass();
            RuntimeCostAccounter.recordJump();
            if (clazz2 != this.elementType) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(clazz);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(" != ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(this.elementType);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
                ClassCastException classCastException = new ClassCastException(string);
                RuntimeCostAccounter.recordThrow();
                throw classCastException;
            }
        }
    }

    private static <E extends Enum<E>> E[] getUniverse(Class<E> clazz) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/SharedSecrets.getJavaLangAccess:()Lsun/misc/JavaLangAccess;");
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/JavaLangAccess.getEnumConstantsShared:(Ljava/lang/Class;)[Ljava/lang/Enum;");
        return javaLangAccess.getEnumConstantsShared(clazz);
    }

    Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/EnumSet$SerializationProxy");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet$SerializationProxy.<init>:(Ljava/util/EnumSet;)V");
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Proxy required");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    static {
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        ZERO_LENGTH_ENUM_ARRAY = new Enum[0];
    }

    private static class SerializationProxy<E extends Enum<E>>
    implements Serializable {
        private final Class<E> elementType;
        private final Enum<?>[] elements;
        private static final long serialVersionUID = 362491234563181265L;

        SerializationProxy(EnumSet<E> enumSet) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.elementType = enumSet.elementType;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.access$000:()[Ljava/lang/Enum;");
            Enum[] enumArray = ZERO_LENGTH_ENUM_ARRAY;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            this.elements = enumSet.toArray(enumArray);
        }

        private Object readResolve() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.noneOf:(Ljava/lang/Class;)Ljava/util/EnumSet;");
            EnumSet<Enum<?>> enumSet = EnumSet.noneOf(this.elementType);
            Enum<?>[] enumArray = this.elements;
            int n = enumArray.length;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                Enum<?> enum_ = enumArray[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/EnumSet.add:(Ljava/lang/Object;)Z");
                enumSet.add(enum_);
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            return enumSet;
        }
    }
}

