/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractCollection;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Deque;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.Consumer;

public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    transient Object[] elements;
    transient int head;
    transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void allocateElements(int n) {
        int n2 = 8;
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            n2 = n;
            n2 |= n2 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
            n2 |= n2 >>> 16;
            RuntimeCostAccounter.recordJump();
            if (++n2 < 0) {
                n2 >>>= 1;
            }
        }
        int n3 = n2;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        this.elements = new Object[n3];
    }

    private void doubleCapacity() {
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordJump();
            if (this.head != this.tail) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        int n = this.head;
        int n2 = this.elements.length;
        int n3 = n2 - n;
        int n4 = n2 << 1;
        RuntimeCostAccounter.recordJump();
        if (n4 < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("Sorry, deque too big");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        int n5 = n4;
        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)8);
        Object[] objectArray = new Object[n5];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.elements, n, objectArray, 0, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.elements, 0, objectArray, n3, n);
        this.elements = objectArray;
        this.head = 0;
        this.tail = n2;
    }

    private <T> T[] copyElements(T[] TArray) {
        RuntimeCostAccounter.recordJump();
        if (this.head < this.tail) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.size:()I");
            int n = this.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.elements, this.head, TArray, 0, n);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (this.head > this.tail) {
                int n = this.elements.length - this.head;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(this.elements, this.head, TArray, 0, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(this.elements, 0, TArray, n, this.tail);
            }
        }
        return TArray;
    }

    public ArrayDeque() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        RuntimeCostAccounter.recordArrayAllocation((int)16, (int)8);
        this.elements = new Object[16];
    }

    public ArrayDeque(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.allocateElements:(I)V");
        this.allocateElements(n);
    }

    public ArrayDeque(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.size:()I");
        int n = collection.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.allocateElements:(I)V");
        this.allocateElements(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.addAll:(Ljava/util/Collection;)Z");
        this.addAll(collection);
    }

    @Override
    public void addFirst(E e) {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        RuntimeCostAccounter.recordJump();
        if (this.head == this.tail) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.doubleCapacity:()V");
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(E e) {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        RuntimeCostAccounter.recordJump();
        if (this.tail == this.head) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.doubleCapacity:()V");
            this.doubleCapacity();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.addFirst:(Ljava/lang/Object;)V");
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.addLast:(Ljava/lang/Object;)V");
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.pollFirst:()Ljava/lang/Object;");
        E e = this.pollFirst();
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return e;
    }

    @Override
    public E removeLast() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.pollLast:()Ljava/lang/Object;");
        E e = this.pollLast();
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return e;
    }

    @Override
    public E pollFirst() {
        int n = this.head;
        Object object = this.elements[n];
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return null;
        }
        this.elements[n] = null;
        this.head = n + 1 & this.elements.length - 1;
        return (E)object;
    }

    @Override
    public E pollLast() {
        int n = this.tail - 1 & this.elements.length - 1;
        Object object = this.elements[n];
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return null;
        }
        this.elements[n] = null;
        this.tail = n;
        return (E)object;
    }

    @Override
    public E getFirst() {
        Object object = this.elements[this.head];
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return (E)object;
    }

    @Override
    public E getLast() {
        Object object = this.elements[this.tail - 1 & this.elements.length - 1];
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return (E)object;
    }

    @Override
    public E peekFirst() {
        return (E)this.elements[this.head];
    }

    @Override
    public E peekLast() {
        return (E)this.elements[this.tail - 1 & this.elements.length - 1];
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while (true) {
            Object object2 = this.elements[n2];
            RuntimeCostAccounter.recordJump();
            if (object2 == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            boolean bl = object.equals(object2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.delete:(I)Z");
                this.delete(n2);
                return true;
            }
            n2 = n2 + 1 & n;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.tail - 1 & n;
        while (true) {
            Object object2 = this.elements[n2];
            RuntimeCostAccounter.recordJump();
            if (object2 == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            boolean bl = object.equals(object2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.delete:(I)Z");
                this.delete(n2);
                return true;
            }
            n2 = n2 - 1 & n;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.addLast:(Ljava/lang/Object;)V");
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.offerLast:(Ljava/lang/Object;)Z");
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.removeFirst:()Ljava/lang/Object;");
        return this.removeFirst();
    }

    @Override
    public E poll() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.pollFirst:()Ljava/lang/Object;");
        return this.pollFirst();
    }

    @Override
    public E element() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.getFirst:()Ljava/lang/Object;");
        return this.getFirst();
    }

    @Override
    public E peek() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.peekFirst:()Ljava/lang/Object;");
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.addFirst:(Ljava/lang/Object;)V");
        this.addFirst(e);
    }

    @Override
    public E pop() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.removeFirst:()Ljava/lang/Object;");
        return this.removeFirst();
    }

    private void checkInvariants() {
        block7: {
            block9: {
                block8: {
                    RuntimeCostAccounter.recordJump();
                    if (!$assertionsDisabled) {
                        Object object = this.elements[this.tail];
                        RuntimeCostAccounter.recordJump();
                        if (object != null) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                            AssertionError assertionError = new AssertionError();
                            RuntimeCostAccounter.recordThrow();
                            throw assertionError;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if ($assertionsDisabled) break block7;
                    RuntimeCostAccounter.recordJump();
                    if (this.head != this.tail) break block8;
                    Object object = this.elements[this.head];
                    RuntimeCostAccounter.recordJump();
                    if (object != null) break block9;
                    RuntimeCostAccounter.recordJump();
                    break block7;
                }
                Object object = this.elements[this.head];
                RuntimeCostAccounter.recordJump();
                if (object == null) break block9;
                Object object2 = this.elements[this.tail - 1 & this.elements.length - 1];
                RuntimeCostAccounter.recordJump();
                if (object2 != null) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
            AssertionError assertionError = new AssertionError();
            RuntimeCostAccounter.recordThrow();
            throw assertionError;
        }
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            Object object = this.elements[this.head - 1 & this.elements.length - 1];
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
    }

    private boolean delete(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.checkInvariants:()V");
        this.checkInvariants();
        Object[] objectArray = this.elements;
        int n2 = objectArray.length - 1;
        int n3 = this.head;
        int n4 = this.tail;
        int n5 = n - n3 & n2;
        int n6 = n4 - n & n2;
        RuntimeCostAccounter.recordJump();
        if (n5 >= (n4 - n3 & n2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }
        RuntimeCostAccounter.recordJump();
        if (n5 < n6) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray, n3, objectArray, n3 + 1, n5);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray, 0, objectArray, 1, n);
                objectArray[0] = objectArray[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            }
            objectArray[n3] = null;
            this.head = n3 + 1 & n2;
            return false;
        }
        RuntimeCostAccounter.recordJump();
        if (n < n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(objectArray, n + 1, objectArray, n, n6);
            this.tail = n4 - 1;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            objectArray[n2] = objectArray[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(objectArray, 1, objectArray, 0, n4);
            this.tail = n4 - 1 & n2;
        }
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.head == this.tail) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayDeque$DeqIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqIterator.<init>:(Ljava/util/ArrayDeque;Ljava/util/ArrayDeque$1;)V");
        return new DeqIterator(this, null);
    }

    @Override
    public Iterator<E> descendingIterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayDeque$DescendingIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DescendingIterator.<init>:(Ljava/util/ArrayDeque;Ljava/util/ArrayDeque$1;)V");
        return new DescendingIterator(this, null);
    }

    @Override
    public boolean contains(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while (true) {
            Object object2 = this.elements[n2];
            RuntimeCostAccounter.recordJump();
            if (object2 == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            boolean bl = object.equals(object2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return true;
            }
            n2 = n2 + 1 & n;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.removeFirstOccurrence:(Ljava/lang/Object;)Z");
        return this.removeFirstOccurrence(object);
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        RuntimeCostAccounter.recordJump();
        if (n != n2) {
            this.tail = 0;
            this.head = 0;
            int n3 = n;
            int n4 = this.elements.length - 1;
            do {
                this.elements[n3] = null;
                n3 = n3 + 1 & n4;
                RuntimeCostAccounter.recordJump();
            } while (n3 != n2);
        }
    }

    @Override
    public Object[] toArray() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        Object[] objectArray = new Object[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.copyElements:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return this.copyElements(objectArray);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.size:()I");
        int n = this.size();
        int n2 = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 < n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = objectArray.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
            Class<?> clazz2 = clazz.getComponentType();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
            objectArray = (Object[])Array.newInstance(clazz2, n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.copyElements:([Ljava/lang/Object;)[Ljava/lang/Object;");
        this.copyElements(objectArray);
        int n3 = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public ArrayDeque<E> clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            ArrayDeque arrayDeque = (ArrayDeque)super.clone();
            int n = this.elements.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
            arrayDeque.elements = Arrays.copyOf(this.elements, n);
            return arrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
            AssertionError assertionError = new AssertionError();
            RuntimeCostAccounter.recordThrow();
            throw assertionError;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
        objectOutputStream.writeInt(n);
        int n2 = this.elements.length - 1;
        int n3 = this.head;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 == this.tail) break;
            Object object = this.elements[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(object);
            n3 = n3 + 1 & n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        int n = objectInputStream.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.allocateElements:(I)V");
        this.allocateElements(n);
        this.head = 0;
        this.tail = n;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            this.elements[n2] = objectInputStream.readObject();
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayDeque$DeqSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqSpliterator.<init>:(Ljava/util/ArrayDeque;II)V");
        return new DeqSpliterator(this, -1, -1);
    }

    static /* synthetic */ boolean access$200(ArrayDeque arrayDeque, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.delete:(I)Z");
        return arrayDeque.delete(n);
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = ArrayDeque.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
    }

    static final class DeqSpliterator<E>
    implements Spliterator<E> {
        private final ArrayDeque<E> deq;
        private int fence;
        private int index;

        DeqSpliterator(ArrayDeque<E> arrayDeque, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.deq = arrayDeque;
            this.index = n;
            this.fence = n2;
        }

        private int getFence() {
            int n = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                n = this.fence = this.deq.tail;
                this.index = this.deq.head;
            }
            return n;
        }

        @Override
        public DeqSpliterator<E> trySplit() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqSpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            int n3 = this.deq.elements.length;
            RuntimeCostAccounter.recordJump();
            if (n2 != n) {
                RuntimeCostAccounter.recordJump();
                if ((n2 + 1 & n3 - 1) != n) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 > n) {
                        n += n3;
                    }
                    int n4 = n2 + n >>> 1 & n3 - 1;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayDeque$DeqSpliterator");
                    this.index = n4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqSpliterator.<init>:(Ljava/util/ArrayDeque;II)V");
                    return new DeqSpliterator<E>(this.deq, n2, this.index);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Object[] objectArray = this.deq.elements;
            int n = objectArray.length - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqSpliterator.getFence:()I");
            int n2 = this.getFence();
            int n3 = this.index;
            this.index = n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 == n2) break;
                Object object = objectArray[n3];
                n3 = n3 + 1 & n;
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(object);
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Object[] objectArray = this.deq.elements;
            int n = objectArray.length - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqSpliterator.getFence:()I");
            int n2 = this.getFence();
            int n3 = this.index;
            RuntimeCostAccounter.recordJump();
            if (n3 != this.fence) {
                Object object = objectArray[n3];
                this.index = n3 + 1 & n;
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(object);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqSpliterator.getFence:()I");
            int n = this.getFence() - this.index;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                n += this.deq.elements.length;
            }
            return n;
        }

        @Override
        public int characteristics() {
            return 16720;
        }
    }

    private class DescendingIterator
    implements Iterator<E> {
        private int cursor;
        private int fence;
        private int lastRet;
        final /* synthetic */ ArrayDeque this$0;

        private DescendingIterator(ArrayDeque arrayDeque) {
            this.this$0 = arrayDeque;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.cursor = this.this$0.tail;
            this.fence = this.this$0.head;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.cursor != this.fence) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            Object object;
            block5: {
                block4: {
                    RuntimeCostAccounter.recordJump();
                    if (this.cursor == this.fence) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                    this.cursor = this.cursor - 1 & this.this$0.elements.length - 1;
                    object = this.this$0.elements[this.cursor];
                    int n = this.this$0.head;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.fence) break block4;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) break block5;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            this.lastRet = this.cursor;
            return object;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.access$200:(Ljava/util/ArrayDeque;I)Z");
            boolean bl = ArrayDeque.access$200(this.this$0, this.lastRet);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                this.cursor = this.cursor + 1 & this.this$0.elements.length - 1;
                this.fence = this.this$0.head;
            }
            this.lastRet = -1;
        }

        /* synthetic */ DescendingIterator(ArrayDeque arrayDeque, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DescendingIterator.<init>:(Ljava/util/ArrayDeque;)V");
            this(arrayDeque);
        }
    }

    private class DeqIterator
    implements Iterator<E> {
        private int cursor;
        private int fence;
        private int lastRet;
        final /* synthetic */ ArrayDeque this$0;

        private DeqIterator(ArrayDeque arrayDeque) {
            this.this$0 = arrayDeque;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.cursor = this.this$0.head;
            this.fence = this.this$0.tail;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.cursor != this.fence) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public E next() {
            Object object;
            block5: {
                block4: {
                    RuntimeCostAccounter.recordJump();
                    if (this.cursor == this.fence) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                        NoSuchElementException noSuchElementException = new NoSuchElementException();
                        RuntimeCostAccounter.recordThrow();
                        throw noSuchElementException;
                    }
                    object = this.this$0.elements[this.cursor];
                    int n = this.this$0.tail;
                    RuntimeCostAccounter.recordJump();
                    if (n != this.fence) break block4;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) break block5;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & this.this$0.elements.length - 1;
            return object;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastRet < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.access$200:(Ljava/util/ArrayDeque;I)Z");
            boolean bl = ArrayDeque.access$200(this.this$0, this.lastRet);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                this.cursor = this.cursor - 1 & this.this$0.elements.length - 1;
                this.fence = this.this$0.tail;
            }
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(consumer);
            Object[] objectArray = this.this$0.elements;
            int n = objectArray.length - 1;
            int n2 = this.fence;
            int n3 = this.cursor;
            this.cursor = n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 == n2) break;
                Object object = objectArray[n3];
                n3 = n3 + 1 & n;
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                consumer.accept(object);
                RuntimeCostAccounter.recordJump();
            }
        }

        /* synthetic */ DeqIterator(ArrayDeque arrayDeque, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque$DeqIterator.<init>:(Ljava/util/ArrayDeque;)V");
            this(arrayDeque);
        }
    }
}

