/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.zone;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Month;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAdjusters;
import sandbox.java.time.zone.Ser;
import sandbox.java.time.zone.ZoneOffsetTransition;
import sandbox.java.util.Objects;

public final class ZoneOffsetTransitionRule
implements Serializable {
    private static final long serialVersionUID = 6889046316657758795L;
    private final Month month;
    private final byte dom;
    private final DayOfWeek dow;
    private final LocalTime time;
    private final boolean timeEndOfDay;
    private final TimeDefinition timeDefinition;
    private final ZoneOffset standardOffset;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    public static ZoneOffsetTransitionRule of(Month month, int n, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        block6: {
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(month, "month");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(localTime, "time");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(timeDefinition, "timeDefnition");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(zoneOffset, "standardOffset");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(zoneOffset2, "offsetBefore");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(zoneOffset3, "offsetAfter");
                RuntimeCostAccounter.recordJump();
                if (n < -28) break block5;
                RuntimeCostAccounter.recordJump();
                if (n > 31) break block5;
                RuntimeCostAccounter.recordJump();
                if (n != 0) break block6;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = localTime.equals(LocalTime.MIDNIGHT);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Time must be midnight when end of day flag is true");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransitionRule");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule.<init>:(Ljava/time/Month;ILjava/time/DayOfWeek;Ljava/time/LocalTime;ZLjava/time/zone/ZoneOffsetTransitionRule$TimeDefinition;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
        return new ZoneOffsetTransitionRule(month, n, dayOfWeek, localTime, bl, timeDefinition, zoneOffset, zoneOffset2, zoneOffset3);
    }

    ZoneOffsetTransitionRule(Month month, int n, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.month = month;
        this.dom = (byte)n;
        this.dow = dayOfWeek;
        this.time = localTime;
        this.timeEndOfDay = bl;
        this.timeDefinition = timeDefinition;
        this.standardOffset = zoneOffset;
        this.offsetBefore = zoneOffset2;
        this.offsetAfter = zoneOffset3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(3, this);
    }

    /*
     * Unable to fully structure code
     */
    void writeExternal(DataOutput var1_1) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.timeEndOfDay) {
            v0 = 86400;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toSecondOfDay:()I");
            v0 = this.time.toSecondOfDay();
        }
        var2_2 = v0;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        var3_3 = this.standardOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        var4_4 = this.offsetBefore.getTotalSeconds() - var3_3;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        var5_5 = this.offsetAfter.getTotalSeconds() - var3_3;
        RuntimeCostAccounter.recordJump();
        if (var2_2 % 3600 == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.timeEndOfDay) {
                v1 = 24;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getHour:()I");
                v1 = this.time.getHour();
                RuntimeCostAccounter.recordJump();
            }
        } else {
            v1 = 31;
        }
        var6_6 = v1;
        RuntimeCostAccounter.recordJump();
        if (var3_3 % 900 == 0) {
            v2 = var3_3 / 900 + 128;
            RuntimeCostAccounter.recordJump();
        } else {
            v2 = 255;
        }
        var7_7 = v2;
        RuntimeCostAccounter.recordJump();
        if (var4_4 == 0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var4_4 == 1800) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var4_4 == 3600) lbl-1000:
        // 3 sources

        {
            v3 = var4_4 / 1800;
            RuntimeCostAccounter.recordJump();
        } else {
            v3 = 3;
        }
        var8_8 = v3;
        RuntimeCostAccounter.recordJump();
        if (var5_5 == 0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var5_5 == 1800) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var5_5 == 3600) lbl-1000:
        // 3 sources

        {
            v4 = var5_5 / 1800;
            RuntimeCostAccounter.recordJump();
        } else {
            v4 = 3;
        }
        var9_9 = v4;
        RuntimeCostAccounter.recordJump();
        if (this.dow == null) {
            v5 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
            v5 = this.dow.getValue();
        }
        var10_10 = v5;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.getValue:()I");
        v6 = (this.month.getValue() << 28) + (this.dom + 32 << 22) + (var10_10 << 19) + (var6_6 << 14);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.ordinal:()I");
        var11_11 = v6 + (this.timeDefinition.ordinal() << 12) + (var7_7 << 4) + (var8_8 << 2) + var9_9;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        var1_1.writeInt(var11_11);
        RuntimeCostAccounter.recordJump();
        if (var6_6 == 31) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
            var1_1.writeInt(var2_2);
        }
        RuntimeCostAccounter.recordJump();
        if (var7_7 == 255) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
            var1_1.writeInt(var3_3);
        }
        RuntimeCostAccounter.recordJump();
        if (var8_8 == 3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
            v7 = this.offsetBefore.getTotalSeconds();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
            var1_1.writeInt(v7);
        }
        RuntimeCostAccounter.recordJump();
        if (var9_9 == 3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
            v8 = this.offsetAfter.getTotalSeconds();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
            var1_1.writeInt(v8);
        }
    }

    static ZoneOffsetTransitionRule readExternal(DataInput dataInput) throws IOException {
        boolean bl;
        ZoneOffset zoneOffset;
        ZoneOffset zoneOffset2;
        ZoneOffset zoneOffset3;
        LocalTime localTime;
        DayOfWeek dayOfWeek;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
        Month month = Month.of(n >>> 28);
        int n2 = ((n & 0xFC00000) >>> 22) - 32;
        int n3 = (n & 0x380000) >>> 19;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            dayOfWeek = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.of:(I)Ljava/time/DayOfWeek;");
            dayOfWeek = DayOfWeek.of(n3);
        }
        DayOfWeek dayOfWeek2 = dayOfWeek;
        int n4 = (n & 0x7C000) >>> 14;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.values:()[Ljava/time/zone/ZoneOffsetTransitionRule$TimeDefinition;");
        TimeDefinition timeDefinition = TimeDefinition.values()[(n & 0x3000) >>> 12];
        int n5 = (n & 0xFF0) >>> 4;
        int n6 = (n & 0xC) >>> 2;
        int n7 = n & 3;
        RuntimeCostAccounter.recordJump();
        if (n4 == 31) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
            long l = dataInput.readInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofSecondOfDay:(J)Ljava/time/LocalTime;");
            localTime = LocalTime.ofSecondOfDay(l);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(II)Ljava/time/LocalTime;");
            localTime = LocalTime.of(n4 % 24, 0);
        }
        LocalTime localTime2 = localTime;
        RuntimeCostAccounter.recordJump();
        if (n5 == 255) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
            int n8 = dataInput.readInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset3 = ZoneOffset.ofTotalSeconds(n8);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset3 = ZoneOffset.ofTotalSeconds((n5 - 128) * 900);
        }
        ZoneOffset zoneOffset4 = zoneOffset3;
        RuntimeCostAccounter.recordJump();
        if (n6 == 3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
            int n9 = dataInput.readInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset2 = ZoneOffset.ofTotalSeconds(n9);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
            int n10 = zoneOffset4.getTotalSeconds() + n6 * 1800;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset2 = ZoneOffset.ofTotalSeconds(n10);
        }
        ZoneOffset zoneOffset5 = zoneOffset2;
        RuntimeCostAccounter.recordJump();
        if (n7 == 3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
            int n11 = dataInput.readInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset = ZoneOffset.ofTotalSeconds(n11);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
            int n12 = zoneOffset4.getTotalSeconds() + n7 * 1800;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset = ZoneOffset.ofTotalSeconds(n12);
        }
        ZoneOffset zoneOffset6 = zoneOffset;
        RuntimeCostAccounter.recordJump();
        if (n4 == 24) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule.of:(Ljava/time/Month;ILjava/time/DayOfWeek;Ljava/time/LocalTime;ZLjava/time/zone/ZoneOffsetTransitionRule$TimeDefinition;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;)Ljava/time/zone/ZoneOffsetTransitionRule;");
        return ZoneOffsetTransitionRule.of(month, n2, dayOfWeek2, localTime2, bl, timeDefinition, zoneOffset4, zoneOffset5, zoneOffset6);
    }

    public Month getMonth() {
        return this.month;
    }

    public int getDayOfMonthIndicator() {
        return this.dom;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dow;
    }

    public LocalTime getLocalTime() {
        return this.time;
    }

    public boolean isMidnightEndOfDay() {
        return this.timeEndOfDay;
    }

    public TimeDefinition getTimeDefinition() {
        return this.timeDefinition;
    }

    public ZoneOffset getStandardOffset() {
        return this.standardOffset;
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore;
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter;
    }

    public ZoneOffsetTransition createTransition(int n) {
        LocalDate localDate;
        RuntimeCostAccounter.recordJump();
        if (this.dom < 0) {
            long l = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
            boolean bl = IsoChronology.INSTANCE.isLeapYear(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.length:(Z)I");
            int n2 = this.month.length(bl) + 1 + this.dom;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(ILjava/time/Month;I)Ljava/time/LocalDate;");
            localDate = LocalDate.of(n, this.month, n2);
            RuntimeCostAccounter.recordJump();
            if (this.dow != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.previousOrSame:(Ljava/time/DayOfWeek;)Ljava/time/temporal/TemporalAdjuster;");
                TemporalAdjuster temporalAdjuster = TemporalAdjusters.previousOrSame(this.dow);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/LocalDate;");
                localDate = localDate.with(temporalAdjuster);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(ILjava/time/Month;I)Ljava/time/LocalDate;");
            localDate = LocalDate.of(n, this.month, (int)this.dom);
            RuntimeCostAccounter.recordJump();
            if (this.dow != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.nextOrSame:(Ljava/time/DayOfWeek;)Ljava/time/temporal/TemporalAdjuster;");
                TemporalAdjuster temporalAdjuster = TemporalAdjusters.nextOrSame(this.dow);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/LocalDate;");
                localDate = localDate.with(temporalAdjuster);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.timeEndOfDay) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
            localDate = localDate.plusDays(1L);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.of(localDate, this.time);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.createDateTime:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime2 = this.timeDefinition.createDateTime(localDateTime, this.standardOffset, this.offsetBefore);
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
        return new ZoneOffsetTransition(localDateTime2, this.offsetBefore, this.offsetAfter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof ZoneOffsetTransitionRule;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        ZoneOffsetTransitionRule zoneOffsetTransitionRule = (ZoneOffsetTransitionRule)object;
        Month month = zoneOffsetTransitionRule.month;
        RuntimeCostAccounter.recordJump();
        if (this.month != month) return false;
        byte by = zoneOffsetTransitionRule.dom;
        RuntimeCostAccounter.recordJump();
        if (this.dom != by) return false;
        DayOfWeek dayOfWeek = zoneOffsetTransitionRule.dow;
        RuntimeCostAccounter.recordJump();
        if (this.dow != dayOfWeek) return false;
        TimeDefinition timeDefinition = zoneOffsetTransitionRule.timeDefinition;
        RuntimeCostAccounter.recordJump();
        if (this.timeDefinition != timeDefinition) return false;
        LocalTime localTime = zoneOffsetTransitionRule.time;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.time.equals(localTime);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = zoneOffsetTransitionRule.timeEndOfDay;
        RuntimeCostAccounter.recordJump();
        if (this.timeEndOfDay != bl3) return false;
        ZoneOffset zoneOffset = zoneOffsetTransitionRule.standardOffset;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl4 = this.standardOffset.equals(zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (!bl4) return false;
        ZoneOffset zoneOffset2 = zoneOffsetTransitionRule.offsetBefore;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl5 = this.offsetBefore.equals(zoneOffset2);
        RuntimeCostAccounter.recordJump();
        if (!bl5) return false;
        ZoneOffset zoneOffset3 = zoneOffsetTransitionRule.offsetAfter;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl6 = this.offsetAfter.equals(zoneOffset3);
        RuntimeCostAccounter.recordJump();
        if (!bl6) return false;
        boolean bl7 = true;
        RuntimeCostAccounter.recordJump();
        return bl7;
    }

    public int hashCode() {
        int n;
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toSecondOfDay:()I");
        int n3 = this.time.toSecondOfDay();
        RuntimeCostAccounter.recordJump();
        if (this.timeEndOfDay) {
            n2 = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0;
        }
        int n4 = n3 + n2 << 15;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.ordinal:()I");
        int n5 = n4 + (this.month.ordinal() << 11) + (this.dom + 32 << 5);
        RuntimeCostAccounter.recordJump();
        if (this.dow == null) {
            n = 7;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.ordinal:()I");
            n = this.dow.ordinal();
        }
        int n6 = n5 + (n << 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.ordinal:()I");
        int n7 = n6 + this.timeDefinition.ordinal();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        int n8 = n7 ^ this.standardOffset.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        int n9 = n8 ^ this.offsetBefore.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        return n9 ^ this.offsetAfter.hashCode();
    }

    public String toString() {
        String string;
        String string2;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("TransitionRule[");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.compareTo:(Ljava/time/ZoneOffset;)I");
        int n = this.offsetBefore.compareTo(this.offsetAfter);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            string2 = "Gap ";
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = "Overlap ";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(this.offsetBefore);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(" to ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(this.offsetAfter);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        stringBuilder6.append(", ");
        RuntimeCostAccounter.recordJump();
        if (this.dow != null) {
            RuntimeCostAccounter.recordJump();
            if (this.dom == -1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.name:()Ljava/lang/String;");
                String string3 = this.dow.name();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder.append(string3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(" on or before last day of ");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.name:()Ljava/lang/String;");
                String string4 = this.month.name();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder8.append(string4);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.dom < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.name:()Ljava/lang/String;");
                    String string5 = this.dow.name();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder9 = stringBuilder.append(string5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder10 = stringBuilder9.append(" on or before last day minus ");
                    int n2 = -this.dom - 1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder11 = stringBuilder10.append(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder12 = stringBuilder11.append(" of ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.name:()Ljava/lang/String;");
                    String string6 = this.month.name();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    stringBuilder12.append(string6);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.name:()Ljava/lang/String;");
                    String string7 = this.dow.name();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder13 = stringBuilder.append(string7);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder14 = stringBuilder13.append(" on or after ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.name:()Ljava/lang/String;");
                    String string8 = this.month.name();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder15 = stringBuilder14.append(string8);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder16 = stringBuilder15.append(' ');
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    stringBuilder16.append(this.dom);
                    RuntimeCostAccounter.recordJump();
                }
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.name:()Ljava/lang/String;");
            String string9 = this.month.name();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder17 = stringBuilder.append(string9);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder18 = stringBuilder17.append(' ');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            stringBuilder18.append(this.dom);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder19 = stringBuilder.append(" at ");
        RuntimeCostAccounter.recordJump();
        if (this.timeEndOfDay) {
            string = "24:00";
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toString:()Ljava/lang/String;");
            string = this.time.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder20 = stringBuilder19.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder21 = stringBuilder20.append(" ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder22 = stringBuilder21.append((Object)this.timeDefinition);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder23 = stringBuilder22.append(", standard offset ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder24 = stringBuilder23.append(this.standardOffset);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder24.append(']');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    public static final class TimeDefinition
    extends Enum<TimeDefinition> {
        public static final /* enum */ TimeDefinition UTC;
        public static final /* enum */ TimeDefinition WALL;
        public static final /* enum */ TimeDefinition STANDARD;
        private static final /* synthetic */ TimeDefinition[] $VALUES;

        /*
         * Exception decompiling
         */
        public static TimeDefinition[] values() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Invalid type string [s
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils.decodeTypeTok(ConstantPoolUtils.java:101)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.convertFromString(ConstantPoolEntryClass.java:52)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.getTypeInstance(ConstantPoolEntryClass.java:61)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef.getMethodPrototype(ConstantPoolEntryMethodRef.java:72)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvoke(Op02WithProcessedDataAndRefs.java:331)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1224)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static TimeDefinition valueOf(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.valueOf:(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
            return Enum.valueOf(TimeDefinition.class, string);
        }

        private TimeDefinition() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.<init>:(Ljava/lang/String;I)V");
        }

        public LocalDateTime createDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneOffset zoneOffset2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.ordinal:()I");
            switch (1.$SwitchMap$java$time$zone$ZoneOffsetTransitionRule$TimeDefinition[this.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    int n = zoneOffset2.getTotalSeconds();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    int n2 = n - ZoneOffset.UTC.getTotalSeconds();
                    long l = n2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
                    return localDateTime.plusSeconds(l);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    int n = zoneOffset2.getTotalSeconds();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    int n3 = n - zoneOffset.getTotalSeconds();
                    long l = n3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
                    return localDateTime.plusSeconds(l);
                }
            }
            return localDateTime;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.<init>:(Ljava/lang/String;I)V");
            UTC = new TimeDefinition();
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.<init>:(Ljava/lang/String;I)V");
            WALL = new TimeDefinition();
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule$TimeDefinition.<init>:(Ljava/lang/String;I)V");
            STANDARD = new TimeDefinition();
            RuntimeCostAccounter.recordArrayAllocation((int)3, (int)8);
            $VALUES = new TimeDefinition[]{UTC, WALL, STANDARD};
        }
    }
}

