/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.format;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.text.DecimalFormatSymbols;
import sandbox.java.util.Collections;
import sandbox.java.util.HashSet;
import sandbox.java.util.Locale;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;

public final class DecimalStyle {
    public static final DecimalStyle STANDARD;
    private static final ConcurrentMap<Locale, DecimalStyle> CACHE;
    private final char zeroDigit;
    private final char positiveSign;
    private final char negativeSign;
    private final char decimalSeparator;

    public static Set<Locale> getAvailableLocales() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getAvailableLocales:()[Ljava/util/Locale;");
        Locale[] localeArray = DecimalFormatSymbols.getAvailableLocales();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
        int n = localeArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:(I)V");
        HashSet<Locale> hashSet = new HashSet<Locale>(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.addAll:(Ljava/util/Collection;[Ljava/lang/Object;)Z");
        Collections.addAll(hashSet, localeArray);
        return hashSet;
    }

    public static DecimalStyle ofDefaultLocale() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.of:(Ljava/util/Locale;)Ljava/time/format/DecimalStyle;");
        return DecimalStyle.of(locale);
    }

    public static DecimalStyle of(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(locale, "locale");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        DecimalStyle decimalStyle = (DecimalStyle)CACHE.get(locale);
        RuntimeCostAccounter.recordJump();
        if (decimalStyle == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.create:(Ljava/util/Locale;)Ljava/time/format/DecimalStyle;");
            decimalStyle = DecimalStyle.create(locale);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            CACHE.putIfAbsent(locale, decimalStyle);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            decimalStyle = (DecimalStyle)CACHE.get(locale);
        }
        return decimalStyle;
    }

    private static DecimalStyle create(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getInstance:(Ljava/util/Locale;)Ljava/text/DecimalFormatSymbols;");
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getZeroDigit:()C");
        char c = decimalFormatSymbols.getZeroDigit();
        char c2 = '+';
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getMinusSign:()C");
        char c3 = decimalFormatSymbols.getMinusSign();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DecimalFormatSymbols.getDecimalSeparator:()C");
        char c4 = decimalFormatSymbols.getDecimalSeparator();
        RuntimeCostAccounter.recordJump();
        if (c == '0') {
            RuntimeCostAccounter.recordJump();
            if (c3 == '-') {
                RuntimeCostAccounter.recordJump();
                if (c4 == '.') {
                    return STANDARD;
                }
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DecimalStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.<init>:(CCCC)V");
        return new DecimalStyle(c, c2, c3, c4);
    }

    private DecimalStyle(char c, char c2, char c3, char c4) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.zeroDigit = c;
        this.positiveSign = c2;
        this.negativeSign = c3;
        this.decimalSeparator = c4;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public DecimalStyle withZeroDigit(char c) {
        RuntimeCostAccounter.recordJump();
        if (c == this.zeroDigit) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DecimalStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.<init>:(CCCC)V");
        return new DecimalStyle(c, this.positiveSign, this.negativeSign, this.decimalSeparator);
    }

    public char getPositiveSign() {
        return this.positiveSign;
    }

    public DecimalStyle withPositiveSign(char c) {
        RuntimeCostAccounter.recordJump();
        if (c == this.positiveSign) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DecimalStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.<init>:(CCCC)V");
        return new DecimalStyle(this.zeroDigit, c, this.negativeSign, this.decimalSeparator);
    }

    public char getNegativeSign() {
        return this.negativeSign;
    }

    public DecimalStyle withNegativeSign(char c) {
        RuntimeCostAccounter.recordJump();
        if (c == this.negativeSign) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DecimalStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.<init>:(CCCC)V");
        return new DecimalStyle(this.zeroDigit, this.positiveSign, c, this.decimalSeparator);
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public DecimalStyle withDecimalSeparator(char c) {
        RuntimeCostAccounter.recordJump();
        if (c == this.decimalSeparator) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DecimalStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.<init>:(CCCC)V");
        return new DecimalStyle(this.zeroDigit, this.positiveSign, this.negativeSign, c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int convertToDigit(char c) {
        int n = c - this.zeroDigit;
        RuntimeCostAccounter.recordJump();
        if (n < 0) return -1;
        RuntimeCostAccounter.recordJump();
        if (n > 9) return -1;
        int n2 = n;
        RuntimeCostAccounter.recordJump();
        return n2;
    }

    String convertNumberToI18N(String string) {
        RuntimeCostAccounter.recordJump();
        if (this.zeroDigit == '0') {
            return string;
        }
        int n = this.zeroDigit - 48;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toCharArray:()[C");
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (true) {
            int n3 = cArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            cArray[n2] = (char)(cArray[n2] + n);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([C)V");
        return new String(cArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof DecimalStyle;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        DecimalStyle decimalStyle = (DecimalStyle)object;
        char c = decimalStyle.zeroDigit;
        RuntimeCostAccounter.recordJump();
        if (this.zeroDigit != c) return false;
        char c2 = decimalStyle.positiveSign;
        RuntimeCostAccounter.recordJump();
        if (this.positiveSign != c2) return false;
        char c3 = decimalStyle.negativeSign;
        RuntimeCostAccounter.recordJump();
        if (this.negativeSign != c3) return false;
        char c4 = decimalStyle.decimalSeparator;
        RuntimeCostAccounter.recordJump();
        if (this.decimalSeparator != c4) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        return this.zeroDigit + this.positiveSign + this.negativeSign + this.decimalSeparator;
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("DecimalStyle[");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(this.zeroDigit);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(this.positiveSign);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(this.negativeSign);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(this.decimalSeparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder7.toString();
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DecimalStyle");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.<init>:(CCCC)V");
        STANDARD = new DecimalStyle('0', '+', '-', '.');
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:(IFI)V");
        CACHE = new ConcurrentHashMap<Locale, DecimalStyle>(16, 0.75f, 2);
    }
}

