/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInput;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutput;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateImpl;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoPeriod;
import sandbox.java.time.chrono.HijrahChronology;
import sandbox.java.time.chrono.HijrahEra;
import sandbox.java.time.chrono.Ser;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;

public final class HijrahDate
extends ChronoLocalDateImpl<HijrahDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -5207853542612002020L;
    private final transient HijrahChronology chrono;
    private final transient int prolepticYear;
    private final transient int monthOfYear;
    private final transient int dayOfMonth;

    static HijrahDate of(HijrahChronology hijrahChronology, int n, int n2, int n3) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/HijrahDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.<init>:(Ljava/time/chrono/HijrahChronology;III)V");
        return new HijrahDate(hijrahChronology, n, n2, n3);
    }

    static HijrahDate ofEpochDay(HijrahChronology hijrahChronology, long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/HijrahDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.<init>:(Ljava/time/chrono/HijrahChronology;J)V");
        return new HijrahDate(hijrahChronology, l);
    }

    public static HijrahDate now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.now:(Ljava/time/Clock;)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.now(clock);
    }

    public static HijrahDate now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.now:(Ljava/time/Clock;)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.now(clock);
    }

    public static HijrahDate now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        long l = localDate.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.ofEpochDay:(Ljava/time/chrono/HijrahChronology;J)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.ofEpochDay(HijrahChronology.INSTANCE, l);
    }

    public static HijrahDate of(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.date:(III)Ljava/time/chrono/HijrahDate;");
        return HijrahChronology.INSTANCE.date(n, n2, n3);
    }

    public static HijrahDate from(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/HijrahDate;");
        return HijrahChronology.INSTANCE.date(temporalAccessor);
    }

    private HijrahDate(HijrahChronology hijrahChronology, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getEpochDay:(III)J");
        hijrahChronology.getEpochDay(n, n2, n3);
        this.chrono = hijrahChronology;
        this.prolepticYear = n;
        this.monthOfYear = n2;
        this.dayOfMonth = n3;
    }

    private HijrahDate(HijrahChronology hijrahChronology, long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.<init>:()V");
        int n = (int)l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getHijrahDateInfo:(I)[I");
        int[] nArray = hijrahChronology.getHijrahDateInfo(n);
        this.chrono = hijrahChronology;
        this.prolepticYear = nArray[0];
        this.monthOfYear = nArray[1];
        this.dayOfMonth = nArray[2];
    }

    @Override
    public HijrahChronology getChronology() {
        return this.chrono;
    }

    @Override
    public HijrahEra getEra() {
        return HijrahEra.AH;
    }

    @Override
    public int lengthOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMonthLength:(II)I");
        return this.chrono.getMonthLength(this.prolepticYear, this.monthOfYear);
    }

    @Override
    public int lengthOfYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getYearLength:(I)I");
        return this.chrono.getYearLength(this.prolepticYear);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl2 = this.isSupported(temporalField);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                ChronoField chronoField = (ChronoField)temporalField;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
                switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                    case 1: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.lengthOfMonth:()I");
                        long l = this.lengthOfMonth();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, l);
                    }
                    case 2: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.lengthOfYear:()I");
                        long l = this.lengthOfYear();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, l);
                    }
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, 5L);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getChronology:()Ljava/time/chrono/HijrahChronology;");
                HijrahChronology hijrahChronology = this.getChronology();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                return hijrahChronology.range(chronoField);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getDayOfWeek:()I");
                    return this.getDayOfWeek();
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getDayOfWeek:()I");
                    return (this.getDayOfWeek() - 1) % 7 + 1;
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getDayOfYear:()I");
                    return (this.getDayOfYear() - 1) % 7 + 1;
                }
                case 1: {
                    return this.dayOfMonth;
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getDayOfYear:()I");
                    return this.getDayOfYear();
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.toEpochDay:()J");
                    return this.toEpochDay();
                }
                case 3: {
                    return (this.dayOfMonth - 1) / 7 + 1;
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getDayOfYear:()I");
                    return (this.getDayOfYear() - 1) / 7 + 1;
                }
                case 9: {
                    return this.monthOfYear;
                }
                case 10: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getProlepticMonth:()J");
                    return this.getProlepticMonth();
                }
                case 11: {
                    return this.prolepticYear;
                }
                case 12: {
                    return this.prolepticYear;
                }
                case 13: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getEraValue:()I");
                    return this.getEraValue();
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.prolepticYear * 12L + (long)this.monthOfYear - 1L;
    }

    @Override
    public HijrahDate with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = this.chrono.range(chronoField);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidValue:(JLjava/time/temporal/TemporalField;)J");
            valueRange.checkValidValue(l, chronoField);
            int n = (int)l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getDayOfWeek:()I");
                    long l2 = l - (long)this.getDayOfWeek();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusDays:(J)Ljava/time/chrono/HijrahDate;");
                    return this.plusDays(l2);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l3 = l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusDays:(J)Ljava/time/chrono/HijrahDate;");
                    return this.plusDays(l3);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l4 = l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusDays:(J)Ljava/time/chrono/HijrahDate;");
                    return this.plusDays(l4);
                }
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.resolvePreviousValid:(III)Ljava/time/chrono/HijrahDate;");
                    return this.resolvePreviousValid(this.prolepticYear, this.monthOfYear, n);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.lengthOfYear:()I");
                    int n2 = this.lengthOfYear();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    int n3 = Math.min(n, n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getDayOfYear:()I");
                    long l5 = n3 - this.getDayOfYear();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusDays:(J)Ljava/time/chrono/HijrahDate;");
                    return this.plusDays(l5);
                }
                case 7: {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/HijrahDate");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.<init>:(Ljava/time/chrono/HijrahChronology;J)V");
                    return new HijrahDate(this.chrono, l);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l6 = (l - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH)) * 7L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusDays:(J)Ljava/time/chrono/HijrahDate;");
                    return this.plusDays(l6);
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l7 = (l - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR)) * 7L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusDays:(J)Ljava/time/chrono/HijrahDate;");
                    return this.plusDays(l7);
                }
                case 9: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.resolvePreviousValid:(III)Ljava/time/chrono/HijrahDate;");
                    return this.resolvePreviousValid(this.prolepticYear, n, this.dayOfMonth);
                }
                case 10: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getProlepticMonth:()J");
                    long l8 = l - this.getProlepticMonth();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusMonths:(J)Ljava/time/chrono/HijrahDate;");
                    return this.plusMonths(l8);
                }
                case 11: {
                    int n4;
                    RuntimeCostAccounter.recordJump();
                    if (this.prolepticYear >= 1) {
                        n4 = n;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n4 = 1 - n;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.resolvePreviousValid:(III)Ljava/time/chrono/HijrahDate;");
                    return this.resolvePreviousValid(n4, this.monthOfYear, this.dayOfMonth);
                }
                case 12: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.resolvePreviousValid:(III)Ljava/time/chrono/HijrahDate;");
                    return this.resolvePreviousValid(n, this.monthOfYear, this.dayOfMonth);
                }
                case 13: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.resolvePreviousValid:(III)Ljava/time/chrono/HijrahDate;");
                    return this.resolvePreviousValid(1 - this.prolepticYear, this.monthOfYear, this.dayOfMonth);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.with(temporalField, l);
    }

    private HijrahDate resolvePreviousValid(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMonthLength:(II)I");
        int n4 = this.chrono.getMonthLength(n, n2);
        RuntimeCostAccounter.recordJump();
        if (n3 > n4) {
            n3 = n4;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.of:(Ljava/time/chrono/HijrahChronology;III)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.of(this.chrono, n, n2, n3);
    }

    @Override
    public HijrahDate with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.with(temporalAdjuster);
    }

    public HijrahDate withVariant(HijrahChronology hijrahChronology) {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.chrono == hijrahChronology) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getDayOfYear:(II)I");
        int n2 = hijrahChronology.getDayOfYear(this.prolepticYear, this.monthOfYear);
        RuntimeCostAccounter.recordJump();
        if (this.dayOfMonth > n2) {
            n = n2;
            RuntimeCostAccounter.recordJump();
        } else {
            n = this.dayOfMonth;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.of:(Ljava/time/chrono/HijrahChronology;III)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.of(hijrahChronology, this.prolepticYear, this.monthOfYear, n);
    }

    @Override
    public HijrahDate plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.plus(temporalAmount);
    }

    @Override
    public HijrahDate minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.minus(temporalAmount);
    }

    @Override
    public long toEpochDay() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getEpochDay:(III)J");
        return this.chrono.getEpochDay(this.prolepticYear, this.monthOfYear, this.dayOfMonth);
    }

    private int getDayOfYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getDayOfYear:(II)I");
        return this.chrono.getDayOfYear(this.prolepticYear, this.monthOfYear) + this.dayOfMonth;
    }

    private int getDayOfWeek() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.toEpochDay:()J");
        long l = this.toEpochDay() + 3L;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n = (int)Math.floorMod(l, 7L);
        return n + 1;
    }

    private int getEraValue() {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.prolepticYear > 1) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean isLeapYear() {
        long l = this.prolepticYear;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.isLeapYear:(J)Z");
        return this.chrono.isLeapYear(l);
    }

    @Override
    HijrahDate plusYears(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        int n = (int)l;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(II)I");
        int n2 = Math.addExact(this.prolepticYear, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.resolvePreviousValid:(III)Ljava/time/chrono/HijrahDate;");
        return this.resolvePreviousValid(n2, this.monthOfYear, this.dayOfMonth);
    }

    @Override
    HijrahDate plusMonths(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.prolepticYear * 12L + (long)(this.monthOfYear - 1);
        long l3 = l2 + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l4 = Math.floorDiv(l3, 12L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.checkValidYear:(J)I");
        int n = this.chrono.checkValidYear(l4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n2 = (int)Math.floorMod(l3, 12L) + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.resolvePreviousValid:(III)Ljava/time/chrono/HijrahDate;");
        return this.resolvePreviousValid(n, n2, this.dayOfMonth);
    }

    @Override
    HijrahDate plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.plusWeeks(l);
    }

    @Override
    HijrahDate plusDays(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/HijrahDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.toEpochDay:()J");
        long l2 = this.toEpochDay() + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.<init>:(Ljava/time/chrono/HijrahChronology;J)V");
        return new HijrahDate(this.chrono, l2);
    }

    @Override
    public HijrahDate plus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.plus(l, temporalUnit);
    }

    @Override
    public HijrahDate minus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.minus(l, temporalUnit);
    }

    @Override
    HijrahDate minusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.minusYears(l);
    }

    @Override
    HijrahDate minusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusMonths:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.minusMonths(l);
    }

    @Override
    HijrahDate minusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.minusWeeks(l);
    }

    @Override
    HijrahDate minusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.minusDays(l);
    }

    public final ChronoLocalDateTime<HijrahDate> atTime(LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
        return super.atTime(localTime);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ChronoPeriod until(ChronoLocalDate var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getChronology:()Ljava/time/chrono/HijrahChronology;");
        v0 = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/HijrahDate;");
        var2_2 = v0.date(var1_1);
        var3_3 = (var2_2.prolepticYear - this.prolepticYear) * 12 + (var2_2.monthOfYear - this.monthOfYear);
        var5_4 = var2_2.dayOfMonth - this.dayOfMonth;
        RuntimeCostAccounter.recordJump();
        if (var3_3 <= 0L) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var5_4 < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusMonths:(J)Ljava/time/chrono/HijrahDate;");
            var6_5 = this.plusMonths(--var3_3);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.toEpochDay:()J");
            v1 = var2_2.toEpochDay();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.toEpochDay:()J");
            var5_4 = (int)(v1 - var6_5.toEpochDay());
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            RuntimeCostAccounter.recordJump();
            if (var3_3 < 0L) {
                RuntimeCostAccounter.recordJump();
                if (var5_4 > 0) {
                    ++var3_3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.lengthOfMonth:()I");
                    var5_4 -= var2_2.lengthOfMonth();
                }
            }
        }
        var7_6 = var3_3 / 12L;
        var9_7 = (int)(var3_3 % 12L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getChronology:()Ljava/time/chrono/HijrahChronology;");
        v2 = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
        v3 = Math.toIntExact(var7_6);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.period:(III)Ljava/time/chrono/ChronoPeriod;");
        return v2.period(v3, var9_7, var5_4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof HijrahDate;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        HijrahDate hijrahDate = (HijrahDate)object;
        int n = hijrahDate.prolepticYear;
        RuntimeCostAccounter.recordJump();
        if (this.prolepticYear != n) return false;
        int n2 = hijrahDate.monthOfYear;
        RuntimeCostAccounter.recordJump();
        if (this.monthOfYear != n2) return false;
        int n3 = hijrahDate.dayOfMonth;
        RuntimeCostAccounter.recordJump();
        if (this.dayOfMonth != n3) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getChronology:()Ljava/time/chrono/HijrahChronology;");
        HijrahChronology hijrahChronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getChronology:()Ljava/time/chrono/HijrahChronology;");
        HijrahChronology hijrahChronology2 = hijrahDate.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = hijrahChronology.equals(hijrahChronology2);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public int hashCode() {
        int n = this.prolepticYear;
        int n2 = this.monthOfYear;
        int n3 = this.dayOfMonth;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getChronology:()Ljava/time/chrono/HijrahChronology;");
        HijrahChronology hijrahChronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getId:()Ljava/lang/String;");
        String string = hijrahChronology.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
        return string.hashCode() ^ n & 0xFFFFF800 ^ (n << 11) + (n2 << 6) + n3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(6, this);
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.getChronology:()Ljava/time/chrono/HijrahChronology;");
        HijrahChronology hijrahChronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.writeObject:(Ljava/lang/Object;)V");
        objectOutput.writeObject(hijrahChronology);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n = this.get(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.writeInt:(I)V");
        objectOutput.writeInt(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n2 = this.get(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.writeByte:(I)V");
        objectOutput.writeByte(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n3 = this.get(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.writeByte:(I)V");
        objectOutput.writeByte(n3);
    }

    static HijrahDate readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInput.readObject:()Ljava/lang/Object;");
        HijrahChronology hijrahChronology = (HijrahChronology)objectInput.readObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInput.readInt:()I");
        int n = objectInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInput.readByte:()B");
        byte by = objectInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInput.readByte:()B");
        byte by2 = objectInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.date:(III)Ljava/time/chrono/HijrahDate;");
        return hijrahChronology.date(n, by, by2);
    }
}

