/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTimeImpl;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Comparator;
import sandbox.java.util.Objects;

public interface ChronoZonedDateTime<D extends ChronoLocalDate>
extends Temporal,
Comparable<ChronoZonedDateTime<?>> {
    public static Comparator<ChronoZonedDateTime<?>> timeLineOrder() {
        return AbstractChronology.INSTANT_ORDER;
    }

    public static ChronoZonedDateTime<?> from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof ChronoZonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (ChronoZonedDateTime)temporalAccessor;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery = TemporalQueries.chronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        Chronology chronology = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (chronology == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ChronoZonedDateTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.zonedDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoZonedDateTime;");
        return chronology.zonedDateTime(temporalAccessor);
    }

    @Override
    default public ValueRange range(TemporalField temporalField) {
        block2: {
            block4: {
                block3: {
                    boolean bl = temporalField instanceof ChronoField;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (temporalField == ChronoField.INSTANT_SECONDS) break block3;
                    RuntimeCostAccounter.recordJump();
                    if (temporalField != ChronoField.OFFSET_SECONDS) break block4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                return temporalField.range();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
            ChronoLocalDateTime<D> chronoLocalDateTime = this.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            return chronoLocalDateTime.range(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    default public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                    UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedTemporalTypeException;
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getOffset:()Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = this.getOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    return zoneOffset.getTotalSeconds();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
            ChronoLocalDateTime<D> chronoLocalDateTime = this.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.get:(Ljava/time/temporal/TemporalField;)I");
            return chronoLocalDateTime.get(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
        return Temporal.super.get(temporalField);
    }

    @Override
    default public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
                    return this.toEpochSecond();
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getOffset:()Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = this.getOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    return zoneOffset.getTotalSeconds();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
            ChronoLocalDateTime<D> chronoLocalDateTime = this.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getLong:(Ljava/time/temporal/TemporalField;)J");
            return chronoLocalDateTime.getLong(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    default public D toLocalDate() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
        ChronoLocalDateTime<D> chronoLocalDateTime = this.toLocalDateTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        return chronoLocalDateTime.toLocalDate();
    }

    default public LocalTime toLocalTime() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
        ChronoLocalDateTime<D> chronoLocalDateTime = this.toLocalDateTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        return chronoLocalDateTime.toLocalTime();
    }

    public ChronoLocalDateTime<D> toLocalDateTime();

    default public Chronology getChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        return d.getChronology();
    }

    public ZoneOffset getOffset();

    public ZoneId getZone();

    public ChronoZonedDateTime<D> withEarlierOffsetAtOverlap();

    public ChronoZonedDateTime<D> withLaterOffsetAtOverlap();

    public ChronoZonedDateTime<D> withZoneSameLocal(ZoneId var1);

    public ChronoZonedDateTime<D> withZoneSameInstant(ZoneId var1);

    @Override
    public boolean isSupported(TemporalField var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalUnit == ChronoUnit.FOREVER) return false;
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl3 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    default public ChronoZonedDateTime<D> with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.with(temporalAdjuster);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoZonedDateTimeImpl;");
        return ChronoZonedDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    public ChronoZonedDateTime<D> with(TemporalField var1, long var2);

    @Override
    default public ChronoZonedDateTime<D> plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.plus(temporalAmount);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoZonedDateTimeImpl;");
        return ChronoZonedDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    public ChronoZonedDateTime<D> plus(long var1, TemporalUnit var3);

    @Override
    default public ChronoZonedDateTime<D> minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.minus(temporalAmount);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoZonedDateTimeImpl;");
        return ChronoZonedDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public ChronoZonedDateTime<D> minus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
        Temporal temporal = Temporal.super.minus(l, temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoZonedDateTimeImpl;");
        return ChronoZonedDateTimeImpl.ensureValid(chronology, temporal);
    }

    @Override
    default public <R> R query(TemporalQuery<R> temporalQuery) {
        block8: {
            block7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery2 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery3 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery3) break block8;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getZone:()Ljava/time/ZoneId;");
            return (R)this.getZone();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<ZoneOffset> temporalQuery4 = TemporalQueries.offset();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getOffset:()Ljava/time/ZoneOffset;");
            return (R)this.getOffset();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalTime> temporalQuery5 = TemporalQueries.localTime();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            return (R)this.toLocalTime();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery6 = TemporalQueries.chronology();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getChronology:()Ljava/time/chrono/Chronology;");
            return (R)this.getChronology();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery7 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery7) {
            return (R)ChronoUnit.NANOS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    default public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    default public Instant toInstant() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        long l2 = localTime.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
        return Instant.ofEpochSecond(l, l2);
    }

    default public long toEpochSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = d.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toSecondOfDay:()I");
        long l2 = l * 86400L + (long)localTime.toSecondOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getOffset:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = this.getOffset();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        return l2 -= (long)zoneOffset.getTotalSeconds();
    }

    @Override
    default public int compareTo(ChronoZonedDateTime<?> chronoZonedDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l2 = chronoZonedDateTime.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(l, l2);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n2 = localTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoZonedDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            n = n2 - localTime2.getNano();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
                ChronoLocalDateTime<D> chronoLocalDateTime = this.toLocalDateTime();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
                ChronoLocalDateTime<?> chronoLocalDateTime2 = chronoZonedDateTime.toLocalDateTime();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.compareTo:(Ljava/time/chrono/ChronoLocalDateTime;)I");
                n = chronoLocalDateTime.compareTo(chronoLocalDateTime2);
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getZone:()Ljava/time/ZoneId;");
                    ZoneId zoneId = this.getZone();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
                    String string = zoneId.getId();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getZone:()Ljava/time/ZoneId;");
                    ZoneId zoneId2 = chronoZonedDateTime.getZone();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
                    String string2 = zoneId2.getId();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.compareTo:(Ljava/lang/String;)I");
                    n = string.compareTo(string2);
                    RuntimeCostAccounter.recordJump();
                    if (n == 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getChronology:()Ljava/time/chrono/Chronology;");
                        Chronology chronology = this.getChronology();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getChronology:()Ljava/time/chrono/Chronology;");
                        Chronology chronology2 = chronoZonedDateTime.getChronology();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.compareTo:(Ljava/time/chrono/Chronology;)I");
                        n = chronology.compareTo(chronology2);
                    }
                }
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isBefore(ChronoZonedDateTime<?> chronoZonedDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l2 = chronoZonedDateTime.toEpochSecond();
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordJump();
            if (l != l2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n = localTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoZonedDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n2 = localTime2.getNano();
            RuntimeCostAccounter.recordJump();
            if (n >= n2) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isAfter(ChronoZonedDateTime<?> chronoZonedDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l2 = chronoZonedDateTime.toEpochSecond();
        RuntimeCostAccounter.recordJump();
        if (l <= l2) {
            RuntimeCostAccounter.recordJump();
            if (l != l2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n = localTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoZonedDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            int n2 = localTime2.getNano();
            RuntimeCostAccounter.recordJump();
            if (n <= n2) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isEqual(ChronoZonedDateTime<?> chronoZonedDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l = this.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l2 = l - chronoZonedDateTime.toEpochSecond();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 != false) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        int n = localTime.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime2 = chronoZonedDateTime.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        int n2 = localTime2.getNano();
        RuntimeCostAccounter.recordJump();
        if (n != n2) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

