/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.util.Objects;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;

public final class ZoneOffset
extends ZoneId
implements TemporalAccessor,
TemporalAdjuster,
Comparable<ZoneOffset>,
Serializable {
    private static final ConcurrentMap<Integer, ZoneOffset> SECONDS_CACHE;
    private static final ConcurrentMap<String, ZoneOffset> ID_CACHE;
    private static final int MAX_SECONDS = 64800;
    private static final long serialVersionUID = 2357656521762053153L;
    public static final ZoneOffset UTC;
    public static final ZoneOffset MIN;
    public static final ZoneOffset MAX;
    private final int totalSeconds;
    private final transient String id;

    public static ZoneOffset of(String string) {
        int n;
        int n2;
        int n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "offsetId");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        ZoneOffset zoneOffset = (ZoneOffset)ID_CACHE.get(string);
        RuntimeCostAccounter.recordJump();
        if (zoneOffset != null) {
            return zoneOffset;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        switch (string.length()) {
            case 2: {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c = string.charAt(0);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(c);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append("0");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c2 = string.charAt(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(c2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder4.toString();
            }
            case 3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = 0;
                n = 0;
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n3 = ZoneOffset.parseNumber(string, 1, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n2 = ZoneOffset.parseNumber(string, 3, false);
                n = 0;
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n3 = ZoneOffset.parseNumber(string, 1, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n2 = ZoneOffset.parseNumber(string, 4, true);
                n = 0;
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n3 = ZoneOffset.parseNumber(string, 1, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n2 = ZoneOffset.parseNumber(string, 3, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n = ZoneOffset.parseNumber(string, 5, false);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 9: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n3 = ZoneOffset.parseNumber(string, 1, false);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n2 = ZoneOffset.parseNumber(string, 4, true);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.parseNumber:(Ljava/lang/CharSequence;IZ)I");
                n = ZoneOffset.parseNumber(string, 7, true);
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder.append("Invalid ID for ZoneOffset, invalid format: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder6.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string2);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        char c = string.charAt(0);
        RuntimeCostAccounter.recordJump();
        if (c != '+') {
            RuntimeCostAccounter.recordJump();
            if (c != '-') {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder.append("Invalid ID for ZoneOffset, plus/minus not found when expected: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder8.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string3);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (c == '-') {
            int n4 = -n3;
            int n5 = -n2;
            int n6 = -n;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofHoursMinutesSeconds:(III)Ljava/time/ZoneOffset;");
            return ZoneOffset.ofHoursMinutesSeconds(n4, n5, n6);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofHoursMinutesSeconds:(III)Ljava/time/ZoneOffset;");
        return ZoneOffset.ofHoursMinutesSeconds(n3, n2, n);
    }

    private static int parseNumber(CharSequence charSequence, int n, boolean bl) {
        char c;
        char c2;
        block6: {
            block5: {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    char c3 = charSequence.charAt(n - 1);
                    RuntimeCostAccounter.recordJump();
                    if (c3 != ':') {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("Invalid ID for ZoneOffset, colon not found when expected: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append((Object)charSequence);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                c2 = charSequence.charAt(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                c = charSequence.charAt(n + 1);
                RuntimeCostAccounter.recordJump();
                if (c2 < '0') break block5;
                RuntimeCostAccounter.recordJump();
                if (c2 > '9') break block5;
                RuntimeCostAccounter.recordJump();
                if (c < '0') break block5;
                RuntimeCostAccounter.recordJump();
                if (c <= '9') break block6;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("Invalid ID for ZoneOffset, non numeric characters found: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append((Object)charSequence);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return (c2 - 48) * 10 + (c - 48);
    }

    public static ZoneOffset ofHours(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofHoursMinutesSeconds:(III)Ljava/time/ZoneOffset;");
        return ZoneOffset.ofHoursMinutesSeconds(n, 0, 0);
    }

    public static ZoneOffset ofHoursMinutes(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofHoursMinutesSeconds:(III)Ljava/time/ZoneOffset;");
        return ZoneOffset.ofHoursMinutesSeconds(n, n2, 0);
    }

    public static ZoneOffset ofHoursMinutesSeconds(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.validate:(III)V");
        ZoneOffset.validate(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.totalSeconds:(III)I");
        int n4 = ZoneOffset.totalSeconds(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
        return ZoneOffset.ofTotalSeconds(n4);
    }

    public static ZoneOffset from(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<ZoneOffset> temporalQuery = TemporalQueries.offset();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        ZoneOffset zoneOffset = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (zoneOffset == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ZoneOffset from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string2);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return zoneOffset;
    }

    private static void validate(int n, int n2, int n3) {
        block27: {
            block28: {
                block22: {
                    block26: {
                        block25: {
                            block23: {
                                block24: {
                                    block20: {
                                        block21: {
                                            block19: {
                                                block18: {
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n < -18) break block18;
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n <= 18) break block19;
                                                }
                                                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                                                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                StringBuilder stringBuilder = new StringBuilder();
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                StringBuilder stringBuilder2 = stringBuilder.append("Zone offset hours not in valid range: value ");
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                                                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                StringBuilder stringBuilder4 = stringBuilder3.append(" is not in the range -18 to 18");
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                String string = stringBuilder4.toString();
                                                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                                                DateTimeException dateTimeException = new DateTimeException(string);
                                                RuntimeCostAccounter.recordThrow();
                                                throw dateTimeException;
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            if (n <= 0) break block20;
                                            RuntimeCostAccounter.recordJump();
                                            if (n2 < 0) break block21;
                                            RuntimeCostAccounter.recordJump();
                                            if (n3 >= 0) break block22;
                                        }
                                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                                        DateTimeException dateTimeException = new DateTimeException("Zone offset minutes and seconds must be positive because hours is positive");
                                        RuntimeCostAccounter.recordThrow();
                                        throw dateTimeException;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (n >= 0) break block23;
                                    RuntimeCostAccounter.recordJump();
                                    if (n2 > 0) break block24;
                                    RuntimeCostAccounter.recordJump();
                                    if (n3 <= 0) break block22;
                                }
                                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                                DateTimeException dateTimeException = new DateTimeException("Zone offset minutes and seconds must be negative because hours is negative");
                                RuntimeCostAccounter.recordThrow();
                                throw dateTimeException;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (n2 <= 0) break block25;
                            RuntimeCostAccounter.recordJump();
                            if (n3 < 0) break block26;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n2 >= 0) break block22;
                        RuntimeCostAccounter.recordJump();
                        if (n3 <= 0) break block22;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException("Zone offset minutes and seconds must have the same sign");
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                int n4 = Math.abs(n2);
                RuntimeCostAccounter.recordJump();
                if (n4 > 59) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder.append("Zone offset minutes not in valid range: abs(value) ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                    int n5 = Math.abs(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder5.append(n5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(" is not in the range 0 to 59");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder7.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                int n6 = Math.abs(n3);
                RuntimeCostAccounter.recordJump();
                if (n6 > 59) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder8 = stringBuilder.append("Zone offset seconds not in valid range: abs(value) ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                    int n7 = Math.abs(n3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder9 = stringBuilder8.append(n7);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder10 = stringBuilder9.append(" is not in the range 0 to 59");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder10.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                int n8 = Math.abs(n);
                RuntimeCostAccounter.recordJump();
                if (n8 != 18) break block27;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                int n9 = Math.abs(n2);
                RuntimeCostAccounter.recordJump();
                if (n9 > 0) break block28;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                int n10 = Math.abs(n3);
                RuntimeCostAccounter.recordJump();
                if (n10 <= 0) break block27;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
    }

    private static int totalSeconds(int n, int n2, int n3) {
        return n * 3600 + n2 * 60 + n3;
    }

    public static ZoneOffset ofTotalSeconds(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
        int n2 = Math.abs(n);
        RuntimeCostAccounter.recordJump();
        if (n2 > 64800) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordJump();
        if (n % 900 == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            Integer n3 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            ZoneOffset zoneOffset = (ZoneOffset)SECONDS_CACHE.get(n3);
            RuntimeCostAccounter.recordJump();
            if (zoneOffset == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/ZoneOffset");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.<init>:(I)V");
                zoneOffset = new ZoneOffset(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                SECONDS_CACHE.putIfAbsent(n3, zoneOffset);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                zoneOffset = (ZoneOffset)SECONDS_CACHE.get(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getId:()Ljava/lang/String;");
                String string = zoneOffset.getId();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                ID_CACHE.putIfAbsent(string, zoneOffset);
            }
            return zoneOffset;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/ZoneOffset");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.<init>:(I)V");
        return new ZoneOffset(n);
    }

    private ZoneOffset(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.<init>:()V");
        this.totalSeconds = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.buildId:(I)Ljava/lang/String;");
        this.id = ZoneOffset.buildId(n);
    }

    private static String buildId(int n) {
        String string;
        String string2;
        String string3;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return "Z";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
        int n2 = Math.abs(n);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n2 / 3600;
        int n4 = n2 / 60 % 60;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            string3 = "-";
            RuntimeCostAccounter.recordJump();
        } else {
            string3 = "+";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        RuntimeCostAccounter.recordJump();
        if (n3 < 10) {
            string2 = "0";
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = "";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(n3);
        RuntimeCostAccounter.recordJump();
        if (n4 < 10) {
            string = ":0";
            RuntimeCostAccounter.recordJump();
        } else {
            string = ":";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        stringBuilder5.append(n4);
        int n5 = n2 % 60;
        RuntimeCostAccounter.recordJump();
        if (n5 != 0) {
            String string4;
            RuntimeCostAccounter.recordJump();
            if (n5 < 10) {
                string4 = ":0";
                RuntimeCostAccounter.recordJump();
            } else {
                string4 = ":";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder.append(string4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            stringBuilder6.append(n5);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    public int getTotalSeconds() {
        return this.totalSeconds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ZoneRules getRules() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.of:(Ljava/time/ZoneOffset;)Ljava/time/zone/ZoneRules;");
        return ZoneRules.of(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField != ChronoField.OFFSET_SECONDS) return false;
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl3 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        return TemporalAccessor.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.OFFSET_SECONDS) {
            return this.totalSeconds;
        }
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = this.getLong(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        return valueRange.checkValidIntValue(l, temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.OFFSET_SECONDS) {
            return this.totalSeconds;
        }
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneOffset> temporalQuery2 = TemporalQueries.offset();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery3 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery3) break block3;
            }
            return (R)this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return TemporalAccessor.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        long l = this.totalSeconds;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal.with(ChronoField.OFFSET_SECONDS, l);
    }

    @Override
    public int compareTo(ZoneOffset zoneOffset) {
        return zoneOffset.totalSeconds - this.totalSeconds;
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof ZoneOffset;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            int n = ((ZoneOffset)object).totalSeconds;
            RuntimeCostAccounter.recordJump();
            if (this.totalSeconds == n) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.totalSeconds;
    }

    @Override
    public String toString() {
        return this.id;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(8, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(8);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.writeExternal:(Ljava/io/DataOutput;)V");
        this.writeExternal(dataOutput);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        int n;
        int n2 = this.totalSeconds;
        RuntimeCostAccounter.recordJump();
        if (n2 % 900 == 0) {
            n = n2 / 900;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 127;
        }
        int n3 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n3);
        RuntimeCostAccounter.recordJump();
        if (n3 == 127) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
            dataOutput.writeInt(n2);
        }
    }

    static ZoneOffset readExternal(DataInput dataInput) throws IOException {
        ZoneOffset zoneOffset;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordJump();
        if (by == 127) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
            int n = dataInput.readInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset = ZoneOffset.ofTotalSeconds(n);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            zoneOffset = ZoneOffset.ofTotalSeconds(by * 900);
        }
        return zoneOffset;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:(IFI)V");
        SECONDS_CACHE = new ConcurrentHashMap<Integer, ZoneOffset>(16, 0.75f, 4);
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:(IFI)V");
        ID_CACHE = new ConcurrentHashMap<String, ZoneOffset>(16, 0.75f, 4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
        UTC = ZoneOffset.ofTotalSeconds(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
        MIN = ZoneOffset.ofTotalSeconds(-64800);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
        MAX = ZoneOffset.ofTotalSeconds(64800);
    }
}

