/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.LocalDate;
import sandbox.java.time.Month;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.format.DateTimeFormatterBuilder;
import sandbox.java.time.format.SignStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;

public final class YearMonth
implements Temporal,
TemporalAdjuster,
Comparable<YearMonth>,
Serializable {
    private static final long serialVersionUID = 4183400860270640070L;
    private static final DateTimeFormatter PARSER;
    private final int year;
    private final int month;

    public static YearMonth now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.now:(Ljava/time/Clock;)Ljava/time/YearMonth;");
        return YearMonth.now(clock);
    }

    public static YearMonth now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.now:(Ljava/time/Clock;)Ljava/time/YearMonth;");
        return YearMonth.now(clock);
    }

    public static YearMonth now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
        int n = localDate.getYear();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonth:()Ljava/time/Month;");
        Month month = localDate.getMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.of:(ILjava/time/Month;)Ljava/time/YearMonth;");
        return YearMonth.of(n, month);
    }

    public static YearMonth of(int n, Month month) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(month, "month");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.getValue:()I");
        int n2 = month.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.of:(II)Ljava/time/YearMonth;");
        return YearMonth.of(n, n2);
    }

    public static YearMonth of(int n, int n2) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.YEAR.checkValidValue(l);
        long l2 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MONTH_OF_YEAR.checkValidValue(l2);
        RuntimeCostAccounter.recordAllocation((String)"java/time/YearMonth");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.<init>:(II)V");
        return new YearMonth(n, n2);
    }

    public static YearMonth from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof YearMonth;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (YearMonth)temporalAccessor;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
            Chronology chronology = Chronology.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = IsoChronology.INSTANCE.equals(chronology);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n = temporalAccessor.get(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.of:(II)Ljava/time/YearMonth;");
            return YearMonth.of(n, n2);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain YearMonth from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static YearMonth parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/YearMonth;");
        return YearMonth.parse(charSequence, PARSER);
    }

    public static YearMonth parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<YearMonth> temporalQuery = YearMonth::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private YearMonth(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.year = n;
        this.month = n2;
    }

    private YearMonth with(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (this.year == n) {
            RuntimeCostAccounter.recordJump();
            if (this.month == n2) {
                return this;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/YearMonth");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.<init>:(II)V");
        return new YearMonth(n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField != ChronoField.YEAR) {
                RuntimeCostAccounter.recordJump();
                if (temporalField != ChronoField.MONTH_OF_YEAR) {
                    RuntimeCostAccounter.recordJump();
                    if (temporalField != ChronoField.PROLEPTIC_MONTH) {
                        RuntimeCostAccounter.recordJump();
                        if (temporalField != ChronoField.YEAR_OF_ERA) {
                            RuntimeCostAccounter.recordJump();
                            if (temporalField != ChronoField.ERA) return false;
                        }
                    }
                }
            }
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl3 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalUnit != ChronoUnit.MONTHS) {
                RuntimeCostAccounter.recordJump();
                if (temporalUnit != ChronoUnit.YEARS) {
                    RuntimeCostAccounter.recordJump();
                    if (temporalUnit != ChronoUnit.DECADES) {
                        RuntimeCostAccounter.recordJump();
                        if (temporalUnit != ChronoUnit.CENTURIES) {
                            RuntimeCostAccounter.recordJump();
                            if (temporalUnit != ChronoUnit.MILLENNIA) {
                                RuntimeCostAccounter.recordJump();
                                if (temporalUnit != ChronoUnit.ERAS) return false;
                            }
                        }
                    }
                }
            }
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl3 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.YEAR_OF_ERA) {
            ValueRange valueRange;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getYear:()I");
            int n = this.getYear();
            RuntimeCostAccounter.recordJump();
            if (n <= 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                valueRange = ValueRange.of(1L, 1000000000L);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                valueRange = ValueRange.of(1L, 999999999L);
            }
            return valueRange;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        return Temporal.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = this.getLong(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        return valueRange.checkValidIntValue(l, temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    return this.month;
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getProlepticMonth:()J");
                    return this.getProlepticMonth();
                }
                case 3: {
                    int n;
                    RuntimeCostAccounter.recordJump();
                    if (this.year < 1) {
                        n = 1 - this.year;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = this.year;
                    }
                    return n;
                }
                case 4: {
                    return this.year;
                }
                case 5: {
                    int n;
                    RuntimeCostAccounter.recordJump();
                    if (this.year < 1) {
                        n = 0;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = 1;
                    }
                    return n;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.year * 12L + (long)this.month - 1L;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonthValue() {
        return this.month;
    }

    public Month getMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
        return Month.of(this.month);
    }

    public boolean isLeapYear() {
        long l = this.year;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
        return IsoChronology.INSTANCE.isLeapYear(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidDay(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 1) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.lengthOfMonth:()I");
        int n2 = this.lengthOfMonth();
        RuntimeCostAccounter.recordJump();
        if (n > n2) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public int lengthOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getMonth:()Ljava/time/Month;");
        Month month = this.getMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.isLeapYear:()Z");
        boolean bl = this.isLeapYear();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.length:(Z)I");
        return month.length(bl);
    }

    public int lengthOfYear() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.isLeapYear:()Z");
        boolean bl = this.isLeapYear();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = 366;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 365;
        }
        return n;
    }

    @Override
    public YearMonth with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (YearMonth)temporalAdjuster.adjustInto(this);
    }

    @Override
    public YearMonth with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
            chronoField.checkValidValue(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.withMonth:(I)Ljava/time/YearMonth;");
                    return this.withMonth(n);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getProlepticMonth:()J");
                    long l2 = l - this.getProlepticMonth();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusMonths:(J)Ljava/time/YearMonth;");
                    return this.plusMonths(l2);
                }
                case 3: {
                    long l3;
                    RuntimeCostAccounter.recordJump();
                    if (this.year < 1) {
                        l3 = 1L - l;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l3 = l;
                    }
                    int n = (int)l3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.withYear:(I)Ljava/time/YearMonth;");
                    return this.withYear(n);
                }
                case 4: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.withYear:(I)Ljava/time/YearMonth;");
                    return this.withYear(n);
                }
                case 5: {
                    YearMonth yearMonth;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l4 = this.getLong(ChronoField.ERA) - l;
                    long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l5 == false) {
                        yearMonth = this;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.withYear:(I)Ljava/time/YearMonth;");
                        yearMonth = this.withYear(1 - this.year);
                    }
                    return yearMonth;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public YearMonth withYear(int n) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.YEAR.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.with:(II)Ljava/time/YearMonth;");
        return this.with(n, this.month);
    }

    public YearMonth withMonth(int n) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MONTH_OF_YEAR.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.with:(II)Ljava/time/YearMonth;");
        return this.with(this.year, n);
    }

    @Override
    public YearMonth plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (YearMonth)temporalAmount.addTo(this);
    }

    @Override
    public YearMonth plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusMonths:(J)Ljava/time/YearMonth;");
                    return this.plusMonths(l);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusYears:(J)Ljava/time/YearMonth;");
                    return this.plusYears(l);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l2 = Math.multiplyExact(l, 10L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusYears:(J)Ljava/time/YearMonth;");
                    return this.plusYears(l2);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l3 = Math.multiplyExact(l, 100L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusYears:(J)Ljava/time/YearMonth;");
                    return this.plusYears(l3);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l4 = Math.multiplyExact(l, 1000L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusYears:(J)Ljava/time/YearMonth;");
                    return this.plusYears(l4);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l5 = this.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                    long l6 = Math.addExact(l5, l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/YearMonth;");
                    return this.with(ChronoField.ERA, l6);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public YearMonth plusYears(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.year + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n = ChronoField.YEAR.checkValidIntValue(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.with:(II)Ljava/time/YearMonth;");
        return this.with(n, this.month);
    }

    public YearMonth plusMonths(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.year * 12L + (long)(this.month - 1);
        long l3 = l2 + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l4 = Math.floorDiv(l3, 12L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n = ChronoField.YEAR.checkValidIntValue(l4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n2 = (int)Math.floorMod(l3, 12L) + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.with:(II)Ljava/time/YearMonth;");
        return this.with(n, n2);
    }

    @Override
    public YearMonth minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (YearMonth)temporalAmount.subtractFrom(this);
    }

    @Override
    public YearMonth minus(long l, TemporalUnit temporalUnit) {
        YearMonth yearMonth;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/YearMonth;");
            YearMonth yearMonth2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/YearMonth;");
            yearMonth = yearMonth2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/YearMonth;");
            yearMonth = this.plus(l2, temporalUnit);
        }
        return yearMonth;
    }

    public YearMonth minusYears(long l) {
        YearMonth yearMonth;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusYears:(J)Ljava/time/YearMonth;");
            YearMonth yearMonth2 = this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusYears:(J)Ljava/time/YearMonth;");
            yearMonth = yearMonth2.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusYears:(J)Ljava/time/YearMonth;");
            yearMonth = this.plusYears(l2);
        }
        return yearMonth;
    }

    public YearMonth minusMonths(long l) {
        YearMonth yearMonth;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusMonths:(J)Ljava/time/YearMonth;");
            YearMonth yearMonth2 = this.plusMonths(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusMonths:(J)Ljava/time/YearMonth;");
            yearMonth = yearMonth2.plusMonths(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.plusMonths:(J)Ljava/time/YearMonth;");
            yearMonth = this.plusMonths(l2);
        }
        return yearMonth;
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery2 = TemporalQueries.chronology();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery2) {
            return (R)IsoChronology.INSTANCE;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery3 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery3) {
            return (R)ChronoUnit.MONTHS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return Temporal.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
        Chronology chronology = Chronology.from(temporal);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
        boolean bl = chronology.equals(IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Adjustment only supported on ISO date-time");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getProlepticMonth:()J");
        long l = this.getProlepticMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal.with(ChronoField.PROLEPTIC_MONTH, l);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/YearMonth;");
        YearMonth yearMonth = YearMonth.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getProlepticMonth:()J");
            long l = yearMonth.getProlepticMonth();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getProlepticMonth:()J");
            long l2 = l - this.getProlepticMonth();
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    return l2;
                }
                case 2: {
                    return l2 / 12L;
                }
                case 3: {
                    return l2 / 120L;
                }
                case 4: {
                    return l2 / 1200L;
                }
                case 5: {
                    return l2 / 12000L;
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l3 = yearMonth.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.getLong:(Ljava/time/temporal/TemporalField;)J");
                    return l3 - this.getLong(ChronoField.ERA);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, yearMonth);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public LocalDate atDay(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        return LocalDate.of(this.year, this.month, n);
    }

    public LocalDate atEndOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.lengthOfMonth:()I");
        int n = this.lengthOfMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        return LocalDate.of(this.year, this.month, n);
    }

    @Override
    public int compareTo(YearMonth yearMonth) {
        int n = this.year - yearMonth.year;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            n = this.month - yearMonth.month;
        }
        return n;
    }

    public boolean isAfter(YearMonth yearMonth) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.compareTo:(Ljava/time/YearMonth;)I");
        int n = this.compareTo(yearMonth);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isBefore(YearMonth yearMonth) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.compareTo:(Ljava/time/YearMonth;)I");
        int n = this.compareTo(yearMonth);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof YearMonth;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        YearMonth yearMonth = (YearMonth)object;
        int n = yearMonth.year;
        RuntimeCostAccounter.recordJump();
        if (this.year != n) return false;
        int n2 = yearMonth.month;
        RuntimeCostAccounter.recordJump();
        if (this.month != n2) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        return this.year ^ this.month << 27;
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
        int n = Math.abs(this.year);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        StringBuilder stringBuilder = new StringBuilder(9);
        RuntimeCostAccounter.recordJump();
        if (n < 1000) {
            RuntimeCostAccounter.recordJump();
            if (this.year < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(this.year - 10000);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.deleteCharAt:(I)Ljava/lang/StringBuilder;");
                stringBuilder2.deleteCharAt(1);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder.append(this.year + 10000);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.deleteCharAt:(I)Ljava/lang/StringBuilder;");
                stringBuilder3.deleteCharAt(0);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            stringBuilder.append(this.year);
        }
        RuntimeCostAccounter.recordJump();
        if (this.month < 10) {
            string = "-0";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "-";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(this.month);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder5.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(12, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.year);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(this.month);
    }

    static YearMonth readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/YearMonth.of:(II)Ljava/time/YearMonth;");
        return YearMonth.of(n, by);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder3 = dateTimeFormatterBuilder2.appendLiteral('-');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder4 = dateTimeFormatterBuilder3.appendValue(ChronoField.MONTH_OF_YEAR, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:()Ljava/time/format/DateTimeFormatter;");
        PARSER = dateTimeFormatterBuilder4.toFormatter();
    }
}

