/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.math.BigDecimal;
import sandbox.java.math.BigInteger;
import sandbox.java.math.RoundingMode;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Ser;
import sandbox.java.time.format.DateTimeParseException;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collections;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Objects;
import sandbox.java.util.regex.Matcher;
import sandbox.java.util.regex.Pattern;

public final class Duration
implements TemporalAmount,
Comparable<Duration>,
Serializable {
    public static final Duration ZERO;
    private static final long serialVersionUID = 3078945930695997490L;
    private static final BigInteger BI_NANOS_PER_SECOND;
    private static final Pattern PATTERN;
    private final long seconds;
    private final int nanos;

    public static Duration ofDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 86400L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l2, 0);
    }

    public static Duration ofHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 3600L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l2, 0);
    }

    public static Duration ofMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 60L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l2, 0);
    }

    public static Duration ofSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l, 0);
    }

    public static Duration ofSeconds(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l3 = Math.floorDiv(l2, 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l4 = Math.addExact(l, l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n = (int)Math.floorMod(l2, 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l4, n);
    }

    public static Duration ofMillis(long l) {
        long l2 = l / 1000L;
        int n = (int)(l % 1000L);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            n += 1000;
            --l2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l2, n * 1000000);
    }

    public static Duration ofNanos(long l) {
        long l2 = l / 1000000000L;
        int n = (int)(l % 1000000000L);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            n = (int)((long)n + 1000000000L);
            --l2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l2, n);
    }

    public static Duration of(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Duration;");
        return ZERO.plus(l, temporalUnit);
    }

    public static Duration from(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amount");
        Duration duration = ZERO;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.getUnits:()Ljava/util/List;");
        List<TemporalUnit> list = temporalAmount.getUnits();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
        Iterator<TemporalUnit> iterator = list.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            TemporalUnit temporalUnit = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.get:(Ljava/time/temporal/TemporalUnit;)J");
            long l = temporalAmount.get(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Duration;");
            duration = duration.plus(l, temporalUnit);
            RuntimeCostAccounter.recordJump();
        }
        return duration;
    }

    public static Duration parse(CharSequence charSequence) {
        block7: {
            int n;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            boolean bl;
            block8: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(charSequence, "text");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.matcher:(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;");
                Matcher matcher = PATTERN.matcher(charSequence);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.matches:()Z");
                boolean bl2 = matcher.matches();
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string6 = matcher.group(3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl3 = "T".equals(string6);
                RuntimeCostAccounter.recordJump();
                if (bl3) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                String string7 = matcher.group(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                bl = "-".equals(string7);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string5 = matcher.group(2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string4 = matcher.group(4);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string3 = matcher.group(5);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string2 = matcher.group(6);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Matcher.group:(I)Ljava/lang/String;");
                string = matcher.group(7);
                RuntimeCostAccounter.recordJump();
                if (string5 != null) break block8;
                RuntimeCostAccounter.recordJump();
                if (string4 != null) break block8;
                RuntimeCostAccounter.recordJump();
                if (string3 != null) break block8;
                RuntimeCostAccounter.recordJump();
                if (string2 == null) break block7;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;ILjava/lang/String;)J");
            long l = Duration.parseNumber(charSequence, string5, 86400, "days");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;ILjava/lang/String;)J");
            long l2 = Duration.parseNumber(charSequence, string4, 3600, "hours");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;ILjava/lang/String;)J");
            long l3 = Duration.parseNumber(charSequence, string3, 60, "minutes");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.parseNumber:(Ljava/lang/CharSequence;Ljava/lang/String;ILjava/lang/String;)J");
            long l4 = Duration.parseNumber(charSequence, string2, 1, "seconds");
            RuntimeCostAccounter.recordJump();
            if (l4 < 0L) {
                n = -1;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.parseFraction:(Ljava/lang/CharSequence;Ljava/lang/String;I)I");
            int n2 = Duration.parseFraction(charSequence, string, n);
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(ZJJJJI)Ljava/time/Duration;");
                return Duration.create(bl, l, l2, l3, l4, n2);
            }
            catch (ArithmeticException arithmeticException) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;I)V");
                DateTimeParseException dateTimeParseException = new DateTimeParseException("Text cannot be parsed to a Duration: overflow", charSequence, 0);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
                DateTimeParseException dateTimeParseException2 = (DateTimeParseException)dateTimeParseException.initCause(arithmeticException);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeParseException2;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;I)V");
        DateTimeParseException dateTimeParseException = new DateTimeParseException("Text cannot be parsed to a Duration", charSequence, 0);
        RuntimeCostAccounter.recordThrow();
        throw dateTimeParseException;
    }

    private static long parseNumber(CharSequence charSequence, String string, int n, String string2) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            return 0L;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.parseLong:(Ljava/lang/String;)J");
            long l = Long.parseLong(string);
            long l2 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
            return Math.multiplyExact(l, l2);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Text cannot be parsed to a Duration: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;I)V");
            DateTimeParseException dateTimeParseException = new DateTimeParseException(string3, charSequence, 0);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
            DateTimeParseException dateTimeParseException2 = (DateTimeParseException)dateTimeParseException.initCause(runtimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException2;
        }
    }

    private static int parseFraction(CharSequence charSequence, String string, int n) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (string == null) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n2 = string.length();
                RuntimeCostAccounter.recordJump();
                if (n2 != 0) break block5;
            }
            return 0;
        }
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("000000000");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            string = string2.substring(0, 9);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
            return Integer.parseInt(string) * n;
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.<init>:(Ljava/lang/String;Ljava/lang/CharSequence;I)V");
            DateTimeParseException dateTimeParseException = new DateTimeParseException("Text cannot be parsed to a Duration: fraction", charSequence, 0);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseException.initCause:(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
            DateTimeParseException dateTimeParseException2 = (DateTimeParseException)dateTimeParseException.initCause(runtimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeParseException2;
        }
    }

    private static Duration create(boolean bl, long l, long l2, long l3, long l4, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l5 = Math.addExact(l3, l4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l6 = Math.addExact(l2, l5);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l7 = Math.addExact(l, l6);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            long l8 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(JJ)Ljava/time/Duration;");
            Duration duration = Duration.ofSeconds(l7, l8);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.negated:()Ljava/time/Duration;");
            return duration.negated();
        }
        long l9 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(JJ)Ljava/time/Duration;");
        return Duration.ofSeconds(l7, l9);
    }

    public static Duration between(Temporal temporal, Temporal temporal2) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
            long l = temporal.until(temporal2, ChronoUnit.NANOS);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofNanos:(J)Ljava/time/Duration;");
            return Duration.ofNanos(l);
        }
        catch (ArithmeticException | DateTimeException runtimeException) {
            long l;
            long l2;
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
                l2 = temporal.until(temporal2, ChronoUnit.SECONDS);
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l3 = temporal2.getLong(ChronoField.NANO_OF_SECOND);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.getLong:(Ljava/time/temporal/TemporalField;)J");
                    l = l3 - temporal.getLong(ChronoField.NANO_OF_SECOND);
                    RuntimeCostAccounter.recordJump();
                    if (l2 > 0L) {
                        RuntimeCostAccounter.recordJump();
                        if (l < 0L) {
                            ++l2;
                            RuntimeCostAccounter.recordJump();
                            break block6;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (l2 >= 0L) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (l <= 0L) break block6;
                    --l2;
                }
                catch (DateTimeException dateTimeException) {
                    l = 0L;
                }
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(JJ)Ljava/time/Duration;");
            return Duration.ofSeconds(l2, l);
        }
    }

    private static Duration create(long l, int n) {
        long l2 = (l | (long)n) - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 == false) {
            return ZERO;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/Duration");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.<init>:(JI)V");
        return new Duration(l, n);
    }

    private Duration(long l, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.seconds = l;
        this.nanos = n;
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.SECONDS) {
            return this.seconds;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.NANOS) {
            return this.nanos;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
        UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
        RuntimeCostAccounter.recordThrow();
        throw unsupportedTemporalTypeException;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return DurationUnits.UNITS;
    }

    public boolean isZero() {
        boolean bl;
        long l = (this.seconds | (long)this.nanos) - 0L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 == false) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isNegative() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.seconds < 0L) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNano() {
        return this.nanos;
    }

    public Duration withSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(l, this.nanos);
    }

    public Duration withNanos(int n) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        ChronoField.NANO_OF_SECOND.checkValidIntValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(JI)Ljava/time/Duration;");
        return Duration.create(this.seconds, n);
    }

    public Duration plus(Duration duration) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getSeconds:()J");
        long l = duration.getSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getNano:()I");
        long l2 = duration.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(l, l2);
    }

    public Duration plus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalUnit, "unit");
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == ChronoUnit.DAYS) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
            long l2 = Math.multiplyExact(l, 86400L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
            return this.plus(l2, 0L);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isDurationEstimated:()Z");
        boolean bl = temporalUnit.isDurationEstimated();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Unit must not have an estimated duration");
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        boolean bl2 = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusNanos:(J)Ljava/time/Duration;");
                    return this.plusNanos(l);
                }
                case 2: {
                    long l3 = l / 1000000000L * 1000L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusSeconds:(J)Ljava/time/Duration;");
                    Duration duration = this.plusSeconds(l3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusNanos:(J)Ljava/time/Duration;");
                    return duration.plusNanos(l % 1000000000L * 1000L);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusMillis:(J)Ljava/time/Duration;");
                    return this.plusMillis(l);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusSeconds:(J)Ljava/time/Duration;");
                    return this.plusSeconds(l);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.getDuration:()Ljava/time/Duration;");
            long l4 = temporalUnit.getDuration().seconds;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
            long l5 = Math.multiplyExact(l4, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusSeconds:(J)Ljava/time/Duration;");
            return this.plusSeconds(l5);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.getDuration:()Ljava/time/Duration;");
        Duration duration = temporalUnit.getDuration();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.multipliedBy:(J)Ljava/time/Duration;");
        Duration duration2 = duration.multipliedBy(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getSeconds:()J");
        long l6 = duration2.getSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusSeconds:(J)Ljava/time/Duration;");
        Duration duration3 = this.plusSeconds(l6);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getNano:()I");
        long l7 = duration2.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusNanos:(J)Ljava/time/Duration;");
        return duration3.plusNanos(l7);
    }

    public Duration plusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 86400L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(l2, 0L);
    }

    public Duration plusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 3600L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(l2, 0L);
    }

    public Duration plusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 60L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(l2, 0L);
    }

    public Duration plusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(l, 0L);
    }

    public Duration plusMillis(long l) {
        long l2 = l / 1000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(l2, l % 1000L * 1000000L);
    }

    public Duration plusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(0L, l);
    }

    private Duration plus(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if ((l | l2) == 0L) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l3 = Math.addExact(this.seconds, l);
        long l4 = l2 / 1000000000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        l3 = Math.addExact(l3, l4);
        long l5 = (long)this.nanos + (l2 %= 1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(JJ)Ljava/time/Duration;");
        return Duration.ofSeconds(l3, l5);
    }

    public Duration minus(Duration duration) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getSeconds:()J");
        long l = duration.getSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getNano:()I");
        int n = duration.getNano();
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            long l2 = -n;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
            Duration duration2 = this.plus(Long.MAX_VALUE, l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
            return duration2.plus(1L, 0L);
        }
        long l3 = -l;
        long l4 = -n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JJ)Ljava/time/Duration;");
        return this.plus(l3, l4);
    }

    public Duration minus(long l, TemporalUnit temporalUnit) {
        Duration duration;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Duration;");
            Duration duration2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Duration;");
            duration = duration2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/Duration;");
            duration = this.plus(l2, temporalUnit);
        }
        return duration;
    }

    public Duration minusDays(long l) {
        Duration duration;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusDays:(J)Ljava/time/Duration;");
            Duration duration2 = this.plusDays(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusDays:(J)Ljava/time/Duration;");
            duration = duration2.plusDays(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusDays:(J)Ljava/time/Duration;");
            duration = this.plusDays(l2);
        }
        return duration;
    }

    public Duration minusHours(long l) {
        Duration duration;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusHours:(J)Ljava/time/Duration;");
            Duration duration2 = this.plusHours(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusHours:(J)Ljava/time/Duration;");
            duration = duration2.plusHours(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusHours:(J)Ljava/time/Duration;");
            duration = this.plusHours(l2);
        }
        return duration;
    }

    public Duration minusMinutes(long l) {
        Duration duration;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusMinutes:(J)Ljava/time/Duration;");
            Duration duration2 = this.plusMinutes(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusMinutes:(J)Ljava/time/Duration;");
            duration = duration2.plusMinutes(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusMinutes:(J)Ljava/time/Duration;");
            duration = this.plusMinutes(l2);
        }
        return duration;
    }

    public Duration minusSeconds(long l) {
        Duration duration;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusSeconds:(J)Ljava/time/Duration;");
            Duration duration2 = this.plusSeconds(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusSeconds:(J)Ljava/time/Duration;");
            duration = duration2.plusSeconds(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusSeconds:(J)Ljava/time/Duration;");
            duration = this.plusSeconds(l2);
        }
        return duration;
    }

    public Duration minusMillis(long l) {
        Duration duration;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusMillis:(J)Ljava/time/Duration;");
            Duration duration2 = this.plusMillis(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusMillis:(J)Ljava/time/Duration;");
            duration = duration2.plusMillis(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusMillis:(J)Ljava/time/Duration;");
            duration = this.plusMillis(l2);
        }
        return duration;
    }

    public Duration minusNanos(long l) {
        Duration duration;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusNanos:(J)Ljava/time/Duration;");
            Duration duration2 = this.plusNanos(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusNanos:(J)Ljava/time/Duration;");
            duration = duration2.plusNanos(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.plusNanos:(J)Ljava/time/Duration;");
            duration = this.plusNanos(l2);
        }
        return duration;
    }

    public Duration multipliedBy(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (l == 1L) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.toSeconds:()Ljava/math/BigDecimal;");
        BigDecimal bigDecimal = this.toSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
        BigDecimal bigDecimal2 = BigDecimal.valueOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.multiply:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(Ljava/math/BigDecimal;)Ljava/time/Duration;");
        return Duration.create(bigDecimal3);
    }

    public Duration dividedBy(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("Cannot divide by zero");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordJump();
        if (l == 1L) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.toSeconds:()Ljava/math/BigDecimal;");
        BigDecimal bigDecimal = this.toSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
        BigDecimal bigDecimal2 = BigDecimal.valueOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.divide:(Ljava/math/BigDecimal;Ljava/math/RoundingMode;)Ljava/math/BigDecimal;");
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, RoundingMode.DOWN);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.create:(Ljava/math/BigDecimal;)Ljava/time/Duration;");
        return Duration.create(bigDecimal3);
    }

    private BigDecimal toSeconds() {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
        BigDecimal bigDecimal = BigDecimal.valueOf(this.seconds);
        long l = this.nanos;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(JI)Ljava/math/BigDecimal;");
        BigDecimal bigDecimal2 = BigDecimal.valueOf(l, 9);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.add:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
        return bigDecimal.add(bigDecimal2);
    }

    private static Duration create(BigDecimal bigDecimal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.movePointRight:(I)Ljava/math/BigDecimal;");
        BigDecimal bigDecimal2 = bigDecimal.movePointRight(9);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.toBigIntegerExact:()Ljava/math/BigInteger;");
        BigInteger bigInteger = bigDecimal2.toBigIntegerExact();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideAndRemainder:(Ljava/math/BigInteger;)[Ljava/math/BigInteger;");
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BI_NANOS_PER_SECOND);
        BigInteger bigInteger2 = bigIntegerArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n = bigInteger2.bitLength();
        RuntimeCostAccounter.recordJump();
        if (n > 63) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Exceeds capacity of Duration: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(bigInteger);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException(string);
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        BigInteger bigInteger3 = bigIntegerArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
        long l = bigInteger3.longValue();
        BigInteger bigInteger4 = bigIntegerArray[1];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intValue:()I");
        long l2 = bigInteger4.intValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(JJ)Ljava/time/Duration;");
        return Duration.ofSeconds(l, l2);
    }

    public Duration negated() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.multipliedBy:(J)Ljava/time/Duration;");
        return this.multipliedBy(-1L);
    }

    public Duration abs() {
        Duration duration;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.isNegative:()Z");
        boolean bl = this.isNegative();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.negated:()Ljava/time/Duration;");
            duration = this.negated();
            RuntimeCostAccounter.recordJump();
        } else {
            duration = this;
        }
        return duration;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        RuntimeCostAccounter.recordJump();
        if (this.seconds != 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.plus(this.seconds, ChronoUnit.SECONDS);
        }
        RuntimeCostAccounter.recordJump();
        if (this.nanos != 0) {
            long l = this.nanos;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.plus(l, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        RuntimeCostAccounter.recordJump();
        if (this.seconds != 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.minus(this.seconds, ChronoUnit.SECONDS);
        }
        RuntimeCostAccounter.recordJump();
        if (this.nanos != 0) {
            long l = this.nanos;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            temporal = temporal.minus(l, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public long toDays() {
        return this.seconds / 86400L;
    }

    public long toHours() {
        return this.seconds / 3600L;
    }

    public long toMinutes() {
        return this.seconds / 60L;
    }

    public long toMillis() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l = Math.multiplyExact(this.seconds, 1000L);
        long l2 = this.nanos / 1000000;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        l = Math.addExact(l, l2);
        return l;
    }

    public long toNanos() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l = Math.multiplyExact(this.seconds, 1000000000L);
        long l2 = this.nanos;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        l = Math.addExact(l, l2);
        return l;
    }

    @Override
    public int compareTo(Duration duration) {
        long l = duration.seconds;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(this.seconds, l);
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            return n;
        }
        return this.nanos - duration.nanos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof Duration;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        Duration duration = (Duration)object;
        long l = this.seconds - duration.seconds;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 != false) return false;
        int n = duration.nanos;
        RuntimeCostAccounter.recordJump();
        if (this.nanos != n) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        return (int)(this.seconds ^ this.seconds >>> 32) + 51 * this.nanos;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        RuntimeCostAccounter.recordJump();
        if (this == Duration.ZERO) {
            return "PT0S";
        }
        var1_1 = this.seconds / 3600L;
        var3_2 = (int)(this.seconds % 3600L / 60L);
        var4_3 = (int)(this.seconds % 60L);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        var5_4 = new StringBuilder(24);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        var5_4.append("PT");
        RuntimeCostAccounter.recordJump();
        if (var1_1 != 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            v0 = var5_4.append(var1_1);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            v0.append('H');
        }
        RuntimeCostAccounter.recordJump();
        if (var3_2 != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            v1 = var5_4.append(var3_2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            v1.append('M');
        }
        RuntimeCostAccounter.recordJump();
        if (var4_3 == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.nanos == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
                v2 = var5_4.length();
                RuntimeCostAccounter.recordJump();
                if (v2 > 2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    return var5_4.toString();
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        if (var4_3 >= 0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (this.nanos > 0) {
            RuntimeCostAccounter.recordJump();
            if (var4_3 == -1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                var5_4.append("-0");
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                var5_4.append(var4_3 + 1);
                RuntimeCostAccounter.recordJump();
            }
        } else lbl-1000:
        // 2 sources

        {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            var5_4.append(var4_3);
        }
        RuntimeCostAccounter.recordJump();
        if (this.nanos > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
            var6_5 = var5_4.length();
            RuntimeCostAccounter.recordJump();
            if (var4_3 < 0) {
                v3 = 2000000000L - (long)this.nanos;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                var5_4.append(v3);
                RuntimeCostAccounter.recordJump();
            } else {
                v4 = (long)this.nanos + 1000000000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                var5_4.append(v4);
            }
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
                v5 = var5_4.length() - 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.charAt:(I)C");
                v6 = var5_4.charAt(v5);
                RuntimeCostAccounter.recordJump();
                if (v6 != '0') break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
                v7 = var5_4.length() - 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.setLength:(I)V");
                var5_4.setLength(v7);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.setCharAt:(IC)V");
            var5_4.setCharAt(var6_5, '.');
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        var5_4.append('S');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return var5_4.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(1, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeLong:(J)V");
        dataOutput.writeLong(this.seconds);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.nanos);
    }

    static Duration readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readLong:()J");
        long l = dataInput.readLong();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        long l2 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(JJ)Ljava/time/Duration;");
        return Duration.ofSeconds(l, l2);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Duration");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.<init>:(JI)V");
        ZERO = new Duration(0L, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        BI_NANOS_PER_SECOND = BigInteger.valueOf(1000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/regex/Pattern.compile:(Ljava/lang/String;I)Ljava/util/regex/Pattern;");
        PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);
    }

    private static class DurationUnits {
        static final List<TemporalUnit> UNITS;

        private DurationUnits() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        static {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            TemporalUnit[] temporalUnitArray = new TemporalUnit[]{ChronoUnit.SECONDS, ChronoUnit.NANOS};
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
            List<TemporalUnit> list = Arrays.asList(temporalUnitArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableList:(Ljava/util/List;)Ljava/util/List;");
            UNITS = Collections.unmodifiableList(list);
        }
    }
}

