/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.text;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.text.DontCareFieldPosition;
import sandbox.java.text.FieldPosition;
import sandbox.java.text.Format;
import sandbox.java.text.NumberFormat;
import sandbox.java.text.ParseException;
import sandbox.java.text.ParsePosition;
import sandbox.java.text.spi.DateFormatProvider;
import sandbox.java.util.Calendar;
import sandbox.java.util.Date;
import sandbox.java.util.HashMap;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.TimeZone;
import sandbox.sun.util.locale.provider.LocaleProviderAdapter;
import sandbox.sun.util.locale.provider.LocaleServiceProviderPool;

public abstract class DateFormat
extends Format {
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    private static final long serialVersionUID = 7218322306649953788L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl = object instanceof Date;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Date date = (Date)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.format:(Ljava/util/Date;Ljava/lang/StringBuffer;Ljava/text/FieldPosition;)Ljava/lang/StringBuffer;");
            return this.format(date, stringBuffer, fieldPosition);
        }
        boolean bl2 = object instanceof Number;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/Date");
            Number number = (Number)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.longValue:()J");
            long l = number.longValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.<init>:(J)V");
            Date date = new Date(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.format:(Ljava/util/Date;Ljava/lang/StringBuffer;Ljava/text/FieldPosition;)Ljava/lang/StringBuffer;");
            return this.format(date, stringBuffer, fieldPosition);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot format given Object as a Date");
        RuntimeCostAccounter.recordThrow();
        throw illegalArgumentException;
    }

    public abstract StringBuffer format(Date var1, StringBuffer var2, FieldPosition var3);

    public final String format(Date date) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:()V");
        StringBuffer stringBuffer = new StringBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.format:(Ljava/util/Date;Ljava/lang/StringBuffer;Ljava/text/FieldPosition;)Ljava/lang/StringBuffer;");
        StringBuffer stringBuffer2 = this.format(date, stringBuffer, DontCareFieldPosition.INSTANCE);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return stringBuffer2.toString();
    }

    public Date parse(String string) throws ParseException {
        RuntimeCostAccounter.recordAllocation((String)"java/text/ParsePosition");
        RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.<init>:(I)V");
        ParsePosition parsePosition = new ParsePosition(0);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.parse:(Ljava/lang/String;Ljava/text/ParsePosition;)Ljava/util/Date;");
        Date date = this.parse(string, parsePosition);
        int n = parsePosition.index;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/text/ParseException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unparseable date: \"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("\"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder4.toString();
            int n2 = parsePosition.errorIndex;
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParseException.<init>:(Ljava/lang/String;I)V");
            ParseException parseException = new ParseException(string2, n2);
            RuntimeCostAccounter.recordThrow();
            throw parseException;
        }
        return date;
    }

    public abstract Date parse(String var1, ParsePosition var2);

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.parse:(Ljava/lang/String;Ljava/text/ParsePosition;)Ljava/util/Date;");
        return this.parse(string, parsePosition);
    }

    public static final DateFormat getTimeInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(2, 0, 1, locale);
    }

    public static final DateFormat getTimeInstance(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(n, 0, 1, locale);
    }

    public static final DateFormat getTimeInstance(int n, Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(n, 0, 1, locale);
    }

    public static final DateFormat getDateInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(0, 2, 2, locale);
    }

    public static final DateFormat getDateInstance(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(0, n, 2, locale);
    }

    public static final DateFormat getDateInstance(int n, Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(0, n, 2, locale);
    }

    public static final DateFormat getDateTimeInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(2, 2, 3, locale);
    }

    public static final DateFormat getDateTimeInstance(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(n2, n, 3, locale);
    }

    public static final DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(IIILjava/util/Locale;)Ljava/text/DateFormat;");
        return DateFormat.get(n2, n, 3, locale);
    }

    public static final DateFormat getInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.getDateTimeInstance:(II)Ljava/text/DateFormat;");
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public static Locale[] getAvailableLocales() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getPool:(Ljava/lang/Class;)Lsun/util/locale/provider/LocaleServiceProviderPool;");
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatProvider.class);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getAvailableLocales:()[Ljava/util/Locale;");
        return localeServiceProviderPool.getAvailableLocales();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setTimeZone(TimeZone timeZone) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.setTimeZone:(Ljava/util/TimeZone;)V");
        this.calendar.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getTimeZone:()Ljava/util/TimeZone;");
        return this.calendar.getTimeZone();
    }

    public void setLenient(boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.setLenient:(Z)V");
        this.calendar.setLenient(bl);
    }

    public boolean isLenient() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.isLenient:()Z");
        return this.calendar.isLenient();
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.hashCode:()I");
        return this.numberFormat.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        RuntimeCostAccounter.recordJump();
        if (object == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz2 = object.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != clazz2) {
            return false;
        }
        DateFormat dateFormat = (DateFormat)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getFirstDayOfWeek:()I");
        int n = this.calendar.getFirstDayOfWeek();
        Calendar calendar = dateFormat.calendar;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getFirstDayOfWeek:()I");
        int n2 = calendar.getFirstDayOfWeek();
        RuntimeCostAccounter.recordJump();
        if (n != n2) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getMinimalDaysInFirstWeek:()I");
        int n3 = this.calendar.getMinimalDaysInFirstWeek();
        Calendar calendar2 = dateFormat.calendar;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getMinimalDaysInFirstWeek:()I");
        int n4 = calendar2.getMinimalDaysInFirstWeek();
        RuntimeCostAccounter.recordJump();
        if (n3 != n4) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.isLenient:()Z");
        boolean bl = this.calendar.isLenient();
        Calendar calendar3 = dateFormat.calendar;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.isLenient:()Z");
        boolean bl2 = calendar3.isLenient();
        RuntimeCostAccounter.recordJump();
        if (bl != bl2) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getTimeZone:()Ljava/util/TimeZone;");
        TimeZone timeZone = this.calendar.getTimeZone();
        Calendar calendar4 = dateFormat.calendar;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getTimeZone:()Ljava/util/TimeZone;");
        TimeZone timeZone2 = calendar4.getTimeZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = timeZone.equals(timeZone2);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        NumberFormat numberFormat = dateFormat.numberFormat;
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.equals:(Ljava/lang/Object;)Z");
        boolean bl4 = this.numberFormat.equals(numberFormat);
        RuntimeCostAccounter.recordJump();
        if (!bl4) return false;
        boolean bl5 = true;
        RuntimeCostAccounter.recordJump();
        return bl5;
    }

    @Override
    public Object clone() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Format.clone:()Ljava/lang/Object;");
        DateFormat dateFormat = (DateFormat)super.clone();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.clone:()Ljava/lang/Object;");
        dateFormat.calendar = (Calendar)this.calendar.clone();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/NumberFormat.clone:()Ljava/lang/Object;");
        dateFormat.numberFormat = (NumberFormat)this.numberFormat.clone();
        return dateFormat;
    }

    private static DateFormat get(int n, int n2, int n3, Locale locale) {
        block10: {
            block8: {
                block9: {
                    block7: {
                        block5: {
                            block6: {
                                RuntimeCostAccounter.recordJump();
                                if ((n3 & 1) == 0) break block5;
                                RuntimeCostAccounter.recordJump();
                                if (n < 0) break block6;
                                RuntimeCostAccounter.recordJump();
                                if (n <= 3) break block7;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder2 = stringBuilder.append("Illegal time style ");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder3 = stringBuilder2.append(n);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string = stringBuilder3.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                            RuntimeCostAccounter.recordThrow();
                            throw illegalArgumentException;
                        }
                        n = -1;
                    }
                    RuntimeCostAccounter.recordJump();
                    if ((n3 & 2) == 0) break block8;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= 3) break block10;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append("Illegal date style ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            n2 = -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getAdapter:(Ljava/lang/Class;Ljava/util/Locale;)Lsun/util/locale/provider/LocaleProviderAdapter;");
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(DateFormatProvider.class, (Locale)locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(Lsun/util/locale/provider/LocaleProviderAdapter;IILjava/util/Locale;)Ljava/text/DateFormat;");
        DateFormat dateFormat = DateFormat.get(localeProviderAdapter, n, n2, locale);
        RuntimeCostAccounter.recordJump();
        if (dateFormat == null) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.forJRE:()Lsun/util/locale/provider/LocaleProviderAdapter;");
            LocaleProviderAdapter localeProviderAdapter2 = LocaleProviderAdapter.forJRE();
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat.get:(Lsun/util/locale/provider/LocaleProviderAdapter;IILjava/util/Locale;)Ljava/text/DateFormat;");
            dateFormat = DateFormat.get(localeProviderAdapter2, n, n2, locale);
        }
        return dateFormat;
    }

    private static DateFormat get(LocaleProviderAdapter localeProviderAdapter, int n, int n2, Locale locale) {
        DateFormat dateFormat;
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getDateFormatProvider:()Ljava/text/spi/DateFormatProvider;");
        DateFormatProvider dateFormatProvider = localeProviderAdapter.getDateFormatProvider();
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/DateFormatProvider.getDateInstance:(ILjava/util/Locale;)Ljava/text/DateFormat;");
            dateFormat = dateFormatProvider.getDateInstance(n2, locale);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n2 == -1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/DateFormatProvider.getTimeInstance:(ILjava/util/Locale;)Ljava/text/DateFormat;");
                dateFormat = dateFormatProvider.getTimeInstance(n, locale);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/DateFormatProvider.getDateTimeInstance:(IILjava/util/Locale;)Ljava/text/DateFormat;");
                dateFormat = dateFormatProvider.getDateTimeInstance(n2, n, locale);
            }
        }
        return dateFormat;
    }

    protected DateFormat() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Format.<init>:()V");
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7441350119349544720L;
        private static final Map<String, Field> instanceMap;
        private static final Field[] calendarToFieldMapping;
        private int calendarField;
        public static final Field ERA;
        public static final Field YEAR;
        public static final Field MONTH;
        public static final Field DAY_OF_MONTH;
        public static final Field HOUR_OF_DAY1;
        public static final Field HOUR_OF_DAY0;
        public static final Field MINUTE;
        public static final Field SECOND;
        public static final Field MILLISECOND;
        public static final Field DAY_OF_WEEK;
        public static final Field DAY_OF_YEAR;
        public static final Field DAY_OF_WEEK_IN_MONTH;
        public static final Field WEEK_OF_YEAR;
        public static final Field WEEK_OF_MONTH;
        public static final Field AM_PM;
        public static final Field HOUR1;
        public static final Field HOUR0;
        public static final Field TIME_ZONE;

        public static Field ofCalendarField(int n) {
            block3: {
                block2: {
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block2;
                    int n2 = calendarToFieldMapping.length;
                    RuntimeCostAccounter.recordJump();
                    if (n < n2) break block3;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Unknown Calendar constant ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            return calendarToFieldMapping[n];
        }

        protected Field(String string, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/Format$Field.<init>:(Ljava/lang/String;)V");
            super(string);
            this.calendarField = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.getClass();
            RuntimeCostAccounter.recordJump();
            if (clazz == Field.class) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                instanceMap.put(string, this);
                RuntimeCostAccounter.recordJump();
                if (n >= 0) {
                    Field.calendarToFieldMapping[n] = this;
                }
            }
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = this.getClass();
            RuntimeCostAccounter.recordJump();
            if (clazz != Field.class) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
                InvalidObjectException invalidObjectException = new InvalidObjectException("subclass didn't correctly implement readResolve");
                RuntimeCostAccounter.recordThrow();
                throw invalidObjectException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.getName:()Ljava/lang/String;");
            String string = this.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            Field field = instanceMap.get(string);
            RuntimeCostAccounter.recordJump();
            if (field != null) {
                return field;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("unknown attribute name");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:(I)V");
            instanceMap = new HashMap<String, Field>(18);
            RuntimeCostAccounter.recordArrayAllocation((int)17, (int)8);
            calendarToFieldMapping = new Field[17];
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            ERA = new Field("era", 0);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            YEAR = new Field("year", 1);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            MONTH = new Field("month", 2);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            DAY_OF_MONTH = new Field("day of month", 5);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            HOUR_OF_DAY1 = new Field("hour of day 1", -1);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            HOUR_OF_DAY0 = new Field("hour of day", 11);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            MINUTE = new Field("minute", 12);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            SECOND = new Field("second", 13);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            MILLISECOND = new Field("millisecond", 14);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            DAY_OF_WEEK = new Field("day of week", 7);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            DAY_OF_YEAR = new Field("day of year", 6);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            WEEK_OF_YEAR = new Field("week of year", 3);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            WEEK_OF_MONTH = new Field("week of month", 4);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            AM_PM = new Field("am pm", 9);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            HOUR1 = new Field("hour 1", -1);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            HOUR0 = new Field("hour", 10);
            RuntimeCostAccounter.recordAllocation((String)"java/text/DateFormat$Field");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DateFormat$Field.<init>:(Ljava/lang/String;I)V");
            TIME_ZONE = new Field("time zone", -1);
        }
    }
}

