/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InterruptedIOException;
import sandbox.java.io.PipedWriter;
import sandbox.java.io.Reader;

public class PipedReader
extends Reader {
    boolean closedByWriter;
    boolean closedByReader;
    boolean connected;
    Thread readSide;
    Thread writeSide;
    private static final int DEFAULT_PIPE_SIZE = 1024;
    char[] buffer;
    int in;
    int out;

    public PipedReader(PipedWriter pipedWriter) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedReader.<init>:(Ljava/io/PipedWriter;I)V");
        this(pipedWriter, 1024);
    }

    public PipedReader(PipedWriter pipedWriter, int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.<init>:()V");
        this.closedByWriter = false;
        this.closedByReader = false;
        this.connected = false;
        this.in = -1;
        this.out = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedReader.initPipe:(I)V");
        this.initPipe(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedReader.connect:(Ljava/io/PipedWriter;)V");
        this.connect(pipedWriter);
    }

    public PipedReader() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.<init>:()V");
        this.closedByWriter = false;
        this.closedByReader = false;
        this.connected = false;
        this.in = -1;
        this.out = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedReader.initPipe:(I)V");
        this.initPipe(1024);
    }

    public PipedReader(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.<init>:()V");
        this.closedByWriter = false;
        this.closedByReader = false;
        this.connected = false;
        this.in = -1;
        this.out = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedReader.initPipe:(I)V");
        this.initPipe(n);
    }

    private void initPipe(int n) {
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Pipe size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)2);
        this.buffer = new char[n2];
    }

    public void connect(PipedWriter pipedWriter) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedWriter.connect:(Ljava/io/PipedReader;)V");
        pipedWriter.connect(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void receive(int n) throws IOException {
        block14: {
            block13: {
                RuntimeCostAccounter.recordJump();
                if (!this.connected) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("Pipe not connected");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                RuntimeCostAccounter.recordJump();
                if (this.closedByWriter) break block13;
                RuntimeCostAccounter.recordJump();
                if (!this.closedByReader) break block14;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.readSide != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
            boolean bl = this.readSide.isAlive();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException("Read end dead");
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        this.writeSide = Thread.currentThread();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.in != this.out) break;
            RuntimeCostAccounter.recordJump();
            if (this.readSide != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
                boolean bl = this.readSide.isAlive();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("Pipe broken");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
            this.notifyAll();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:(J)V");
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InterruptedIOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InterruptedIOException.<init>:()V");
                InterruptedIOException interruptedIOException = new InterruptedIOException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedIOException;
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (char)n;
        int n2 = this.buffer.length;
        RuntimeCostAccounter.recordJump();
        if (this.in >= n2) {
            this.in = 0;
        }
    }

    synchronized void receive(char[] cArray, int n, int n2) throws IOException {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (--n2 < 0) break;
            char c = cArray[n++];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedReader.receive:(I)V");
            this.receive(c);
            RuntimeCostAccounter.recordJump();
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
        this.notifyAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int read() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.connected) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe not connected");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.closedByReader) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.writeSide != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
            boolean bl = this.writeSide.isAlive();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (!this.closedByWriter) {
                    RuntimeCostAccounter.recordJump();
                    if (this.in < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("Write end dead");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        this.readSide = Thread.currentThread();
        int n = 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.in >= 0) break;
            RuntimeCostAccounter.recordJump();
            if (this.closedByWriter) {
                return -1;
            }
            RuntimeCostAccounter.recordJump();
            if (this.writeSide != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
                boolean bl = this.writeSide.isAlive();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordJump();
                    if (--n < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("Pipe broken");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.notifyAll:()V");
            this.notifyAll();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.wait:(J)V");
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/InterruptedIOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InterruptedIOException.<init>:()V");
                InterruptedIOException interruptedIOException = new InterruptedIOException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedIOException;
            }
            RuntimeCostAccounter.recordJump();
        }
        char c = this.buffer[this.out++];
        int n2 = this.buffer.length;
        RuntimeCostAccounter.recordJump();
        if (this.out >= n2) {
            this.out = 0;
        }
        RuntimeCostAccounter.recordJump();
        if (this.in == this.out) {
            this.in = -1;
        }
        return c;
    }

    @Override
    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        block14: {
            block13: {
                RuntimeCostAccounter.recordJump();
                if (!this.connected) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("Pipe not connected");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                RuntimeCostAccounter.recordJump();
                if (this.closedByReader) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("Pipe closed");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                RuntimeCostAccounter.recordJump();
                if (this.writeSide != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
                    boolean bl = this.writeSide.isAlive();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordJump();
                        if (!this.closedByWriter) {
                            RuntimeCostAccounter.recordJump();
                            if (this.in < 0) {
                                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                                IOException iOException = new IOException("Write end dead");
                                RuntimeCostAccounter.recordThrow();
                                throw iOException;
                            }
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block13;
                int n3 = cArray.length;
                RuntimeCostAccounter.recordJump();
                if (n > n3) break block13;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block13;
                int n4 = cArray.length;
                RuntimeCostAccounter.recordJump();
                if (n + n2 > n4) break block13;
                RuntimeCostAccounter.recordJump();
                if (n + n2 >= 0) break block14;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PipedReader.read:()I");
        int n5 = this.read();
        RuntimeCostAccounter.recordJump();
        if (n5 < 0) {
            return -1;
        }
        cArray[n] = (char)n5;
        int n6 = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.in < 0) break;
            RuntimeCostAccounter.recordJump();
            if (--n2 <= 0) break;
            cArray[n + n6] = this.buffer[this.out++];
            ++n6;
            int n7 = this.buffer.length;
            RuntimeCostAccounter.recordJump();
            if (this.out >= n7) {
                this.out = 0;
            }
            RuntimeCostAccounter.recordJump();
            if (this.in != this.out) continue;
            this.in = -1;
            RuntimeCostAccounter.recordJump();
        }
        return n6;
    }

    @Override
    public synchronized boolean ready() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.connected) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe not connected");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.closedByReader) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Pipe closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.writeSide != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.isAlive:()Z");
            boolean bl = this.writeSide.isAlive();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (!this.closedByWriter) {
                    RuntimeCostAccounter.recordJump();
                    if (this.in < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                        IOException iOException = new IOException("Write end dead");
                        RuntimeCostAccounter.recordThrow();
                        throw iOException;
                    }
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        return this.in >= 0;
    }

    @Override
    public void close() throws IOException {
        this.in = -1;
        this.closedByReader = true;
    }
}

