/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import java.lang.ref.ReferenceQueue;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Bits;
import sandbox.java.io.DataOutput;
import sandbox.java.io.DataOutputStream;
import sandbox.java.io.Externalizable;
import sandbox.java.io.IOException;
import sandbox.java.io.NotActiveException;
import sandbox.java.io.NotSerializableException;
import sandbox.java.io.ObjectOutput;
import sandbox.java.io.ObjectStreamClass;
import sandbox.java.io.ObjectStreamConstants;
import sandbox.java.io.ObjectStreamField;
import sandbox.java.io.OutputStream;
import sandbox.java.io.SerialCallbackContext;
import sandbox.java.io.Serializable;
import sandbox.java.io.UTFDataFormatException;
import sandbox.java.security.AccessController;
import sandbox.java.security.Permission;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.List;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.sun.reflect.misc.ReflectUtil;
import sandbox.sun.security.action.GetBooleanAction;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private SerialCallbackContext curContext;
    private PutFieldImpl curPut;
    private final DebugTraceInfoStack debugInfoStack;
    private static final boolean extendedDebugInfo;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.<init>:()V");
        this.protocol = 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.verifySubclass:()V");
        this.verifySubclass();
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectOutputStream$BlockDataOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.<init>:(Ljava/io/OutputStream;)V");
        this.bout = new BlockDataOutputStream(outputStream);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectOutputStream$HandleTable");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.<init>:(IF)V");
        this.handles = new HandleTable(10, 3.0f);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectOutputStream$ReplaceTable");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$ReplaceTable.<init>:(IF)V");
        this.subs = new ReplaceTable(10, 3.0f);
        this.enableOverride = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeStreamHeader:()V");
        this.writeStreamHeader();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(true);
        RuntimeCostAccounter.recordJump();
        if (extendedDebugInfo) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectOutputStream$DebugTraceInfoStack");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.<init>:()V");
            this.debugInfoStack = new DebugTraceInfoStack();
            RuntimeCostAccounter.recordJump();
        } else {
            this.debugInfoStack = null;
        }
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.<init>:()V");
        this.protocol = 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bout = null;
        this.handles = null;
        this.subs = null;
        this.enableOverride = true;
        this.debugInfoStack = null;
    }

    public void useProtocolVersion(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.size:()I");
        int n2 = this.handles.size();
        RuntimeCostAccounter.recordJump();
        if (n2 != 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("stream non-empty");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        switch (n) {
            case 1: 
            case 2: {
                this.protocol = n;
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("unknown version: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
    }

    @Override
    public final void writeObject(Object object) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.enableOverride) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObjectOverride:(Ljava/lang/Object;)V");
            this.writeObjectOverride(object);
            return;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject0:(Ljava/lang/Object;Z)V");
            this.writeObject0(object, false);
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordJump();
            if (this.depth == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeFatalException:(Ljava/io/IOException;)V");
                this.writeFatalException(iOException);
            }
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void writeUnshared(Object object) throws IOException {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject0:(Ljava/lang/Object;Z)V");
            this.writeObject0(object, true);
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordJump();
            if (this.depth == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeFatalException:(Ljava/io/IOException;)V");
                this.writeFatalException(iOException);
            }
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordJump();
    }

    public void defaultWriteObject() throws IOException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        RuntimeCostAccounter.recordJump();
        if (serialCallbackContext == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/NotActiveException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/NotActiveException.<init>:(Ljava/lang/String;)V");
            NotActiveException notActiveException = new NotActiveException("not in call to writeObject");
            RuntimeCostAccounter.recordThrow();
            throw notActiveException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getObj:()Ljava/lang/Object;");
        Object object = serialCallbackContext.getObj();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getDesc:()Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteFields:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
        this.defaultWriteFields(object, objectStreamClass);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(true);
    }

    public PutField putFields() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.curPut == null) {
            SerialCallbackContext serialCallbackContext = this.curContext;
            RuntimeCostAccounter.recordJump();
            if (serialCallbackContext == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/NotActiveException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/NotActiveException.<init>:(Ljava/lang/String;)V");
                NotActiveException notActiveException = new NotActiveException("not in call to writeObject");
                RuntimeCostAccounter.recordThrow();
                throw notActiveException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getObj:()Ljava/lang/Object;");
            Object object = serialCallbackContext.getObj();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.getDesc:()Ljava/io/ObjectStreamClass;");
            ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
            RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectOutputStream$PutFieldImpl");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.<init>:(Ljava/io/ObjectOutputStream;Ljava/io/ObjectStreamClass;)V");
            this.curPut = new PutFieldImpl(objectStreamClass);
        }
        return this.curPut;
    }

    public void writeFields() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.curPut == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/NotActiveException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/NotActiveException.<init>:(Ljava/lang/String;)V");
            NotActiveException notActiveException = new NotActiveException("no current PutField object");
            RuntimeCostAccounter.recordThrow();
            throw notActiveException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.writeFields:()V");
        this.curPut.writeFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(true);
    }

    public void reset() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.depth != 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("stream active");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(121);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.clear:()V");
        this.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(true);
    }

    protected void annotateClass(Class<?> clazz) throws IOException {
    }

    protected void annotateProxyClass(Class<?> clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        boolean bl2;
        RuntimeCostAccounter.recordJump();
        if (bl == this.enableReplace) {
            return bl;
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
            SecurityManager securityManager = System.getSecurityManager();
            RuntimeCostAccounter.recordJump();
            if (securityManager != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
                securityManager.checkPermission((Permission)SUBSTITUTION_PERMISSION);
            }
        }
        this.enableReplace = bl;
        RuntimeCostAccounter.recordJump();
        if (!this.enableReplace) {
            bl2 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl2 = false;
        }
        return bl2;
    }

    protected void writeStreamHeader() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeShort:(I)V");
        this.bout.writeShort(-21267);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeShort:(I)V");
        this.bout.writeShort(5);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.writeNonProxy:(Ljava/io/ObjectOutputStream;)V");
        objectStreamClass.writeNonProxy(this);
    }

    @Override
    public void write(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:(I)V");
        this.bout.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:([BIIZ)V");
        this.bout.write(byArray, 0, n, false);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        block5: {
            block4: {
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                int n3 = n + n2;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block4;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block4;
                int n4 = byArray.length;
                RuntimeCostAccounter.recordJump();
                if (n3 > n4) break block4;
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:([BIIZ)V");
        this.bout.write(byArray, n, n2, false);
    }

    @Override
    public void flush() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.flush:()V");
        this.bout.flush();
    }

    protected void drain() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
        this.bout.drain();
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.flush:()V");
        this.flush();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.clear:()V");
        this.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.close:()V");
        this.bout.close();
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeBoolean:(Z)V");
        this.bout.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeShort:(I)V");
        this.bout.writeShort(n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeChar:(I)V");
        this.bout.writeChar(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
        this.bout.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeLong:(J)V");
        this.bout.writeLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeFloat:(F)V");
        this.bout.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeDouble:(D)V");
        this.bout.writeDouble(d);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeBytes:(Ljava/lang/String;)V");
        this.bout.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeChars:(Ljava/lang/String;)V");
        this.bout.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeUTF:(Ljava/lang/String;)V");
        this.bout.writeUTF(string);
    }

    int getProtocolVersion() {
        return this.protocol;
    }

    void writeTypeString(String string) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeNull:()V");
            this.writeNull();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.lookup:(Ljava/lang/Object;)I");
            int n = this.handles.lookup(string);
            RuntimeCostAccounter.recordJump();
            if (n != -1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeHandle:(I)V");
                this.writeHandle(n);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeString:(Ljava/lang/String;Z)V");
                this.writeString(string, false);
            }
        }
    }

    private void verifySubclass() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz == ObjectOutputStream.class) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager == null) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.processQueue:(Ljava/lang/ref/ReferenceQueue;Ljava/util/concurrent/ConcurrentMap;)V");
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamClass$WeakClassKey");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass$WeakClassKey.<init>:(Ljava/lang/Class;Ljava/lang/ref/ReferenceQueue;)V");
        ObjectStreamClass.WeakClassKey weakClassKey = new ObjectStreamClass.WeakClassKey(clazz, Caches.subclassAuditsQueue);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Boolean bl = (Boolean)Caches.subclassAudits.get(weakClassKey);
        RuntimeCostAccounter.recordJump();
        if (bl == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.auditSubclass:(Ljava/lang/Class;)Z");
            boolean bl2 = ObjectOutputStream.auditSubclass(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;");
            bl = bl2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            Caches.subclassAudits.putIfAbsent(weakClassKey, bl);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.booleanValue:()Z");
        boolean bl3 = bl;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
        securityManager.checkPermission((Permission)SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class<?> clazz) {
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectOutputStream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$1.<init>:(Ljava/lang/Class;)V");
        PrivilegedAction<Boolean> privilegedAction = new PrivilegedAction<Boolean>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            public Boolean run() {
                Class clazz2 = clazz;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (clazz2 == ObjectOutputStream.class) break;
                    try {
                        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                        Class[] classArray = new Class[]{Object.class};
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredMethod:(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                        clazz2.getDeclaredMethod("writeUnshared", classArray);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] classArray = null;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredMethod:(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                            clazz2.getDeclaredMethod("putFields", classArray);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSuperclass:()Ljava/lang/Class;");
                            clazz2 = clazz2.getSuperclass();
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                    }
                    break;
                }
                return Boolean.TRUE;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)privilegedAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.booleanValue:()Z");
        return bl;
    }

    private void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$ReplaceTable.clear:()V");
        this.subs.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.clear:()V");
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object clazz, boolean bl) throws IOException {
        ObjectStreamClass objectStreamClass;
        Class<?> clazz2;
        boolean bl2;
        block28: {
            block31: {
                block30: {
                    int n;
                    block29: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                                        bl2 = this.bout.setBlockDataMode(false);
                                        ++this.depth;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$ReplaceTable.lookup:(Ljava/lang/Object;)Ljava/lang/Object;");
                                        clazz = this.subs.lookup(clazz);
                                        RuntimeCostAccounter.recordJump();
                                        if (clazz != null) break block24;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeNull:()V");
                                        this.writeNull();
                                        --this.depth;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                                        this.bout.setBlockDataMode(bl2);
                                        return;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (bl) break block25;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.lookup:(Ljava/lang/Object;)I");
                                    n = this.handles.lookup(clazz);
                                    RuntimeCostAccounter.recordJump();
                                    if (n == -1) break block25;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeHandle:(I)V");
                                    this.writeHandle(n);
                                    --this.depth;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                                    this.bout.setBlockDataMode(bl2);
                                    return;
                                }
                                boolean bl3 = clazz instanceof Class;
                                RuntimeCostAccounter.recordJump();
                                if (!bl3) break block26;
                                Class clazz3 = clazz;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClass:(Ljava/lang/Class;Z)V");
                                this.writeClass(clazz3, bl);
                                --this.depth;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                                this.bout.setBlockDataMode(bl2);
                                return;
                            }
                            boolean bl4 = clazz instanceof ObjectStreamClass;
                            RuntimeCostAccounter.recordJump();
                            if (!bl4) break block27;
                            ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)((Object)clazz);
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
                            this.writeClassDesc(objectStreamClass2, bl);
                            --this.depth;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                            this.bout.setBlockDataMode(bl2);
                            return;
                        }
                        try {
                            Class<?> clazz4;
                            Class<?> clazz5 = clazz;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                            clazz2 = clazz.getClass();
                            while (true) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.lookup:(Ljava/lang/Class;Z)Ljava/io/ObjectStreamClass;");
                                objectStreamClass = ObjectStreamClass.lookup(clazz2, true);
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasWriteReplaceMethod:()Z");
                                boolean bl5 = objectStreamClass.hasWriteReplaceMethod();
                                RuntimeCostAccounter.recordJump();
                                if (!bl5) break;
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.invokeWriteReplace:(Ljava/lang/Object;)Ljava/lang/Object;");
                                clazz = objectStreamClass.invokeWriteReplace(clazz);
                                RuntimeCostAccounter.recordJump();
                                if (clazz == null) break;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                                clazz4 = clazz.getClass();
                                RuntimeCostAccounter.recordJump();
                                if (clazz4 == clazz2) {
                                    RuntimeCostAccounter.recordJump();
                                    break;
                                }
                                clazz2 = clazz4;
                                RuntimeCostAccounter.recordJump();
                            }
                            RuntimeCostAccounter.recordJump();
                            if (this.enableReplace) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.replaceObject:(Ljava/lang/Object;)Ljava/lang/Object;");
                                clazz4 = this.replaceObject(clazz);
                                RuntimeCostAccounter.recordJump();
                                if (clazz4 != clazz) {
                                    RuntimeCostAccounter.recordJump();
                                    if (clazz4 != null) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                                        clazz2 = clazz4.getClass();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.lookup:(Ljava/lang/Class;Z)Ljava/io/ObjectStreamClass;");
                                        objectStreamClass = ObjectStreamClass.lookup(clazz2, true);
                                    }
                                }
                                clazz = clazz4;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (clazz == clazz5) break block28;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$ReplaceTable.assign:(Ljava/lang/Object;Ljava/lang/Object;)V");
                            this.subs.assign(clazz5, clazz);
                            RuntimeCostAccounter.recordJump();
                            if (clazz != null) break block29;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeNull:()V");
                            this.writeNull();
                            --this.depth;
                        }
                        catch (Throwable throwable) {
                            --this.depth;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                            this.bout.setBlockDataMode(bl2);
                            RuntimeCostAccounter.recordThrow();
                            throw throwable;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                        this.bout.setBlockDataMode(bl2);
                        return;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block30;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.lookup:(Ljava/lang/Object;)I");
                    n = this.handles.lookup(clazz);
                    RuntimeCostAccounter.recordJump();
                    if (n == -1) break block30;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeHandle:(I)V");
                    this.writeHandle(n);
                    --this.depth;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                    this.bout.setBlockDataMode(bl2);
                    return;
                }
                boolean bl6 = clazz instanceof Class;
                RuntimeCostAccounter.recordJump();
                if (!bl6) break block31;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClass:(Ljava/lang/Class;Z)V");
                this.writeClass(clazz, bl);
                --this.depth;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                this.bout.setBlockDataMode(bl2);
                return;
            }
            boolean bl7 = clazz instanceof ObjectStreamClass;
            RuntimeCostAccounter.recordJump();
            if (!bl7) break block28;
            ObjectStreamClass objectStreamClass3 = (ObjectStreamClass)((Object)clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
            this.writeClassDesc(objectStreamClass3, bl);
            --this.depth;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
            this.bout.setBlockDataMode(bl2);
            return;
        }
        boolean bl8 = clazz instanceof String;
        RuntimeCostAccounter.recordJump();
        if (bl8) {
            String string = (String)((Object)clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeString:(Ljava/lang/String;Z)V");
            this.writeString(string, bl);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isArray:()Z");
            boolean bl9 = clazz2.isArray();
            RuntimeCostAccounter.recordJump();
            if (bl9) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeArray:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;Z)V");
                this.writeArray(clazz, objectStreamClass, bl);
                RuntimeCostAccounter.recordJump();
            } else {
                boolean bl10 = clazz instanceof Enum;
                RuntimeCostAccounter.recordJump();
                if (bl10) {
                    Enum enum_ = (Enum)((Object)clazz);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeEnum:(Ljava/lang/Enum;Ljava/io/ObjectStreamClass;Z)V");
                    this.writeEnum(enum_, objectStreamClass, bl);
                    RuntimeCostAccounter.recordJump();
                } else {
                    boolean bl11 = clazz instanceof Serializable;
                    RuntimeCostAccounter.recordJump();
                    if (bl11) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeOrdinaryObject:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;Z)V");
                        this.writeOrdinaryObject(clazz, objectStreamClass, bl);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (extendedDebugInfo) {
                            RuntimeCostAccounter.recordAllocation((String)"java/io/NotSerializableException");
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                            StringBuilder stringBuilder = new StringBuilder();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
                            String string = clazz2.getName();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder2 = stringBuilder.append(string);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder3 = stringBuilder2.append("\n");
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.toString:()Ljava/lang/String;");
                            String string2 = this.debugInfoStack.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder4 = stringBuilder3.append(string2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                            String string3 = stringBuilder4.toString();
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/NotSerializableException.<init>:(Ljava/lang/String;)V");
                            NotSerializableException notSerializableException = new NotSerializableException(string3);
                            RuntimeCostAccounter.recordThrow();
                            throw notSerializableException;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/io/NotSerializableException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
                        String string = clazz2.getName();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/NotSerializableException.<init>:(Ljava/lang/String;)V");
                        NotSerializableException notSerializableException = new NotSerializableException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw notSerializableException;
                    }
                }
            }
        }
        --this.depth;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(bl2);
        RuntimeCostAccounter.recordJump();
    }

    private void writeNull() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(112);
    }

    private void writeHandle(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(113);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
        this.bout.writeInt(0x7E0000 + n);
    }

    private void writeClass(Class<?> clazz, boolean bl) throws IOException {
        Class<?> clazz2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(118);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.lookup:(Ljava/lang/Class;Z)Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
        this.writeClassDesc(objectStreamClass, false);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            clazz2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            clazz2 = clazz;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.handles.assign(clazz2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeClassDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (objectStreamClass == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeNull:()V");
            this.writeNull();
            RuntimeCostAccounter.recordJump();
            return;
        }
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.lookup:(Ljava/lang/Object;)I");
            int n = this.handles.lookup(objectStreamClass);
            RuntimeCostAccounter.recordJump();
            if (n != -1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeHandle:(I)V");
                this.writeHandle(n);
                RuntimeCostAccounter.recordJump();
                return;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.isProxy:()Z");
        boolean bl2 = objectStreamClass.isProxy();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeProxyDesc:(Ljava/io/ObjectStreamClass;Z)V");
            this.writeProxyDesc(objectStreamClass, bl);
            RuntimeCostAccounter.recordJump();
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeNonProxyDesc:(Ljava/io/ObjectStreamClass;Z)V");
        this.writeNonProxyDesc(objectStreamClass, bl);
    }

    private boolean isCustomSubclass() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader = clazz.getClassLoader();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getClassLoader:()Ljava/lang/ClassLoader;");
        ClassLoader classLoader2 = ObjectOutputStream.class.getClassLoader();
        RuntimeCostAccounter.recordJump();
        if (classLoader != classLoader2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    private void writeProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        ObjectStreamClass objectStreamClass2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(125);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            objectStreamClass2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            objectStreamClass2 = objectStreamClass;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.handles.assign(objectStreamClass2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
        Class<?> clazz = objectStreamClass.forClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getInterfaces:()[Ljava/lang/Class;");
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
        this.bout.writeInt(n);
        int n2 = 0;
        while (true) {
            int n3 = classArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            Class<?> clazz2 = classArray[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz2.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeUTF:(Ljava/lang/String;)V");
            this.bout.writeUTF(string);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(true);
        RuntimeCostAccounter.recordJump();
        if (clazz != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.isCustomSubclass:()Z");
            boolean bl2 = this.isCustomSubclass();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/reflect/misc/ReflectUtil.checkPackageAccess:(Ljava/lang/Class;)V");
                ReflectUtil.checkPackageAccess(clazz);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.annotateProxyClass:(Ljava/lang/Class;)V");
        this.annotateProxyClass(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(120);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getSuperDesc:()Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass3 = objectStreamClass.getSuperDesc();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
        this.writeClassDesc(objectStreamClass3, false);
    }

    private void writeNonProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        ObjectStreamClass objectStreamClass2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(114);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            objectStreamClass2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            objectStreamClass2 = objectStreamClass;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.handles.assign(objectStreamClass2);
        RuntimeCostAccounter.recordJump();
        if (this.protocol == 1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.writeNonProxy:(Ljava/io/ObjectOutputStream;)V");
            objectStreamClass.writeNonProxy(this);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDescriptor:(Ljava/io/ObjectStreamClass;)V");
            this.writeClassDescriptor(objectStreamClass);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
        Class<?> clazz = objectStreamClass.forClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(true);
        RuntimeCostAccounter.recordJump();
        if (clazz != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.isCustomSubclass:()Z");
            boolean bl2 = this.isCustomSubclass();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/reflect/misc/ReflectUtil.checkPackageAccess:(Ljava/lang/Class;)V");
                ReflectUtil.checkPackageAccess(clazz);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.annotateClass:(Ljava/lang/Class;)V");
        this.annotateClass(clazz);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(120);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getSuperDesc:()Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass3 = objectStreamClass.getSuperDesc();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
        this.writeClassDesc(objectStreamClass3, false);
    }

    private void writeString(String string, boolean bl) throws IOException {
        String string2;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = string;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.handles.assign(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.getUTFLength:(Ljava/lang/String;)J");
        long l = this.bout.getUTFLength(string);
        RuntimeCostAccounter.recordJump();
        if (l <= 65535L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
            this.bout.writeByte(116);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeUTF:(Ljava/lang/String;J)V");
            this.bout.writeUTF(string, l);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
            this.bout.writeByte(124);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeLongUTF:(Ljava/lang/String;J)V");
            this.bout.writeLongUTF(string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeArray(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        Object object2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(117);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
        this.writeClassDesc(objectStreamClass, false);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            object2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            object2 = object;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.handles.assign(object2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
        Class<?> clazz = objectStreamClass.forClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
        Class<?> clazz2 = clazz.getComponentType();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isPrimitive:()Z");
        boolean bl2 = clazz2.isPrimitive();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])object;
                int n = nArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n2 = nArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInts:([III)V");
                this.bout.writeInts(nArray, 0, n2);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                int n = byArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n3 = byArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:([BIIZ)V");
                this.bout.write(byArray, 0, n3, true);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])object;
                int n = lArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n4 = lArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeLongs:([JII)V");
                this.bout.writeLongs(lArray, 0, n4);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])object;
                int n = fArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n5 = fArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeFloats:([FII)V");
                this.bout.writeFloats(fArray, 0, n5);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                int n = dArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n6 = dArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeDoubles:([DII)V");
                this.bout.writeDoubles(dArray, 0, n6);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])object;
                int n = sArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n7 = sArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeShorts:([SII)V");
                this.bout.writeShorts(sArray, 0, n7);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Character.TYPE) {
                char[] cArray = (char[])object;
                int n = cArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n8 = cArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeChars:([CII)V");
                this.bout.writeChars(cArray, 0, n8);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                int n = blArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
                this.bout.writeInt(n);
                int n9 = blArray.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeBooleans:([ZII)V");
                this.bout.writeBooleans(blArray, 0, n9);
                RuntimeCostAccounter.recordJump();
                return;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeInt:(I)V");
        this.bout.writeInt(n);
        RuntimeCostAccounter.recordJump();
        if (extendedDebugInfo) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("array (class \"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz3 = object.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz3.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("\", size: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder6.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.push:(Ljava/lang/String;)V");
            this.debugInfoStack.push(string2);
        }
        try {
            int n10 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n10 >= n) break;
                RuntimeCostAccounter.recordJump();
                if (extendedDebugInfo) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder.append("element of array (index: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder8 = stringBuilder7.append(n10);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder9 = stringBuilder8.append(")");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder9.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.push:(Ljava/lang/String;)V");
                    this.debugInfoStack.push(string);
                }
                try {
                    Object object3 = objectArray[n10];
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject0:(Ljava/lang/Object;Z)V");
                    this.writeObject0(object3, false);
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordJump();
                    if (extendedDebugInfo) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                        this.debugInfoStack.pop();
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordJump();
                if (extendedDebugInfo) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                    this.debugInfoStack.pop();
                    RuntimeCostAccounter.recordJump();
                }
                ++n10;
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (extendedDebugInfo) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                this.debugInfoStack.pop();
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (!extendedDebugInfo) return;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
        this.debugInfoStack.pop();
        RuntimeCostAccounter.recordJump();
    }

    private void writeEnum(Enum<?> enum_, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        Enum<?> enum_2;
        ObjectStreamClass objectStreamClass2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
        this.bout.writeByte(126);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getSuperDesc:()Ljava/io/ObjectStreamClass;");
        ObjectStreamClass objectStreamClass3 = objectStreamClass.getSuperDesc();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
        Class<?> clazz = objectStreamClass3.forClass();
        RuntimeCostAccounter.recordJump();
        if (clazz == Enum.class) {
            objectStreamClass2 = objectStreamClass;
            RuntimeCostAccounter.recordJump();
        } else {
            objectStreamClass2 = objectStreamClass3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
        this.writeClassDesc(objectStreamClass2, false);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            enum_2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            enum_2 = enum_;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
        this.handles.assign(enum_2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.name:()Ljava/lang/String;");
        String string = enum_.name();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeString:(Ljava/lang/String;Z)V");
        this.writeString(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOrdinaryObject(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        block11: {
            RuntimeCostAccounter.recordJump();
            if (extendedDebugInfo) {
                String string;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordJump();
                if (this.depth == 1) {
                    string = "root ";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = "";
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append("object (class \"");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = object.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
                String string2 = clazz.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append("\", ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
                String string3 = object.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(string3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(")");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string4 = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.push:(Ljava/lang/String;)V");
                this.debugInfoStack.push(string4);
            }
            try {
                Object object2;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.checkSerialize:()V");
                objectStreamClass.checkSerialize();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
                this.bout.writeByte(115);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeClassDesc:(Ljava/io/ObjectStreamClass;Z)V");
                this.writeClassDesc(objectStreamClass, false);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    object2 = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    object2 = object;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
                this.handles.assign(object2);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.isExternalizable:()Z");
                boolean bl2 = objectStreamClass.isExternalizable();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.isProxy:()Z");
                    boolean bl3 = objectStreamClass.isProxy();
                    RuntimeCostAccounter.recordJump();
                    if (!bl3) {
                        Externalizable externalizable = (Externalizable)object;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeExternalData:(Ljava/io/Externalizable;)V");
                        this.writeExternalData(externalizable);
                        RuntimeCostAccounter.recordJump();
                        break block11;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeSerialData:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
                this.writeSerialData(object, objectStreamClass);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordJump();
                if (extendedDebugInfo) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                    this.debugInfoStack.pop();
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (extendedDebugInfo) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
            this.debugInfoStack.pop();
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalData(Externalizable externalizable) throws IOException {
        PutFieldImpl putFieldImpl = this.curPut;
        this.curPut = null;
        RuntimeCostAccounter.recordJump();
        if (extendedDebugInfo) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.push:(Ljava/lang/String;)V");
            this.debugInfoStack.push("writeExternal data");
        }
        SerialCallbackContext serialCallbackContext = this.curContext;
        try {
            this.curContext = null;
            RuntimeCostAccounter.recordJump();
            if (this.protocol == 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Externalizable.writeExternal:(Ljava/io/ObjectOutput;)V");
                externalizable.writeExternal(this);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                this.bout.setBlockDataMode(true);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Externalizable.writeExternal:(Ljava/io/ObjectOutput;)V");
                externalizable.writeExternal(this);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                this.bout.setBlockDataMode(false);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
                this.bout.writeByte(120);
            }
            this.curContext = serialCallbackContext;
        }
        catch (Throwable throwable) {
            this.curContext = serialCallbackContext;
            RuntimeCostAccounter.recordJump();
            if (extendedDebugInfo) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                this.debugInfoStack.pop();
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        if (extendedDebugInfo) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
            this.debugInfoStack.pop();
            RuntimeCostAccounter.recordJump();
        }
        this.curPut = putFieldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getClassDataLayout:()[Ljava/io/ObjectStreamClass$ClassDataSlot;");
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        int n = 0;
        while (true) {
            block7: {
                ObjectStreamClass objectStreamClass2;
                block6: {
                    int n2 = classDataSlotArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n >= n2) break;
                    objectStreamClass2 = classDataSlotArray[n].desc;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.hasWriteObjectMethod:()Z");
                    boolean bl = objectStreamClass2.hasWriteObjectMethod();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block6;
                    PutFieldImpl putFieldImpl = this.curPut;
                    this.curPut = null;
                    SerialCallbackContext serialCallbackContext = this.curContext;
                    RuntimeCostAccounter.recordJump();
                    if (extendedDebugInfo) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("custom writeObject data (class \"");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getName:()Ljava/lang/String;");
                        String string = objectStreamClass2.getName();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder3.append("\")");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string2 = stringBuilder4.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.push:(Ljava/lang/String;)V");
                        this.debugInfoStack.push(string2);
                    }
                    try {
                        RuntimeCostAccounter.recordAllocation((String)"java/io/SerialCallbackContext");
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.<init>:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
                        this.curContext = new SerialCallbackContext(object, objectStreamClass2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                        this.bout.setBlockDataMode(true);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.invokeWriteObject:(Ljava/lang/Object;Ljava/io/ObjectOutputStream;)V");
                        objectStreamClass2.invokeWriteObject(object, this);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
                        this.bout.setBlockDataMode(false);
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
                        this.bout.writeByte(120);
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.setUsed:()V");
                        this.curContext.setUsed();
                        this.curContext = serialCallbackContext;
                        RuntimeCostAccounter.recordJump();
                        if (extendedDebugInfo) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                            this.debugInfoStack.pop();
                        }
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/SerialCallbackContext.setUsed:()V");
                    this.curContext.setUsed();
                    this.curContext = serialCallbackContext;
                    RuntimeCostAccounter.recordJump();
                    if (extendedDebugInfo) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                        this.debugInfoStack.pop();
                        RuntimeCostAccounter.recordJump();
                    }
                    this.curPut = putFieldImpl;
                    RuntimeCostAccounter.recordJump();
                    break block7;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteFields:(Ljava/lang/Object;Ljava/io/ObjectStreamClass;)V");
                this.defaultWriteFields(object, objectStreamClass2);
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultWriteFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        int n;
        block14: {
            block13: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.forClass:()Ljava/lang/Class;");
                Class<?> clazz = objectStreamClass.forClass();
                RuntimeCostAccounter.recordJump();
                if (clazz != null) {
                    RuntimeCostAccounter.recordJump();
                    if (object != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isInstance:(Ljava/lang/Object;)Z");
                        boolean bl = clazz.isInstance(object);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:()V");
                            ClassCastException classCastException = new ClassCastException();
                            RuntimeCostAccounter.recordThrow();
                            throw classCastException;
                        }
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.checkDefaultSerialize:()V");
                objectStreamClass.checkDefaultSerialize();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getPrimDataSize:()I");
                n = objectStreamClass.getPrimDataSize();
                RuntimeCostAccounter.recordJump();
                if (this.primVals == null) break block13;
                int n2 = this.primVals.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break block14;
            }
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)1);
            this.primVals = new byte[n3];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getPrimFieldValues:(Ljava/lang/Object;[B)V");
        objectStreamClass.getPrimFieldValues(object, this.primVals);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:([BIIZ)V");
        this.bout.write(this.primVals, 0, n, false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getFields:(Z)[Ljava/io/ObjectStreamField;");
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getNumObjFields:()I");
        int n4 = objectStreamClass.getNumObjFields();
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
        Object[] objectArray = new Object[n4];
        int n5 = objectStreamFieldArray.length - objectArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getObjFieldValues:(Ljava/lang/Object;[Ljava/lang/Object;)V");
        objectStreamClass.getObjFieldValues(object, objectArray);
        int n6 = 0;
        while (true) {
            int n7 = objectArray.length;
            RuntimeCostAccounter.recordJump();
            if (n6 >= n7) break;
            RuntimeCostAccounter.recordJump();
            if (extendedDebugInfo) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("field (class \"");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getName:()Ljava/lang/String;");
                String string = objectStreamClass.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("\", name: \"");
                ObjectStreamField objectStreamField = objectStreamFieldArray[n5 + n6];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.getName:()Ljava/lang/String;");
                String string2 = objectStreamField.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append("\", type: \"");
                ObjectStreamField objectStreamField2 = objectStreamFieldArray[n5 + n6];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.getType:()Ljava/lang/Class;");
                Class<?> clazz = objectStreamField2.getType();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(clazz);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append("\")");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder8.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.push:(Ljava/lang/String;)V");
                this.debugInfoStack.push(string3);
            }
            try {
                Object object2 = objectArray[n6];
                ObjectStreamField objectStreamField = objectStreamFieldArray[n5 + n6];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.isUnshared:()Z");
                boolean bl = objectStreamField.isUnshared();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject0:(Ljava/lang/Object;Z)V");
                this.writeObject0(object2, bl);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordJump();
                if (extendedDebugInfo) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                    this.debugInfoStack.pop();
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            if (extendedDebugInfo) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                this.debugInfoStack.pop();
                RuntimeCostAccounter.recordJump();
            }
            ++n6;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void writeFatalException(IOException iOException) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.clear:()V");
        this.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        boolean bl = this.bout.setBlockDataMode(false);
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeByte:(I)V");
            this.bout.writeByte(123);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject0:(Ljava/lang/Object;Z)V");
            this.writeObject0(iOException, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.clear:()V");
            this.clear();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
            this.bout.setBlockDataMode(bl);
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.setBlockDataMode:(Z)Z");
        this.bout.setBlockDataMode(bl);
        RuntimeCostAccounter.recordJump();
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    static /* synthetic */ void access$300(ObjectOutputStream objectOutputStream, Object object, boolean bl) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject0:(Ljava/lang/Object;Z)V");
        objectOutputStream.writeObject0(object, bl);
    }

    static /* synthetic */ void access$400(float[] fArray, int n, byte[] byArray, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.floatsToBytes:([FI[BII)V");
        ObjectOutputStream.floatsToBytes(fArray, n, byArray, n2, n3);
    }

    static /* synthetic */ void access$500(double[] dArray, int n, byte[] byArray, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.doublesToBytes:([DI[BII)V");
        ObjectOutputStream.doublesToBytes(dArray, n, byArray, n2, n3);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetBooleanAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetBooleanAction.<init>:(Ljava/lang/String;)V");
        GetBooleanAction getBooleanAction = new GetBooleanAction("sun.io.serialization.extendedDebugInfo");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        Boolean bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)getBooleanAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Boolean.booleanValue:()Z");
        extendedDebugInfo = bl;
    }

    private static class DebugTraceInfoStack {
        private final List<String> stack;

        DebugTraceInfoStack() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
            this.stack = new ArrayList<String>();
        }

        void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.clear:()V");
            this.stack.clear();
        }

        void pop() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n = this.stack.size() - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.remove:(I)Ljava/lang/Object;");
            this.stack.remove(n);
        }

        void push(String string) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("\t- ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            this.stack.add(string2);
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.isEmpty:()Z");
            boolean bl = this.stack.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                int n = this.stack.size();
                while (true) {
                    String string;
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) break;
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder2 = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(this.stack.get(n - 1));
                    RuntimeCostAccounter.recordJump();
                    if (n != 1) {
                        string = "\n";
                        RuntimeCostAccounter.recordJump();
                    } else {
                        string = "";
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string2 = stringBuilder4.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    stringBuilder.append(string2);
                    --n;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder.toString();
        }
    }

    private static class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int n, float f) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectOutputStream$HandleTable");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.<init>:(IF)V");
            this.htab = new HandleTable(n, f);
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            this.reps = new Object[n2];
        }

        void assign(Object object, Object object2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.assign:(Ljava/lang/Object;)I");
            int n = this.htab.assign(object);
            while (true) {
                int n2 = this.reps.length;
                RuntimeCostAccounter.recordJump();
                if (n < n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$ReplaceTable.grow:()V");
                this.grow();
                RuntimeCostAccounter.recordJump();
            }
            this.reps[n] = object2;
        }

        Object lookup(Object object) {
            Object object2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.lookup:(Ljava/lang/Object;)I");
            int n = this.htab.lookup(object);
            RuntimeCostAccounter.recordJump();
            if (n >= 0) {
                object2 = this.reps[n];
                RuntimeCostAccounter.recordJump();
            } else {
                object2 = object;
            }
            return object2;
        }

        void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.size:()I");
            int n = this.htab.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;IILjava/lang/Object;)V");
            Arrays.fill(this.reps, 0, n, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.clear:()V");
            this.htab.clear();
        }

        int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.size:()I");
            return this.htab.size();
        }

        private void grow() {
            int n = (this.reps.length << 1) + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            Object[] objectArray = new Object[n];
            int n2 = this.reps.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.reps, 0, objectArray, 0, n2);
            this.reps = objectArray;
        }
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int n, float f) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.loadFactor = f;
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
            this.spine = new int[n2];
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            this.next = new int[n3];
            int n4 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
            this.objs = new Object[n4];
            this.threshold = (int)((float)n * f);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.clear:()V");
            this.clear();
        }

        int assign(Object object) {
            int n = this.next.length;
            RuntimeCostAccounter.recordJump();
            if (this.size >= n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.growEntries:()V");
                this.growEntries();
            }
            RuntimeCostAccounter.recordJump();
            if (this.size >= this.threshold) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.growSpine:()V");
                this.growSpine();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.insert:(Ljava/lang/Object;I)V");
            this.insert(object, this.size);
            return this.size++;
        }

        int lookup(Object object) {
            RuntimeCostAccounter.recordJump();
            if (this.size == 0) {
                return -1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.hash:(Ljava/lang/Object;)I");
            int n = this.hash(object) % this.spine.length;
            int n2 = this.spine[n];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break;
                Object object2 = this.objs[n2];
                RuntimeCostAccounter.recordJump();
                if (object2 == object) {
                    return n2;
                }
                n2 = this.next[n2];
                RuntimeCostAccounter.recordJump();
            }
            return -1;
        }

        void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([II)V");
            Arrays.fill(this.spine, -1);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;IILjava/lang/Object;)V");
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object object, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.hash:(Ljava/lang/Object;)I");
            int n2 = this.hash(object) % this.spine.length;
            this.objs[n] = object;
            this.next[n] = this.spine[n2];
            this.spine[n2] = n;
        }

        private void growSpine() {
            int n = (this.spine.length << 1) + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)4);
            this.spine = new int[n];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([II)V");
            Arrays.fill(this.spine, -1);
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= this.size) break;
                Object object = this.objs[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$HandleTable.insert:(Ljava/lang/Object;I)V");
                this.insert(object, n2);
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
        }

        private void growEntries() {
            int n;
            int n2 = n = (this.next.length << 1) + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
            int[] nArray = new int[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.next, 0, nArray, 0, this.size);
            this.next = nArray;
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
            Object[] objectArray = new Object[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.objs, 0, objectArray, 0, this.size);
            this.objs = objectArray;
        }

        private int hash(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.identityHashCode:(Ljava/lang/Object;)I");
            return System.identityHashCode(object) & Integer.MAX_VALUE;
        }
    }

    private static class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf;
        private final byte[] hbuf;
        private final char[] cbuf;
        private boolean blkmode;
        private int pos;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream outputStream) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.<init>:()V");
            RuntimeCostAccounter.recordArrayAllocation((int)1024, (int)1);
            this.buf = new byte[1024];
            RuntimeCostAccounter.recordArrayAllocation((int)5, (int)1);
            this.hbuf = new byte[5];
            RuntimeCostAccounter.recordArrayAllocation((int)256, (int)2);
            this.cbuf = new char[256];
            this.blkmode = false;
            this.pos = 0;
            this.out = outputStream;
            RuntimeCostAccounter.recordAllocation((String)"java/io/DataOutputStream");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.<init>:(Ljava/io/OutputStream;)V");
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (this.blkmode == bl) {
                return this.blkmode;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
            this.drain();
            this.blkmode = bl;
            RuntimeCostAccounter.recordJump();
            if (!this.blkmode) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        @Override
        public void write(int n) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos >= 1024) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
                this.drain();
            }
            this.buf[this.pos++] = (byte)n;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            int n = byArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:([BIIZ)V");
            this.write(byArray, 0, n, false);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:([BIIZ)V");
            this.write(byArray, n, n2, false);
        }

        @Override
        public void flush() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
            this.drain();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.flush:()V");
            this.flush();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.close:()V");
            this.out.close();
        }

        void write(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (!this.blkmode) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
                    this.drain();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                    this.out.write(byArray, n, n2);
                    return;
                }
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 <= 0) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos >= 1024) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
                    this.drain();
                }
                RuntimeCostAccounter.recordJump();
                if (n2 >= 1024) {
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordJump();
                        if (this.pos == 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeBlockHeader:(I)V");
                            this.writeBlockHeader(1024);
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                            this.out.write(byArray, n, 1024);
                            n += 1024;
                            n2 -= 1024;
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                int n3 = Math.min(n2, 1024 - this.pos);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(byArray, n, this.buf, this.pos, n3);
                this.pos += n3;
                n += n3;
                n2 -= n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        void drain() throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos == 0) {
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (this.blkmode) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeBlockHeader:(I)V");
                this.writeBlockHeader(this.pos);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int n) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (n <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)n;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                this.out.write(this.hbuf, 0, 2);
                RuntimeCostAccounter.recordJump();
            } else {
                this.hbuf[0] = 122;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putInt:([BII)V");
                Bits.putInt(this.hbuf, 1, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                this.out.write(this.hbuf, 0, 5);
            }
        }

        @Override
        public void writeBoolean(boolean bl) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos >= 1024) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
                this.drain();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putBoolean:([BIZ)V");
            Bits.putBoolean(this.buf, this.pos++, bl);
        }

        @Override
        public void writeByte(int n) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos >= 1024) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
                this.drain();
            }
            this.buf[this.pos++] = (byte)n;
        }

        @Override
        public void writeChar(int n) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos + 2 <= 1024) {
                char c = (char)n;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putChar:([BIC)V");
                Bits.putChar(this.buf, this.pos, c);
                this.pos += 2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeChar:(I)V");
                this.dout.writeChar(n);
            }
        }

        @Override
        public void writeShort(int n) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos + 2 <= 1024) {
                short s = (short)n;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putShort:([BIS)V");
                Bits.putShort(this.buf, this.pos, s);
                this.pos += 2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeShort:(I)V");
                this.dout.writeShort(n);
            }
        }

        @Override
        public void writeInt(int n) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos + 4 <= 1024) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putInt:([BII)V");
                Bits.putInt(this.buf, this.pos, n);
                this.pos += 4;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeInt:(I)V");
                this.dout.writeInt(n);
            }
        }

        @Override
        public void writeFloat(float f) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos + 4 <= 1024) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putFloat:([BIF)V");
                Bits.putFloat(this.buf, this.pos, f);
                this.pos += 4;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeFloat:(F)V");
                this.dout.writeFloat(f);
            }
        }

        @Override
        public void writeLong(long l) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos + 8 <= 1024) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putLong:([BIJ)V");
                Bits.putLong(this.buf, this.pos, l);
                this.pos += 8;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeLong:(J)V");
                this.dout.writeLong(l);
            }
        }

        @Override
        public void writeDouble(double d) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (this.pos + 8 <= 1024) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putDouble:([BID)V");
                Bits.putDouble(this.buf, this.pos, d);
                this.pos += 8;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeDouble:(D)V");
                this.dout.writeDouble(d);
            }
        }

        @Override
        public void writeBytes(String string) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string.length();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 >= n) break;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) {
                    n2 = 0;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    n3 = Math.min(n - n4, 256);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
                    string.getChars(n4, n4 + n3, this.cbuf, 0);
                }
                RuntimeCostAccounter.recordJump();
                if (this.pos >= 1024) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
                    this.drain();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                int n5 = Math.min(n3 - n2, 1024 - this.pos);
                int n6 = this.pos + n5;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (this.pos >= n6) break;
                    this.buf[this.pos++] = (byte)this.cbuf[n2++];
                    RuntimeCostAccounter.recordJump();
                }
                n4 += n5;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public void writeChars(String string) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string.length();
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                int n3 = Math.min(n - n2, 256);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
                string.getChars(n2, n2 + n3, this.cbuf, 0);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeChars:([CII)V");
                this.writeChars(this.cbuf, 0, n3);
                n2 += n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public void writeUTF(String string) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.getUTFLength:(Ljava/lang/String;)J");
            long l = this.getUTFLength(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeUTF:(Ljava/lang/String;J)V");
            this.writeUTF(string, l);
        }

        void writeBooleans(boolean[] blArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n3) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos >= 1024) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.drain:()V");
                    this.drain();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                int n4 = Math.min(n3, n + (1024 - this.pos));
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= n4) break;
                    boolean bl = blArray[n++];
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putBoolean:([BIZ)V");
                    Bits.putBoolean(this.buf, this.pos++, bl);
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            }
        }

        void writeChars(char[] cArray, int n, int n2) throws IOException {
            int n3 = 1022;
            int n4 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n4) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos <= n3) {
                    int n5 = 1024 - this.pos >> 1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    int n6 = Math.min(n4, n + n5);
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n >= n6) break;
                        char c = cArray[n++];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putChar:([BIC)V");
                        Bits.putChar(this.buf, this.pos, c);
                        this.pos += 2;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                char c = cArray[n++];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeChar:(I)V");
                this.dout.writeChar(c);
                RuntimeCostAccounter.recordJump();
            }
        }

        void writeShorts(short[] sArray, int n, int n2) throws IOException {
            int n3 = 1022;
            int n4 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n4) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos <= n3) {
                    int n5 = 1024 - this.pos >> 1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    int n6 = Math.min(n4, n + n5);
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n >= n6) break;
                        short s = sArray[n++];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putShort:([BIS)V");
                        Bits.putShort(this.buf, this.pos, s);
                        this.pos += 2;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                short s = sArray[n++];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeShort:(I)V");
                this.dout.writeShort(s);
                RuntimeCostAccounter.recordJump();
            }
        }

        void writeInts(int[] nArray, int n, int n2) throws IOException {
            int n3 = 1020;
            int n4 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n4) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos <= n3) {
                    int n5 = 1024 - this.pos >> 2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    int n6 = Math.min(n4, n + n5);
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n >= n6) break;
                        int n7 = nArray[n++];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putInt:([BII)V");
                        Bits.putInt(this.buf, this.pos, n7);
                        this.pos += 4;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                int n8 = nArray[n++];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeInt:(I)V");
                this.dout.writeInt(n8);
                RuntimeCostAccounter.recordJump();
            }
        }

        void writeFloats(float[] fArray, int n, int n2) throws IOException {
            int n3 = 1020;
            int n4 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n4) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos <= n3) {
                    int n5 = 1024 - this.pos >> 2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    int n6 = Math.min(n4 - n, n5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$400:([FI[BII)V");
                    ObjectOutputStream.access$400(fArray, n, this.buf, this.pos, n6);
                    n += n6;
                    this.pos += n6 << 2;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                float f = fArray[n++];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeFloat:(F)V");
                this.dout.writeFloat(f);
                RuntimeCostAccounter.recordJump();
            }
        }

        void writeLongs(long[] lArray, int n, int n2) throws IOException {
            int n3 = 1016;
            int n4 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n4) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos <= n3) {
                    int n5 = 1024 - this.pos >> 3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    int n6 = Math.min(n4, n + n5);
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n >= n6) break;
                        long l = lArray[n++];
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putLong:([BIJ)V");
                        Bits.putLong(this.buf, this.pos, l);
                        this.pos += 8;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                long l = lArray[n++];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeLong:(J)V");
                this.dout.writeLong(l);
                RuntimeCostAccounter.recordJump();
            }
        }

        void writeDoubles(double[] dArray, int n, int n2) throws IOException {
            int n3 = 1016;
            int n4 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= n4) break;
                RuntimeCostAccounter.recordJump();
                if (this.pos <= n3) {
                    int n5 = 1024 - this.pos >> 3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    int n6 = Math.min(n4 - n, n5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$500:([DI[BII)V");
                    ObjectOutputStream.access$500(dArray, n, this.buf, this.pos, n6);
                    n += n6;
                    this.pos += n6 << 3;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                double d = dArray[n++];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutputStream.writeDouble:(D)V");
                this.dout.writeDouble(d);
                RuntimeCostAccounter.recordJump();
            }
        }

        /*
         * Unable to fully structure code
         */
        long getUTFLength(String var1_1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            var2_2 = var1_1.length();
            var3_3 = 0L;
            var5_4 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var5_4 >= var2_2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                var6_5 = Math.min(var2_2 - var5_4, 256);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
                var1_1.getChars(var5_4, var5_4 + var6_5, this.cbuf, 0);
                var7_6 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (var7_6 >= var6_5) break;
                    var8_7 = this.cbuf[var7_6];
                    RuntimeCostAccounter.recordJump();
                    if (var8_7 < '\u0001') ** GOTO lbl-1000
                    RuntimeCostAccounter.recordJump();
                    if (var8_7 <= '\u007f') {
                        ++var3_3;
                        RuntimeCostAccounter.recordJump();
                    } else lbl-1000:
                    // 2 sources

                    {
                        RuntimeCostAccounter.recordJump();
                        if (var8_7 > '\u07ff') {
                            var3_3 += 3L;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            var3_3 += 2L;
                        }
                    }
                    ++var7_6;
                    RuntimeCostAccounter.recordJump();
                }
                var5_4 += var6_5;
                RuntimeCostAccounter.recordJump();
            }
            return var3_3;
        }

        void writeUTF(String string, long l) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (l > 65535L) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/UTFDataFormatException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/UTFDataFormatException.<init>:()V");
                UTFDataFormatException uTFDataFormatException = new UTFDataFormatException();
                RuntimeCostAccounter.recordThrow();
                throw uTFDataFormatException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeShort:(I)V");
            this.writeShort(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            long l2 = l - (long)string.length();
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 == false) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeBytes:(Ljava/lang/String;)V");
                this.writeBytes(string);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeUTFBody:(Ljava/lang/String;)V");
                this.writeUTFBody(string);
            }
        }

        void writeLongUTF(String string) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.getUTFLength:(Ljava/lang/String;)J");
            long l = this.getUTFLength(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeLongUTF:(Ljava/lang/String;J)V");
            this.writeLongUTF(string, l);
        }

        void writeLongUTF(String string, long l) throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeLong:(J)V");
            this.writeLong(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            long l2 = l - (long)string.length();
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 == false) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeBytes:(Ljava/lang/String;)V");
                this.writeBytes(string);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.writeUTFBody:(Ljava/lang/String;)V");
                this.writeUTFBody(string);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void writeUTFBody(String var1_1) throws IOException {
            var2_2 = 1021;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            var3_3 = var1_1.length();
            var4_4 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var4_4 >= var3_3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                var5_5 = Math.min(var3_3 - var4_4, 256);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
                var1_1.getChars(var4_4, var4_4 + var5_5, this.cbuf, 0);
                var6_6 = 0;
                while (true) {
                    block11: {
                        block10: {
                            RuntimeCostAccounter.recordJump();
                            if (var6_6 >= var5_5) break;
                            var7_7 = this.cbuf[var6_6];
                            RuntimeCostAccounter.recordJump();
                            if (this.pos > var2_2) break block10;
                            RuntimeCostAccounter.recordJump();
                            if (var7_7 > '\u007f') ** GOTO lbl-1000
                            RuntimeCostAccounter.recordJump();
                            if (var7_7 != '\u0000') {
                                this.buf[this.pos++] = (byte)var7_7;
                                RuntimeCostAccounter.recordJump();
                            } else lbl-1000:
                            // 2 sources

                            {
                                RuntimeCostAccounter.recordJump();
                                if (var7_7 > '\u07ff') {
                                    this.buf[this.pos + 2] = (byte)(128 | var7_7 >> 0 & 63);
                                    this.buf[this.pos + 1] = (byte)(128 | var7_7 >> 6 & 63);
                                    this.buf[this.pos + 0] = (byte)(224 | var7_7 >> 12 & 15);
                                    this.pos += 3;
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    this.buf[this.pos + 1] = (byte)(128 | var7_7 >> 0 & 63);
                                    this.buf[this.pos + 0] = (byte)(192 | var7_7 >> 6 & 31);
                                    this.pos += 2;
                                    RuntimeCostAccounter.recordJump();
                                }
                            }
                            break block11;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var7_7 > '\u007f') ** GOTO lbl-1000
                        RuntimeCostAccounter.recordJump();
                        if (var7_7 != '\u0000') {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:(I)V");
                            this.write(var7_7);
                            RuntimeCostAccounter.recordJump();
                        } else lbl-1000:
                        // 2 sources

                        {
                            RuntimeCostAccounter.recordJump();
                            if (var7_7 > '\u07ff') {
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:(I)V");
                                this.write(224 | var7_7 >> 12 & 15);
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:(I)V");
                                this.write(128 | var7_7 >> 6 & 63);
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:(I)V");
                                this.write(128 | var7_7 >> 0 & 63);
                                RuntimeCostAccounter.recordJump();
                            } else {
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:(I)V");
                                this.write(192 | var7_7 >> 6 & 31);
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:(I)V");
                                this.write(128 | var7_7 >> 0 & 63);
                            }
                        }
                    }
                    ++var6_6;
                    RuntimeCostAccounter.recordJump();
                }
                var4_4 += var5_5;
                RuntimeCostAccounter.recordJump();
            }
        }
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass objectStreamClass) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.<init>:()V");
            this.desc = objectStreamClass;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getPrimDataSize:()I");
            int n = objectStreamClass.getPrimDataSize();
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)1);
            this.primVals = new byte[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getNumObjFields:()I");
            int n2 = objectStreamClass.getNumObjFields();
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            this.objVals = new Object[n2];
        }

        @Override
        public void put(String string, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Boolean.TYPE);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putBoolean:([BIZ)V");
            Bits.putBoolean(this.primVals, n, bl);
        }

        @Override
        public void put(String string, byte by) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            this.primVals[this.getFieldOffset((String)string, Byte.TYPE)] = by;
        }

        @Override
        public void put(String string, char c) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Character.TYPE);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putChar:([BIC)V");
            Bits.putChar(this.primVals, n, c);
        }

        @Override
        public void put(String string, short s) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Short.TYPE);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putShort:([BIS)V");
            Bits.putShort(this.primVals, n, s);
        }

        @Override
        public void put(String string, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n2 = this.getFieldOffset(string, Integer.TYPE);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putInt:([BII)V");
            Bits.putInt(this.primVals, n2, n);
        }

        @Override
        public void put(String string, float f) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Float.TYPE);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putFloat:([BIF)V");
            Bits.putFloat(this.primVals, n, f);
        }

        @Override
        public void put(String string, long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Long.TYPE);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putLong:([BIJ)V");
            Bits.putLong(this.primVals, n, l);
        }

        @Override
        public void put(String string, double d) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            int n = this.getFieldOffset(string, Double.TYPE);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putDouble:([BID)V");
            Bits.putDouble(this.primVals, n, d);
        }

        @Override
        public void put(String string, Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutFieldImpl.getFieldOffset:(Ljava/lang/String;Ljava/lang/Class;)I");
            this.objVals[this.getFieldOffset((String)string, Object.class)] = object;
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            RuntimeCostAccounter.recordJump();
            if (ObjectOutputStream.this != objectOutput) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("wrong stream");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = this.primVals.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.write:([BII)V");
            objectOutput.write(this.primVals, 0, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getFields:(Z)[Ljava/io/ObjectStreamField;");
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n2 = objectStreamFieldArray.length - this.objVals.length;
            int n3 = 0;
            while (true) {
                int n4 = this.objVals.length;
                RuntimeCostAccounter.recordJump();
                if (n3 >= n4) break;
                ObjectStreamField objectStreamField = objectStreamFieldArray[n2 + n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.isUnshared:()Z");
                boolean bl = objectStreamField.isUnshared();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("cannot write unshared object");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                Object object = this.objVals[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.writeObject:(Ljava/lang/Object;)V");
                objectOutput.writeObject(object);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeFields() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$000:(Ljava/io/ObjectOutputStream;)Ljava/io/ObjectOutputStream$BlockDataOutputStream;");
            BlockDataOutputStream blockDataOutputStream = ObjectOutputStream.this.bout;
            int n = this.primVals.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$BlockDataOutputStream.write:([BIIZ)V");
            blockDataOutputStream.write(this.primVals, 0, n, false);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getFields:(Z)[Ljava/io/ObjectStreamField;");
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n2 = objectStreamFieldArray.length - this.objVals.length;
            int n3 = 0;
            while (true) {
                int n4 = this.objVals.length;
                RuntimeCostAccounter.recordJump();
                if (n3 >= n4) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$100:()Z");
                boolean bl = extendedDebugInfo;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$200:(Ljava/io/ObjectOutputStream;)Ljava/io/ObjectOutputStream$DebugTraceInfoStack;");
                    DebugTraceInfoStack debugTraceInfoStack = ObjectOutputStream.this.debugInfoStack;
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("field (class \"");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getName:()Ljava/lang/String;");
                    String string = this.desc.getName();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append("\", name: \"");
                    ObjectStreamField objectStreamField = objectStreamFieldArray[n2 + n3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.getName:()Ljava/lang/String;");
                    String string2 = objectStreamField.getName();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder5.append("\", type: \"");
                    ObjectStreamField objectStreamField2 = objectStreamFieldArray[n2 + n3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.getType:()Ljava/lang/Class;");
                    Class<?> clazz = objectStreamField2.getType();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(clazz);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder8 = stringBuilder7.append("\")");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string3 = stringBuilder8.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.push:(Ljava/lang/String;)V");
                    debugTraceInfoStack.push(string3);
                }
                try {
                    Object object = this.objVals[n3];
                    ObjectStreamField objectStreamField = objectStreamFieldArray[n2 + n3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.isUnshared:()Z");
                    boolean bl2 = objectStreamField.isUnshared();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$300:(Ljava/io/ObjectOutputStream;Ljava/lang/Object;Z)V");
                    ObjectOutputStream.access$300(ObjectOutputStream.this, object, bl2);
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$100:()Z");
                    boolean bl3 = extendedDebugInfo;
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$200:(Ljava/io/ObjectOutputStream;)Ljava/io/ObjectOutputStream$DebugTraceInfoStack;");
                        DebugTraceInfoStack debugTraceInfoStack = ObjectOutputStream.this.debugInfoStack;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                        debugTraceInfoStack.pop();
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$100:()Z");
                boolean bl4 = extendedDebugInfo;
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.access$200:(Ljava/io/ObjectOutputStream;)Ljava/io/ObjectOutputStream$DebugTraceInfoStack;");
                    DebugTraceInfoStack debugTraceInfoStack = ObjectOutputStream.this.debugInfoStack;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$DebugTraceInfoStack.pop:()V");
                    debugTraceInfoStack.pop();
                    RuntimeCostAccounter.recordJump();
                }
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }

        private int getFieldOffset(String string, Class<?> clazz) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamClass.getField:(Ljava/lang/String;Ljava/lang/Class;)Ljava/io/ObjectStreamField;");
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            RuntimeCostAccounter.recordJump();
            if (objectStreamField == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("no such field ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(" with type ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(clazz);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.getOffset:()I");
            return objectStreamField.getOffset();
        }
    }

    public static abstract class PutField {
        public PutField() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits;
        static final ReferenceQueue<Class<?>> subclassAuditsQueue;

        private Caches() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
            subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/ReferenceQueue");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.<init>:()V");
            subclassAuditsQueue = new ReferenceQueue();
        }
    }
}

