/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Iterator;
import sandbox.java.util.LinkedHashMap;
import sandbox.java.util.Map;
import sandbox.java.util.Set;

class ExpiringCache {
    private long millisUntilExpiration;
    private Map<String, Entry> map;
    private int queryCount;
    private int queryOverflow;
    private int MAX_ENTRIES;

    ExpiringCache() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.<init>:(J)V");
        this(30000L);
    }

    ExpiringCache(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.queryOverflow = 300;
        this.MAX_ENTRIES = 200;
        this.millisUntilExpiration = l;
        RuntimeCostAccounter.recordAllocation((String)"java/io/ExpiringCache$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache$1.<init>:(Ljava/io/ExpiringCache;)V");
        this.map = new LinkedHashMap<String, Entry>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedHashMap.<init>:()V");
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Entry> entry) {
                boolean bl;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache$1.size:()I");
                int n = this.size();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.access$000:(Ljava/io/ExpiringCache;)I");
                int n2 = ExpiringCache.this.MAX_ENTRIES;
                RuntimeCostAccounter.recordJump();
                if (n > n2) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                return bl;
            }
        };
    }

    synchronized String get(String string) {
        RuntimeCostAccounter.recordJump();
        if (++this.queryCount >= this.queryOverflow) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.cleanup:()V");
            this.cleanup();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.entryFor:(Ljava/lang/String;)Ljava/io/ExpiringCache$Entry;");
        Entry entry = this.entryFor(string);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache$Entry.val:()Ljava/lang/String;");
            return entry.val();
        }
        return null;
    }

    synchronized void put(String string, String string2) {
        RuntimeCostAccounter.recordJump();
        if (++this.queryCount >= this.queryOverflow) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.cleanup:()V");
            this.cleanup();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.entryFor:(Ljava/lang/String;)Ljava/io/ExpiringCache$Entry;");
        Entry entry = this.entryFor(string);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
            long l = System.currentTimeMillis();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache$Entry.setTimestamp:(J)V");
            entry.setTimestamp(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache$Entry.setVal:(Ljava/lang/String;)V");
            entry.setVal(string2);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/io/ExpiringCache$Entry");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
            long l = System.currentTimeMillis();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache$Entry.<init>:(JLjava/lang/String;)V");
            Entry entry2 = new Entry(l, string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.map.put(string, entry2);
        }
    }

    synchronized void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.clear:()V");
        this.map.clear();
    }

    private Entry entryFor(String string) {
        Entry entry;
        block2: {
            block3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                entry = this.map.get(string);
                RuntimeCostAccounter.recordJump();
                if (entry == null) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
                long l = System.currentTimeMillis();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache$Entry.timestamp:()J");
                long l2 = l - entry.timestamp();
                RuntimeCostAccounter.recordJump();
                if (l2 < 0L) break block3;
                RuntimeCostAccounter.recordJump();
                if (l2 < this.millisUntilExpiration) break block2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.map.remove(string);
            entry = null;
        }
        return entry;
    }

    private void cleanup() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
        Set<String> set = this.map.keySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
        int n = set.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        String[] stringArray = new String[n];
        int n2 = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<String> iterator = set.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            String string = iterator.next();
            stringArray[n2++] = string;
            RuntimeCostAccounter.recordJump();
        }
        int n3 = 0;
        while (true) {
            int n4 = stringArray.length;
            RuntimeCostAccounter.recordJump();
            if (n3 >= n4) break;
            String string = stringArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.entryFor:(Ljava/lang/String;)Ljava/io/ExpiringCache$Entry;");
            this.entryFor(string);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        this.queryCount = 0;
    }

    static class Entry {
        private long timestamp;
        private String val;

        Entry(long l, String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.timestamp = l;
            this.val = string;
        }

        long timestamp() {
            return this.timestamp;
        }

        void setTimestamp(long l) {
            this.timestamp = l;
        }

        String val() {
            return this.val;
        }

        void setVal(String string) {
            this.val = string;
        }
    }
}

