/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.Writer;
import sandbox.java.util.Arrays;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayWriter.<init>:(I)V");
        this(32);
    }

    public CharArrayWriter(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Negative initial size: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)2);
        this.buf = new char[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        Object object = this.lock;
        try {
            int n2 = this.count + 1;
            int n3 = this.buf.length;
            RuntimeCostAccounter.recordJump();
            if (n2 > n3) {
                int n4 = this.buf.length << 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                int n5 = Math.max(n4, n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([CI)[C");
                this.buf = Arrays.copyOf(this.buf, n5);
            }
            this.buf[this.count] = (char)n;
            this.count = n2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        block8: {
            block7: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block7;
                int n3 = cArray.length;
                RuntimeCostAccounter.recordJump();
                if (n > n3) break block7;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block7;
                int n4 = cArray.length;
                RuntimeCostAccounter.recordJump();
                if (n + n2 > n4) break block7;
                RuntimeCostAccounter.recordJump();
                if (n + n2 >= 0) break block8;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        try {
            int n5 = this.count + n2;
            int n6 = this.buf.length;
            RuntimeCostAccounter.recordJump();
            if (n5 > n6) {
                int n7 = this.buf.length << 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                int n8 = Math.max(n7, n5);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([CI)[C");
                this.buf = Arrays.copyOf(this.buf, n8);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count = n5;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) {
        Object object = this.lock;
        try {
            int n3 = this.count + n2;
            int n4 = this.buf.length;
            RuntimeCostAccounter.recordJump();
            if (n3 > n4) {
                int n5 = this.buf.length << 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                int n6 = Math.max(n5, n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([CI)[C");
                this.buf = Arrays.copyOf(this.buf, n6);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
            string.getChars(n, n + n2, this.buf, this.count);
            this.count = n3;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:([CII)V");
            writer.write(this.buf, 0, this.count);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public CharArrayWriter append(CharSequence charSequence) {
        String string;
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            string = "null";
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
            string = charSequence.toString();
        }
        String string2 = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string2.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayWriter.write:(Ljava/lang/String;II)V");
        this.write(string2, 0, n);
        return this;
    }

    @Override
    public CharArrayWriter append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2;
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            charSequence2 = "null";
            RuntimeCostAccounter.recordJump();
        } else {
            charSequence2 = charSequence;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
        CharSequence charSequence3 = charSequence2.subSequence(n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        String string = charSequence3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n3 = string.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayWriter.write:(Ljava/lang/String;II)V");
        this.write(string, 0, n3);
        return this;
    }

    @Override
    public CharArrayWriter append(char c) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayWriter.write:(I)V");
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([CI)[C");
            return Arrays.copyOf(this.buf, this.count);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([CII)V");
            return new String(this.buf, 0, this.count);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

