/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;

class Bits {
    Bits() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    static boolean getBoolean(byte[] byArray, int n) {
        boolean bl;
        byte by = byArray[n];
        RuntimeCostAccounter.recordJump();
        if (by != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    static char getChar(byte[] byArray, int n) {
        return (char)((byArray[n + 1] & 0xFF) + (byArray[n] << 8));
    }

    static short getShort(byte[] byArray, int n) {
        return (short)((byArray[n + 1] & 0xFF) + (byArray[n] << 8));
    }

    static int getInt(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + (byArray[n] << 24);
    }

    static float getFloat(byte[] byArray, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getInt:([BI)I");
        int n2 = Bits.getInt(byArray, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.intBitsToFloat:(I)F");
        return Float.intBitsToFloat(n2);
    }

    static long getLong(byte[] byArray, int n) {
        return ((long)byArray[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + ((long)byArray[n] << 56);
    }

    static double getDouble(byte[] byArray, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.getLong:([BI)J");
        long l = Bits.getLong(byArray, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
        return Double.longBitsToDouble(l);
    }

    static void putBoolean(byte[] byArray, int n, boolean bl) {
        boolean bl2;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            bl2 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl2 = false;
        }
        byArray[n] = (byte)(bl2 ? 1 : 0);
    }

    static void putChar(byte[] byArray, int n, char c) {
        byArray[n + 1] = (byte)c;
        byArray[n] = (byte)(c >>> 8);
    }

    static void putShort(byte[] byArray, int n, short s) {
        byArray[n + 1] = (byte)s;
        byArray[n] = (byte)(s >>> 8);
    }

    static void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)n2;
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n] = (byte)(n2 >>> 24);
    }

    static void putFloat(byte[] byArray, int n, float f) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.floatToIntBits:(F)I");
        int n2 = Float.floatToIntBits(f);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putInt:([BII)V");
        Bits.putInt(byArray, n, n2);
    }

    static void putLong(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)l;
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n] = (byte)(l >>> 56);
    }

    static void putDouble(byte[] byArray, int n, double d) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToLongBits:(D)J");
        long l = Double.doubleToLongBits(d);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Bits.putLong:([BIJ)V");
        Bits.putLong(byArray, n, l);
    }
}

