class ObjectGroup:
    """
    An abstraction that encompasses a group of objects that interact together in a meaningful way
    name (str): Name of this object group. This will be prepended to all objects generated by this group.
    """

    def __init__(self, name):
        # Store internal variables
        self.name = name
        self.sim = None  # Reference to shared mjsim object
        self._objects = {}  # maps object names to object class instances

        # Generate objects
        self._generate_objects()

    def get_states(self):
        """
        Function to grab group-relevant states. This should be implemented by the subclass.
        Returns:
            dict: Keyword-mapped states for this group
        """
        raise NotImplementedError

    def update_sim(self, sim):
        """
        Updates internal reference to sim and all other relevant references
        Args:
            sim (MjSim): Active mujoco sim reference
        """
        self.sim = sim

    def _generate_objects(self):
        """
        Internal helper function that generates the objects for this group. Should populate self._objects mapping
        names of objects to their actual object class instances.
        """
        raise NotImplementedError

    @property
    def objects(self):
        """
        Contains references to all objects owned by this group. Mapped from names to object instances
        Returns:
            dict: keyword-mapped object class instances
        """
        return self._objects
