# Projects using robosuite

A list of references of projects and papers that use **robosuite**. If you would like to add your work to this list, please send the paper information to Yuke Zhu ([yukez@cs.utexas.edu](mailto:yukez@cs.utexas.edu)).

## 2022

- [Robot Learning on the Job: Human-in-the-Loop Autonomy and Learning During Deployment](https://arxiv.org/abs/2211.08416). Huihan Liu, Soroush Nasiriany, Lance Zhang, Zhiyao Bao, Yuke Zhu
- [Geometric Impedance Control on SE(3) for Robotic Manipulators](https://arxiv.org/abs/2211.07945). Joohwan Seo, Nikhil Potu, Surya Prakash, Alexander Rose, Roberto Horowitz
- [Guided Skill Learning and Abstraction for Long-Horizon Manipulation](https://arxiv.org/abs/2210.12631). Shuo Cheng, Danfei Xu
- [VIOLA: Imitation Learning for Vision-Based Manipulation with Object Proposal Priors](https://arxiv.org/abs/2210.11339). Yifeng Zhu, Abhishek Joshi, Peter Stone, Yuke Zhu
- [Monte Carlo Augmented Actor-Critic for Sparse Reward Deep Reinforcement Learning from Suboptimal Demonstrations](https://arxiv.org/abs/2210.07432). Albert Wilcox, Ashwin Balakrishna, Jules Dedieu, Wyame Benslimane, Daniel S. Brown, Ken Goldberg
- [ASPiRe: Adaptive Skill Priors for Reinforcement Learning](https://arxiv.org/abs/2209.15205). Mengda Xu, Manuela Veloso, Shuran Song
- [Active Predicting Coding: Brain-Inspired Reinforcement Learning for Sparse Reward Robotic Control Problems](https://arxiv.org/abs/2209.09174). Alexander Ororbia, Ankur Mali
- [Spatial and Temporal Features Unified Self-Supervised Representation Learning Network](https://www.sciencedirect.com/science/article/pii/S0921889022001506). Rahul Choudhary, Rahee Walambe, Ketan Kotecha
- [HERD: Continuous Human-to-Robot Evolution for Learning from Human Demonstration](https://openreview.net/forum?id=VHia4Cint7). Xingyu Liu, Deepak Pathak, Kris M. Kitani
- [A Dual Representation Framework for Robot Learning with Human Guidance](https://openreview.net/forum?id=H6rr_CGzV9y). Ruohan Zhang, Dhruva Bansal, Yilun Hao, Ayano Hiranaka, Jialu Gao, Chen Wang, Roberto Martín-Martín, Li Fei-Fei, Jiajun Wu
- [CompoSuite: A Compositional Reinforcement Learning Benchmark](https://arxiv.org/abs/2207.04136). Jorge A. Mendez, Marcel Hussing, Meghna Gummadi, Eric Eaton
- [Causal Dynamics Learning for Task-Independent State Abstraction](https://arxiv.org/abs/2206.13452). Zizhao Wang, Xuesu Xiao, Zifan Xu, Yuke Zhu, Peter Stone
- [Latent Policies for Adversarial Imitation Learning](https://arxiv.org/abs/2206.11299). Tianyu Wang, Nikhil Karnwal, Nikolay Atanasov
- [Play it by Ear: Learning Skills amidst Occlusion through Audio-Visual Imitation Learning](https://arxiv.org/abs/2205.14850). Maximilian Du, Olivia Y. Lee, Suraj Nair, Chelsea Finn
- [Visuotactile-RL: Learning Multimodal Manipulation Policies with Deep Reinforcement Learning](https://ieeexplore.ieee.org/abstract/document/9812019). Johanna Hansen, Francois Hogan, Dmitriy Rivkin, David Meger, Michael Jenkin, Gregory Dudek
- [DreamingV2: Reinforcement Learning with Discrete World Models without Reconstruction](https://arxiv.org/abs/2203.00494). Masashi Okada, Tadahiro Taniguchi
- [Ditto: Building Digital Twins of Articulated Objects from Interaction](https://arxiv.org/abs/2202.08227). Zhenyu Jiang, Cheng-Chun Hsu, Yuke Zhu
- [A Ranking Game for Imitation Learning](https://arxiv.org/abs/2202.03481). Harshit Sikchi, Akanksha Saran, Wonjoon Goo, Scott Niekum
- [Learning to Grasp the Ungraspable with Emergent Extrinsic Dexterity](https://arxiv.org/abs/2211.01500). Wenxuan Zhou, David Held
- [Efficiently Learning Recoveries from Failures Under Partial Observability](https://arxiv.org/abs/2209.13605). Shivam Vats, Maxim Likhachev, Oliver Kroemer
- [Learning Representations via a Robust Behavioral Metric for Deep Reinforcement Learning](https://openreview.net/forum?id=7YXXt9lRls). Jianda Chen, Sinno Pan
- [Synthesizing Adversarial Visual Scenarios for Model-Based Robotic Control](https://openreview.net/forum?id=WJbw_C-pCox). Shubhankar Agarwal, Sandeep P. Chinchali

## 2021

- [Guided Imitation of Task and Motion Planning](https://arxiv.org/abs/2112.03386). Michael McDonald, Dylan Hadfield-Menell
- [V-MAO: Generative Modeling for Multi-Arm Manipulation of Articulated Objects](https://arxiv.org/abs/2111.03987). Xingyu Liu, Kris M. Kitani
- [Koopman Q-learning: Offline Reinforcement Learning via Symmetries of Dynamics](https://arxiv.org/abs/2111.01365). Matthias Weissenbacher, Samarth Sinha, Animesh Garg, Yoshinobu Kawahara
- [Validate on Sim, Detect on Real -- Model Selection for Domain Randomization](https://arxiv.org/abs/2111.00765). Gal Leibovich, Guy Jacob, Shadi Endrawis, Gal Novik, Aviv Tamar
- [Accelerating Robotic Reinforcement Learning via Parameterized Action Primitives](https://arxiv.org/abs/2110.15360). Murtaza Dalal, Deepak Pathak, Ruslan Salakhutdinov
- [Towards More Generalizable One-shot Visual Imitation Learning](https://arxiv.org/abs/2110.13423). Zhao Mandi, Fangchen Liu, Kimin Lee, Pieter Abbeel
- [Decentralized Multi-Agent Control of a Manipulator in Continuous Task Learning](https://www.mdpi.com/2076-3417/11/21/10227). Asad Ali Shahid, Jorge Said Vidal Sesin, Damjan Pecioski, Francesco Braghin, Dario Piga, Loris Roveda
- [Augmenting Reinforcement Learning with Behavior Primitives for Diverse Manipulation Tasks](https://arxiv.org/abs/2110.03655). Soroush Nasiriany, Huihan Liu, Yuke Zhu
- [Bottom-Up Skill Discovery from Unsegmented Demonstrations for Long-Horizon Robot Manipulation](https://arxiv.org/abs/2109.13841). Yifeng Zhu, Peter Stone, Yuke Zhu
- [Lifelong Robotic Reinforcement Learning by Retaining Experiences](https://arxiv.org/abs/2109.09180). Annie Xie, Chelsea Finn
- [ThriftyDAgger: Budget-Aware Novelty and Risk Gating for Interactive Imitation Learning](https://arxiv.org/abs/2109.08273). Ryan Hoque, Ashwin Balakrishna, Ellen Novoseller, Albert Wilcox, Daniel S. Brown, Ken Goldberg
- [What Matters in Learning from Offline Human Demonstrations for Robot Manipulation](https://arxiv.org/abs/2108.03298). Ajay Mandlekar, Danfei Xu, Josiah Wong, Soroush Nasiriany, Chen Wang, Rohun Kulkarni, Li Fei-Fei, Silvio Savarese, Yuke Zhu, Roberto Martín-Martín
- [Multi-Modal Mutual Information (MuMMI) Training for Robust Self-Supervised Deep Reinforcement Learning](https://arxiv.org/abs/2107.02339). Kaiqi Chen, Yong Lee, Harold Soh
- [SECANT: Self-Expert Cloning for Zero-Shot Generalization of Visual Policies](https://arxiv.org/abs/2106.09678). Linxi Fan, Guanzhi Wang, De-An Huang, Zhiding Yu, Li Fei-Fei, Yuke Zhu, Anima Anandkumar
- [What Can I Do Here? Learning New Skills by Imagining Visual Affordances](https://arxiv.org/abs/2106.00671). Alexander Khazatsky, Ashvin Nair, Daniel Jing, Sergey Levine
- [Calibration-Free Monocular Vision-Based Robot Manipulations With Occlusion Awareness](https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=9439456). Yongle Luo, Kun Dong, Lili Zhao, Zhiyong Sun, Erkang Cheng, Honglin Kan, Chao Zhou, Bo Song
- [Learning a Skill-sequence-dependent Policy for Long-horizon Manipulation Tasks](https://arxiv.org/abs/2105.05484). Zhihao Li, Zhenglong Sun, Jionglong Su, Jiaming Zhang
- [Efficient Self-Supervised Data Collection for Offline Robot Learning](https://arxiv.org/abs/2105.04607). Shadi Endrawis, Gal Leibovich, Guy Jacob, Gal Novik, Aviv Tamar
- [Learning Visually Guided Latent Actions for Assistive Teleoperation](https://arxiv.org/abs/2105.00580). Siddharth Karamcheti, Albert J. Zhai, Dylan P. Losey, Dorsa Sadigh
- [LASER: Learning a Latent Action Space for Efficient Reinforcement Learning](https://arxiv.org/abs/2103.15793). Arthur Allshire, Roberto Martín-Martín, Charles Lin, Shawn Manuel, Silvio Savarese, Animesh Garg
- [S4RL: Surprisingly Simple Self-Supervision for Offline Reinforcement Learning](https://arxiv.org/abs/2103.06326). Samarth Sinha, Ajay Mandlekar, Animesh Garg
- [Generalization Through Hand-Eye Coordination: An Action Space for Learning Spatially-Invariant Visuomotor Control](https://arxiv.org/abs/2103.00375). Chen Wang, Rui Wang, Ajay Mandlekar, Li Fei-Fei, Silvio Savarese, Danfei Xu
- [Interpreting Contact Interactions to Overcome Failure in Robot Assembly Tasks](https://arxiv.org/abs/2101.02725). Peter A. Zachares, Michelle A. Lee, Wenzhao Lian, Jeannette Bohg
- [Learning Contact-Rich Assembly Skills Using Residual Admittance Policy](https://ieeexplore.ieee.org/document/9636547). Oren Spector, Miriam Zacksenhouse
- [Learning Multi-Arm Manipulation Through Collaborative Teleoperation](https://arxiv.org/abs/2012.06738). Albert Tung, Josiah Wong, Ajay Mandlekar, Roberto Martín-Martín, Yuke Zhu, Li Fei-Fei, Silvio Savarese
- [OSCAR: Data-Driven Operational Space Control for Adaptive and Robust Robot Manipulation](https://arxiv.org/abs/2110.00704). Josiah Wong, Viktor Makoviychuk, Anima Anandkumar, Yuke Zhu 
- [OPIRL: Sample Efficient Off-Policy Inverse Reinforcement Learning via Distribution Matching](https://arxiv.org/abs/2109.04307). Hana Hoshino, Kei Ota, Asako Kanezaki, Rio Yokota 
- [RLDS: an Ecosystem to Generate, Share and Use Datasets in Reinforcement Learning](https://arxiv.org/abs/2111.02767). Sabela Ramos, Sertan Girgin, Léonard Hussenot, Damien Vincent, Hanna Yakubovich, Daniel Toyama, Anita Gergely, Piotr Stanczyk, Raphael Marinier, Jeremiah Harmsen, Olivier Pietquin, Nikola Momchev
- [RMPs for Safe Impedance Control in Contact-Rich Manipulation](https://arxiv.org/abs/2109.12103). Seiji Shaw, Ben Abbatematteo, George Konidaris
- [Learning Robotic Manipulation Skills Using an Adaptive Force-Impedance Action Space](https://arxiv.org/abs/2110.09904). Maximilian Ulmer, Elie Aljalbout, Sascha Schwarz, Sami Haddadin

## 2020

- [On the Impact of Gravity Compensation on Reinforcement Learning in Goal-Reaching Tasks for Robotic Manipulators](https://www.mdpi.com/2218-6581/10/1/46). Jonathan Fugal, Jihye Bae, Hasan A. Poonawala
- [Learning Multi-Arm Manipulation Through Collaborative Teleoperation](https://arxiv.org/abs/2012.06738). Albert Tung, Josiah Wong, Ajay Mandlekar, Roberto Martín-Martín, Yuke Zhu, Li Fei-Fei, Silvio Savarese
- [Human-in-the-Loop Imitation Learning using Remote Teleoperation](https://arxiv.org/abs/2012.06733). Ajay Mandlekar, Danfei Xu, Roberto Martín-Martín, Yuke Zhu, Li Fei-Fei, Silvio Savarese
- [Transformers for One-Shot Visual Imitation](https://arxiv.org/abs/2011.05970). Sudeep Dasari, Abhinav Gupta
- [Conservative Safety Critics for Exploration](https://arxiv.org/abs/2010.14497). Homanga Bharadhwaj, Aviral Kumar, Nicholas Rhinehart, Sergey Levine, Florian Shkurti, Animesh Garg
- [Continual Model-Based Reinforcement Learning with Hypernetworks](https://arxiv.org/abs/2009.11997). Yizhou Huang, Kevin Xie, Homanga Bharadhwaj, Florian Shkurti
- [Hierarchical 6-DoF Grasping with Approaching Direction Selection](http://rllab.snu.ac.kr/publications/papers/2020_icra_gads.pdf). Yunho Choi, Hogun Kee, Kyungjae Lee, JaeGoo Choy, Junhong Min, Sohee Lee, Songhwai Oh
- [Residual Learning from Demonstration](https://arxiv.org/abs/2008.07682). Todor Davchev, Kevin Sebastian Luck, Michael Burke, Franziska Meier, Stefan Schaal, Subramanian Ramamoorthy
- [Crossing the Gap: A Deep Dive into Zero-Shot Sim-to-Real Transfer for Dynamics](https://arxiv.org/abs/2008.06686). Eugene Valassakis, Zihan Ding, Edward Johns
- [Deep Reinforcement Learning for Contact-Rich Skills Using Compliant Movement Primitives](https://arxiv.org/abs/2008.13223). Oren Spector, Miriam Zacksenhouse
- [Learning Robot Skills with Temporal Variational Inference](https://arxiv.org/abs/2006.16232). Tanmay Shankar, Abhinav Gupta
- [Long-Horizon Visual Planning with Goal-Conditioned Hierarchical Predictors](https://arxiv.org/abs/2006.13205). Karl Pertsch, Oleh Rybkin, Frederik Ebert, Chelsea Finn, Dinesh Jayaraman, Sergey Levine
- [Variational Imitation Learning with Diverse-quality Demonstrations](https://proceedings.icml.cc/static/paper_files/icml/2020/577-Paper.pdf). Voot Tangkaratt, Bo Han, Mohammad Emtiyaz Khan, Masashi Sugiyama
- [Balance Between Efficient and Effective Learning: Dense2Sparse Reward Shaping for Robot Manipulation with Environment Uncertainty](https://arxiv.org/abs/2003.02740). Yongle Luo, Kun Dong, Lili Zhao, Zhiyong Sun, Chao Zhou, Bo Song
- [Intrinsic Motivation for Encouraging Synergistic Behavior](https://arxiv.org/abs/2002.05189). Rohan Chitnis, Shubham Tulsiani, Saurabh Gupta, Abhinav Gupta
- [Learning Continuous Control Actions for Robotic Grasping with Reinforcement Learning](https://ieeexplore.ieee.org/document/9282951). Asad Ali Shahid, Loris Roveda, Dario Piga, Francesco Braghin
- [Combining Reinforcement Learning and Rule-based Method to Manipulate Objects in Clutter](https://ieeexplore.ieee.org/document/9207153). Yiwen Chen, Zhaojie Ju, Chenguang Yang
- [Research on Complex Robot Manipulation Tasks Based on Hindsight Trust Region Policy Optimization](https://ieeexplore.ieee.org/document/9327251). Deyu Yang, Hanbo Zhang, Xuguang Lan

## 2019

- [To Follow or not to Follow: Selective Imitation Learning from Observations](https://arxiv.org/abs/1912.07670). Youngwoon Lee, Edward S. Hu, Zhengyu Yang, Joseph J. Lim
- [IKEA Furniture Assembly Environment for Long-Horizon Complex Manipulation Tasks](https://arxiv.org/abs/1911.07246). Youngwoon Lee, Edward S. Hu, Zhengyu Yang, Alex Yin, Joseph J. Lim
- [IRIS: Implicit Reinforcement without Interaction at Scale for Learning Control from Offline Robot Manipulation Data](https://arxiv.org/abs/1911.05321). Ajay Mandlekar, Fabio Ramos, Byron Boots, Silvio Savarese, Li Fei-Fei, Animesh Garg, Dieter Fox
- [Network Randomization: A Simple Technique for Generalization in Deep Reinforcement Learning](https://arxiv.org/abs/1910.05396). Kimin Lee, Kibok Lee, Jinwoo Shin, Honglak Lee
- [Efficient Bimanual Manipulation Using Learned Task Schemas](https://arxiv.org/abs/1909.13874). Rohan Chitnis, Shubham Tulsiani, Saurabh Gupta, Abhinav Gupta
- [SURREAL-System: Fully-Integrated Stack for Distributed Deep Reinforcement Learning](https://arxiv.org/abs/1909.12989). Linxi Fan\*, Yuke Zhu\*, Jiren Zhu, Zihua Liu, Orien Zeng, Anchit Gupta, Joan Creus-Costa, Silvio Savarese, Li Fei-Fei
- [Memory Based Trajectory-conditioned Policies for Learning from Sparse Rewards](https://arxiv.org/abs/1907.10247). Yijie Guo, Jongwook Choi, Marcin Moczulski, Shengyu Feng, Samy Bengio, Mohammad Norouzi, Honglak Lee
- [Variable Impedance Control in End-Effector Space: An Action Space for Reinforcement Learning in Contact-Rich Tasks](https://arxiv.org/abs/1906.08880). Roberto Martín-Martín, Michelle A. Lee, Rachel Gardner, Silvio Savarese, Jeannette Bohg, Animesh Garg

## 2018

- [RoboTurk: A Crowdsourcing Platform for Robotic Skill Learning through Imitation](https://arxiv.org/abs/1811.02790). Ajay Mandlekar, Yuke Zhu, Animesh Garg, Jonathan Booher, Max Spero, Albert Tung, Julian Gao, John Emmons, Anchit Gupta, Emre Orbay, Silvio Savarese, Li Fei-Fei
- [SURREAL: Open-Source Reinforcement Learning Framework and Robot Manipulation Benchmark](http://svl.stanford.edu/assets/papers/fan2018corl.pdf). Linxi Fan\*, Yuke Zhu\*, Jiren Zhu, Zihua Liu, Orien Zeng, Anchit Gupta, Joan Creus-Costa, Silvio Savarese, Li Fei-Fei
