+++
title = "The Model"
description = "The model"
keywords = ["model","How do I","questions","what if"]
+++

## SAMM model overview

{{< table "table" >}}
| <a href="/model/governance">Governance</a> | <a href="/model/design">Design</a> | <a href="/model/implementation">Implementation</a> | <a href="/model/verification">Verification</a> | <a href="/model/operations">Operations</a> |
|:---|:---|:---|:---|:---|
| <a href="/model/governance/strategy-and-metrics">Strategy and Metrics</a> | <a href="/model/design/threat-assessment">Threat Assessment</a> | <a href="/model/implementation/secure-build">Secure Build</a> | <a href="/model/verification/architecture-assessment">Architecture Assessment</a> | <a href="/model/operations/incident-management">Incident Management</a>
| <a href="/model/governance/policy-and-compliance">Policy and Compliance</a> | <a href="/model/design/security-requirements">Security Requirements</a> | <a href="/model/implementation/secure-deployment">Secure Deployment</a> | <a href="/model/verification/requirements-driven-testing">Requirements-driven Testing</a> | <a href="/model/operations/environment-management">Environment Management</a>
| <a href="/model/governance/education-and-guidance">Education and Guidance</a> | <a href="/model/design/security-architecture">Security Architecture</a> | <a href="/model/implementation/defect-management">Defect Management</a> | <a href="/model/verification/security-testing">Security Testing</a> | <a href="/model/operations/operational-management">Operational Management</a>
{{% /table %}}

## Introduction

The mission of OWASP Software Assurance Maturity Model (SAMM) is to be the prime maturity model for software assurance that provides an effective and measurable way for all types of organizations to analyze and improve their software security posture. OWASP SAMM supports the complete software lifecycle, including development and acquisition, and is technology and process agnostic. It is intentionally built to be evolutive and risk-driven in nature.

The original model (v1.0) was written by Pravir Chandra and dates back from 2009. Over the last 10 years, it has proven a widely distributed and effective model for improving secure software practices in different types of organizations throughout the world. Translations and supporting tools have been contributed by the community to facilitate adoption and alignment. With version 2.0, we further improve the model to deal with some of its current limitations.

After a period of intensive discussions and with input from practitioners and the OWASP community during summits in Europe and the US on the best way forward, we take a new approach for version 2.0 based on the input we gathered.

For an overview of the version 2 changes, read our [SAMM version 2 release notes](/release-notes-v2).

We generated a bare-bones [PDF version](https://github.com/OWASP/samm/blob/master/Supporting%20Resources/v2.0/OWASP-SAMM-v2.0.pdf) of the model. We'll continue to work on it to have a final version as soon as possible.
