---
title: Create and Promote
type: stream
url: model/governance/strategy-and-metrics/stream-a/
business_function: Governance
business_function_url: governance
practice: Strategy & Metrics
stream: A
description: Governance / Strategy & Metrics
keywords: ["Business function", "Practice", "Governance", "Strategy & Metrics"]

maturity_levels:
    level1:
        level: 1
        benefit: |
            Have a common understanding of an application security baseline.
        activity: |
            Understand, based on application risk exposure, what threats exist or may exist, as well as how tolerant executive leadership is of these risks. This understanding is a key component of determining software security assurance priorities. To ascertain these threats, interview business owners and stakeholders and document drivers specific to industries where the organization operates as well as drivers specific to the organization. Gathered information includes worst-case scenarios that could impact the organization, as well as opportunities where an optimized software development life-cycle and more secure applications could provide a market-differentiator or create additional opportunities.

            Gathered information provides a baseline for the organization to develop and promote its application security program. Items in the program are prioritized to address threats and opportunities most important to the organization. The baseline is split into several risk factors and drivers linked directly to the organization’s priorities and used to help build a risk profile of each custom-developed application by documenting how they can impact the organization if they are compromised.

            The baseline and individual risk factors should be published and made available to application development teams to ensure a more transparent process of creating application risk profiles and incorporating the organization’s priorities into the program. Additionally, these goals should provide a set of objectives which should be used to ensure all application security program enhancements provide direct support of the organization’s current and future needs.

        question: Do you prioritize applications based on a granular set of risks?
        quality_criteria:
            - You capture the risk appetite of your organization's executive leadership
            - The organization's leadership vet and approve the set of risks
            - You identify the main business and technical threats to your assets and data
            - You document risks and store them in an accessible location

        answers:
            - "No"
            - Yes, basic risks
            - Yes, covers most significant risks
            - Yes, covers risks and opportunities

    level2:
        level: 2
        benefit: |
            Have an aligned plan and roadmap within the organization.
        activity: |
            Based on the magnitude of assets, threats, and risk tolerance, develop a security strategic plan and budget to address business priorities around application security. The plan covers 1 to 3 years and includes milestones consistent with the organization’s business drivers and risks. It provides tactical and strategic initiatives and follows a roadmap that makes its alignment with business priorities and needs visible.

            In the roadmap reach a balance between changes requiring financial expenditures, changes of processes and procedures, and changes impacting the organization’s culture. This balance helps accomplish multiple milestones concurrently and without overloading or exhausting available resources or development teams. The milestones are frequent enough to help monitor program success and trigger timely roadmap adjustments.

            For the program to be successful, the application security team obtains buy-in from the organization’s stakeholders and application development teams. A published plan is available to anyone who is required to support or participate in its implementation.

        question: Do you have a strategic plan for application security and use it to make decisions?
        quality_criteria:
            - The plan reflects the organization's business priorities and risk appetite
            - The plan includes measurable milestones and a budget
            - The plan is consistent with the organization's business drivers and risks
            - The plan lays out a roadmap for strategic and tactical initiatives
            - You have buy-in from stakeholders, including development teams

        answers:
            - "No"
            - Yes, we review it annually
            - Yes, we consult the plan before making significant decisions
            - Yes, we consult the plan often, and it is aligned with our application security strategy

    level3:
        level: 3
        benefit: |
            Continuous improvement of your application security efforts.
        activity: |
            You review the application security plan periodically for ongoing applicability and support of the organization’s evolving needs and future growth. To do this, you repeat the steps from the first two maturity levels of this Security Practice at least annually. The goal is for the plan to always support the current and future needs of the organization, which ensures the program is aligned with the business.

            In addition to reviewing the business drivers, the organization closely monitors the success of the implementation of each of the roadmap milestones. You evaluate the success of the milestones based on a wide range of criteria, including completeness and efficiency of the implementation, budget considerations, and any cultural impacts or changes resulting from the initiative. You review missed or unsatisfactory milestones and evaluate possible changes to the overall program.

            The organization develops dashboards and measurements for management and teams responsible for software development to monitor the implementation of the roadmap. These dashboards are detailed enough to identify individual projects and initiatives and provide a clear understanding of whether the program is successful and aligned with the organization’s needs.

        question: Do you regularly review and update the Strategic Plan for Application Security?
        quality_criteria:
            - You review and update the plan in response to significant changes in the business environment, the organization, or its risk appetite
            - Plan update steps include reviewing the plan with all the stakeholders and updating the business drivers and strategies
            - You adjust the plan and roadmap based on lessons learned from completed roadmap activities
            - You publish progress information on roadmap activities, making sure they are available to all stakeholders

        answers:
            - "No"
            - Yes, but review is ad-hoc
            - Yes, we review it every two years or so
            - Yes, we review it at least annually

---
