---
title: Architecture Assessment
url: /model/verification/architecture-assessment/
business_function: "Verification"
business_function_url: "verification"
keywords: ["Business function", "Practice", "Architecture Assessment"]
type: practice

practice_maturity_1_description: Review the architecture to ensure baseline mitigations are in place for known risks.
practice_maturity_2_description: Review the complete provision of security mechanisms in the architecture.
practice_maturity_3_description: Review the architecture effectiveness and feedback results to improve the security architecture.

stream_a: Architecture Validation

stream_a_maturity_1_activity: Identify application and infrastructure architecture components
stream_a_maturity_2_activity: Validate the architecture security mechanisms
stream_a_maturity_3_activity: Review of the architecture components effectiveness

stream_b: Architecture Compliance

stream_b_maturity_1_activity: Ad-hoc review of the architecture against compliance requirements
stream_b_maturity_2_activity: Analyze the architecture against known security requirements and best practices
stream_b_maturity_3_activity: Feed the architecture review results back into the enterprise architecture, organisation design principles & patterns, security solutions and reference architectures.
---

Validate the security of the software and supporting infrastructure architecture. Identify application and infrastructure architecture components. For each interface note any security-related functionality and check the model for design-level consistency for how interfaces with similar access are secured. Iterate through the list of security mechanisms and analyze the system for their provision.

Validate the software and supporting infrastructure architecture against known security requirements, compliance goals and best practices. The overall goal is to verify that the system design has addressed each requirement and best practice. Note any requirements that are not met at the design level as assessment findings.

Review the effectiveness of each application and infrastructure component to secure the application. Feed any findings back into the Security Architecture practice.

Security-savvy staff conduct this analysis with assistance from the project team for application-specific knowledge. Perform this analysis upon major architecture changes, usually toward the end of a design phase.

