---
title: Operational Management
url: /model/operations/operational-management/
business_function: "Operations"
business_function_url: "operations"
keywords: ["Business function", "Practice", "Operational Management"]
type: practice

practice_maturity_1_description: Foundational Practices
practice_maturity_2_description: Managed, Responsive Processes
practice_maturity_3_description: Active Monitoring and Response

stream_a: Data Protection

stream_a_maturity_1_activity: Implement basic data protection practices
stream_a_maturity_2_activity: Develop data catalog and establish data protection policy.
stream_a_maturity_3_activity: Automate detection of policy non-compliance, and audit compliance periodically. Regularly review and update to data catalog and data protection policy.

stream_b: System Decomissioning / Legacy Management

stream_b_maturity_1_activity: Decomission unused applications and services as identified. Manage customer upgrades/migrations individually.
stream_b_maturity_2_activity: Develop repeatable decomissioning processes for unused systems/services, and for migration from legacy dependencies. Manage legacy migration roadmaps for customers.
stream_b_maturity_3_activity: Proactively manage migration roadmaps, for both unsupported end-of-life dependencies, and legacy versions of delivered software.
---

The Operational Management (OM) practice focuses on activities to ensure security is maintained throughout operational support functions. Although these functions are not performed directly by an application, the overall security of the application and its data depends on their proper performance. Deploying an application on an unsupported operating system with unpatched vulnerabilities, or failing to store backup media securely, can make the protections built into that application irrelevant.

The functions covered by this practice include, but are not limited to: system provisioning, administration, and decommissioning; database provisioning and administration; and data backup, restore, and archival.

