---
title: Incident Management
url: /model/operations/incident-management/
business_function: "Operations"
business_function_url: "operations"
keywords: ["Business function", "Practice", "Incident Management"]
type: practice

practice_maturity_1_description: Best-effort incident detection and handling
practice_maturity_2_description: Formal incident management process in place
practice_maturity_3_description: Mature incident management

stream_a: Incident Detection

stream_a_maturity_1_activity: Use available log data to perform best-effort detection of possible security incidents.
stream_a_maturity_2_activity: Follow an established, well-documented process for incident detection, with emphasis on automated log evaluation.
stream_a_maturity_3_activity: Use a proactively managed process for detection of incidents.

stream_b: Incident Response

stream_b_maturity_1_activity: Identify roles and responsibilities for incident response.
stream_b_maturity_2_activity: Establish a formal incident response process and ensure staff are properly trained in performing their roles.
stream_b_maturity_3_activity: Employ a dedicated, well-trained incident response team.
---

Once your organization has applications in operation, you're likely to face security incidents. In this model, we define a security incident as a breach, or the threat of an imminent breach, of at least one asset's security goals, whether due to malicious or negligent behavior. Examples of security incidents might include:
- a successful Denial of Service (DoS) attack against a cloud application;
- an application user accessing private data of another, by abusing a security vulnerability; or
- an attacker modifying application source code.
The Incident Management (IM) practice focuses on dealing with these in your organization.

Historically, many security incidents have been detected months, or even years, after the initial breach. During the "dwell time" before an incident is detected, significant damage can occur, increasing the difficulty of recovery. Our first Activity Stream, Incident Detection, focuses on decreasing that dwell time.

Once you have identified that you're suffering from a security incident, it's essential to respond in a disciplined, thorough manner to limit the damage, and return to normal operations as efficiently as possible.

