---
title: Defect Management
url: /model/implementation/defect-management/
business_function: "Implementation"
business_function_url: "implementation"
keywords: ["Business function", "Practice", "Defect Management"]
type: practice

practice_maturity_1_description: All defects are tracked within each project.
practice_maturity_2_description: Defect tracking used to influence the deployment process.
practice_maturity_3_description: Defect tracking across multiple components is used to help reduce the number of new defects.

stream_a: Defect Tracking

stream_a_maturity_1_activity: Introduce a structured tracking of security defects and make knowledgeable decisions based on this information.
stream_a_maturity_2_activity: Rate all security defects over the whole organization consistently and define SLAs for particular severity classes.
stream_a_maturity_3_activity: Enforce the predefined SLAs and integrate your defect management system with other relevant tooling.

stream_b: Metrics and Feedback

stream_b_maturity_1_activity: Regularly go over previously recorded security defects and derive quick wins from basic metrics.
stream_b_maturity_2_activity: Collect standardized defect management metrics and use these also for prioritization of centrally driven initiatives.
stream_b_maturity_3_activity: Continuously improve your security defect management metrics and correlate it with other sources.
---

The Defect Management (DM) practice focuses on collecting, recording, and analysing software security defects and enriching them with information to drive metrics-based decisions.

The practice’s first stream deals with the process of handling and managing defects to ensure released software has a given assurance level. The second stream focuses on enriching the information about the defects and deriving metrics to guide decisions about the security of individual projects and of the security assurance program as a whole.

In a sophisticated form, the practice requires formalised, independent defect management and real-time, correlated information to detect trends and influence security strategy.

