---
title: Threat Assessment
url: /model/design/threat-assessment/
business_function: "Design"
business_function_url: "design"
keywords: ["Business function", "Practice", "Threat Assessment"]
type: practice

practice_maturity_1_description: Consider security explicitly during the software requirements process.
practice_maturity_2_description: Increase granularity of security requirements derived from business logic and known risks.
practice_maturity_3_description: Mandate security requirements process for all software projects and third-party dependencies.

stream_a: Application Risk Profile

stream_a_maturity_1_activity: A basic assessment of the application risk is performed to understand likelihood and impact of an attack.
stream_a_maturity_2_activity: Understand the risk for all applications in the organization by centralizing the risk profile inventory for stakeholders.
stream_a_maturity_3_activity: Periodically review application risk profiles at regular intervals to ensure accuracy and reflect current state.

stream_b: Threat Modeling

stream_b_maturity_1_activity: Perform best-effort, risk-based threat modeling using brainstorming and existing diagrams with simple threat checklists.
stream_b_maturity_2_activity: Standardize threat modeling training, processes, and tools to scale across the organization.
stream_b_maturity_3_activity: Continuously optimization and automation of your threat modeling methodology.
---

The Threat Assessment (TA) practice is centered on identification and understanding the project-level risks based on the functionality of the software being developed and characteristics of the runtime environment. From details about threats and likely attacks against each project, the organization as a whole operates more effectively through better decisions about prioritization of initiatives for security. Additionally, decisions for risk acceptance are more informed, therefore better aligned to the business.

By starting with simple threat models and building application risk profiles, an organization improves over time. Ultimately, a sophisticated organization would maintain this information in a way that is tightly coupled to the compensating factors and pass-through risks from external entities. This provides greater breadth of understanding for potential downstream impacts from security issues while keeping a close watch on the organization’s current performance against known threats.

