---
title: Security Requirements
url: /model/design/security-requirements/
business_function: "Design"
business_function_url: "design"
keywords: ["Business function", "Practice", "Security Requirements"]
type: practice

practice_maturity_1_description: Consider security explicitly during the software requirements process.
practice_maturity_2_description: Increase granularity of security requirements derived from business logic and known risks.
practice_maturity_3_description: Mandate security requirements process for all software projects and third-party dependencies.

stream_a: Software Requirements

stream_a_maturity_1_activity: High-level application security objectives are mapped to functional requirements.
stream_a_maturity_2_activity: Structured security requirements are available and utilized by developer teams.
stream_a_maturity_3_activity: Build a requirements framework for product teams to utilize.

stream_b: Supplier Security

stream_b_maturity_1_activity: Evaluate the supplier based on organizational security requirements.
stream_b_maturity_2_activity: Build security into supplier agreements in order to ensure compliance with organizational requirements.
stream_b_maturity_3_activity: Ensure proper security coverage for external suppliers by providing clear objectives.
---

This practice focuses on security requirements that are important
in the context of secure software. A first type deals with typical software-related
requirements, to specify objectives and expectations to protect the service and
data at the core of the application. A second type deals with requirements that
are relative to supplier organisations that are part of the development context
of the application, in particular for outsourced development. It is important to
streamline the expectations in terms of secure development because outsourced development
can have significant impact on the security of the application. The security of
3rd party (technical) libraries is part of the software supply chaing stream (LINK
Secure Build), so it is not included in this practice.

