+++
title = "SAMM V2 community release"
date = "2019-12-20T12:00:00+02:00"
tags = ["release", "what's new"]
categories = ["events"]
banner = "img/banners/undraw_explore_7ofa.png"
author = "The SAMM Project Team"
+++

## SAMM v2 community launch!

After three years of preparation, our SAMM project team has delivered release 2 of SAMM!

First, we're releasing SAMM v2 to the OWASP community and then plan our public release for mid-January 2020. We value your feedback and questions. To contribute, do one of the following, in decreasing order of preference:

- add issues to our [SAMM Github repository](https://github.com/OWASP/samm/issues)
- Complete the [Google form](https://goo.gl/forms/c5fYJIgzxV7DRmdE2) per issue
- Start a discussion on our [#project-samm Slack channel](https://owasp.slack.com/messages/C0VF1EJGH) on OWASP. Confirm that a member of the SAMM team picks up your discussion to make sure we consider your feedback.
- Send us an email: <info@owaspsamm.org>


SAMM’s mission is to raise awareness and educate organizations on how to design, develop, and implement secure software through our self-assessment model.
The new SAMM release v2 consists of:

* the SAMM Model, explaining the maturity model
* a quick-start guide with steps to improve your secure software practice
* an updated SAMM toolbox to perform SAMM assessments and create SAMM road maps
* an updated SAMM website, containing our SAMM model together with guidance
* a new SAMM Benchmark initiative to compare your maturity with other similar organizations and teams

## What changed with SAMM v2?

* We introduced a fifth business function, Implementation, to represent a number of core activities in the build and deploy domains of an organization.
* The now 15 security practices are divided into two streams, which aligns and links the activities in the practice over the different maturity levels.
* Each stream has an objective that can be reached in increasing levels of maturity. This way, there are no “orphan” activities that seem only relevant on a single maturity level (for instance, code signing in the current model).
* Maturity level activities are aligned and linked per stream. Each stream has a clear objective and maturity level activities are designed in order of increasing difficulty.
* The model now supports maturity measurements both from a coverage and quality based measurement perspectives.
* An updated scoring SAMM toolbox has been designed to help assessors and organizations with their software assurance assessments and roadmaps.
* A single source using GitHub to automatically generate documents, the website, the toolbox and applications.
* We converted all content of the model to YAML files, allowing tools or other SAMM consumers to automatically use the model.
* We defined a standard list of roles aligned throughout the security practices.
* The version 2.0 model will support frequent updates through incremental changes with regular updates to explanations, tooling, and guidance by the community.

To learn more, explore our website. For additional information, contact <info@owaspsamm.org>.

The OWASP SAMM project team
