+++
title = "OWASP SAMM version 2 - public release"
date = "2020-01-31T00:00:00+02:00"
tags = ["version 2", "release", "what's new"]
categories = ["release"]
banner = "img/banners/undraw_celebration_0jvk.png"
author = "The SAMM Project Team"
+++

#### After three years of preparation, our SAMM project team has delivered version 2 of SAMM!

OWASP SAMM (Software Assurance Maturity Model) is the OWASP framework to help organizations assess, formulate, and implement, through our self-assessment model, a strategy for software security they can be integrate into their existing Software Development Lifecycle (SDLC).

The new SAMM v2 consists of the following components:

* the [SAMM Model](/model/) overview and introduction, explaining the maturity model in detail
* a [Quick-start Guide](/quick-start-guide/) with different steps to improve your secure software practice
* an updated [SAMM Toolbox](https://owaspsamm.org/assessment/) to perform SAMM assessments and create SAMM roadmaps
* a new [SAMM Benchmark initiative](/benchmarking/) to compare your maturity and progress with other similar organizations and teams

### What's changed with SAMM v2?

For those organizations using earlier versions of SAMM it’s important to take the time to understand how the framework has evolved in favor of automation and better alignment with development teams. Organizationally, some important changes worth noting:

* Construction is now Design
* New business function: Implementation
* Redesigned business function: Verification
* New security practice: Operational Management
* Operational Enablement no longer exists and other practices absorbed its activities

Activities are now ordered in logical flows throughout each of the 15 security practices divided into two streams, which aligns and links the activities in the practice over the different maturity levels.

The new model supports maturity measurements both from coverage and quality perspectives. We added new quality criteria for all the activities. There is an updated scoring SAMM toolbox designed to help assessors and organizations with their software assurance assessments and roadmaps.

We have a single source using [GitHub](https://github.com/OWASP/samm) and we can automatically generate PDF documents, the website, the toolbox, and applications. All the model content has been converted to YAML files, allowing tools or other SAMM consumers to automatically use the model. You can always find the latest version of SAMM on our website, in the [Model section](/model/). The full release notes for version 2 are available [here](/release-notes-v2/).

As always, feedback is welcome in our usual channels:

* the [SAMM Github repository](https://github.com/OWASP/samm/issues)
* our [#project-samm](https://owasp.slack.com/messages/C0VF1EJGH) Slack channel  
* our email address [info@owaspsamm.org](mailto:info@owaspsamm.org)

Seba Deleersnyder and Bart De Win, SAMM Project co-leaders, commented: “This is a really important release for the project team. We are grateful for the team, our SAMM community, and the help of our sponsors, With all of them, after three years, we now have an effective and measurable way for all types of organizations to analyze and improve their software security posture”.

Don’t forget to look around our [new website](https://owaspsamm.org/), review the [updated model](/model/) and [toolbox](/assessment/).

### Thanks

A big thanks to our community, your feedback, corrections, questions, input, and encouragement. SAMM version 2 is for you!

Special thanks to Brett Crawley, Brian Glas, Bruce Jenkins, Chris Cooper, Daniel Kefer, Felipe Zipitria, Hardik Parekh, John Dileo, John Ellingsworth, John Kennedy, Nessim Kisserli, Patricia Duarte, Sebastian Arriada, and Yan Kravchenko.

And to our leading sponsors, Concord, Micro Focus Fortify, NCC Group, Toreon, PWC, and Splunk.


**Time to celebrate!**

The OWASP SAMM project team
</br>
</br>
</br>

##### About the OWASP Foundation
The Open Web Application Security Project (OWASP) is a nonprofit organization working to improve the security of software. Through community-led open source software projects, over 260 local chapters worldwide, tens of thousands of members, and leading educational and training conferences, the OWASP Foundation is the source for developers and technologists to secure the web. For nearly two decades corporations, foundations, developers, and volunteers have supported the OWASP Foundation and its work. To learn more or to become a member, visit https://owasp.org. OWASP and the Open Web Application Security Project are trademarks of the OWASP Foundation.

##### About OWASP SAMM
The OWASP SAMM community is powered by security knowledgeable volunteers from businesses and educational organizations. The global community works to create freely-available articles, methodologies, documentation, tools, and technologies.

##### Contact

* The SAMM Project Team: [info@owaspsamm.org](mailto:info@owaspsamm.org)  
* Sebastien Deleersnyder, project leader: [seba@owasp.org](mailto:seba@owasp.org) | +32 478 504 117
* Bart De Win, project leader: [bart.dewin@owasp.org](mailto:bart.dewin@owasp.org) | +32 479 467 957
