+++
title = "Open Security Summit 2019"
date = "2019-07-10T13:07:31+02:00"
tags = ["OSS"]
categories = ["events"]
banner = "img/banners/undraw_Connecting_Teams_8ntu.png"
+++



## SAMM track, an overview and commentary of the event
The Open Security Summit 2019 focused on the collaboration between Developers and Application Security and was organised with the support of OWASP. The 5-day sprint on SAMMv2 enabled attendees to work and collaborate intensively towards specific Application Security challenges with a focus on actionable outcomes. In addition to specific Maturity Models sessions, a large number of [OWASP SAMM](https://open-security-summit.org/tracks/owasp-samm/) Working Sessions took place at the Summit.

For SAMM, it is a great opportunity to get the team together, be extra productive, and meet SAMM users.

If you weren’t able to attend this year, you can still [visit the website](https://open-security-summit.org/) and read up on the summit tracks, participants, and outomes.

{{< responsive-image  "/img/blog/oss.png" "group photo of OSS 2019">}}

### SAMM Track - Main focus
The measurement model was at the forefront of this year’s summit discussions. With the goal to release SAMM v2 before the end of the year, the working sessions were used to discuss question format, scoring and quality indicators to address any ambiguity.

### Feedback and contributions
The OSS2019 brought together new members and users from all over the world to attend the SAMM track. As an open source project, we highly value the feedback from our community, and we offer several ways of providing that feedback.

Also, to help users make impactful content contributions to our Git repository, we produced a step-by-step guide.

During OSS2019 we had some sessions focusing on the integration with other tracks taking place in the summit:

* DevSecOps with a focus on DSO MM to SAMM
* Threat modeling with a discussion around the alignment of maturity levels and SAMM threat assessment practices
* We started mapping OWASP ASVS to SAMM
* We also had a session to talk about a guidance document specific to Agile processes

## What’s the plan for the future?
Currently, the OWASP SAMM team is working to complete the measurement model questions covering the business functions: Verification, Design, Governance, Implementation, and Operations.

The idea is to publish them as soon as possible to get user feedback before the last push towards v2.

The next steps will be to update the activity descriptions and goals based on the new questions and discussions at OSS2019.

We are planning a SAMM summit for autumn, when we plan to have SAMM v2 ready for release.

We would also like to thank our outstanding sponsors for their support of OWASP SAMM, and if you want to learn more about OSS2019 you can visit the website.

 [Hugo configuration documentation](/overview/configuration/) for details.

