+++
title = "SAMM Assessment"
description = "SAMM Assessment"
keywords = ["assessment","measurement","questions"]
+++

## SAMM Assessment

The SAMM v2 assessment Toolbox has been improved to measure the quality of you own software assurance maturity performance. Our Toolbox allows you to review your security activities against the defined quality criteria and calculate your maturity score.

### Self-assessment

Your first step towards improvement, is to measure where you are now.

Make sure you first read our [getting started guide](/quick-start-guide/), then you can start with assessing your current software assurance posture.

You will typically start with a self-assessment to get an overview on your status of software security activities in your organization. We created the OWASP SAMM [Toolbox spreadsheet](https://github.com/OWASP/samm/tree/master/Supporting%20Resources/v2.0/toolbox) to do just that. You can also use the Toolbox to support an interview or workshop together with other people that are involved in your software development process.

Once you downloaded the SAMM Toolbox, check out the tab “Interview”. Here you will see a list of questions for each of the activities in our [SAMM Model](https://owaspsamm.org/model/).
Each of the questions has a set of quality criteria listed under the question. In order to answer on the assessment question, you need to evaluate if these criteria are actually met. If the quality criteria are not (completely) filled in, you should answer “No”. If you meet the quality criteria, you can choose any of the other options.
Once you start filling in the questions, you will see that the Scorecard tab updates automatically for your current maturity score.

If you need help, do not hesitate to reach out to our SAMM community on [Slack](https://owasp.slack.com/archives/C0VF1EJGH) or [Google Groups](https://groups.google.com/a/owasp.org/d/forum/samm-project). We are available to help you with practical advice and welcome any feedback to improve the Toolbox and our SAMM model!

### Online assessment

One of our SAMM sponsors has created an [online calculator](https://concordusa.com/SAMM/) based on SAMM v2.

### Next steps

Based on your assessment, you can now set targets for improvement and use the Toolbox to create and track your own SAMM roadmap.

We encourage you to share your SAMM assessment data with our [Benchmark](/benchmarking/) project. Once we have enough data available, you can start to compare yourself with your peers!
