/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading.wrappers;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.trading.ServiceInterface;
import com.nubits.nubot.trading.Ticker;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.utils.ErrorManager;
import com.nubits.nubot.utils.HttpUtils;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.jsoup.Connection;
import org.jsoup.nodes.Document;

public class PeatioWrapper
implements TradeInterface {
    private static final Logger LOG = Logger.getLogger(PeatioWrapper.class.getName());
    private ApiKeys keys;
    private Exchange exchange;
    private final int SPACING_BETWEEN_CALLS = 1100;
    private final int TIME_OUT = 15000;
    private long lastSentTonce = 0L;
    private boolean apiBusy = false;
    private final String SIGN_HASH_FUNCTION = "HmacSHA256";
    private final String ENCODING = "UTF-8";
    private String apiBaseUrl;
    public String checkConnectionUrl;
    private final String API_GET_INFO = "/api/v2/members/me";
    private final String API_TRADE = "/api/v2/orders";
    private final String API_ACTIVE_ORDERS = "/api/v2/orders";
    private final String API_ORDER = "/api/v2/order";
    private final String API_CANCEL_ORDER = "/api/v2/order/delete";
    private final String API_CLEAR_ORDERS = "/api/v2/orders/clear";
    private final String API_GET_TRADES = "/api/v2/trades/my.json";
    private ErrorManager errors = new ErrorManager();
    private final String TOKEN_ERR = "error";
    private final String TOKEN_BAD_RETURN = "No Connection With Exchange";

    public PeatioWrapper() {
        this.setupErrors();
    }

    public PeatioWrapper(ApiKeys keys, Exchange exchange, String api_base) {
        this.keys = keys;
        this.exchange = exchange;
        this.apiBaseUrl = api_base;
        this.checkConnectionUrl = api_base;
        this.setupErrors();
    }

    protected Long createNonce(String requester) {
        Long toReturn = 0L;
        if (!this.apiBusy) {
            toReturn = this.getNonceInternal(requester);
        } else {
            try {
                if (Global.options != null && Global.options.isVerbose()) {
                    LOG.info(System.currentTimeMillis() + " - Api is busy, I'll sleep and retry in a few ms (" + requester + ")");
                }
                Thread.sleep(Math.round(2420.0));
                this.createNonce(requester);
            }
            catch (InterruptedException e) {
                LOG.severe(e.toString());
            }
        }
        return toReturn;
    }

    private void setupErrors() {
        this.errors.setExchangeName(this.exchange);
    }

    private String getTickerPath(CurrencyPair pair) {
        return "api/v2/tickers/" + pair.toString();
    }

    private ApiResponse getQuery(String url, String method, TreeMap<String, String> query_args, boolean isGet) {
        ApiResponse apiResponse = new ApiResponse();
        String queryResult = this.query(url, method, query_args, isGet);
        if (queryResult == null) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.noConnectionError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            if (httpAnswerJson.containsKey("error")) {
                JSONObject error = (JSONObject)httpAnswerJson.get("error");
                int code = Integer.parseInt(error.get("code").toString());
                String msg = error.get("message").toString();
                ApiError errorObj = this.errors.apiReturnError;
                errorObj.setDescription(msg);
                apiResponse.setError(errorObj);
                return apiResponse;
            }
            apiResponse.setResponseObject(httpAnswerJson);
        }
        catch (ClassCastException cce) {
            try {
                JSONArray httpAnswerJson = (JSONArray)parser.parse(queryResult);
                apiResponse.setResponseObject(httpAnswerJson);
            }
            catch (ParseException pe) {
                LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
                apiResponse.setError(this.errors.parseError);
            }
        }
        catch (ParseException pe) {
            LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalances(CurrencyPair pair) {
        return this.getBalanceImpl(null, pair);
    }

    @Override
    public ApiResponse getAvailableBalance(Currency currency) {
        return this.getBalanceImpl(currency, null);
    }

    private ApiResponse getBalanceImpl(Currency currency, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        Balance balance = null;
        String url = this.apiBaseUrl;
        String method = "/api/v2/members/me";
        boolean isGet = true;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("canonical_verb", "GET");
        query_args.put("canonical_uri", method);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            Amount NBTonOrder = null;
            Amount NBTAvail = null;
            Amount PEGonOrder = null;
            Amount PEGAvail = null;
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONArray accounts = (JSONArray)httpAnswerJson.get("accounts");
            if (currency == null) {
                for (int i = 0; i < accounts.size(); ++i) {
                    JSONObject balanceObj = (JSONObject)accounts.get(i);
                    String tempCurrency = balanceObj.get("currency").toString();
                    String nbtCurrencyCode = pair.getOrderCurrency().getCode();
                    String pegCurrencyCode = pair.getPaymentCurrency().getCode();
                    if (tempCurrency.equalsIgnoreCase(nbtCurrencyCode)) {
                        NBTAvail = new Amount(Double.parseDouble(balanceObj.get("balance").toString()), pair.getOrderCurrency());
                        NBTonOrder = new Amount(Double.parseDouble(balanceObj.get("locked").toString()), pair.getOrderCurrency());
                    }
                    if (!tempCurrency.equalsIgnoreCase(pegCurrencyCode)) continue;
                    PEGAvail = new Amount(Double.parseDouble(balanceObj.get("balance").toString()), pair.getPaymentCurrency());
                    PEGonOrder = new Amount(Double.parseDouble(balanceObj.get("locked").toString()), pair.getPaymentCurrency());
                }
                if (NBTAvail != null && NBTonOrder != null && PEGAvail != null && PEGonOrder != null) {
                    balance = new Balance(PEGAvail, NBTAvail, PEGonOrder, NBTonOrder);
                    apiResponse.setResponseObject(balance);
                } else {
                    apiResponse.setError(this.errors.nullReturnError);
                }
            } else {
                boolean found = false;
                Amount amount = null;
                for (int i = 0; i < accounts.size(); ++i) {
                    JSONObject balanceObj = (JSONObject)accounts.get(i);
                    String tempCurrency = balanceObj.get("currency").toString();
                    if (!tempCurrency.equalsIgnoreCase(currency.getCode())) continue;
                    amount = new Amount(Double.parseDouble(balanceObj.get("balance").toString()), currency);
                    found = true;
                }
                if (found) {
                    apiResponse.setResponseObject(amount);
                } else {
                    apiResponse.setError(new ApiError(21341, "Can't find balance for specified currency: " + currency.getCode()));
                }
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getLastPrice(CurrencyPair pair) {
        Ticker ticker = new Ticker();
        ApiResponse apiResponse = new ApiResponse();
        double last = -1.0;
        double ask = -1.0;
        double bid = -1.0;
        String ticker_url = this.apiBaseUrl + this.getTickerPath(pair);
        String queryResult = HttpUtils.getContentForGet(ticker_url, 5000);
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            JSONObject tickerOBJ = (JSONObject)httpAnswerJson.get("ticker");
            last = Double.parseDouble(tickerOBJ.get("last").toString());
            ask = Double.parseDouble(tickerOBJ.get("buy").toString());
            bid = Double.parseDouble(tickerOBJ.get("sell").toString());
            ticker.setAsk(ask);
            ticker.setBid(bid);
            ticker.setLast(last);
            apiResponse.setResponseObject(ticker);
        }
        catch (ParseException pe) {
            LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse sell(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("SELL", pair, amount, rate);
    }

    @Override
    public ApiResponse buy(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("BUY", pair, amount, rate);
    }

    public ApiResponse enterOrder(String type, CurrencyPair pair, double amount, double rate) {
        ApiResponse apiResponse = new ApiResponse();
        String order_id = "";
        String url = this.apiBaseUrl;
        String method = "/api/v2/orders";
        boolean isGet = false;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("side", type.toLowerCase());
        query_args.put("volume", Double.toString(amount));
        query_args.put("price", Double.toString(rate));
        query_args.put("market", pair.toString());
        query_args.put("canonical_verb", "POST");
        query_args.put("canonical_uri", method);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            if (httpAnswerJson.containsKey("id")) {
                order_id = httpAnswerJson.get("id").toString();
                apiResponse.setResponseObject(order_id);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getActiveOrders() {
        ApiError err = this.errors.genericError;
        err.setDescription("In Peatio API you should specify the CurrencyPair\nuse getActiveOrders(CurrencyPair pair)");
        return new ApiResponse(false, null, err);
    }

    @Override
    public ApiResponse getActiveOrders(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<Order> orderList = new ArrayList<Order>();
        String url = this.apiBaseUrl;
        String method = "/api/v2/orders";
        boolean isGet = true;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("canonical_verb", "GET");
        query_args.put("canonical_uri", method);
        query_args.put("market", pair.toString());
        query_args.put("limit", "999");
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONArray httpAnswerJson = (JSONArray)response.getResponseObject();
            for (Object anOrdersResponse : httpAnswerJson) {
                JSONObject orderResponse = (JSONObject)anOrdersResponse;
                Order tempOrder = this.parseOrder(orderResponse);
                if (tempOrder.isCompleted()) continue;
                orderList.add(tempOrder);
            }
            apiResponse.setResponseObject(orderList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getOrderDetail(String orderID) {
        ApiResponse apiResponse = new ApiResponse();
        Object order = null;
        String url = this.apiBaseUrl;
        String method = "/api/v2/order";
        boolean isGet = true;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("canonical_verb", "GET");
        query_args.put("canonical_uri", "/api/v2/order");
        query_args.put("id", orderID);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            if (httpAnswerJson.containsKey("error")) {
                JSONObject error = (JSONObject)httpAnswerJson.get("error");
                int code = ~((Integer)error.get("code")).intValue();
                String msg = error.get("message").toString();
                apiResponse.setError(new ApiError(code, msg));
                return apiResponse;
            }
            apiResponse.setResponseObject(this.parseOrder(httpAnswerJson));
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse cancelOrder(String orderID, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = this.apiBaseUrl;
        String method = "/api/v2/order/delete";
        boolean isGet = false;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("id", orderID);
        query_args.put("canonical_verb", "POST");
        query_args.put("canonical_uri", method);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            if (httpAnswerJson.containsKey("error")) {
                JSONObject error = (JSONObject)httpAnswerJson.get("error");
                int code = (Integer)error.get("code");
                String msg = error.get("message").toString();
                apiResponse.setError(new ApiError(code, msg));
                return apiResponse;
            }
            apiResponse.setResponseObject(true);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse isOrderActive(String id) {
        boolean exists = false;
        ApiResponse existResponse = new ApiResponse();
        ApiResponse orderDetailResponse = this.getOrderDetail(id);
        if (orderDetailResponse.isPositive()) {
            Order order = (Order)orderDetailResponse.getResponseObject();
            exists = !order.isCompleted();
            existResponse.setResponseObject(exists);
        } else {
            ApiError err = orderDetailResponse.getError();
            if (err.getCode() == 2004) {
                exists = false;
                existResponse.setResponseObject(exists);
            } else {
                existResponse.setError(err);
                LOG.severe(existResponse.getError().toString());
            }
        }
        return existResponse;
    }

    @Override
    public ApiResponse getTxFee() {
        return this.getTxFeeImpl();
    }

    @Override
    public ApiResponse getTxFee(CurrencyPair pair) {
        return this.getTxFeeImpl();
    }

    private ApiResponse getTxFeeImpl() {
        double defaultFee = 0.2;
        if (Global.options != null) {
            return new ApiResponse(true, Global.options.getTxFee(), null);
        }
        return new ApiResponse(true, defaultFee, null);
    }

    @Override
    public ApiError getErrorByCode(int code) {
        return null;
    }

    @Override
    public String getUrlConnectionCheck() {
        return this.checkConnectionUrl;
    }

    @Override
    public String query(String url, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String base, String method, TreeMap<String, String> args, boolean isGet) {
        String queryResult;
        PeatioService query = new PeatioService(base, method, args, this.keys);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(true, isGet);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to Peatio");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    private Order parseOrder(JSONObject jsonObject) {
        Order order = new Order();
        String status = jsonObject.get("state").toString();
        boolean executed = false;
        switch (status) {
            case "wait": {
                executed = false;
                break;
            }
            case "done": {
                executed = true;
                break;
            }
            case "cancel": {
                executed = true;
            }
        }
        CurrencyPair cp = CurrencyPair.getCurrencyPairFromString(jsonObject.get("market").toString(), "");
        order.setPair(cp);
        order.setCompleted(executed);
        order.setId("" + jsonObject.get("id"));
        order.setAmount(new Amount(Double.parseDouble(jsonObject.get("remaining_volume").toString()), cp.getOrderCurrency()));
        order.setPrice(new Amount(Double.parseDouble(jsonObject.get("price").toString()), cp.getPaymentCurrency()));
        order.setInsertedDate(this.parseDate(jsonObject.get("created_at").toString()));
        order.setType(jsonObject.get("side").toString());
        return order;
    }

    @Override
    public String query(String url, HashMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String base, String method, HashMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Date parseDate(String dateStr) {
        Date toRet = null;
        dateStr = dateStr.substring(0, dateStr.length() - 1);
        String datePattern = "yyyy-MM-dd'T'HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(datePattern, Locale.ENGLISH);
        try {
            toRet = df.parse(dateStr);
        }
        catch (java.text.ParseException ex) {
            LOG.severe(ex.toString());
            toRet = new Date();
        }
        return toRet;
    }

    @Override
    public ApiResponse clearOrders(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String method = "/api/v2/orders/clear";
        String url = this.apiBaseUrl;
        boolean isGet = false;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        query_args.put("canonical_verb", "POST");
        query_args.put("canonical_uri", method);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            apiResponse.setResponseObject(true);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    private long getNonceInternal(String requester) {
        long timeElapsedSinceLastCall;
        this.apiBusy = true;
        long currentTime = System.currentTimeMillis();
        if (Global.options != null && Global.options.isVerbose()) {
            LOG.info(currentTime + " Now apiBusy! req : " + requester);
        }
        if ((timeElapsedSinceLastCall = currentTime - this.lastSentTonce) < 1100L) {
            try {
                long sleepTime = 1100L;
                Thread.sleep(sleepTime);
                currentTime = System.currentTimeMillis();
                if (Global.options != null && Global.options.isVerbose()) {
                    LOG.info("Just slept " + sleepTime + "; req : " + requester);
                }
            }
            catch (InterruptedException e) {
                LOG.severe(e.toString());
            }
        }
        this.lastSentTonce = currentTime;
        if (Global.options != null && Global.options.isVerbose()) {
            LOG.info("Final tonce to be sent: req : " + requester + " ; Tonce=" + this.lastSentTonce);
        }
        this.apiBusy = false;
        return this.lastSentTonce;
    }

    @Override
    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    @Override
    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        this.checkConnectionUrl = apiBaseUrl;
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair) {
        return this.getLastTradesImpl(pair, 0L);
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair, long startTime) {
        return this.getLastTradesImpl(pair, startTime);
    }

    public ApiResponse getLastTradesImpl(CurrencyPair pair, long startTime) {
        ApiResponse apiResponse = new ApiResponse();
        String url = this.apiBaseUrl;
        String method = "/api/v2/trades/my.json";
        boolean isGet = true;
        TreeMap<String, String> query_args = new TreeMap<String, String>();
        ArrayList<Trade> tradeList = new ArrayList<Trade>();
        query_args.put("canonical_verb", "GET");
        query_args.put("canonical_uri", method);
        query_args.put("market", pair.toString());
        query_args.put("limit", "1000");
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            LOG.info("A maximum of 1000 trades can be returned from the BitSpark API");
            JSONArray httpAnswerJson = (JSONArray)response.getResponseObject();
            Iterator trade = httpAnswerJson.iterator();
            while (trade.hasNext()) {
                Trade thisTrade = this.parseTrade((JSONObject)trade.next());
                if (thisTrade.getDate().getTime() < startTime) continue;
                tradeList.add(thisTrade);
            }
            apiResponse.setResponseObject(tradeList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    public Trade parseTrade(JSONObject in) {
        Trade out = new Trade();
        out.setId(in.get("id").toString());
        out.setOrder_id(in.get("id").toString());
        CurrencyPair pair = CurrencyPair.getCurrencyPairFromString(in.get("market").toString(), "");
        out.setPair(pair);
        out.setType(in.get("side").toString().equals("bid") ? "BUY" : "SELL");
        Amount price = new Amount(Double.parseDouble(in.get("price").toString()), pair.getPaymentCurrency());
        out.setPrice(price);
        Amount amount = new Amount(Double.parseDouble(in.get("volume").toString()), pair.getOrderCurrency());
        out.setAmount(amount);
        out.setDate(this.parseDate(in.get("created_at").toString()));
        out.setExchangeName(this.exchange.getName());
        return out;
    }

    private class PeatioService
    implements ServiceInterface {
        protected String base;
        protected String method;
        protected TreeMap args;
        protected ApiKeys keys;
        protected String url;

        public PeatioService(String base, String method, TreeMap<String, String> args, ApiKeys keys) {
            this.base = base;
            this.method = method;
            this.args = args;
            this.keys = keys;
        }

        private PeatioService(String url, TreeMap<String, String> args) {
            this.url = url;
            this.args = args;
            this.method = "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String executeQuery(boolean needAuth, boolean isGet) {
            this.args.put("access_key", this.keys.getApiKey());
            String messageDbg = (String)this.args.get("canonical_verb") + " " + (String)this.args.get("canonical_uri");
            this.args.put("tonce", PeatioWrapper.this.createNonce(messageDbg).toString());
            this.args.put("signature", this.getSign(this.args));
            String canonical_verb = (String)this.args.get("canonical_verb");
            this.args.remove("canonical_verb");
            String canonical_uri = (String)this.args.get("canonical_uri");
            this.args.remove("canonical_uri");
            LOG.fine("Calling " + canonical_uri + " with params:" + this.args);
            String response = null;
            try {
                String url = PeatioWrapper.this.apiBaseUrl + canonical_uri;
                Connection connection = HttpUtils.getConnectionForPost(url, this.args).timeout(15000);
                connection.ignoreHttpErrors(true);
                Document doc = "post".equalsIgnoreCase(canonical_verb) ? connection.ignoreContentType(true).post() : connection.ignoreContentType(true).get();
                String string = response = doc.body().text();
                LOG.fine("result:{}" + response);
                return string;
            }
            catch (Exception e) {
                LOG.severe(e.toString());
                String string = null;
                return string;
            }
            finally {
                LOG.fine("result:{}" + response);
            }
        }

        @Override
        public String signRequest(String secret, String hash_data) {
            throw new UnsupportedOperationException("Use getSign(TreeMap<String, String> parameters");
        }

        private String getSign(TreeMap<String, String> parameters) {
            if (parameters.containsKey("signature")) {
                parameters.remove("signature");
            }
            StringBuilder parameter = new StringBuilder();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getKey().equals("canonical_verb") || entry.getKey().equals("canonical_uri")) continue;
                parameter.append("&").append((Object)entry.getKey()).append("=").append((Object)entry.getValue());
            }
            if (parameter.length() > 0) {
                parameter.deleteCharAt(0);
            }
            String canonical_verb = parameters.get("canonical_verb");
            String canonical_uri = parameters.get("canonical_uri");
            String signStr = String.format("%s|%s|%s", canonical_verb, canonical_uri, parameter.toString());
            try {
                Mac mac = Mac.getInstance("HmacSHA256");
                SecretKeySpec keyspec = new SecretKeySpec(this.keys.getPrivateKey().getBytes("UTF-8"), "HmacSHA256");
                mac.init(keyspec);
                mac.update(signStr.getBytes("UTF-8"));
                return String.format("%064x", new BigInteger(1, mac.doFinal()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

