/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading.wrappers;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.models.Trade;
import com.nubits.nubot.trading.ServiceInterface;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.TradeUtils;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.utils.ErrorManager;
import com.nubits.nubot.utils.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Hex;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CcedkWrapper
implements TradeInterface {
    private ApiKeys keys;
    private Exchange exchange;
    private final int SPACING_BETWEEN_CALLS = 1100;
    private final int TIME_OUT = 15000;
    private long lastSentTonce = 0L;
    private static int offset = -1000000000;
    private String checkConnectionUrl = "https://www.ccedk.com/";
    private boolean apiBusy = false;
    private final String SIGN_HASH_FUNCTION = "HmacSHA512";
    private final String ENCODING = "UTF-8";
    private final String API_BASE_URL = this.checkConnectionUrl + "api/v1/";
    private final String API_GET_INFO = "balance/list";
    private final String API_TRADE = "order/new";
    private final String API_GET_TRADES = "trade/list";
    private final String API_ACTIVE_ORDERS = "order/list";
    private final String API_ORDER = "order/info";
    private final String API_CANCEL_ORDER = "order/cancel";
    private ErrorManager errors = new ErrorManager();
    private final String TOKEN_ERR = "errors";
    private final String TOKEN_BAD_RETURN = "No Connection With Exchange";
    private static final Logger LOG = Logger.getLogger(CcedkWrapper.class.getName());
    private static final String INVALID_NONCE_ERROR = "Invalid Nonce value detected";
    private static final int ROUND_CUTOFF = 99;
    private static int INVALID_NONCE_COUNT = 1;

    public CcedkWrapper() {
        this.setupErrors();
    }

    public CcedkWrapper(ApiKeys keys, Exchange exchange) {
        this.keys = keys;
        this.exchange = exchange;
        this.setupErrors();
    }

    public String createNonce(String requester) {
        String validNonce;
        String startvalid = " till";
        if (offset == -1000000000) {
            JSONParser parser = new JSONParser();
            try {
                String htmlString = Utils.getHTML("https://www.ccedk.com/api/v1/currency/list?nonce=1234567891", false);
                JSONObject httpAnswerJson = (JSONObject)parser.parse(htmlString);
                JSONObject errors = (JSONObject)httpAnswerJson.get("errors");
                String nonceError = (String)errors.get("nonce");
                int indexStart = nonceError.lastIndexOf(startvalid) + startvalid.length() + 2;
                int upperEdge = Integer.parseInt(nonceError.substring(indexStart, indexStart + 10));
                offset = upperEdge - (int)(System.currentTimeMillis() / 1000L);
            }
            catch (ParseException ex) {
                LOG.severe(ex.toString());
            }
            catch (IOException io) {
                LOG.severe(io.toString());
            }
        }
        if (offset != -1000000000) {
            int numericalNonce = (int)(System.currentTimeMillis() / 1000L) + offset;
            validNonce = Objects.toString(numericalNonce);
        } else {
            LOG.severe("Error calculating nonce");
            validNonce = "1234567891";
        }
        return validNonce;
    }

    private void setupErrors() {
        this.errors.setExchangeName(this.exchange);
    }

    private ApiResponse getQuery(String url, String method, HashMap<String, String> query_args, boolean isGet) {
        ApiResponse apiResponse = new ApiResponse();
        String queryResult = this.query(url, method, query_args, isGet);
        if (queryResult == null) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.noConnectionError);
            return apiResponse;
        }
        if (queryResult.contains(INVALID_NONCE_ERROR)) {
            ApiError error = this.errors.genericError;
            error.setDescription(queryResult);
            apiResponse.setError(error);
            if (INVALID_NONCE_COUNT < 5) {
                this.getQuery(url, method, query_args, isGet);
                ++INVALID_NONCE_COUNT;
            }
            return apiResponse;
        }
        INVALID_NONCE_COUNT = 1;
        JSONParser parser = new JSONParser();
        try {
            boolean hasErrors;
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            try {
                hasErrors = (Boolean)httpAnswerJson.get("errors");
            }
            catch (ClassCastException e) {
                hasErrors = true;
            }
            if (hasErrors) {
                JSONObject errorMessage = (JSONObject)httpAnswerJson.get("errors");
                ApiError apiErr = this.errors.apiReturnError;
                apiErr.setDescription(errorMessage.toJSONString());
                LOG.severe("Ccedk API returned an error: " + errorMessage);
                apiResponse.setError(apiErr);
            } else {
                apiResponse.setResponseObject(httpAnswerJson);
            }
        }
        catch (ClassCastException cce) {
            try {
                JSONArray httpAnswerJson = (JSONArray)parser.parse(queryResult);
                apiResponse.setResponseObject(httpAnswerJson);
            }
            catch (ParseException pe) {
                LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
                apiResponse.setError(this.errors.parseError);
            }
        }
        catch (ParseException ex) {
            LOG.severe("httpresponse: " + queryResult + " \n" + ex.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalances(CurrencyPair pair) {
        return this.getBalanceImpl(null, pair);
    }

    @Override
    public ApiResponse getAvailableBalance(Currency currency) {
        return this.getBalanceImpl(currency, null);
    }

    private ApiResponse getBalanceImpl(Currency currency, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        Balance balance = new Balance();
        String url = this.API_BASE_URL;
        String method = "balance/list";
        HashMap<String, String> query_args = new HashMap<String, String>();
        boolean isGet = false;
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("response");
            JSONArray entities = (JSONArray)dataJson.get("entities");
            if (currency == null) {
                int NBTid = TradeUtils.getCCDKECurrencyId(pair.getOrderCurrency().getCode().toUpperCase());
                int PEGid = TradeUtils.getCCDKECurrencyId(pair.getPaymentCurrency().getCode().toUpperCase());
                boolean foundNBT = false;
                boolean foundPEG = false;
                Amount NBTTotal = new Amount(-1.0, pair.getOrderCurrency());
                Amount PEGTotal = new Amount(-1.0, pair.getPaymentCurrency());
                for (int i = 0; i < entities.size(); ++i) {
                    double tempbalance;
                    JSONObject temp = (JSONObject)entities.get(i);
                    int tempid = Integer.parseInt((String)temp.get("currency_id"));
                    if (tempid == NBTid) {
                        foundNBT = true;
                        tempbalance = Double.parseDouble((String)temp.get("balance"));
                        NBTTotal = new Amount(tempbalance, pair.getOrderCurrency());
                        continue;
                    }
                    if (tempid != PEGid) continue;
                    tempbalance = Double.parseDouble((String)temp.get("balance"));
                    PEGTotal = new Amount(tempbalance, pair.getPaymentCurrency());
                    foundPEG = true;
                }
                if (foundNBT && foundPEG) {
                    balance = new Balance(NBTTotal, PEGTotal);
                    apiResponse.setResponseObject(balance);
                } else {
                    ApiError err = this.errors.genericError;
                    err.setDescription("Cannot find a currency with id = " + NBTid + " or " + PEGid);
                    apiResponse.setError(err);
                }
            } else {
                int id = TradeUtils.getCCDKECurrencyId(currency.getCode().toUpperCase());
                boolean found = false;
                Amount total = new Amount(-1.0, currency);
                for (int i = 0; i < entities.size(); ++i) {
                    JSONObject temp = (JSONObject)entities.get(i);
                    int tempid = Integer.parseInt((String)temp.get("currency_id"));
                    if (tempid != id) continue;
                    found = true;
                    double tempbalance = Double.parseDouble((String)temp.get("balance"));
                    total = new Amount(tempbalance, currency);
                }
                if (found) {
                    apiResponse.setResponseObject(total);
                } else {
                    ApiError err = this.errors.apiReturnError;
                    err.setDescription("Cannot find a currency with id = " + id);
                    apiResponse.setError(err);
                }
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getLastPrice(CurrencyPair pair) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ApiResponse sell(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("SELL".toLowerCase(), pair, amount, rate);
    }

    @Override
    public ApiResponse buy(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("BUY".toLowerCase(), pair, amount, rate);
    }

    private ApiResponse enterOrder(String type, CurrencyPair pair, double amount, double price) {
        ApiResponse apiResponse = new ApiResponse();
        String order_id = "";
        String url = this.API_BASE_URL;
        String method = "order/new";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        query_args.put("pair_id", Integer.toString(TradeUtils.getCCDKECurrencyPairId(pair)));
        query_args.put("type", type);
        query_args.put("price", Double.toString(price));
        query_args.put("volume", Double.toString(amount));
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("response");
            JSONObject entity = (JSONObject)dataJson.get("entity");
            order_id = (String)entity.get("order_id");
            apiResponse.setResponseObject(order_id);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getActiveOrders() {
        return this.getActiveOrdersImpl(null);
    }

    @Override
    public ApiResponse getActiveOrders(CurrencyPair pair) {
        return this.getActiveOrdersImpl(pair);
    }

    private ApiResponse getActiveOrdersImpl(CurrencyPair pair) {
        ApiResponse response;
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<Order> orderList = new ArrayList<Order>();
        String url = this.API_BASE_URL;
        String method = "order/list";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        if (pair != null) {
            String pair_id = Integer.toString(TradeUtils.getCCDKECurrencyPairId(pair));
            query_args.put("pair_id", pair_id);
        }
        if ((response = this.getQuery(url, method, query_args, isGet)).isPositive()) {
            JSONArray entities;
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("response");
            try {
                entities = (JSONArray)dataJson.get("entities");
            }
            catch (ClassCastException e) {
                apiResponse.setResponseObject(orderList);
                return apiResponse;
            }
            for (int i = 0; i < entities.size(); ++i) {
                JSONObject orderObject = (JSONObject)entities.get(i);
                Order tempOrder = this.parseOrder(orderObject);
                if (tempOrder.isCompleted()) continue;
                orderList.add(tempOrder);
            }
            apiResponse.setResponseObject(orderList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getOrderDetail(String orderID) {
        ApiResponse apiResponse = new ApiResponse();
        ArrayList orderList = new ArrayList();
        String url = this.API_BASE_URL;
        String method = "order/info";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        query_args.put("order_id", orderID);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("response");
            try {
                boolean valid = (Boolean)dataJson.get("entity");
                String message = "The order " + orderID + " does not exist";
                ApiError err = this.errors.apiReturnError;
                err.setDescription(message);
                apiResponse.setError(err);
                return apiResponse;
            }
            catch (ClassCastException e) {
                JSONObject entity = (JSONObject)dataJson.get("entity");
                Order order = this.parseOrder(entity);
                apiResponse.setResponseObject(order);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse cancelOrder(String orderID, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        ArrayList orderList = new ArrayList();
        String url = this.API_BASE_URL;
        String method = "order/cancel";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        query_args.put("order_id", orderID);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("response");
            try {
                boolean valid = (Boolean)dataJson.get("entity");
                String message = "The order " + orderID + " does not exist";
                LOG.severe(message);
                apiResponse.setResponseObject(false);
                return apiResponse;
            }
            catch (ClassCastException e) {
                JSONObject entity = (JSONObject)dataJson.get("entity");
                apiResponse.setResponseObject(true);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getTxFee() {
        double defaultFee = 0.2;
        if (Global.options != null) {
            return new ApiResponse(true, Global.options.getTxFee(), null);
        }
        return new ApiResponse(true, defaultFee, null);
    }

    @Override
    public ApiResponse getTxFee(CurrencyPair pair) {
        LOG.warning("CCEDK uses global TX fee, currency pair not supported.now calling getTxFee()");
        return this.getTxFee();
    }

    @Override
    public ApiResponse isOrderActive(String orderID) {
        ApiResponse apiResponse = new ApiResponse();
        ArrayList orderList = new ArrayList();
        String url = this.API_BASE_URL;
        String method = "order/info";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        query_args.put("order_id", orderID);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("response");
            try {
                boolean valid = (Boolean)dataJson.get("entity");
                String message = "The order " + orderID + " does not exist";
                LOG.info(message);
                apiResponse.setResponseObject(false);
                return apiResponse;
            }
            catch (ClassCastException e) {
                JSONObject entity = (JSONObject)dataJson.get("entity");
                Order order = this.parseOrder(entity);
                apiResponse.setResponseObject(true);
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse clearOrders(CurrencyPair pair) {
        ApiResponse toReturn = new ApiResponse();
        boolean ok = true;
        ApiResponse activeOrdersResponse = this.getActiveOrders();
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                if (pair.equals(tempOrder.getPair())) {
                    ApiResponse deleteOrderResponse = this.cancelOrder(tempOrder.getId(), null);
                    if (deleteOrderResponse.isPositive()) {
                        boolean deleted = (Boolean)deleteOrderResponse.getResponseObject();
                        if (deleted) {
                            LOG.warning("Order " + tempOrder.getId() + " deleted succesfully");
                        } else {
                            LOG.warning("Could not delete order " + tempOrder.getId() + "");
                            ok = false;
                        }
                    } else {
                        LOG.severe(deleteOrderResponse.getError().toString());
                    }
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            toReturn.setError(activeOrdersResponse.getError());
            return toReturn;
        }
        toReturn.setResponseObject(ok);
        return toReturn;
    }

    @Override
    public ApiError getErrorByCode(int code) {
        return null;
    }

    @Override
    public String getUrlConnectionCheck() {
        return this.checkConnectionUrl;
    }

    @Override
    public String query(String url, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        CcedkService query = new CcedkService(url, args);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(false, false);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to ccdek");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String base, String method, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        CcedkService query = new CcedkService(base, method, args, this.keys);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(true, false);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to ccdek");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String url, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String base, String method, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Order parseOrder(JSONObject orderObject) {
        Order order = new Order();
        order.setId((String)orderObject.get("order_id"));
        int currencyPairID = Integer.parseInt((String)orderObject.get("pair_id"));
        CurrencyPair cp = TradeUtils.getCCEDKPairFromID(currencyPairID);
        order.setPair(cp);
        order.setType(orderObject.get("type").toString());
        order.setAmount(new Amount(Double.parseDouble((String)orderObject.get("volume")), cp.getOrderCurrency()));
        order.setPrice(new Amount(Double.parseDouble((String)orderObject.get("price")), cp.getPaymentCurrency()));
        int active = Integer.parseInt((String)orderObject.get("active"));
        if (active == 0) {
            order.setCompleted(true);
        } else {
            order.setCompleted(false);
        }
        long created = Long.parseLong((String)orderObject.get("created") + "000");
        order.setInsertedDate(new Date(created));
        return order;
    }

    private Trade parseTrade(JSONObject orderObject) {
        Trade trade = new Trade();
        trade.setId((String)orderObject.get("trade_id"));
        trade.setExchangeName("ccedk");
        int currencyPairID = Integer.parseInt((String)orderObject.get("pair_id"));
        CurrencyPair cp = TradeUtils.getCCEDKPairFromID(currencyPairID);
        trade.setPair(cp);
        trade.setType(orderObject.get("is_seller").equals("1") ? "SELL" : "BUY");
        trade.setAmount(new Amount(Double.parseDouble((String)orderObject.get("volume")), cp.getOrderCurrency()));
        trade.setPrice(new Amount(Double.parseDouble((String)orderObject.get("price")), cp.getPaymentCurrency()));
        trade.setFee(new Amount(Double.parseDouble((String)orderObject.get("fee")), cp.getPaymentCurrency()));
        long date = Long.parseLong((String)orderObject.get("created") + "000");
        trade.setDate(new Date(date));
        return trade;
    }

    @Override
    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    @Override
    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setApiBaseUrl(String apiBaseUrl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair) {
        return this.getLastTradesImpl(pair, 0L);
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair, long startTime) {
        return this.getLastTradesImpl(pair, startTime);
    }

    public ApiResponse getLastTradesImpl(CurrencyPair pair, long startTime) {
        String startDateArg;
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        String url = this.API_BASE_URL;
        String method = "trade/list";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        String pair_id = Integer.toString(TradeUtils.getCCDKECurrencyPairId(pair));
        if (startTime == 0L) {
            long now = System.currentTimeMillis();
            long yesterday = now - Utils.getOneDayInMillis();
            startDateArg = Long.toString(yesterday);
        } else {
            startDateArg = Long.toString(startTime);
        }
        startDateArg = startDateArg.substring(0, 10);
        query_args.put("date_from", startDateArg);
        query_args.put("items_per_page", "10000");
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONArray entities;
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("response");
            try {
                entities = (JSONArray)dataJson.get("entities");
            }
            catch (ClassCastException e) {
                apiResponse.setResponseObject(tradesList);
                return apiResponse;
            }
            for (int i = 0; i < entities.size(); ++i) {
                JSONObject tradeObject = (JSONObject)entities.get(i);
                Trade tempTrade = this.parseTrade(tradeObject);
                tradesList.add(tempTrade);
            }
            apiResponse.setResponseObject(tradesList);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    private class CcedkService
    implements ServiceInterface {
        protected String base;
        protected String method;
        protected HashMap args;
        protected ApiKeys keys;
        protected String url;
        protected final int MAX_NUMBER_ATTEMPTS = 3;
        protected int wrongNonceCounter;
        protected String adjustedNonce;

        public CcedkService(String base, String method, HashMap<String, String> args, ApiKeys keys) {
            this.base = base;
            this.method = method;
            this.args = args;
            this.keys = keys;
            this.wrongNonceCounter = 0;
        }

        private CcedkService(String url, HashMap<String, String> args) {
            this.url = url;
            this.args = args;
            this.method = "";
            this.wrongNonceCounter = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String executeQuery(boolean needAuth, boolean isGet) {
            String string;
            String answer = "";
            String signature = "";
            String post_data = "";
            boolean httpError = false;
            HttpURLConnection connection = null;
            try {
                String output;
                if (needAuth) {
                    String nonce;
                    if (this.wrongNonceCounter == 0) {
                        nonce = CcedkWrapper.this.createNonce("");
                    } else {
                        LOG.info("Re executing query for the " + this.wrongNonceCounter + " time. " + "New nonce = " + this.adjustedNonce + " while calling : " + this.method);
                        nonce = this.adjustedNonce;
                    }
                    this.args.put("nonce", nonce);
                    String toHash = post_data = TradeUtils.buildQueryString(this.args, "UTF-8");
                    signature = this.signRequest(this.keys.getPrivateKey(), toHash);
                }
                URL queryUrl = needAuth ? new URL(this.base + this.method) : new URL(this.url);
                connection = (HttpsURLConnection)queryUrl.openConnection();
                if (isGet) {
                    connection.setRequestMethod("GET");
                } else {
                    connection.setRequestMethod("POST");
                }
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; CCEDK PHP client; " + Global.settings.getProperty("app_name"));
                if (needAuth) {
                    connection.setRequestProperty("Key", this.keys.getApiKey());
                    connection.setRequestProperty("Sign", signature);
                }
                connection.setDoOutput(true);
                connection.setDoInput(true);
                DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                os.writeBytes(post_data);
                os.close();
                BufferedReader br = null;
                if (connection.getResponseCode() >= 400) {
                    httpError = true;
                    br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                } else {
                    br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                }
                if (httpError) {
                    LOG.severe("Http error - Post Data: " + post_data);
                }
                LOG.fine("Query to :" + this.base + "(method=" + this.method + ")" + " , HTTP response : \n");
                while ((output = br.readLine()) != null) {
                    LOG.fine(output);
                    answer = answer + output;
                }
                if (answer.contains("\"nonce\":\"incorrect range")) {
                    String string2 = "Invalid Nonce value detected " + answer;
                    return string2;
                }
                if (httpError) {
                    JSONParser parser = new JSONParser();
                    try {
                        JSONObject obj2 = (JSONObject)parser.parse(answer);
                        answer = (String)obj2.get("errors");
                    }
                    catch (ParseException ex) {
                        LOG.severe(ex.toString());
                    }
                }
            }
            catch (IllegalStateException ex) {
                LOG.severe(ex.toString());
                string = null;
                return string;
            }
            catch (NoRouteToHostException | UnknownHostException ex) {
                LOG.severe(ex.toString());
                answer = "No Connection With Exchange";
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
                string = null;
                return string;
            }
            finally {
                connection.disconnect();
                connection = null;
            }
            return answer;
        }

        @Override
        public String signRequest(String secret, String hash_data) {
            Mac mac;
            String signature = "";
            SecretKeySpec key = null;
            try {
                key = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA512");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.severe("Unsupported encoding exception: " + uee.toString());
                return null;
            }
            try {
                mac = Mac.getInstance("HmacSHA512");
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.severe("No such algorithm exception: " + nsae.toString());
                return null;
            }
            try {
                mac.init(key);
            }
            catch (InvalidKeyException ike) {
                LOG.severe("Invalid key exception: " + ike.toString());
                return null;
            }
            try {
                signature = Hex.encodeHexString(mac.doFinal(hash_data.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.severe(ex.toString());
            }
            return signature;
        }
    }
}

