/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.trading.wrappers;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiError;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.Balance;
import com.nubits.nubot.models.Currency;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.trading.ServiceInterface;
import com.nubits.nubot.trading.Ticker;
import com.nubits.nubot.trading.TradeInterface;
import com.nubits.nubot.trading.TradeUtils;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.utils.ErrorManager;
import com.nubits.nubot.utils.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BtceWrapper
implements TradeInterface {
    private static final Logger LOG = Logger.getLogger(BtceWrapper.class.getName());
    private ApiKeys keys;
    private Exchange exchange;
    private String checkConnectionUrl = "http://btc-e.com";
    private final String SIGN_HASH_FUNCTION = "HmacSHA512";
    private final String ENCODING = "UTF-8";
    private final String API_BASE_URL = "https://btc-e.com/tapi/";
    private final String API_GET_INFO = "getInfo";
    private final String API_TRADE = "Trade";
    private final String API_ACTIVE_ORDERS = "ActiveOrders";
    private final String API_CANCEL_ORDER = "CancelOrder";
    private final String API_GET_FEE = "https://btc-e.com/exchange/";
    private final String API_V2_URL = "https://btc-e.com/api/2/";
    private final String API_TICKER_USD = "btc_usd/ticker";
    private ErrorManager errors = new ErrorManager();
    private final String TOKEN_ERR = "error";
    private final String TOKEN_BAD_RETURN = "No Connection With Exchange";

    public BtceWrapper() {
        this.setupErrors();
    }

    public BtceWrapper(ApiKeys keys, Exchange exchange) {
        this.keys = keys;
        this.exchange = exchange;
        this.setupErrors();
    }

    private void setupErrors() {
        this.errors.setExchangeName(this.exchange);
    }

    protected static String createNonce() {
        long toRet = Math.round(System.currentTimeMillis() / 1000L);
        return Long.toString(toRet);
    }

    private ApiResponse getQuery(String url, String method, HashMap<String, String> query_args, boolean isGet) {
        ApiResponse apiResponse = new ApiResponse();
        String queryResult = this.query("https://btc-e.com/tapi/", method, query_args, false);
        if (queryResult == null) {
            apiResponse.setError(this.errors.nullReturnError);
            return apiResponse;
        }
        if (queryResult.equals("No Connection With Exchange")) {
            apiResponse.setError(this.errors.noConnectionError);
            return apiResponse;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject httpAnswerJson = (JSONObject)parser.parse(queryResult);
            long success = (Long)httpAnswerJson.get("success");
            if (success == 0L) {
                String errorMessage = (String)httpAnswerJson.get("error");
                ApiError apiErr = this.errors.apiReturnError;
                apiErr.setDescription(errorMessage);
                apiResponse.setError(apiErr);
            } else {
                apiResponse.setResponseObject(httpAnswerJson);
            }
        }
        catch (ClassCastException cce) {
            try {
                JSONArray httpAnswerJson = (JSONArray)parser.parse(queryResult);
                apiResponse.setResponseObject(httpAnswerJson);
            }
            catch (ParseException pe) {
                LOG.severe("httpResponse: " + queryResult + " \n" + pe.toString());
                apiResponse.setError(this.errors.parseError);
            }
        }
        catch (ParseException ex) {
            LOG.severe("httpresponse: " + queryResult + " \n" + ex.toString());
            apiResponse.setError(this.errors.parseError);
            return apiResponse;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalances(CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        Balance balance = new Balance();
        String url = "https://btc-e.com/tapi/";
        String method = "getInfo";
        HashMap<String, String> query_args = new HashMap<String, String>();
        boolean isGet = false;
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("return");
            JSONObject funds = (JSONObject)dataJson.get("funds");
            String pegCode = pair.getPaymentCurrency().getCode().toLowerCase();
            String nbtCode = pair.getOrderCurrency().getCode().toLowerCase();
            Amount PEGTotal = new Amount(Double.parseDouble(funds.get(pegCode).toString()), Constant.USD);
            Amount NBTTotal = new Amount(Double.parseDouble(funds.get(nbtCode).toString()), Constant.NBT);
            balance = new Balance(NBTTotal, PEGTotal);
            apiResponse.setResponseObject(balance);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getAvailableBalance(Currency currency) {
        ApiResponse apiResponse = new ApiResponse();
        Balance balance = new Balance();
        String url = "https://btc-e.com/tapi/";
        String method = "getInfo";
        HashMap<String, String> query_args = new HashMap<String, String>();
        boolean isGet = false;
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("return");
            JSONObject funds = (JSONObject)dataJson.get("funds");
            Amount amount = new Amount(Double.parseDouble(funds.get(currency.getCode().toLowerCase()).toString()), currency);
            apiResponse.setResponseObject(amount);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getLastPrice(CurrencyPair pair) {
        Ticker ticker = new Ticker();
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://btc-e.com/api/2/";
        String method = "btc_usd/ticker";
        boolean isGet = false;
        double last = -1.0;
        double ask = -1.0;
        double bid = -1.0;
        HashMap<String, String> query_args = new HashMap<String, String>();
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject tickerObject = (JSONObject)httpAnswerJson.get("ticker");
            last = Utils.getDouble(tickerObject.get("last"));
            bid = Utils.getDouble(tickerObject.get("sell"));
            ask = Utils.getDouble(tickerObject.get("buy"));
            ticker.setAsk(ask);
            ticker.setBid(bid);
            ticker.setLast(last);
            apiResponse.setResponseObject(ticker);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse sell(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("SELL", pair, amount, rate);
    }

    @Override
    public ApiResponse buy(CurrencyPair pair, double amount, double rate) {
        return this.enterOrder("BUY", pair, amount, rate);
    }

    @Override
    public ApiResponse getActiveOrders() {
        return this.getActiveOrdersImpl(null);
    }

    @Override
    public ApiResponse getActiveOrders(CurrencyPair pair) {
        return this.getActiveOrdersImpl(pair);
    }

    @Override
    public ApiResponse getOrderDetail(String orderID) {
        ApiResponse apiResp = new ApiResponse();
        Object order = null;
        ApiResponse listApiResp = this.getActiveOrders();
        if (listApiResp.isPositive()) {
            ArrayList orderList = (ArrayList)listApiResp.getResponseObject();
            boolean found = false;
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                if (!orderID.equals(tempOrder.getId())) continue;
                found = true;
                apiResp.setResponseObject(tempOrder);
                return apiResp;
            }
            if (!found) {
                ApiError error = this.errors.genericError;
                error.setDescription("Cannot find the order with id " + orderID);
                apiResp.setError(error);
                return apiResp;
            }
        } else {
            return listApiResp;
        }
        return apiResp;
    }

    @Override
    public ApiResponse cancelOrder(String orderID, CurrencyPair pair) {
        ApiResponse apiResponse = new ApiResponse();
        String url = "https://btc-e.com/tapi/";
        String method = "CancelOrder";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        query_args.put("order_id", orderID);
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            apiResponse.setResponseObject(true);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getTxFee() {
        if (Global.options != null) {
            return new ApiResponse(true, Global.options.getTxFee(), null);
        }
        ApiResponse apiResponse = new ApiResponse();
        String strDelimiterStart = "the fee for transactions is ";
        String strDelimterStop = "%.</p>";
        String content = "ERROR";
        try {
            content = Utils.getHTML("https://btc-e.com/exchange/", true);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        if (!content.equals("ERROR")) {
            int startIndex = content.lastIndexOf(strDelimiterStart) + strDelimiterStart.length();
            int stopIndex = content.lastIndexOf(strDelimterStop);
            String feeString = content.substring(startIndex, stopIndex);
            double fee = Double.parseDouble(feeString);
            apiResponse.setResponseObject(fee);
        } else {
            apiResponse.setError(this.errors.genericError);
        }
        return apiResponse;
    }

    @Override
    public ApiResponse getTxFee(CurrencyPair pair) {
        LOG.fine("Btc-e uses global TX fee, currency pair not supprted. \nnow calling getTxFee()");
        return this.getTxFee();
    }

    private ApiResponse getActiveOrdersImpl(CurrencyPair pair) {
        ApiResponse response;
        ApiResponse apiResponse = new ApiResponse();
        ArrayList<Order> orderList = new ArrayList<Order>();
        String url = "https://btc-e.com/tapi/";
        String method = "ActiveOrders";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        if (pair != null) {
            query_args.put("pair", pair.toString("_"));
        }
        if ((response = this.getQuery(url, method, query_args, isGet)).isPositive()) {
            try {
                JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
                org.json.JSONObject dataJson = (org.json.JSONObject)httpAnswerJson.get("return");
                String[] names = org.json.JSONObject.getNames(dataJson);
                for (int i = 0; i < names.length; ++i) {
                    org.json.JSONObject tempJson = dataJson.getJSONObject(names[i]);
                    Order temp = new Order();
                    temp.setId(names[i]);
                    CurrencyPair cp = CurrencyPair.getCurrencyPairFromString((String)tempJson.get("pair"), "_");
                    boolean executed = false;
                    int status = tempJson.getInt("status");
                    switch (status) {
                        case 0: {
                            executed = false;
                            break;
                        }
                        case 1: {
                            executed = true;
                            break;
                        }
                        default: {
                            apiResponse.setError(new ApiError(231445, "Order status unknown : " + status));
                        }
                    }
                    temp.setPair(cp);
                    temp.setType((String)tempJson.get("type"));
                    temp.setAmount(new Amount(tempJson.getDouble("amount"), cp.getOrderCurrency()));
                    temp.setPrice(new Amount(tempJson.getDouble("rate"), cp.getPaymentCurrency()));
                    temp.setInsertedDate(new Date(tempJson.getLong("timestamp_created")));
                    temp.setCompleted(executed);
                    if (executed) continue;
                    orderList.add(temp);
                }
                apiResponse.setResponseObject(orderList);
            }
            catch (JSONException ex) {
                LOG.severe(ex.toString());
                apiResponse.setError(this.errors.parseError);
                return apiResponse;
            }
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    private ApiResponse enterOrder(String type, CurrencyPair pair, double amount, double rate) {
        ApiResponse apiResponse = new ApiResponse();
        String order_id = "";
        String url = "https://btc-e.com/tapi/";
        String method = "Trade";
        boolean isGet = false;
        HashMap<String, String> query_args = new HashMap<String, String>();
        query_args.put("pair", pair.toString("_"));
        query_args.put("type", type);
        query_args.put("rate", Double.toString(rate));
        query_args.put("amount", Double.toString(amount));
        ApiResponse response = this.getQuery(url, method, query_args, isGet);
        if (response.isPositive()) {
            JSONObject httpAnswerJson = (JSONObject)response.getResponseObject();
            JSONObject dataJson = (JSONObject)httpAnswerJson.get("return");
            order_id = "" + (Long)dataJson.get("order_id");
            apiResponse.setResponseObject(order_id);
        } else {
            apiResponse = response;
        }
        return apiResponse;
    }

    @Override
    public ApiError getErrorByCode(int code) {
        return null;
    }

    @Override
    public ApiResponse isOrderActive(String id) {
        ApiResponse existResponse = new ApiResponse();
        ApiResponse orderDetailResponse = this.getOrderDetail(id);
        if (orderDetailResponse.isPositive()) {
            Order order = (Order)orderDetailResponse.getResponseObject();
            existResponse.setResponseObject(true);
        } else {
            ApiError err = orderDetailResponse.getError();
            if (err.getCode() == 4564) {
                existResponse.setResponseObject(false);
            } else {
                existResponse.setError(err);
                LOG.severe(existResponse.getError().toString());
            }
        }
        return existResponse;
    }

    @Override
    public String query(String url, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        BtceService query = new BtceService(url, args);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(false, false);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to btce");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String base, String method, HashMap<String, String> args, boolean isGet) {
        String queryResult;
        BtceService query = new BtceService(base, method, args, this.keys);
        if (this.exchange.getLiveData().isConnected()) {
            queryResult = query.executeQuery(true, false);
        } else {
            LOG.severe("The bot will not execute the query, there is no connection to btce");
            queryResult = "No Connection With Exchange";
        }
        return queryResult;
    }

    @Override
    public String query(String url, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String query(String base, String method, TreeMap<String, String> args, boolean isGet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ApiResponse clearOrders(CurrencyPair pair) {
        ApiResponse toReturn = new ApiResponse();
        boolean ok = true;
        ApiResponse activeOrdersResponse = this.getActiveOrders();
        if (activeOrdersResponse.isPositive()) {
            ArrayList orderList = (ArrayList)activeOrdersResponse.getResponseObject();
            for (int i = 0; i < orderList.size(); ++i) {
                Order tempOrder = (Order)orderList.get(i);
                ApiResponse deleteOrderResponse = this.cancelOrder(tempOrder.getId(), null);
                if (deleteOrderResponse.isPositive()) {
                    boolean deleted = (Boolean)deleteOrderResponse.getResponseObject();
                    if (deleted) {
                        LOG.warning("Order " + tempOrder.getId() + " deleted succesfully");
                    } else {
                        LOG.warning("Could not delete order " + tempOrder.getId() + "");
                        ok = false;
                    }
                } else {
                    LOG.severe(deleteOrderResponse.getError().toString());
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.severe(ex.toString());
                }
            }
        } else {
            LOG.severe(activeOrdersResponse.getError().toString());
            toReturn.setError(activeOrdersResponse.getError());
            return toReturn;
        }
        toReturn.setResponseObject(ok);
        return toReturn;
    }

    @Override
    public String getUrlConnectionCheck() {
        return this.checkConnectionUrl;
    }

    @Override
    public void setKeys(ApiKeys keys) {
        this.keys = keys;
    }

    @Override
    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setApiBaseUrl(String apiBaseUrl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ApiResponse getLastTrades(CurrencyPair pair, long startTime) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class BtceService
    implements ServiceInterface {
        protected String base;
        protected String method;
        protected HashMap args;
        protected ApiKeys keys;
        protected String url;

        public BtceService(String base, String method, HashMap<String, String> args, ApiKeys keys) {
            this.base = base;
            this.method = method;
            this.args = args;
            this.keys = keys;
        }

        private BtceService(String url, HashMap<String, String> args) {
            this.url = url;
            this.args = args;
            this.method = "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String executeQuery(boolean needAuth, boolean isGet) {
            String answer = null;
            String signature = "";
            String post_data = "";
            boolean httpError = false;
            HttpURLConnection connection = null;
            try {
                String output;
                if (needAuth) {
                    this.args.put("nonce", BtceWrapper.createNonce());
                    this.args.put("method", this.method);
                    String toHash = post_data = TradeUtils.buildQueryString(this.args, "UTF-8");
                    signature = this.signRequest(this.keys.getPrivateKey(), toHash);
                }
                URL queryUrl = needAuth ? new URL(this.base) : new URL(this.url);
                connection = (HttpsURLConnection)queryUrl.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("User-Agent", Global.settings.getProperty("app_name"));
                if (needAuth) {
                    connection.setRequestProperty("Key", this.keys.getApiKey());
                    connection.setRequestProperty("Sign", signature);
                }
                connection.setDoOutput(true);
                connection.setDoInput(true);
                DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                os.writeBytes(post_data);
                os.close();
                BufferedReader br = null;
                boolean toLog = false;
                if (connection.getResponseCode() >= 400) {
                    httpError = true;
                    br = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                    toLog = true;
                } else {
                    br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                }
                if (httpError) {
                    LOG.severe("Post Data: " + post_data);
                }
                LOG.fine("Query to :" + this.base + "(method=" + this.method + ")" + " , HTTP response : \n");
                while ((output = br.readLine()) != null) {
                    LOG.fine(output);
                    answer = answer + output;
                }
            }
            catch (IllegalStateException ex) {
                LOG.severe(ex.toString());
                String string = null;
                return string;
            }
            catch (NoRouteToHostException | UnknownHostException ex) {
                LOG.severe(ex.toString());
                answer = "No Connection With Exchange";
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
                String string = null;
                return string;
            }
            finally {
                connection.disconnect();
                connection = null;
            }
            return answer;
        }

        @Override
        public String signRequest(String secret, String hash_data) {
            Mac mac;
            String signature = "";
            SecretKeySpec key = null;
            try {
                key = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA512");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.severe("Unsupported encoding exception: " + uee.toString());
                return null;
            }
            try {
                mac = Mac.getInstance("HmacSHA512");
            }
            catch (NoSuchAlgorithmException nsae) {
                LOG.severe("No such algorithm exception: " + nsae.toString());
                return null;
            }
            try {
                mac.init(key);
            }
            catch (InvalidKeyException ike) {
                LOG.severe("Invalid key exception: " + ike.toString());
                return null;
            }
            try {
                signature = Hex.encodeHexString(mac.doFinal(hash_data.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.severe(ex.toString());
            }
            return signature;
        }
    }
}

