/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tests;

import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.ApiResponse;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.Order;
import com.nubits.nubot.options.OptionsJSON;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.AllCoinWrapper;
import com.nubits.nubot.trading.wrappers.BitSparkWrapper;
import com.nubits.nubot.trading.wrappers.BitcoinCoIDWrapper;
import com.nubits.nubot.trading.wrappers.BtceWrapper;
import com.nubits.nubot.trading.wrappers.BterWrapper;
import com.nubits.nubot.trading.wrappers.CcedkWrapper;
import com.nubits.nubot.trading.wrappers.CcexWrapper;
import com.nubits.nubot.trading.wrappers.ExcoinWrapper;
import com.nubits.nubot.trading.wrappers.PeatioWrapper;
import com.nubits.nubot.trading.wrappers.PoloniexWrapper;
import com.nubits.nubot.utils.FileSystem;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class TestWrapperReturns {
    private static final Logger LOG = Logger.getLogger(TestWrapperReturns.class.getName());
    private static final String TEST_OPTIONS_PATH = "options.json";
    public static ArrayList<String> testExchanges = new ArrayList();
    public static CurrencyPair testPair = Constant.NBT_BTC;
    public static final double testNBTAmount = 1.0;
    public static final double sellPrice = 0.04;
    public static final double buyPrice = 4.0E-4;

    public static void main(String[] args) {
        Utils.loadProperties("settings.properties");
        TestWrapperReturns.init();
        String[] inputs = new String[]{TEST_OPTIONS_PATH};
        Global.options = OptionsJSON.parseOptions(inputs);
        testExchanges = TestWrapperReturns.populateExchanges();
        for (String testExchange : testExchanges) {
            TestWrapperReturns.configExchange(testExchange);
            TestWrapperReturns.runTests();
        }
        System.exit(0);
    }

    private static void runTests() {
        Amount price;
        Amount amount;
        Order order;
        testPair = Global.exchange.getName().equals("excoin") ? Constant.BTC_NBT : Constant.NBT_BTC;
        TestWrapperReturns.print("Testing " + Global.exchange.getName());
        TestWrapperReturns.clearOrders(testPair);
        TestWrapperReturns.print("SELL 1.0 NBT @ 0.04 BTC");
        String order_id = TestWrapperReturns.sell(testPair, 1.0, 0.04);
        TestWrapperReturns.sleep();
        if (order_id != null) {
            order = TestWrapperReturns.getOrderDetail(order_id);
            amount = order.getAmount();
            if (!amount.getCurrency().equals(testPair.getOrderCurrency())) {
                TestWrapperReturns.print("BAD - Amount not listed in " + testPair.getOrderCurrency().getCode() + "\nReturned " + amount.getCurrency().getCode());
            } else if (amount.getQuantity() != 1.0) {
                TestWrapperReturns.print("BAD - Amount Quantity does not equal " + Double.toString(1.0));
            } else {
                TestWrapperReturns.print("Amount OK");
            }
            price = order.getPrice();
            if (!price.getCurrency().equals(testPair.getPaymentCurrency())) {
                TestWrapperReturns.print("BAD - Price not listed in " + testPair.getPaymentCurrency().getCode());
            } else if (price.getQuantity() != 0.04) {
                TestWrapperReturns.print("BAD - Price Quantity does not equal " + Double.toString(0.04));
            } else {
                TestWrapperReturns.print("Price OK");
            }
            TestWrapperReturns.cancelOrder(order_id, testPair);
        } else {
            TestWrapperReturns.print("BAD - Order not placed");
        }
        TestWrapperReturns.print("BUY 1.0 NBT @ 4.0E-4 BTC");
        order_id = TestWrapperReturns.buy(testPair, 1.0, 4.0E-4);
        TestWrapperReturns.sleep();
        if (order_id != null) {
            order = TestWrapperReturns.getOrderDetail(order_id);
            amount = order.getAmount();
            if (!amount.getCurrency().equals(testPair.getOrderCurrency())) {
                TestWrapperReturns.print("BAD - Amount not listed in " + testPair.getOrderCurrency().getCode() + "\nReturned " + amount.getCurrency().getCode());
            } else if (amount.getQuantity() != 1.0) {
                TestWrapperReturns.print("BAD - Amount Quantity does not equal " + Double.toString(1.0));
            } else {
                TestWrapperReturns.print("Amount OK");
            }
            price = order.getPrice();
            if (!price.getCurrency().equals(testPair.getPaymentCurrency())) {
                TestWrapperReturns.print("BAD - Price not listed in " + testPair.getPaymentCurrency().getCode());
            } else if (price.getQuantity() != 4.0E-4) {
                TestWrapperReturns.print("BAD - Price Quantity does not equal " + Double.toString(4.0E-4));
            } else {
                TestWrapperReturns.print("Price OK");
            }
            TestWrapperReturns.cancelOrder(order_id, testPair);
        } else {
            TestWrapperReturns.print("BAD - Order not placed");
        }
    }

    private static void clearOrders(CurrencyPair pair) {
        ApiResponse response = Global.exchange.getTrade().clearOrders(pair);
        if (!response.isPositive()) {
            TestWrapperReturns.print("Error: " + response.getError().toString());
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            TestWrapperReturns.print(ie.toString());
        }
    }

    private static void print(String s) {
        System.out.println(s);
    }

    private static boolean cancelOrder(String order_id, CurrencyPair pair) {
        ApiResponse response = Global.exchange.getTrade().cancelOrder(order_id, pair);
        if (response.isPositive()) {
            return (Boolean)response.getResponseObject();
        }
        TestWrapperReturns.print("Error: " + response.getError().toString());
        return false;
    }

    private static Order getOrderDetail(String order_id) {
        ApiResponse response = Global.exchange.getTrade().getOrderDetail(order_id);
        if (response.isPositive()) {
            return (Order)response.getResponseObject();
        }
        TestWrapperReturns.print("Error: " + response.getError().toString());
        return null;
    }

    private static String getOpenOrders() {
        ApiResponse response = Global.exchange.getTrade().getActiveOrders();
        if (response.isPositive()) {
            TestWrapperReturns.print("Response object: " + response.getResponseObject().toString());
            return response.getResponseObject().toString();
        }
        TestWrapperReturns.print("Error: " + response.getError().toString());
        return null;
    }

    private static void getBalance(CurrencyPair pair) {
        ApiResponse response = Global.exchange.getTrade().getAvailableBalances(pair);
        if (!response.isPositive()) {
            TestWrapperReturns.print("Error: " + response.getError().toString());
        }
    }

    private static String sell(CurrencyPair pair, double amount, double price) {
        ApiResponse response = Global.exchange.getTrade().sell(pair, amount, price);
        if (response.isPositive()) {
            return response.getResponseObject().toString();
        }
        TestWrapperReturns.print("Error: " + response.getError().toString());
        return null;
    }

    private static String buy(CurrencyPair pair, double amount, double price) {
        ApiResponse response = Global.exchange.getTrade().buy(pair, amount, price);
        if (response.isPositive()) {
            return response.getResponseObject().toString();
        }
        TestWrapperReturns.print("Error: " + response.getError().toString());
        return null;
    }

    private static void init() {
        String folderName = "testwrapperreturns_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        FileSystem.mkdir(logsFolder);
        try {
            NuLogger.setup(false, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        System.setProperty("javax.net.ssl.trustStore", Global.settings.getProperty("keystore_path"));
        System.setProperty("javax.net.ssl.trustStorePassword", Global.settings.getProperty("keystore_pass"));
    }

    private static ArrayList<String> populateExchanges() {
        ArrayList<String> testExchanges = new ArrayList<String>();
        testExchanges.add("peatio");
        testExchanges.add("bter");
        testExchanges.add("ccedk");
        testExchanges.add("poloniex");
        testExchanges.add("allcoin");
        testExchanges.add("bitspark");
        testExchanges.add("excoin");
        testExchanges.add("bitcoincoid");
        return testExchanges;
    }

    public static void configExchange(String exchangeName) {
        Global.exchange = new Exchange(exchangeName);
        ExchangeLiveData liveData = new ExchangeLiveData();
        Global.exchange.setLiveData(liveData);
        Global.options.setExchangeName(exchangeName);
        if (exchangeName.equals("btce")) {
            ApiKeys keys = new ApiKeys("a27d7dd031ce00bf44fc0c760d94330089670456fd406039f73710e84509f98e", "8A1LURBN-C6XKA4YH-L6X877T1-8Z5Q7T4S-G9GUDGGQ");
            Global.exchange.setTrade(new BtceWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("peatio")) {
            ApiKeys keys = new ApiKeys("X6DZbcMUEDVWpjAMDgRga7liSLOy7gGIVo0zYxQD", "jp1nE97dfnJVR3mS9FanFKYwlPM00XFOixxLH74a");
            Global.exchange.setTrade(new PeatioWrapper(keys, Global.exchange, "http://178.62.186.229/"));
        } else if (exchangeName.equals("ccedk")) {
            ApiKeys keys = new ApiKeys("b910430q472qg2xc97gwu2dp5np8pj1szcn3b36zl9316yd87q8mjhi4q8m2qqeu", "1PS581UD5VZ5JSUHLGOTP32K33P2B9EBMWJA3HVURRH12MF2PQ2K4G1BFXIX7I5T");
            Global.exchange.setTrade(new CcedkWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("bter")) {
            ApiKeys keys = new ApiKeys("ab2432aba7e95db56ce893058986bbce39c48fa7ce134746e3621fbdfd0525f4", "853FC50F-E8C8-4177-B62E-3FE2C1239A83");
            Global.exchange.setTrade(new BterWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("poloniex")) {
            ApiKeys keys = new ApiKeys("caa08a726ed19e604bdfb2686bbad457bec32ae18b5229a16cbc575eb31e2674ede0da733e35d3de5fe9fbb86e3d75bbf812f16c652575b5d2b530c10fbb4bf3", "ANHBHV2Z-T8PYNP2X-DUM90Y27-CDXPP68Q");
            Global.exchange.setTrade(new PoloniexWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("ccex")) {
            ApiKeys keys = new ApiKeys("64ED6B493924A5121FB9ECDEE2726977", "");
            Global.exchange.setTrade(new CcexWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("allcoin")) {
            ApiKeys keys = new ApiKeys("ae60d490cf996d6aea448e071de54328b4996d6a281765f142a97414a665ef", "7c9b8f524c9b7db5977eb21ad94120f0fec96a2f");
            Global.exchange.setTrade(new AllCoinWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("bitspark")) {
            ApiKeys keys = new ApiKeys("MTIjH2x10jObstAR7XSyFtKqQ0Ke7ZaBYBUPzQfX", "QGxlNMG2Jc2jANsOxor239JQ50WJWv8aCkR4WxkA");
            Global.exchange.setTrade(new BitSparkWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("excoin")) {
            ApiKeys keys = new ApiKeys("MnXwGc1HAmmP7JBDZKMv_Q1guIvTn2ZtvfyIZUOjRKMQ", "plG2RCgyH794--Y-7F3GoQ5rJN5Nhkh-k2iLnOZC228A");
            Global.exchange.setTrade(new ExcoinWrapper(keys, Global.exchange));
        } else if (exchangeName.equals("bitcoincoid")) {
            ApiKeys keys = new ApiKeys("1c81ae7b748905b50a4b50fc03603464a8c3091f576065586b11d78a5c64403ec89482fbbfaef289", "VGUYLP7B-LFILPWLD-S0N9Q0ED-TLZCTIWY-TVTAME71");
            Global.exchange.setTrade(new BitcoinCoIDWrapper(keys, Global.exchange));
        } else {
            LOG.severe("Exchange " + exchangeName + " not supported");
            System.exit(0);
        }
        Global.exchange.getLiveData().setUrlConnectionCheck(Global.exchange.getTrade().getUrlConnectionCheck());
        Global.taskManager = new TaskManager();
        Global.taskManager.getCheckConnectionTask().start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
    }
}

