/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tests;

import com.nubits.nubot.RPC.NuRPCClient;
import com.nubits.nubot.exchanges.Exchange;
import com.nubits.nubot.exchanges.ExchangeLiveData;
import com.nubits.nubot.global.Constant;
import com.nubits.nubot.global.Global;
import com.nubits.nubot.options.OptionsJSON;
import com.nubits.nubot.tasks.TaskManager;
import com.nubits.nubot.trading.keys.ApiKeys;
import com.nubits.nubot.trading.wrappers.PeatioWrapper;
import com.nubits.nubot.utils.Utils;
import com.nubits.nubot.utils.logging.NuLogger;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestOrderTask {
    private static final Logger LOG = Logger.getLogger(TestOrderTask.class.getName());
    private static Exchange exchange;
    private static String nudip;
    private static int nudport;

    public static void main(String[] args) {
        TestOrderTask.setup();
        Global.taskManager.getSendLiquidityTask().start();
    }

    private static void setup() {
        String folderName = "tests_" + System.currentTimeMillis() + "/";
        String logsFolder = Global.settings.getProperty("log_path") + folderName;
        try {
            NuLogger.setup(true, logsFolder);
        }
        catch (IOException ex) {
            LOG.severe(ex.toString());
        }
        LOG.setLevel(Level.FINE);
        System.setProperty("javax.net.ssl.trustStore", Global.settings.getProperty("keystore_path"));
        System.setProperty("javax.net.ssl.trustStorePassword", Global.settings.getProperty("keystore_pass"));
        Global.options = new OptionsJSON(true, nudip, "", "", "", "", nudip, nudport, nudport, nudport, true, "", true, true, null, 60, 30, false, false, "", -1, 0.0, false, true, 0.0, 0.0, null);
        LOG.fine("Checking existance of API keys on local filesystem");
        String secret = "X6DZbcMUEDVWpjAMDgRga7liSLOy7gGIVo0zYxQD";
        String apikey = "jp1nE97dfnJVR3mS9FanFKYwlPM00XFOixxLH74a";
        ApiKeys keys = new ApiKeys(secret, apikey);
        exchange = new Exchange("peatio");
        ExchangeLiveData liveData = new ExchangeLiveData();
        exchange.setLiveData(liveData);
        exchange.setTrade(new PeatioWrapper(keys, exchange, "http://178.62.186.229/"));
        exchange.getLiveData().setUrlConnectionCheck(exchange.getTrade().getUrlConnectionCheck());
        Global.taskManager = new TaskManager();
        Global.taskManager.getCheckConnectionTask().start();
        Global.publicAddress = "bVcXrdTgrMSg6J2YqsLedCbi6Ubek9eTe5";
        LOG.fine("Setting up (verbose) RPC client on " + nudip + ":" + nudport);
        Global.rpcClient = new NuRPCClient(nudip, nudport, "desrever", "c140c140", true, true, Global.publicAddress, Constant.NBT_PPC, "testid");
        Utils.printSeparator();
        Global.taskManager.getCheckNudTask().start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            LOG.severe(ex.toString());
        }
        LOG.fine("Check connection with nud");
        if (Global.rpcClient.isConnected()) {
            LOG.fine("OK!");
        } else {
            LOG.severe("Problem while connecting with nud");
            System.exit(0);
        }
    }

    static {
        nudip = "127.0.0.1";
        nudport = 9091;
    }
}

