/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.tasks.strategy;

import com.nubits.nubot.global.Global;
import com.nubits.nubot.notifications.HipChatNotifications;
import com.nubits.nubot.notifications.jhipchat.messages.Message;
import com.nubits.nubot.tasks.SubmitLiquidityinfoTask;
import com.nubits.nubot.tasks.strategy.PriceMonitorTriggerTask;
import com.nubits.nubot.tasks.strategy.StrategySecondaryPegUtils;
import java.util.TimerTask;
import java.util.logging.Logger;

public class StrategySecondaryPegTask
extends TimerTask {
    private static final Logger LOG = Logger.getLogger(StrategySecondaryPegTask.class.getName());
    private StrategySecondaryPegUtils strategyUtils = new StrategySecondaryPegUtils(this);
    private boolean mightNeedInit = true;
    private int activeSellOrders;
    private int activeBuyOrders;
    private int totalActiveOrders;
    private boolean ordersAndBalancesOK;
    private boolean needWallShift;
    private double sellPricePEG;
    private double buyPricePEG;
    private boolean shiftingWalls = false;
    private String priceDirection;
    private PriceMonitorTriggerTask priceMonitorTask;
    private SubmitLiquidityinfoTask sendLiquidityTask;
    private boolean isFirstTime = true;
    private boolean proceedsInBalance = false;

    @Override
    public void run() {
        LOG.fine("Executing task on " + Global.exchange.getName() + ": StrategySecondaryPegTask. DualSide :  " + Global.options.isDualSide());
        if (!this.isFirstTime) {
            if (!Global.options.isMultipleCustodians() && !this.shiftingWalls) {
                this.strategyUtils.recount();
                if (this.mightNeedInit) {
                    boolean reset;
                    boolean bl = reset = this.mightNeedInit && !this.ordersAndBalancesOK;
                    if (reset) {
                        String message = "Order reset needed on " + Global.exchange.getName();
                        HipChatNotifications.sendMessage(message, Message.Color.PURPLE);
                        LOG.warning(message);
                        boolean reinitiateSuccess = this.strategyUtils.reInitiateOrders(false);
                        if (reinitiateSuccess) {
                            this.mightNeedInit = false;
                        }
                    } else {
                        LOG.fine("No need to init new orders since current orders seems correct");
                    }
                    this.strategyUtils.recount();
                }
                if (!this.ordersAndBalancesOK) {
                    LOG.severe("Detected a number of active orders not in line with strategy. Will try to aggregate soon");
                    this.mightNeedInit = true;
                } else if (Global.options.getKeepProceeds() > 0.0 && Global.options.getPair().getPaymentCurrency().isFiat() && Global.isDualSide && this.proceedsInBalance && !this.needWallShift) {
                    this.strategyUtils.aggregateAndKeepProceeds();
                }
            }
        } else {
            LOG.info("Initializing strategy");
            this.isFirstTime = false;
            this.strategyUtils.recount();
            boolean reinitiateSuccess = this.strategyUtils.reInitiateOrders(true);
            if (!reinitiateSuccess) {
                LOG.severe("There was a problem while trying to reinitiating orders on first execution. Trying again on next execution");
                this.isFirstTime = true;
            }
            this.getSendLiquidityTask().setFirstOrdersPlaced(true);
        }
    }

    public void notifyPriceChanged(double new_sellPricePEG, double new_buyPricePEG, double conversion, String direction) {
        if (!this.shiftingWalls) {
            this.shiftingWalls = true;
            LOG.warning("Strategy received a price change notification.");
            this.needWallShift = true;
            if (!Global.swappedPair) {
                this.sellPricePEG = new_sellPricePEG;
                this.buyPricePEG = new_buyPricePEG;
            } else {
                this.sellPricePEG = new_buyPricePEG;
                this.buyPricePEG = new_sellPricePEG;
            }
            this.priceDirection = direction;
            boolean shiftSuccess = false;
            String currencyTracked = "";
            currencyTracked = Global.swappedPair ? Global.options.getPair().getOrderCurrency().getCode().toUpperCase() : Global.options.getPair().getPaymentCurrency().getCode().toUpperCase();
            String message = "Shift needed on " + Global.exchange.getName() + "\nReason : ";
            message = !Global.options.isMultipleCustodians() ? message + currencyTracked + " price went " + this.getPriceDirection() + " more than " + Global.options.getSecondaryPegOptions().getWallchangeThreshold() + " %" : message + Integer.parseInt(Global.settings.getProperty("reset_every_minutes")) + " minutes elapsed since last shift";
            HipChatNotifications.sendMessage(message, Message.Color.PURPLE);
            LOG.warning(message);
            shiftSuccess = this.strategyUtils.shiftWalls();
            if (shiftSuccess) {
                this.mightNeedInit = false;
                this.needWallShift = false;
                LOG.info("Wall shift successful");
            } else {
                LOG.severe("Wall shift failed");
            }
            this.shiftingWalls = false;
        } else {
            LOG.warning("Shift request failed, shift in progress.");
        }
    }

    public double getSellPricePEG() {
        return this.sellPricePEG;
    }

    public void setSellPricePEG(double sellPricePEG) {
        this.sellPricePEG = sellPricePEG;
    }

    public double getBuyPricePEG() {
        return this.buyPricePEG;
    }

    public void setBuyPricePEG(double buyPricePEG) {
        this.buyPricePEG = buyPricePEG;
    }

    public PriceMonitorTriggerTask getPriceMonitorTask() {
        return this.priceMonitorTask;
    }

    public void setPriceMonitorTask(PriceMonitorTriggerTask priceMonitorTask) {
        this.priceMonitorTask = priceMonitorTask;
    }

    public SubmitLiquidityinfoTask getSendLiquidityTask() {
        return this.sendLiquidityTask;
    }

    public void setSendLiquidityTask(SubmitLiquidityinfoTask sendLiquidityTask) {
        this.sendLiquidityTask = sendLiquidityTask;
    }

    public int getActiveSellOrders() {
        return this.activeSellOrders;
    }

    public void setActiveSellOrders(int activeSellOrders) {
        this.activeSellOrders = activeSellOrders;
    }

    public int getActiveBuyOrders() {
        return this.activeBuyOrders;
    }

    public void setActiveBuyOrders(int activeBuyOrders) {
        this.activeBuyOrders = activeBuyOrders;
    }

    public int getTotalActiveOrders() {
        return this.totalActiveOrders;
    }

    public void setTotalActiveOrders(int totalActiveOrders) {
        this.totalActiveOrders = totalActiveOrders;
    }

    public boolean isMightNeedInit() {
        return this.mightNeedInit;
    }

    public void setMightNeedInit(boolean mightNeedInit) {
        this.mightNeedInit = mightNeedInit;
    }

    public boolean isOrdersAndBalancesOK() {
        return this.ordersAndBalancesOK;
    }

    public void setOrdersAndBalancesOK(boolean ordersAndBalancesOK) {
        this.ordersAndBalancesOK = ordersAndBalancesOK;
    }

    public boolean isFirstTime() {
        return this.isFirstTime;
    }

    public void setIsFirstTime(boolean isFirstTime) {
        this.isFirstTime = isFirstTime;
    }

    public boolean isProceedsInBalance() {
        return this.proceedsInBalance;
    }

    public void setProceedsInBalance(boolean proceedsInBalance) {
        this.proceedsInBalance = proceedsInBalance;
    }

    public String getPriceDirection() {
        return this.priceDirection;
    }

    public void setPriceDirection(String priceDirection) {
        this.priceDirection = priceDirection;
    }
}

