/*
 * Decompiled with CFR 0.152.
 */
package com.nubits.nubot.pricefeeds;

import com.nubits.nubot.models.Amount;
import com.nubits.nubot.models.CurrencyPair;
import com.nubits.nubot.models.LastPrice;
import com.nubits.nubot.pricefeeds.AbstractPriceFeed;
import com.nubits.nubot.utils.Utils;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ExchangeratelabPriceFeed
extends AbstractPriceFeed {
    private static final Logger LOG = Logger.getLogger(ExchangeratelabPriceFeed.class.getName());

    public ExchangeratelabPriceFeed() {
        this.name = "exchangeratelab";
        this.refreshMinTime = 28800000L;
    }

    @Override
    public LastPrice getLastPrice(CurrencyPair pair) {
        long now = System.currentTimeMillis();
        long diff = now - this.lastRequest;
        if (diff >= this.refreshMinTime) {
            String htmlString;
            String url = this.getUrl(pair);
            try {
                htmlString = Utils.getHTML(url, true);
            }
            catch (IOException ex) {
                LOG.severe(ex.toString());
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            JSONParser parser = new JSONParser();
            try {
                JSONObject httpAnswerJson = (JSONObject)parser.parse(htmlString);
                JSONArray array = (JSONArray)httpAnswerJson.get("rates");
                String lookingfor = pair.getOrderCurrency().getCode().toUpperCase();
                boolean found = false;
                double rate = -1.0;
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject temp = (JSONObject)array.get(i);
                    String tempCurrency = (String)temp.get("to");
                    if (!tempCurrency.equalsIgnoreCase(lookingfor)) continue;
                    found = true;
                    rate = Utils.getDouble((Double)temp.get("rate"));
                    rate = Utils.round(1.0 / rate, 8);
                }
                this.lastRequest = System.currentTimeMillis();
                if (found) {
                    this.lastPrice = new LastPrice(false, this.name, pair.getOrderCurrency(), new Amount(rate, pair.getPaymentCurrency()));
                    return this.lastPrice;
                }
                LOG.warning("Cannot find currency " + lookingfor + " on feed " + this.name);
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
            catch (Exception ex) {
                LOG.severe(ex.toString());
                this.lastRequest = System.currentTimeMillis();
                return new LastPrice(true, this.name, pair.getOrderCurrency(), null);
            }
        }
        LOG.fine("Wait " + (this.refreshMinTime - (System.currentTimeMillis() - this.lastRequest)) + " ms " + "before making a new request. Now returning the last saved price\n\n");
        return this.lastPrice;
    }

    private String getUrl(CurrencyPair pair) {
        return "http://api.exchangeratelab.com/api/current?apikey=EE7BB151B242601155CE6822C23B5C3A";
    }
}

